/*
 * Decompiled with CFR 0.152.
 */
package com.j256.simplemagic.endian;

import com.j256.simplemagic.endian.EndianConverter;

public class MiddleEndianConverter
implements EndianConverter {
    MiddleEndianConverter() {
    }

    @Override
    public Long convertNumber(int offset, byte[] bytes, int size) {
        return this.convertNumber(offset, bytes, size, 8, 255);
    }

    @Override
    public Long convertId3(int offset, byte[] bytes, int size) {
        return this.convertNumber(offset, bytes, size, 7, 127);
    }

    @Override
    public byte[] convertToByteArray(long value, int size) {
        if (size == 4) {
            return new byte[]{(byte)(value >> 16 & 0xFFL), (byte)(value >> 24 & 0xFFL), (byte)(value >> 0 & 0xFFL), (byte)(value >> 8 & 0xFFL)};
        }
        return null;
    }

    private Long convertNumber(int offset, byte[] bytes, int size, int shift, int mask) {
        if (size != 4) {
            throw new UnsupportedOperationException("Middle-endian only supports 4-byte integers");
        }
        if (offset < 0 || offset + size > bytes.length) {
            return null;
        }
        long value = 0L;
        value = value << shift | (long)(bytes[offset + 1] & mask);
        value = value << shift | (long)(bytes[offset + 0] & mask);
        value = value << shift | (long)(bytes[offset + 3] & mask);
        value = value << shift | (long)(bytes[offset + 2] & mask);
        return value;
    }
}

