/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.crossdc.common;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public abstract class CrossDcConf {
    public static final String CROSSDC_PROPERTIES = "/crossdc.properties";
    public static final String ZK_CROSSDC_PROPS_PATH = "zkCrossDcPropsPath";
    public static final String EXPAND_DBQ = "solr.crossdc.expandDbq";
    public static final String COLLAPSE_UPDATES = "solr.crossdc.collapseUpdates";
    public static final String MAX_COLLAPSE_RECORDS = "solr.crossdc.maxCollapseRecords";

    public static enum CollapseUpdates {
        NONE,
        PARTIAL,
        ALL;

        private static final Map<String, CollapseUpdates> valueMap;

        public static CollapseUpdates getOrDefault(String strValue, CollapseUpdates defaultValue) {
            if (strValue == null || strValue.isBlank()) {
                return defaultValue;
            }
            CollapseUpdates value = valueMap.get(strValue.toUpperCase(Locale.ROOT));
            return value != null ? value : defaultValue;
        }

        static {
            valueMap = new HashMap<String, CollapseUpdates>();
            for (CollapseUpdates value : CollapseUpdates.values()) {
                valueMap.put(value.name().toUpperCase(Locale.ROOT), value);
            }
        }
    }

    public static enum ExpandDbq {
        NONE,
        EXPAND;

        private static final Map<String, ExpandDbq> valueMap;

        public static ExpandDbq getOrDefault(String strValue, ExpandDbq defaultValue) {
            if (strValue == null || strValue.isBlank()) {
                return defaultValue;
            }
            ExpandDbq value = valueMap.get(strValue.toUpperCase(Locale.ROOT));
            return value != null ? value : defaultValue;
        }

        static {
            valueMap = new HashMap<String, ExpandDbq>();
            for (ExpandDbq value : ExpandDbq.values()) {
                valueMap.put(value.name().toUpperCase(Locale.ROOT), value);
            }
        }
    }
}

