/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import java.io.IOException;
import java.util.Objects;
import javax.security.auth.kerberos.KeyTab;
import sun.security.jgss.krb5.Krb5Util;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.Credentials;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbAsReq;
import sun.security.krb5.KrbException;
import sun.security.krb5.KrbKdcRep;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.internal.ASRep;
import sun.security.krb5.internal.ASReq;
import sun.security.krb5.internal.EncASRepPart;
import sun.security.krb5.internal.KRBError;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.PAData;
import sun.security.krb5.internal.crypto.EType;
import sun.security.util.DerValue;

class KrbAsRep
extends KrbKdcRep {
    private ASRep rep;
    private Credentials creds;
    private boolean DEBUG = Krb5.DEBUG;

    KrbAsRep(byte[] byArray) throws KrbException, Asn1Exception, IOException {
        DerValue derValue = new DerValue(byArray);
        try {
            this.rep = new ASRep(derValue);
        }
        catch (Asn1Exception asn1Exception) {
            KrbException krbException;
            this.rep = null;
            KRBError kRBError = new KRBError(derValue);
            String string = kRBError.getErrorString();
            String string2 = null;
            if (string != null && string.length() > 0) {
                string2 = string.charAt(string.length() - 1) == '\u0000' ? string.substring(0, string.length() - 1) : string;
            }
            if (string2 == null) {
                krbException = new KrbException(kRBError);
            } else {
                if (this.DEBUG) {
                    System.out.println("KRBError received: " + string2);
                }
                krbException = new KrbException(kRBError, string2);
            }
            krbException.initCause(asn1Exception);
            throw krbException;
        }
    }

    PAData[] getPA() {
        return this.rep.pAData;
    }

    void decryptUsingKeyTab(KeyTab keyTab, KrbAsReq krbAsReq, PrincipalName principalName) throws KrbException, Asn1Exception, IOException {
        Integer n;
        int n2;
        EncryptionKey encryptionKey;
        block3: {
            encryptionKey = null;
            n2 = this.rep.encPart.getEType();
            n = this.rep.encPart.kvno;
            try {
                encryptionKey = EncryptionKey.findKey(n2, n, Krb5Util.keysFromJavaxKeyTab(keyTab, principalName));
            }
            catch (KrbException krbException) {
                if (krbException.returnCode() != 44) break block3;
                encryptionKey = EncryptionKey.findKey(n2, Krb5Util.keysFromJavaxKeyTab(keyTab, principalName));
            }
        }
        if (encryptionKey == null) {
            throw new KrbException(400, "Cannot find key for type/kvno to decrypt AS REP - " + EType.toString(n2) + "/" + n);
        }
        this.decrypt(encryptionKey, krbAsReq, principalName);
    }

    void decryptUsingPassword(char[] cArray, KrbAsReq krbAsReq, PrincipalName principalName) throws KrbException, Asn1Exception, IOException {
        int n = this.rep.encPart.getEType();
        EncryptionKey encryptionKey = EncryptionKey.acquireSecretKey(principalName, cArray, n, PAData.getSaltAndParams(n, this.rep.pAData));
        this.decrypt(encryptionKey, krbAsReq, principalName);
    }

    private void decrypt(EncryptionKey encryptionKey, KrbAsReq krbAsReq, PrincipalName principalName) throws KrbException, Asn1Exception, IOException {
        byte[] byArray = this.rep.encPart.decrypt(encryptionKey, 3);
        byte[] byArray2 = this.rep.encPart.reset(byArray);
        DerValue derValue = new DerValue(byArray2);
        EncASRepPart encASRepPart = new EncASRepPart(derValue);
        this.rep.encKDCRepPart = encASRepPart;
        ASReq aSReq = krbAsReq.getMessage();
        KrbAsRep.check(true, aSReq, this.rep, encryptionKey);
        PrincipalName principalName2 = principalName;
        if (principalName2.equals(this.rep.cname)) {
            principalName2 = null;
        }
        this.creds = new Credentials(this.rep.ticket, this.rep.cname, principalName2, encASRepPart.sname, null, encASRepPart.key, encASRepPart.flags, encASRepPart.authtime, encASRepPart.starttime, encASRepPart.endtime, encASRepPart.renewTill, encASRepPart.caddr);
        if (this.DEBUG) {
            System.out.println(">>> KrbAsRep cons in KrbAsReq.getReply " + aSReq.reqBody.cname.getNameString());
        }
    }

    Credentials getCreds() {
        return Objects.requireNonNull(this.creds, "Creds not available yet.");
    }

    sun.security.krb5.internal.ccache.Credentials getCCreds() {
        return new sun.security.krb5.internal.ccache.Credentials(this.rep);
    }
}

