/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection.custom;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModel;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.find.FindModel;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.ui.InspectionMetaDataDialog;
import com.intellij.profile.codeInspection.ui.SingleInspectionProfilePanel;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.border.Border;
import org.intellij.lang.regexp.RegExpBundle;
import org.intellij.lang.regexp.inspection.custom.CustomRegExpInspection;
import org.intellij.lang.regexp.inspection.custom.RegExpDialog;
import org.intellij.lang.regexp.inspection.custom.RegExpInspectionConfiguration;
import org.intellij.lang.regexp.inspection.custom.RegExpInspectionConfigurationCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomRegExpFakeInspection
extends LocalInspectionTool {
    private static final String GROUP = "RegExp";
    @NotNull
    private final RegExpInspectionConfiguration myConfiguration;

    public CustomRegExpFakeInspection(@NotNull RegExpInspectionConfiguration configuration) {
        if (configuration == null) {
            CustomRegExpFakeInspection.$$$reportNull$$$0(0);
        }
        if (configuration.getPatterns().isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.myConfiguration = configuration;
    }

    @NotNull
    public RegExpInspectionConfiguration getConfiguration() {
        RegExpInspectionConfiguration regExpInspectionConfiguration = this.myConfiguration;
        if (regExpInspectionConfiguration == null) {
            CustomRegExpFakeInspection.$$$reportNull$$$0(1);
        }
        return regExpInspectionConfiguration;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getDisplayName() {
        String string = this.myConfiguration.getName();
        if (string == null) {
            CustomRegExpFakeInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        String string = this.myConfiguration.getUuid();
        if (string == null) {
            CustomRegExpFakeInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public boolean isCleanup() {
        return this.isCleanupAllowed() && this.myConfiguration.isCleanup();
    }

    private boolean isCleanupAllowed() {
        return ContainerUtil.exists(this.myConfiguration.getPatterns(), p -> p.replacement() != null);
    }

    @NotNull
    public String getID() {
        HighlightDisplayKey key = HighlightDisplayKey.find((String)this.getShortName());
        if (key != null) {
            String string = key.getID();
            if (string == null) {
                CustomRegExpFakeInspection.$$$reportNull$$$0(4);
            }
            return string;
        }
        String suppressId = this.myConfiguration.getSuppressId();
        return !StringUtil.isEmpty((String)suppressId) ? suppressId : "CustomRegExpInspection";
    }

    @Nullable
    public String getAlternativeID() {
        return "CustomRegExpInspection";
    }

    @Nullable
    public String getMainToolId() {
        return "CustomRegExpInspection";
    }

    public static String[] getGroup() {
        return new String[]{InspectionsBundle.message((String)"group.names.user.defined", (Object[])new Object[0]), GROUP};
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getGroupDisplayName() {
        return GROUP;
    }

    public @Nls(capitalization=Nls.Capitalization.Sentence) String @NotNull [] getGroupPath() {
        String[] stringArray = CustomRegExpFakeInspection.getGroup();
        if (stringArray == null) {
            CustomRegExpFakeInspection.$$$reportNull$$$0(5);
        }
        return stringArray;
    }

    @Nullable
    public String getStaticDescription() {
        String description = this.myConfiguration.getDescription();
        if (StringUtil.isEmpty((String)description)) {
            return RegExpBundle.message("no.description.provided.description", new Object[0]);
        }
        return description;
    }

    @NotNull
    public JComponent createOptionsPanel() {
        MyListModel model = new MyListModel();
        JButton button = new JButton(RegExpBundle.message("edit.metadata.button", new Object[0]));
        button.addActionListener(__ -> this.performEditMetaData(button));
        JBList list = new JBList((ListModel)model);
        list.setVisibleRowCount(3);
        list.setCellRenderer(new RegExpInspectionConfigurationCellRenderer());
        JPanel listPanel = ToolbarDecorator.createDecorator((JList)list).setAddAction(arg_0 -> this.lambda$createOptionsPanel$2((JList)list, arg_0)).setAddActionName(RegExpBundle.message("action.add.pattern.text", new Object[0])).setAddIcon(LayeredIcon.ADD_WITH_DROPDOWN).setRemoveAction(arg_0 -> this.lambda$createOptionsPanel$3((JList)list, arg_0)).setRemoveActionUpdater(arg_0 -> CustomRegExpFakeInspection.lambda$createOptionsPanel$4((JList)list, arg_0)).setEditAction(arg_0 -> this.lambda$createOptionsPanel$5((JList)list, arg_0)).setMoveUpAction(arg_0 -> this.lambda$createOptionsPanel$6((JList)list, arg_0)).setMoveDownActionUpdater(arg_0 -> CustomRegExpFakeInspection.lambda$createOptionsPanel$7((JList)list, arg_0)).setMoveDownAction(arg_0 -> this.lambda$createOptionsPanel$8((JList)list, arg_0)).setMoveDownActionUpdater(arg_0 -> CustomRegExpFakeInspection.lambda$createOptionsPanel$9((JList)list, arg_0)).createPanel();
        new DoubleClickListener((JList)list){
            final /* synthetic */ JList val$list;
            {
                this.val$list = jList;
            }

            protected boolean onDoubleClick(@NotNull MouseEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                CustomRegExpFakeInspection.this.performEdit(this.val$list);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/intellij/lang/regexp/inspection/custom/CustomRegExpFakeInspection$1", "onDoubleClick"));
            }
        }.installOn((Component)list);
        JPanel panel = new FormBuilder().addComponent((JComponent)button).addVerticalGap(4).addLabeledComponentFillVertically(RegExpBundle.message("label.regexp.patterns", new Object[0]), (JComponent)listPanel).getPanel();
        panel.setBorder((Border)JBUI.Borders.emptyTop((int)10));
        JPanel jPanel = panel;
        if (jPanel == null) {
            CustomRegExpFakeInspection.$$$reportNull$$$0(6);
        }
        return jPanel;
    }

    private void performEditMetaData(@NotNull Component context) {
        if (context == null) {
            CustomRegExpFakeInspection.$$$reportNull$$$0(7);
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext(context));
        InspectionProfileModifiableModel profile = CustomRegExpFakeInspection.getInspectionProfile(context);
        if (profile == null || project == null) {
            return;
        }
        CustomRegExpInspection inspection = CustomRegExpFakeInspection.getRegExpInspection((InspectionProfile)profile);
        InspectionMetaDataDialog dialog = inspection.createMetaDataDialog(project, profile.getDisplayName(), this.myConfiguration);
        if (this.isCleanupAllowed()) {
            dialog.showCleanupOption(this.myConfiguration.isCleanup());
        }
        if (!dialog.showAndGet()) {
            return;
        }
        this.myConfiguration.setName(dialog.getName());
        this.myConfiguration.setDescription(dialog.getDescription());
        this.myConfiguration.setSuppressId(dialog.getSuppressId());
        this.myConfiguration.setProblemDescriptor(dialog.getProblemDescriptor());
        this.myConfiguration.setCleanup(dialog.isCleanup());
        inspection.updateConfiguration(this.myConfiguration);
        profile.setModified(true);
        profile.getProfileManager().fireProfileChanged((InspectionProfileImpl)profile);
    }

    private void performMove(JList<RegExpInspectionConfiguration.InspectionPattern> list, boolean up) {
        MyListModel model = (MyListModel)list.getModel();
        int index = list.getSelectedIndex();
        List<RegExpInspectionConfiguration.InspectionPattern> patterns = this.myConfiguration.getPatterns();
        int newIndex = up ? index - 1 : index + 1;
        Collections.swap(patterns, index, newIndex);
        model.fireContentsChanged(list);
        list.setSelectedIndex(newIndex);
        this.saveChangesToProfile(list);
    }

    private void performAdd(JList<RegExpInspectionConfiguration.InspectionPattern> list, @NotNull AnActionButton b) {
        if (b == null) {
            CustomRegExpFakeInspection.$$$reportNull$$$0(8);
        }
        AnAction[] children = new AnAction[]{new AddTemplateAction(list, false), new AddTemplateAction(list, true)};
        RelativePoint point = b.getPreferredPopupPoint();
        JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)new DefaultActionGroup(children), DataManager.getInstance().getDataContext((Component)b.getContextComponent()), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true).show(point);
    }

    private void performRemove(JList<RegExpInspectionConfiguration.InspectionPattern> list) {
        List<RegExpInspectionConfiguration.InspectionPattern> patterns = this.myConfiguration.getPatterns();
        for (RegExpInspectionConfiguration.InspectionPattern pattern : list.getSelectedValuesList()) {
            this.myConfiguration.removePattern(pattern);
        }
        int size = patterns.size();
        int maxIndex = list.getMaxSelectionIndex();
        if (maxIndex != list.getMinSelectionIndex()) {
            list.setSelectedIndex(maxIndex);
        }
        ((MyListModel)list.getModel()).fireContentsChanged(list);
        if (list.getSelectedIndex() >= size) {
            list.setSelectedIndex(size - 1);
        }
        int index = list.getSelectedIndex();
        list.scrollRectToVisible(list.getCellBounds(index, index));
        this.saveChangesToProfile(list);
    }

    private void performEdit(JList<RegExpInspectionConfiguration.InspectionPattern> list) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext(list));
        if (project == null) {
            return;
        }
        int index = list.getSelectedIndex();
        if (index < 0) {
            return;
        }
        List<RegExpInspectionConfiguration.InspectionPattern> patterns = this.myConfiguration.getPatterns();
        RegExpInspectionConfiguration.InspectionPattern configuration = patterns.get(index);
        if (configuration == null) {
            return;
        }
        RegExpDialog dialog = new RegExpDialog(project, true, configuration);
        if (!dialog.showAndGet()) {
            return;
        }
        RegExpInspectionConfiguration.InspectionPattern newConfiguration = dialog.getPattern();
        patterns.set(index, newConfiguration);
        ((MyListModel)list.getModel()).fireContentsChanged(list);
        this.saveChangesToProfile(list);
    }

    private void saveChangesToProfile(JList<RegExpInspectionConfiguration.InspectionPattern> list) {
        InspectionProfileModifiableModel profile = CustomRegExpFakeInspection.getInspectionProfile(list);
        if (profile == null) {
            return;
        }
        CustomRegExpInspection inspection = CustomRegExpFakeInspection.getRegExpInspection((InspectionProfile)profile);
        inspection.updateConfiguration(this.myConfiguration);
        profile.setModified(true);
    }

    @NotNull
    private static CustomRegExpInspection getRegExpInspection(@NotNull InspectionProfile profile) {
        if (profile == null) {
            CustomRegExpFakeInspection.$$$reportNull$$$0(9);
        }
        InspectionToolWrapper wrapper = profile.getInspectionTool("CustomRegExpInspection", (Project)null);
        assert (wrapper != null);
        CustomRegExpInspection customRegExpInspection = (CustomRegExpInspection)wrapper.getTool();
        if (customRegExpInspection == null) {
            CustomRegExpFakeInspection.$$$reportNull$$$0(10);
        }
        return customRegExpInspection;
    }

    private static InspectionProfileModifiableModel getInspectionProfile(@NotNull Component c) {
        SingleInspectionProfilePanel panel;
        if (c == null) {
            CustomRegExpFakeInspection.$$$reportNull$$$0(11);
        }
        if ((panel = (SingleInspectionProfilePanel)UIUtil.uiParents((Component)c, (boolean)true).filter(SingleInspectionProfilePanel.class).first()) == null) {
            return null;
        }
        return panel.getProfile();
    }

    private static /* synthetic */ boolean lambda$createOptionsPanel$9(JList list, AnActionEvent e) {
        return list.getSelectedValuesList().size() == 1;
    }

    private /* synthetic */ void lambda$createOptionsPanel$8(JList list, AnActionButton b) {
        this.performMove(list, false);
    }

    private static /* synthetic */ boolean lambda$createOptionsPanel$7(JList list, AnActionEvent e) {
        return list.getSelectedValuesList().size() == 1;
    }

    private /* synthetic */ void lambda$createOptionsPanel$6(JList list, AnActionButton b) {
        this.performMove(list, true);
    }

    private /* synthetic */ void lambda$createOptionsPanel$5(JList list, AnActionButton b) {
        this.performEdit(list);
    }

    private static /* synthetic */ boolean lambda$createOptionsPanel$4(JList list, AnActionEvent e) {
        return list.getSelectedValuesList().size() < list.getModel().getSize();
    }

    private /* synthetic */ void lambda$createOptionsPanel$3(JList list, AnActionButton b) {
        this.performRemove(list);
    }

    private /* synthetic */ void lambda$createOptionsPanel$2(JList list, AnActionButton b) {
        this.performAdd(list, b);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/regexp/inspection/custom/CustomRegExpFakeInspection";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/regexp/inspection/custom/CustomRegExpFakeInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupPath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptionsPanel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegExpInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "performEditMetaData";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "performAdd";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRegExpInspection";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getInspectionProfile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 10 -> new IllegalStateException(string);
        };
    }

    private class MyListModel
    extends AbstractListModel<RegExpInspectionConfiguration.InspectionPattern> {
        private MyListModel() {
        }

        @Override
        public int getSize() {
            return CustomRegExpFakeInspection.this.myConfiguration.getPatterns().size();
        }

        @Override
        public RegExpInspectionConfiguration.InspectionPattern getElementAt(int index) {
            return CustomRegExpFakeInspection.this.myConfiguration.getPatterns().get(index);
        }

        public void fireContentsChanged(Object source) {
            this.fireContentsChanged(source, -1, -1);
        }
    }

    private final class AddTemplateAction
    extends DumbAwareAction {
        private final JList<RegExpInspectionConfiguration.InspectionPattern> myList;
        private final boolean myReplace;

        private AddTemplateAction(JList<RegExpInspectionConfiguration.InspectionPattern> list, boolean replace) {
            super(replace ? RegExpBundle.message("action.add.regexp.replace.template.text", new Object[0]) : RegExpBundle.message("action.add.regexp.search.template.text", new Object[0]));
            this.myList = list;
            this.myReplace = replace;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            String replace;
            RegExpInspectionConfiguration.InspectionPattern defaultPattern;
            RegExpDialog dialog;
            if (e == null) {
                AddTemplateAction.$$$reportNull$$$0(0);
            }
            Project project = (Project)e.getData(CommonDataKeys.PROJECT);
            assert (project != null);
            FileType fileType = null;
            int flags = 0;
            FindModel.SearchContext context = FindModel.SearchContext.ANY;
            if (this.myList.getModel().getSize() > 0) {
                RegExpInspectionConfiguration.InspectionPattern pattern = this.myList.getModel().getElementAt(0);
                fileType = pattern.fileType();
                flags = pattern.flags;
                context = pattern.searchContext();
            }
            if (!(dialog = new RegExpDialog(project, true, defaultPattern = new RegExpInspectionConfiguration.InspectionPattern("", fileType, flags, context, replace = this.myReplace ? "" : null))).showAndGet()) {
                return;
            }
            RegExpInspectionConfiguration.InspectionPattern pattern = dialog.getPattern();
            CustomRegExpFakeInspection.this.myConfiguration.addPattern(pattern);
            ((MyListModel)this.myList.getModel()).fireContentsChanged(this.myList);
            CustomRegExpFakeInspection.this.saveChangesToProfile(this.myList);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/intellij/lang/regexp/inspection/custom/CustomRegExpFakeInspection$AddTemplateAction", "actionPerformed"));
        }
    }
}

