/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.en;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.tagging.BaseTagger;
import org.languagetool.tools.StringTools;

public class EnglishTagger
extends BaseTagger {
    public static final EnglishTagger INSTANCE = new EnglishTagger();

    public EnglishTagger() {
        super("/en/english.dict", Locale.ENGLISH, false, true);
    }

    public List<AnalyzedTokenReadings> tag(List<String> sentenceTokens) {
        ArrayList<AnalyzedTokenReadings> tokenReadings = new ArrayList<AnalyzedTokenReadings>();
        int pos = 0;
        for (String word : sentenceTokens) {
            boolean containsTypographicApostrophe = false;
            if (word.length() > 1 && word.contains("\u2019")) {
                containsTypographicApostrophe = true;
                word = word.replace('\u2019', '\'');
            }
            ArrayList<AnalyzedToken> l = new ArrayList<AnalyzedToken>();
            String lowerWord = word.toLowerCase(this.locale);
            boolean isLowercase = word.equals(lowerWord);
            boolean isMixedCase = StringTools.isMixedCase((String)word);
            boolean isAllUpper = StringTools.isAllUppercase((String)word);
            List taggerTokens = this.asAnalyzedTokenListForTaggedWords(word, this.getWordTagger().tag(word));
            this.addTokens(taggerTokens, l);
            if (!isLowercase && !isMixedCase) {
                List lowerTaggerTokens = this.asAnalyzedTokenListForTaggedWords(word, this.getWordTagger().tag(lowerWord));
                this.addTokens(lowerTaggerTokens, l);
            }
            if (l.isEmpty() && isAllUpper) {
                String firstUpper = StringTools.uppercaseFirstChar((String)lowerWord);
                List firstupperTaggerTokens = this.asAnalyzedTokenListForTaggedWords(word, this.getWordTagger().tag(firstUpper));
                this.addTokens(firstupperTaggerTokens, l);
            }
            if (l.isEmpty() && lowerWord.endsWith("in'")) {
                Object correctedWord = word;
                correctedWord = isAllUpper ? ((String)correctedWord).substring(0, ((String)correctedWord).length() - 1) + "G" : ((String)correctedWord).substring(0, ((String)correctedWord).length() - 1) + "g";
                List taggerTokens2 = this.asAnalyzedTokenListForTaggedWords(word, this.getWordTagger().tag((String)correctedWord));
                this.addTokens(taggerTokens2, l);
                if (!isLowercase && !isMixedCase) {
                    List lowerTaggerTokens = this.asAnalyzedTokenListForTaggedWords(word, this.getWordTagger().tag(((String)correctedWord).toLowerCase()));
                    this.addTokens(lowerTaggerTokens, l);
                }
            }
            if (l.isEmpty()) {
                l.add(new AnalyzedToken(word, null, null));
            }
            AnalyzedTokenReadings atr = new AnalyzedTokenReadings(l, pos);
            if (containsTypographicApostrophe) {
                atr.setTypographicApostrophe();
            }
            tokenReadings.add(atr);
            pos += word.length();
        }
        return tokenReadings;
    }

    private void addTokens(List<AnalyzedToken> taggedTokens, List<AnalyzedToken> l) {
        if (taggedTokens != null) {
            l.addAll(taggedTokens);
        }
    }
}

