/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.ide.ui.configurable;

import ai.grazie.nlp.langs.Language;
import ai.grazie.rules.Rule;
import ai.grazie.rules.RuleClient;
import ai.grazie.rules.settings.Setting;
import ai.grazie.rules.settings.SettingComponent;
import ai.grazie.rules.settings.TextStyle;
import ai.grazie.rules.toolkit.LanguageToolkit;
import com.intellij.grazie.GrazieBundle;
import com.intellij.grazie.GrazieConfig;
import com.intellij.grazie.ide.ui.configurable.CombinedSettings;
import com.intellij.grazie.ide.ui.configurable.FeaturedSettings;
import com.intellij.grazie.ide.ui.configurable.StyleConfigurable;
import com.intellij.grazie.ide.ui.configurable.StyleConfigurableKt;
import com.intellij.grazie.ide.ui.configurable.TreeSettings;
import com.intellij.grazie.ide.ui.grammar.tabs.rules.component.GrazieDescriptionComponent;
import com.intellij.grazie.ide.ui.grammar.tabs.rules.component.GrazieTreeComponent;
import com.intellij.grazie.rule.RuleIdeClient;
import com.intellij.grazie.utils.GrazieUtilsKt;
import com.intellij.grazie.utils.TextStyleDomain;
import com.intellij.grazie.utils.TextUtilsKt;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.dsl.builder.IntelliJSpacingConfiguration;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import java.awt.Font;
import java.awt.Image;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012 \b\u0002\u0010\u0002\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00030\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0015J\u001e\u0010\u001a\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001cJ\u001e\u0010\u001d\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001cJ\u001e\u0010\u001e\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0004J\u0006\u0010 \u001a\u00020\u0017J!\u0010!\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00030\u0003H\u00c6\u0003J+\u0010\"\u001a\u00020\u00002 \b\u0002\u0010\u0002\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00030\u0003H\u00c6\u0001J\u0013\u0010#\u001a\u00020\u00132\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010%\u001a\u00020&H\u00d6\u0001J\t\u0010'\u001a\u00020\u0004H\u00d6\u0001R)\u0010\u0002\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006("}, d2={"Lcom/intellij/grazie/ide/ui/configurable/Settings;", "", "combinedSettings", "", "", "Lai/grazie/nlp/langs/Language;", "Lcom/intellij/grazie/ide/ui/configurable/CombinedSettings;", "<init>", "(Ljava/util/Map;)V", "getCombinedSettings", "()Ljava/util/Map;", "getFeaturedSettings", "Lcom/intellij/grazie/ide/ui/configurable/FeaturedSettings;", "textStyle", "Lai/grazie/rules/settings/TextStyle;", "language", "getTreeSettings", "Lcom/intellij/grazie/ide/ui/configurable/TreeSettings;", "isModified", "", "state", "Lcom/intellij/grazie/GrazieConfig$State;", "reset", "", "apply", "originalState", "addTextStyle", "filterComponent", "Lcom/intellij/ui/SearchTextField;", "addLanguage", "updateFilter", "option", "clear", "component1", "copy", "equals", "other", "hashCode", "", "toString", "intellij.grazie.core"})
@SourceDebugExtension(value={"SMAP\nStyleConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StyleConfigurable.kt\ncom/intellij/grazie/ide/ui/configurable/Settings\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,566:1\n1761#2,3:567\n216#3:570\n216#3,2:571\n217#3:573\n188#3,3:577\n216#3:584\n216#3,2:592\n216#3,2:594\n217#3:596\n536#4:574\n521#4,2:575\n523#4,4:580\n536#4:585\n521#4,6:586\n*S KotlinDebug\n*F\n+ 1 StyleConfigurable.kt\ncom/intellij/grazie/ide/ui/configurable/Settings\n*L\n331#1:567,3\n334#1:570\n335#1:571,2\n334#1:573\n343#1:577,3\n344#1:584\n351#1:592,2\n385#1:594,2\n344#1:596\n343#1:574\n343#1:575,2\n343#1:580,4\n350#1:585\n350#1:586,6\n*E\n"})
public final class Settings {
    @NotNull
    private final Map<String, Map<Language, CombinedSettings>> combinedSettings;

    public Settings(@NotNull Map<String, Map<Language, CombinedSettings>> combinedSettings) {
        Intrinsics.checkNotNullParameter(combinedSettings, (String)"combinedSettings");
        this.combinedSettings = combinedSettings;
    }

    public /* synthetic */ Settings(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            map = new HashMap();
        }
        this(map);
    }

    @NotNull
    public final Map<String, Map<Language, CombinedSettings>> getCombinedSettings() {
        return this.combinedSettings;
    }

    @Nullable
    public final FeaturedSettings getFeaturedSettings(@NotNull TextStyle textStyle, @NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)textStyle, (String)"textStyle");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Map<Language, CombinedSettings> map = this.combinedSettings.get(textStyle.id());
        Intrinsics.checkNotNull(map);
        CombinedSettings combinedSettings = map.get(language);
        Intrinsics.checkNotNull((Object)combinedSettings);
        return combinedSettings.getFeaturedSettings();
    }

    @NotNull
    public final TreeSettings getTreeSettings(@NotNull TextStyle textStyle, @NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)textStyle, (String)"textStyle");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Map<Language, CombinedSettings> map = this.combinedSettings.get(textStyle.id());
        Intrinsics.checkNotNull(map);
        CombinedSettings combinedSettings = map.get(language);
        Intrinsics.checkNotNull((Object)combinedSettings);
        return combinedSettings.getTreeSettings();
    }

    public final boolean isModified(@NotNull GrazieConfig.State state) {
        boolean bl;
        block7: {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Iterable $this$any$iv = this.combinedSettings.values();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    block6: {
                        Map settings = (Map)element$iv;
                        boolean bl3 = false;
                        Iterable $this$any$iv2 = settings.values();
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                CombinedSettings it = (CombinedSettings)element$iv2;
                                boolean bl4 = false;
                                if (!it.isModified(state)) continue;
                                bl2 = true;
                                break block6;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void reset(@NotNull GrazieConfig.State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Map<String, Map<Language, CombinedSettings>> $this$forEach$iv = this.combinedSettings;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, Map<Language, CombinedSettings>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map<Language, CombinedSettings> settingsMap;
            Map.Entry<String, Map<Language, CombinedSettings>> element$iv;
            Map.Entry<String, Map<Language, CombinedSettings>> entry = element$iv = iterator.next();
            boolean bl = false;
            String textStyleId = entry.getKey();
            Map<Language, CombinedSettings> $this$forEach$iv2 = settingsMap = entry.getValue();
            boolean $i$f$forEach2 = false;
            Iterator<Map.Entry<Language, CombinedSettings>> iterator2 = $this$forEach$iv2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<Language, CombinedSettings> element$iv2;
                Map.Entry<Language, CombinedSettings> entry2 = element$iv2 = iterator2.next();
                boolean bl2 = false;
                Language language = entry2.getKey();
                CombinedSettings settings = entry2.getValue();
                settings.reset(state, StyleConfigurableKt.access$getTextStyle(textStyleId), language);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void apply(@NotNull GrazieConfig.State originalState) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)originalState, (String)"originalState");
        Map<String, Map<Language, CombinedSettings>> $this$filter$iv = this.combinedSettings;
        boolean $i$f$filter = false;
        Object object = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            boolean bl;
            Map.Entry element$iv$iv;
            block11: {
                Map.Entry it = element$iv$iv = iterator.next();
                boolean bl2 = false;
                Map $this$any$iv = (Map)it.getValue();
                boolean $i$f$any = false;
                if ($this$any$iv.isEmpty()) {
                    bl = false;
                } else {
                    Iterator iterator2 = $this$any$iv.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Map.Entry element$iv;
                        Map.Entry settings = element$iv = iterator2.next();
                        boolean bl3 = false;
                        if (!((CombinedSettings)settings.getValue()).isModified(originalState)) continue;
                        bl = true;
                        break block11;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$forEach$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry element$iv;
            Map changedSettings;
            void $this$filterTo$iv$iv2;
            Map.Entry element$iv2;
            Map.Entry entry = element$iv2 = (Map.Entry)object.next();
            boolean bl = false;
            String textStyleId = (String)entry.getKey();
            Map settingsMap = (Map)entry.getValue();
            TextStyleDomain domain = TextUtilsKt.getTextDomain(StyleConfigurableKt.access$getTextStyle(textStyleId));
            HashSet userEnabledRules = new HashSet();
            HashSet userDisabledRules = new HashSet();
            HashMap parameters = new HashMap();
            Map $this$filter$iv2 = settingsMap;
            boolean $i$f$filter2 = false;
            Map bl3 = $this$filter$iv2;
            Map destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$filterTo2 = false;
            Iterator iterator3 = $this$filterTo$iv$iv2.entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry settings = element$iv$iv = iterator3.next();
                boolean bl4 = false;
                if (!((CombinedSettings)settings.getValue()).isModified(originalState)) continue;
                destination$iv$iv2.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Map $this$forEach$iv2 = changedSettings = destination$iv$iv2;
            boolean $i$f$forEach2 = false;
            Iterator iterator4 = $this$forEach$iv2.entrySet().iterator();
            while (iterator4.hasNext()) {
                Map.Entry entry2 = element$iv = iterator4.next();
                boolean bl5 = false;
                Language language = (Language)entry2.getKey();
                CombinedSettings combinedSettings = (CombinedSettings)entry2.getValue();
                HashSet<CallSite> userEnabledRulesPerLanguage = new HashSet<CallSite>();
                HashSet<CallSite> userDisabledRulesPerLanguage = new HashSet<CallSite>();
                if (combinedSettings.getFeaturedSettings() != null) {
                    String prefix;
                    FeaturedSettings featuredSettings;
                    boolean bl6 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)Rule.globalIdPrefix((Language)language), (String)"globalIdPrefix(...)");
                    SettingComponent.SettingState settingsState = featuredSettings.getComponent().getState();
                    Intrinsics.checkNotNull((Object)settingsState);
                    featuredSettings.setResetState(settingsState);
                    for (String id : settingsState.enabledRules()) {
                        userEnabledRulesPerLanguage.add((CallSite)((Object)(prefix + id)));
                        userDisabledRulesPerLanguage.remove(prefix + id);
                    }
                    for (String id : settingsState.disabledRules()) {
                        userEnabledRulesPerLanguage.remove(prefix + id);
                        userDisabledRulesPerLanguage.add((CallSite)((Object)(prefix + id)));
                    }
                    ((Map)parameters).put(language, settingsState.paramValues());
                }
                GrazieConfig.State updatedState = combinedSettings.getTreeSettings().getTree().apply(originalState);
                Set<String> affectedGlobalRules = GrazieUtilsKt.getAffectedGlobalRules(language);
                GrazieConfig.UserChangedRules userChangedRules = updatedState.getUserChangedRules(domain);
                boolean bl7 = false;
                Set<String> enabledRules = userChangedRules.component1();
                Set<String> disabledRules = userChangedRules.component2();
                userEnabledRulesPerLanguage.addAll(SetsKt.minus(enabledRules, (Iterable)affectedGlobalRules));
                userDisabledRulesPerLanguage.addAll(SetsKt.minus(disabledRules, (Iterable)affectedGlobalRules));
                userEnabledRules.addAll(userEnabledRulesPerLanguage);
                userDisabledRules.addAll(userDisabledRulesPerLanguage);
            }
            GrazieConfig.Companion.update((Function1<? super GrazieConfig.State, GrazieConfig.State>)((Function1)arg_0 -> Settings.apply$lambda$1$2(domain, parameters, userEnabledRules, userDisabledRules, arg_0)));
            $this$forEach$iv2 = changedSettings;
            $i$f$forEach2 = false;
            iterator4 = $this$forEach$iv2.entrySet().iterator();
            while (iterator4.hasNext()) {
                Map.Entry entry3 = element$iv = iterator4.next();
                boolean bl8 = false;
                CombinedSettings settings = (CombinedSettings)entry3.getValue();
                settings.getTreeSettings().getTree().reset(GrazieConfig.Companion.get());
            }
        }
    }

    public final void addTextStyle(@NotNull TextStyle textStyle, @NotNull Language language, @NotNull SearchTextField filterComponent2) {
        Intrinsics.checkNotNullParameter((Object)textStyle, (String)"textStyle");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)filterComponent2, (String)"filterComponent");
        Map<Language, CombinedSettings> settings = this.combinedSettings.get(textStyle.id());
        if (settings != null && settings.containsKey(language)) {
            return;
        }
        if (settings == null) {
            this.combinedSettings.put(textStyle.id(), new HashMap());
        }
        this.addLanguage(textStyle, language, filterComponent2);
    }

    public final void addLanguage(@NotNull TextStyle textStyle, @NotNull Language language, @NotNull SearchTextField filterComponent2) {
        Intrinsics.checkNotNullParameter((Object)textStyle, (String)"textStyle");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)filterComponent2, (String)"filterComponent");
        Map<Language, CombinedSettings> map = this.combinedSettings.get(textStyle.id());
        Intrinsics.checkNotNull(map);
        Map<Language, CombinedSettings> settingsPerLanguage = map;
        if (settingsPerLanguage.containsKey(language)) {
            return;
        }
        TextStyleDomain domain = TextUtilsKt.getTextDomain(textStyle);
        GrazieDescriptionComponent description = new GrazieDescriptionComponent();
        GrazieTreeComponent tree = new GrazieTreeComponent(description.getListener(), language, domain, filterComponent2);
        tree.reset(GrazieConfig.Companion.get());
        if (!StyleConfigurable.Companion.getRuleEngineLanguages().contains(language)) {
            settingsPerLanguage.put(language, new CombinedSettings(null, new TreeSettings(description, tree)));
            return;
        }
        LanguageToolkit toolkit = LanguageToolkit.forLanguage((Language)language);
        IntelliJSpacingConfiguration spacing = new IntelliJSpacingConfiguration();
        SettingComponent.UI ui2 = new SettingComponent.UI(spacing){
            final /* synthetic */ IntelliJSpacingConfiguration $spacing;
            {
                this.$spacing = $spacing;
            }

            public String getExamplePrefix() {
                return GrazieBundle.message("grazie.settings.style.configurable.example.prefix", new Object[0]);
            }

            public String getCorrectionPrefix() {
                return GrazieBundle.message("grazie.settings.style.configurable.corrected.prefix", new Object[0]);
            }

            public void navigateHyperlink(URL url) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                BrowserUtil.browse((URL)url);
            }

            public Image externalLinkArrow() {
                Icon icon = AllIcons.Ide.External_link_arrow;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"External_link_arrow");
                return IconUtil.toBufferedImage((Icon)icon, (boolean)true);
            }

            public JComponent createResetToDefaultComponent(Runnable action2) {
                Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
                return StyleConfigurableKt.access$createLinkLabel(GrazieBundle.message("grazie.settings.style.configurable.reset.to.default.link", new Object[0]), action2);
            }

            public JComponent createExpandComponent(boolean examplesOnly, Runnable doExpand) {
                Intrinsics.checkNotNullParameter((Object)doExpand, (String)"doExpand");
                String text = examplesOnly ? GrazieBundle.message("grazie.settings.style.configurable.expand.examples.link", new Object[0]) : GrazieBundle.message("grazie.settings.style.configurable.expand.link", new Object[0]);
                return StyleConfigurableKt.access$createLinkLabel(text, doExpand);
            }

            public JComponent createCollapseComponent(boolean examplesOnly, Runnable doCollapse) {
                Intrinsics.checkNotNullParameter((Object)doCollapse, (String)"doCollapse");
                String text = examplesOnly ? GrazieBundle.message("grazie.settings.style.configurable.collapse.examples.link", new Object[0]) : GrazieBundle.message("grazie.settings.style.configurable.collapse.link", new Object[0]);
                return StyleConfigurableKt.access$createLinkLabel(text, doCollapse);
            }

            public JComponent createGroupHeader(@NlsContexts.Label String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                return (JComponent)StyleConfigurableKt.access$createTitledSeparator(name, this.$spacing);
            }

            public void customizeSettingSection(Setting setting, JComponent section) {
                Intrinsics.checkNotNullParameter((Object)setting, (String)"setting");
                Intrinsics.checkNotNullParameter((Object)section, (String)"section");
                section.setBorder((Border)new JBEmptyBorder(0, this.$spacing.getHorizontalIndent(), this.$spacing.getVerticalComponentGap(), 0));
            }

            public void customizeRuleDescription(JEditorPane pane) {
                Intrinsics.checkNotNullParameter((Object)pane, (String)"pane");
                pane.setFont((Font)JBFont.medium());
                pane.setForeground(JBUI.CurrentTheme.ContextHelp.FOREGROUND);
            }
        };
        SettingComponent component2 = new SettingComponent(toolkit, (RuleClient)RuleIdeClient.INSTANCE, ui2);
        SettingComponent.SettingState settingState = StyleConfigurableKt.access$getSettingsState(language, textStyle);
        component2.loadState(settingState, textStyle);
        settingsPerLanguage.put(language, new CombinedSettings(new FeaturedSettings(component2, settingState), new TreeSettings(description, tree)));
    }

    public final void updateFilter(@NotNull TextStyle textStyle, @NotNull Language language, @NotNull String option) {
        Intrinsics.checkNotNullParameter((Object)textStyle, (String)"textStyle");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        Map<Language, CombinedSettings> map = this.combinedSettings.get(textStyle.id());
        Intrinsics.checkNotNull(map);
        CombinedSettings combinedSettings = map.get(language);
        Intrinsics.checkNotNull((Object)combinedSettings);
        combinedSettings.updateFilter(option);
    }

    public final void clear() {
        this.combinedSettings.clear();
    }

    @NotNull
    public final Map<String, Map<Language, CombinedSettings>> component1() {
        return this.combinedSettings;
    }

    @NotNull
    public final Settings copy(@NotNull Map<String, Map<Language, CombinedSettings>> combinedSettings) {
        Intrinsics.checkNotNullParameter(combinedSettings, (String)"combinedSettings");
        return new Settings(combinedSettings);
    }

    public static /* synthetic */ Settings copy$default(Settings settings, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            map = settings.combinedSettings;
        }
        return settings.copy(map);
    }

    @NotNull
    public String toString() {
        return "Settings(combinedSettings=" + this.combinedSettings + ")";
    }

    public int hashCode() {
        return ((Object)this.combinedSettings).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Settings)) {
            return false;
        }
        Settings settings = (Settings)other;
        return Intrinsics.areEqual(this.combinedSettings, settings.combinedSettings);
    }

    private static final GrazieConfig.State apply$lambda$1$2(TextStyleDomain $domain, HashMap $parameters, HashSet $userEnabledRules, HashSet $userDisabledRules, GrazieConfig.State it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        GrazieConfig.State withParameters = $domain == TextStyleDomain.Other ? GrazieConfig.State.copy$default(it, null, null, null, false, null, null, null, null, null, null, null, null, null, $parameters, null, false, false, null, 253951, null) : GrazieConfig.State.copy$default(it, null, null, null, false, null, null, null, null, null, null, null, null, null, null, MapsKt.mapOf((Pair)TuplesKt.to((Object)((Object)$domain), (Object)$parameters)), false, false, null, 245759, null);
        return withParameters.updateUserRules($domain, $userEnabledRules, $userDisabledRules);
    }

    public Settings() {
        this(null, 1, null);
    }
}

