/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.progress.CancellationUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.textmate.TextMateBundle;
import org.jetbrains.plugins.textmate.TextMateBundleToLoad;
import org.jetbrains.plugins.textmate.TextMateBundlesLoader;
import org.jetbrains.plugins.textmate.TextMateService;
import org.jetbrains.plugins.textmate.TextMateServiceImplKt;
import org.jetbrains.plugins.textmate.TextMateServiceImplKtKt;
import org.jetbrains.plugins.textmate.bundles.BundleReaderCoreKt;
import org.jetbrains.plugins.textmate.bundles.BundleType;
import org.jetbrains.plugins.textmate.bundles.TextMateBundleReader;
import org.jetbrains.plugins.textmate.bundles.TextMateFileNameMatcher;
import org.jetbrains.plugins.textmate.bundles.TextMateGrammar;
import org.jetbrains.plugins.textmate.bundles.TextMateNioResourceReader;
import org.jetbrains.plugins.textmate.bundles.TextMatePreferences;
import org.jetbrains.plugins.textmate.bundles.TextMateResourceReader;
import org.jetbrains.plugins.textmate.bundles.VSCBundleReaderKt;
import org.jetbrains.plugins.textmate.configuration.TextMateBuiltinBundlesSettings;
import org.jetbrains.plugins.textmate.configuration.TextMatePersistentBundle;
import org.jetbrains.plugins.textmate.configuration.TextMateUserBundlesSettings;
import org.jetbrains.plugins.textmate.editor.TextMateEditorUtilsKt;
import org.jetbrains.plugins.textmate.language.TextMateConcurrentMapInterner;
import org.jetbrains.plugins.textmate.language.TextMateInterner;
import org.jetbrains.plugins.textmate.language.TextMateLanguageDescriptor;
import org.jetbrains.plugins.textmate.language.preferences.Preferences;
import org.jetbrains.plugins.textmate.language.preferences.PreferencesRegistry;
import org.jetbrains.plugins.textmate.language.preferences.PreferencesRegistryBuilder;
import org.jetbrains.plugins.textmate.language.preferences.PreferencesRegistryImpl;
import org.jetbrains.plugins.textmate.language.preferences.ShellVariablesRegistry;
import org.jetbrains.plugins.textmate.language.preferences.ShellVariablesRegistryBuilder;
import org.jetbrains.plugins.textmate.language.preferences.ShellVariablesRegistryImpl;
import org.jetbrains.plugins.textmate.language.preferences.SnippetsRegistry;
import org.jetbrains.plugins.textmate.language.preferences.SnippetsRegistryBuilder;
import org.jetbrains.plugins.textmate.language.preferences.SnippetsRegistryImpl;
import org.jetbrains.plugins.textmate.language.preferences.TextMateAutoClosingPair;
import org.jetbrains.plugins.textmate.language.preferences.TextMateBracePair;
import org.jetbrains.plugins.textmate.language.preferences.TextMateShellVariable;
import org.jetbrains.plugins.textmate.language.preferences.TextMateSnippet;
import org.jetbrains.plugins.textmate.language.preferences.TextMateTextAttributes;
import org.jetbrains.plugins.textmate.language.syntax.TextMateSyntaxTableBuilder;
import org.jetbrains.plugins.textmate.language.syntax.TextMateSyntaxTableCore;
import org.jetbrains.plugins.textmate.language.syntax.highlighting.TextMateTextAttributesAdapter;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateCachingSelectorWeigher;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateCachingSelectorWeigherKt;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateSelectorWeigher;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateSelectorWeigherImpl;
import org.jetbrains.plugins.textmate.plist.JsonOrXmlPlistReader;
import org.jetbrains.plugins.textmate.plist.JsonPlistReader;
import org.jetbrains.plugins.textmate.plist.Plist;
import org.jetbrains.plugins.textmate.plist.PlistReaderCore;
import org.jetbrains.plugins.textmate.plist.XmlPlistReader;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\u0007H\u0002J\b\u0010%\u001a\u00020\"H\u0002J\u0014\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u0013H\u0016J\b\u0010'\u001a\u00020\u001eH\u0016J\b\u0010(\u001a\u00020\u001aH\u0016J\b\u0010)\u001a\u00020\u001cH\u0016J\u0012\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020\u000fH\u0016J\u0014\u0010-\u001a\u0004\u0018\u00010+2\b\u0010.\u001a\u0004\u0018\u00010\u000fH\u0016J\u0014\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u000f0\u0013H\u0016J\u0014\u00100\u001a\u0004\u0018\u0001012\b\u00102\u001a\u0004\u0018\u000103H\u0016J\b\u00104\u001a\u00020\"H\u0002JF\u00105\u001a\u00020\u00072\b\u00102\u001a\u0004\u0018\u0001032\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u000f062\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>H\u0002J\u0018\u0010?\u001a\u00020\"2\u0006\u0010@\u001a\u0002012\u0006\u0010A\u001a\u00020<H\u0002J \u0010B\u001a\u00020\"2\u0006\u0010@\u001a\u0002012\u0006\u00109\u001a\u00020:2\u0006\u0010=\u001a\u00020>H\u0002J,\u0010C\u001a\u00020\"2\u0006\u0010@\u001a\u0002012\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u000f062\u0006\u00107\u001a\u000208H\u0002J\u0012\u0010D\u001a\u00020\"2\b\u0010E\u001a\u0004\u0018\u00010FH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000ej\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u000f0\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0015\u001a\u0010\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00170\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lorg/jetbrains/plugins/textmate/TextMateServiceImpl;", "Lorg/jetbrains/plugins/textmate/TextMateService;", "myScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "builtinBundlesDisabled", "", "isInitialized", "registrationLock", "Ljava/util/concurrent/locks/ReentrantLock;", "globalCachingSelectorWeigher", "Lorg/jetbrains/plugins/textmate/language/syntax/selector/TextMateCachingSelectorWeigher;", "customHighlightingColors", "Ljava/util/HashMap;", "", "Lorg/jetbrains/plugins/textmate/language/syntax/highlighting/TextMateTextAttributesAdapter;", "Lkotlin/collections/HashMap;", "extensionMapping", "", "Lorg/jetbrains/plugins/textmate/bundles/TextMateFileNameMatcher;", "syntaxTable", "Ljava/util/concurrent/atomic/AtomicReference;", "Lorg/jetbrains/plugins/textmate/language/syntax/TextMateSyntaxTableCore;", "kotlin.jvm.PlatformType", "snippetRegistry", "Lorg/jetbrains/plugins/textmate/language/preferences/SnippetsRegistry;", "preferenceRegistry", "Lorg/jetbrains/plugins/textmate/language/preferences/PreferencesRegistry;", "shellVariablesRegistry", "Lorg/jetbrains/plugins/textmate/language/preferences/ShellVariablesRegistry;", "interner", "Lorg/jetbrains/plugins/textmate/language/TextMateInterner;", "reloadEnabledBundles", "", "registerBundles", "fireEvents", "unregisterAllBundles", "getCustomHighlightingColors", "getShellVariableRegistry", "getSnippetRegistry", "getPreferenceRegistry", "getLanguageDescriptorByFileName", "Lorg/jetbrains/plugins/textmate/language/TextMateLanguageDescriptor;", "fileName", "getLanguageDescriptorByExtension", "extension", "getFileNameMatcherToScopeNameMapping", "readBundle", "Lorg/jetbrains/plugins/textmate/bundles/TextMateBundleReader;", "directory", "Ljava/nio/file/Path;", "ensureInitialized", "registerBundle", "", "syntaxTableBuilder", "Lorg/jetbrains/plugins/textmate/language/syntax/TextMateSyntaxTableBuilder;", "preferencesBuilder", "Lorg/jetbrains/plugins/textmate/language/preferences/PreferencesRegistryBuilder;", "snippetsRegistryBuilder", "Lorg/jetbrains/plugins/textmate/language/preferences/SnippetsRegistryBuilder;", "shellVariablesRegistryBuilder", "Lorg/jetbrains/plugins/textmate/language/preferences/ShellVariablesRegistryBuilder;", "registerSnippets", "reader", "snippetRegistryBuilder", "registerPreferences", "registerLanguageSupport", "disableBuiltinBundles", "disposable", "Lcom/intellij/openapi/Disposable;", "intellij.textmate"})
@SourceDebugExtension(value={"SMAP\nTextMateServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextMateServiceImpl.kt\norg/jetbrains/plugins/textmate/TextMateServiceImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 measureTime.kt\nkotlin/time/MeasureTimeKt\n*L\n1#1,416:1\n774#2:417\n865#2,2:418\n1617#2,9:420\n1869#2:429\n1870#2:431\n1626#2:432\n1634#2,3:437\n1634#2,3:440\n1634#2,3:443\n1#3:430\n95#4:433\n135#4,3:434\n*S KotlinDebug\n*F\n+ 1 TextMateServiceImpl.kt\norg/jetbrains/plugins/textmate/TextMateServiceImpl\n*L\n94#1:417\n94#1:418,2\n114#1:420,9\n114#1:429\n114#1:431\n114#1:432\n310#1:437,3\n318#1:440,3\n326#1:443,3\n114#1:430\n269#1:433\n269#1:434,3\n*E\n"})
public final class TextMateServiceImpl
extends TextMateService {
    @NotNull
    private final CoroutineScope myScope;
    private boolean builtinBundlesDisabled;
    private volatile boolean isInitialized;
    @NotNull
    private final ReentrantLock registrationLock;
    @NotNull
    private final TextMateCachingSelectorWeigher globalCachingSelectorWeigher;
    @NotNull
    private final HashMap<CharSequence, TextMateTextAttributesAdapter> customHighlightingColors;
    @NotNull
    private Map<TextMateFileNameMatcher, ? extends CharSequence> extensionMapping;
    @NotNull
    private final AtomicReference<TextMateSyntaxTableCore> syntaxTable;
    @NotNull
    private final AtomicReference<SnippetsRegistry> snippetRegistry;
    @NotNull
    private final AtomicReference<PreferencesRegistry> preferenceRegistry;
    @NotNull
    private final AtomicReference<ShellVariablesRegistry> shellVariablesRegistry;
    @NotNull
    private final TextMateInterner interner;

    public TextMateServiceImpl(@NotNull CoroutineScope myScope) {
        Intrinsics.checkNotNullParameter((Object)myScope, (String)"myScope");
        this.myScope = myScope;
        this.registrationLock = new ReentrantLock();
        this.globalCachingSelectorWeigher = TextMateCachingSelectorWeigherKt.caching((TextMateSelectorWeigher)((TextMateSelectorWeigher)new TextMateSelectorWeigherImpl()));
        this.customHighlightingColors = new HashMap();
        Map map = Map.of();
        Intrinsics.checkNotNullExpressionValue(map, (String)"of(...)");
        this.extensionMapping = map;
        this.syntaxTable = new AtomicReference<TextMateSyntaxTableCore>(new TextMateSyntaxTableCore(MapsKt.emptyMap()));
        this.snippetRegistry = new AtomicReference<SnippetsRegistryImpl>(new SnippetsRegistryImpl((TextMateSelectorWeigher)this.globalCachingSelectorWeigher, MapsKt.emptyMap()));
        this.preferenceRegistry = new AtomicReference<PreferencesRegistryImpl>(new PreferencesRegistryImpl((TextMateSelectorWeigher)this.globalCachingSelectorWeigher, null, null, null, null, null, 62, null));
        this.shellVariablesRegistry = new AtomicReference<ShellVariablesRegistryImpl>(new ShellVariablesRegistryImpl((TextMateSelectorWeigher)this.globalCachingSelectorWeigher, MapsKt.emptyMap()));
        this.interner = (TextMateInterner)new TextMateConcurrentMapInterner();
    }

    @Override
    public void reloadEnabledBundles() {
        this.registerBundles(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void registerBundles(boolean fireEvents) {
        this.registrationLock.lock();
        try {
            Iterable $this$filter$iv;
            Iterable<TextMateBundleToLoad> builtInBundles;
            TextMateBuiltinBundlesSettings builtinBundlesSettings;
            TextMateUserBundlesSettings textMateUserBundlesSettings;
            TextMateSyntaxTableBuilder syntaxTableBuilder = new TextMateSyntaxTableBuilder(this.interner);
            PreferencesRegistryBuilder preferencesBuilder = new PreferencesRegistryBuilder((TextMateSelectorWeigher)this.globalCachingSelectorWeigher);
            SnippetsRegistryBuilder snippetsRegistryBuilder = new SnippetsRegistryBuilder((TextMateSelectorWeigher)this.globalCachingSelectorWeigher);
            ShellVariablesRegistryBuilder shellVariablesRegistryBuilder = new ShellVariablesRegistryBuilder((TextMateSelectorWeigher)this.globalCachingSelectorWeigher);
            Map<TextMateFileNameMatcher, ? extends CharSequence> oldExtensionsMapping = this.extensionMapping;
            this.unregisterAllBundles();
            if (TextMateUserBundlesSettings.Companion.getInstance() == null) {
                return;
            }
            TextMateUserBundlesSettings settings = textMateUserBundlesSettings;
            ConcurrentHashMap newExtensionsMapping = new ConcurrentHashMap();
            if (!this.builtinBundlesDisabled && (builtinBundlesSettings = TextMateBuiltinBundlesSettings.Companion.getInstance()) != null) {
                Iterable<TextMateBundleToLoad> iterable;
                Set<String> turnedOffBundleNames = builtinBundlesSettings.getTurnedOffBundleNames();
                builtInBundles = TextMateServiceImplKt.discoverBuiltinBundles(builtinBundlesSettings);
                if (turnedOffBundleNames.isEmpty()) {
                    iterable = builtInBundles;
                } else {
                    void $this$filterTo$iv$iv;
                    $this$filter$iv = builtInBundles;
                    boolean $i$f$filter = false;
                    Iterable iterable2 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        TextMateBundleToLoad it = (TextMateBundleToLoad)element$iv$iv;
                        boolean bl = false;
                        if (!(!turnedOffBundleNames.contains(it.getName()))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    iterable = (List)destination$iv$iv;
                }
                Iterable<TextMateBundleToLoad> bundlesToEnable = iterable;
                TextMateBundlesLoader.registerBundlesInParallel$default(this.myScope, bundlesToEnable, arg_0 -> TextMateServiceImpl.registerBundles$lambda$1(this, newExtensionsMapping, syntaxTableBuilder, preferencesBuilder, snippetsRegistryBuilder, shellVariablesRegistryBuilder, arg_0), null, 8, null);
            }
            Map<String, TextMatePersistentBundle> userBundles = settings.getBundles();
            List<TextMateBundleToLoad> bundlesToLoad = TextMateServiceImplKtKt.getPluginBundles(this);
            if (!userBundles.isEmpty()) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                builtInBundles = userBundles.entrySet();
                List<TextMateBundleToLoad> list = bundlesToLoad;
                boolean $i$f$mapNotNull = false;
                $this$filter$iv = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    TextMateBundleToLoad it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    Map.Entry entry = (Map.Entry)element$iv$iv;
                    boolean bl2 = false;
                    if ((((TextMatePersistentBundle)entry.getValue()).getEnabled() ? new TextMateBundleToLoad(((TextMatePersistentBundle)entry.getValue()).getName(), (String)entry.getKey()) : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                list.addAll((List)destination$iv$iv);
            }
            if (!bundlesToLoad.isEmpty()) {
                TextMateBundlesLoader.registerBundlesInParallel(this.myScope, bundlesToLoad, (Function1<? super TextMateBundleToLoad, Boolean>)((Function1)arg_0 -> TextMateServiceImpl.registerBundles$lambda$3(this, newExtensionsMapping, syntaxTableBuilder, preferencesBuilder, snippetsRegistryBuilder, shellVariablesRegistryBuilder, arg_0)), arg_0 -> TextMateServiceImpl.registerBundles$lambda$4(settings, arg_0));
            }
            if (fireEvents && !Intrinsics.areEqual(oldExtensionsMapping, newExtensionsMapping)) {
                TextMateServiceImplKt.access$fireFileTypesChangedEvent("old mappings = " + oldExtensionsMapping + ", new mappings" + newExtensionsMapping, () -> TextMateServiceImpl.registerBundles$lambda$5(this, newExtensionsMapping));
            } else {
                Map map = Map.copyOf(newExtensionsMapping);
                Intrinsics.checkNotNullExpressionValue(map, (String)"copyOf(...)");
                this.extensionMapping = map;
            }
            this.syntaxTable.set(syntaxTableBuilder.build());
            this.preferenceRegistry.set(preferencesBuilder.build());
            this.snippetRegistry.set(snippetsRegistryBuilder.build());
            this.shellVariablesRegistry.set(shellVariablesRegistryBuilder.build());
        }
        finally {
            this.registrationLock.unlock();
        }
    }

    private final void unregisterAllBundles() {
        Map map = Map.of();
        Intrinsics.checkNotNullExpressionValue(map, (String)"of(...)");
        this.extensionMapping = map;
        this.customHighlightingColors.clear();
        this.syntaxTable.set(new TextMateSyntaxTableCore(MapsKt.emptyMap()));
        this.globalCachingSelectorWeigher.clearCache();
        this.preferenceRegistry.set((PreferencesRegistry)new PreferencesRegistryImpl((TextMateSelectorWeigher)this.globalCachingSelectorWeigher, null, null, null, null, null, 62, null));
        this.snippetRegistry.set((SnippetsRegistry)new SnippetsRegistryImpl((TextMateSelectorWeigher)this.globalCachingSelectorWeigher, MapsKt.emptyMap()));
        this.shellVariablesRegistry.set((ShellVariablesRegistry)new ShellVariablesRegistryImpl((TextMateSelectorWeigher)this.globalCachingSelectorWeigher, MapsKt.emptyMap()));
        this.interner.clear();
    }

    @Override
    @NotNull
    public Map<CharSequence, TextMateTextAttributesAdapter> getCustomHighlightingColors() {
        this.ensureInitialized();
        return this.customHighlightingColors;
    }

    @Override
    @NotNull
    public ShellVariablesRegistry getShellVariableRegistry() {
        this.ensureInitialized();
        ShellVariablesRegistry shellVariablesRegistry = this.shellVariablesRegistry.get();
        Intrinsics.checkNotNullExpressionValue((Object)shellVariablesRegistry, (String)"get(...)");
        return shellVariablesRegistry;
    }

    @Override
    @NotNull
    public SnippetsRegistry getSnippetRegistry() {
        this.ensureInitialized();
        SnippetsRegistry snippetsRegistry = this.snippetRegistry.get();
        Intrinsics.checkNotNullExpressionValue((Object)snippetsRegistry, (String)"get(...)");
        return snippetsRegistry;
    }

    @Override
    @NotNull
    public PreferencesRegistry getPreferenceRegistry() {
        this.ensureInitialized();
        PreferencesRegistry preferencesRegistry = this.preferenceRegistry.get();
        Intrinsics.checkNotNullExpressionValue((Object)preferencesRegistry, (String)"get(...)");
        return preferencesRegistry;
    }

    @Override
    @Nullable
    public TextMateLanguageDescriptor getLanguageDescriptorByFileName(@NotNull CharSequence fileName) {
        CharSequence scopeName;
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        if (Strings.isEmpty((CharSequence)fileName)) {
            return null;
        }
        this.ensureInitialized();
        String string = ((Object)fileName).toString().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        CharSequence charSequence = scopeName = this.extensionMapping.get(new TextMateFileNameMatcher.Name(string));
        if (!(charSequence == null || charSequence.length() == 0)) {
            return this.syntaxTable.get().getLanguageDescriptor(scopeName);
        }
        Iterator extensionsIterator = TextMateEditorUtilsKt.fileNameExtensions(fileName).iterator();
        while (extensionsIterator.hasNext()) {
            TextMateLanguageDescriptor descriptor = this.getLanguageDescriptorByExtension((CharSequence)extensionsIterator.next());
            if (descriptor == null) continue;
            return descriptor;
        }
        return null;
    }

    @Override
    @Nullable
    public TextMateLanguageDescriptor getLanguageDescriptorByExtension(@Nullable CharSequence extension) {
        CharSequence scopeName;
        if (Strings.isEmpty((CharSequence)extension)) {
            return null;
        }
        this.ensureInitialized();
        String string = StringUtil.toLowerCase((String)String.valueOf(extension));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        CharSequence charSequence = scopeName = this.extensionMapping.get(new TextMateFileNameMatcher.Extension(string));
        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? null : this.syntaxTable.get().getLanguageDescriptor(scopeName);
    }

    @Override
    @NotNull
    public Map<TextMateFileNameMatcher, CharSequence> getFileNameMatcherToScopeNameMapping() {
        this.ensureInitialized();
        return this.extensionMapping;
    }

    @Override
    @Nullable
    public TextMateBundleReader readBundle(@Nullable Path directory) {
        if (directory != null) {
            TextMateNioResourceReader resourceReader = new TextMateNioResourceReader(directory);
            BundleType bundleType = BundleType.Companion.detectBundleType((TextMateResourceReader)resourceReader, PathsKt.getName((Path)directory));
            JsonOrXmlPlistReader plistReader = new JsonOrXmlPlistReader((PlistReaderCore)new JsonPlistReader(), (PlistReaderCore)new XmlPlistReader());
            return switch (WhenMappings.$EnumSwitchMapping$0[bundleType.ordinal()]) {
                case 1 -> BundleReaderCoreKt.readTextMateBundle((String)PathsKt.getName((Path)directory), (PlistReaderCore)((PlistReaderCore)plistReader), (TextMateResourceReader)((TextMateResourceReader)resourceReader));
                case 2 -> BundleReaderCoreKt.readSublimeBundle((String)PathsKt.getName((Path)directory), (PlistReaderCore)((PlistReaderCore)plistReader), (TextMateResourceReader)((TextMateResourceReader)resourceReader));
                case 3 -> VSCBundleReaderKt.readVSCBundle((PlistReaderCore)((PlistReaderCore)plistReader), (TextMateResourceReader)((TextMateResourceReader)resourceReader));
                case 4 -> null;
                default -> throw new NoWhenBranchMatchedException();
            };
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void ensureInitialized() {
        if (!this.isInitialized) {
            CancellationUtil.lockMaybeCancellable((Lock)this.registrationLock);
            try {
                if (this.isInitialized) {
                    return;
                }
                this.registerBundles(false);
                this.isInitialized = true;
            }
            catch (Throwable e) {
                TextMateService.LOG.debug("Initialization of textmate bundles was cancelled", e);
                throw e;
            }
            finally {
                this.registrationLock.unlock();
            }
        }
    }

    private final boolean registerBundle(Path directory, Map<TextMateFileNameMatcher, CharSequence> extensionMapping, TextMateSyntaxTableBuilder syntaxTableBuilder, PreferencesRegistryBuilder preferencesBuilder, SnippetsRegistryBuilder snippetsRegistryBuilder, ShellVariablesRegistryBuilder shellVariablesRegistryBuilder) {
        boolean bl;
        boolean $i$f$measureTimedValue = false;
        TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTimedValue2 = false;
        long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
        boolean bl2 = false;
        TextMateBundleReader reader = this.readBundle(directory);
        if (reader != null) {
            this.registerLanguageSupport(reader, extensionMapping, syntaxTableBuilder);
            this.registerPreferences(reader, preferencesBuilder, shellVariablesRegistryBuilder);
            this.registerSnippets(reader, snippetsRegistryBuilder);
            bl = true;
        } else {
            bl = false;
        }
        Boolean result$iv$iv = bl;
        TimedValue timedValue = new TimedValue((Object)result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
        boolean result = (Boolean)timedValue.component1();
        long duration = timedValue.component2-UwyO8pc();
        if (result) {
            TextMateService.LOG.debug("Bundle from `" + directory + "` loaded in " + Duration.toString-impl((long)duration));
        }
        return result;
    }

    private final void registerSnippets(TextMateBundleReader reader, SnippetsRegistryBuilder snippetRegistryBuilder) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            Iterator snippetsIterator = reader.readSnippets().iterator();
            while (snippetsIterator.hasNext()) {
                snippetRegistryBuilder.register((TextMateSnippet)snippetsIterator.next());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void registerPreferences(TextMateBundleReader reader, PreferencesRegistryBuilder preferencesBuilder, ShellVariablesRegistryBuilder shellVariablesRegistryBuilder) {
        for (TextMatePreferences preferences : reader.readPreferences()) {
            Set set;
            Set internedSmartTypingPairs;
            Set internedHighlightingPairs;
            Iterable<TextMateBracePair> iterable;
            Iterable<TextMateBracePair> destination$iv;
            String scopeName = this.interner.intern(preferences.getScopeName());
            Set set2 = preferences.getHighlightingPairs();
            if (set2 != null) {
                Set pairs = set2;
                boolean bl = false;
                if (pairs.isEmpty()) {
                    v1 = SetsKt.emptySet();
                } else {
                    void $this$mapTo$iv;
                    Iterable iterable2 = pairs;
                    destination$iv = new HashSet(pairs.size());
                    boolean $i$f$mapTo = false;
                    for (Object item$iv : $this$mapTo$iv) {
                        void it;
                        TextMateBracePair textMateBracePair = (TextMateBracePair)item$iv;
                        iterable = destination$iv;
                        boolean bl2 = false;
                        iterable.add(it.copy(this.interner.intern(it.getLeft()), this.interner.intern(it.getRight())));
                    }
                    v1 = (Set)destination$iv;
                }
            } else {
                v1 = internedHighlightingPairs = null;
            }
            if (preferences.getSmartTypingPairs() != null) {
                Set pairs;
                boolean bl = false;
                if (pairs.isEmpty()) {
                    v2 = SetsKt.emptySet();
                } else {
                    void $this$mapTo$iv;
                    Object item$iv;
                    destination$iv = pairs;
                    Collection destination$iv2 = new HashSet(pairs.size());
                    boolean $i$f$mapTo = false;
                    item$iv = $this$mapTo$iv.iterator();
                    while (item$iv.hasNext()) {
                        void it;
                        Object item$iv2 = item$iv.next();
                        iterable = (TextMateAutoClosingPair)item$iv2;
                        Collection bl2 = destination$iv2;
                        boolean bl3 = false;
                        bl2.add(TextMateAutoClosingPair.copy$default((TextMateAutoClosingPair)it, (CharSequence)this.interner.intern(((Object)it.getLeft()).toString()), (CharSequence)this.interner.intern(((Object)it.getRight()).toString()), (int)0, (int)4, null));
                    }
                    v2 = (Set)destination$iv2;
                }
            } else {
                v2 = internedSmartTypingPairs = null;
            }
            if (preferences.getSurroundingPairs() != null) {
                Set pairs;
                boolean bl = false;
                if (pairs.isEmpty()) {
                    set = SetsKt.emptySet();
                } else {
                    void $this$mapTo$iv;
                    Iterable destination$iv2 = pairs;
                    Collection destination$iv3 = new HashSet(pairs.size());
                    boolean $i$f$mapTo = false;
                    for (Object item$iv : $this$mapTo$iv) {
                        void it;
                        TextMateBracePair bl2 = (TextMateBracePair)item$iv;
                        Collection collection = destination$iv3;
                        boolean bl4 = false;
                        collection.add(it.copy(this.interner.intern(it.getLeft()), this.interner.intern(it.getRight())));
                    }
                    set = (Set)destination$iv3;
                }
            } else {
                set = null;
            }
            Set internedSurroundingPairs = set;
            preferencesBuilder.add(new Preferences((CharSequence)scopeName, internedHighlightingPairs, internedSmartTypingPairs, internedSurroundingPairs, preferences.getAutoCloseBefore(), preferences.getIndentationRules(), preferences.getOnEnterRules()));
            for (TextMateShellVariable variable : preferences.getVariables()) {
                shellVariablesRegistryBuilder.addVariable(variable);
            }
            TextMateTextAttributes customHighlightingAttributes = preferences.getCustomHighlightingAttributes();
            if (customHighlightingAttributes == null) continue;
            this.customHighlightingColors.put(scopeName, new TextMateTextAttributesAdapter(scopeName, customHighlightingAttributes));
        }
    }

    private final void registerLanguageSupport(TextMateBundleReader reader, Map<TextMateFileNameMatcher, CharSequence> extensionMapping, TextMateSyntaxTableBuilder syntaxTableBuilder) {
        for (TextMateGrammar grammar : reader.readGrammars()) {
            if (syntaxTableBuilder.addSyntax((Plist)grammar.getPlist().getValue()) == null) continue;
            for (TextMateFileNameMatcher fileNameMatcher : grammar.getFileNameMatchers()) {
                CharSequence charSequence;
                CharSequence rootScopeName;
                if (fileNameMatcher instanceof TextMateFileNameMatcher.Name) {
                    String newName;
                    Intrinsics.checkNotNullExpressionValue((Object)((TextMateFileNameMatcher.Name)fileNameMatcher).getFileName().toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
                    charSequence = extensionMapping.put((TextMateFileNameMatcher)((TextMateFileNameMatcher.Name)fileNameMatcher).copy(newName), rootScopeName);
                    continue;
                }
                charSequence = extensionMapping.put(fileNameMatcher, rootScopeName);
            }
        }
    }

    @TestOnly
    public final void disableBuiltinBundles(@Nullable Disposable disposable) {
        this.builtinBundlesDisabled = true;
        this.reloadEnabledBundles();
        this.isInitialized = true;
        Disposable disposable2 = disposable;
        Intrinsics.checkNotNull((Object)disposable2);
        Disposer.register((Disposable)disposable2, () -> TextMateServiceImpl.disableBuiltinBundles$lambda$0(this));
    }

    private static final boolean registerBundles$lambda$1(TextMateServiceImpl this$0, ConcurrentHashMap $newExtensionsMapping, TextMateSyntaxTableBuilder $syntaxTableBuilder, PreferencesRegistryBuilder $preferencesBuilder, SnippetsRegistryBuilder $snippetsRegistryBuilder, ShellVariablesRegistryBuilder $shellVariablesRegistryBuilder, TextMateBundleToLoad it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.registerBundle(Path.of(it.getPath(), new String[0]), $newExtensionsMapping, $syntaxTableBuilder, $preferencesBuilder, $snippetsRegistryBuilder, $shellVariablesRegistryBuilder);
    }

    private static final boolean registerBundles$lambda$3(TextMateServiceImpl this$0, ConcurrentHashMap $newExtensionsMapping, TextMateSyntaxTableBuilder $syntaxTableBuilder, PreferencesRegistryBuilder $preferencesBuilder, SnippetsRegistryBuilder $snippetsRegistryBuilder, ShellVariablesRegistryBuilder $shellVariablesRegistryBuilder, TextMateBundleToLoad bundleToLoad) {
        Intrinsics.checkNotNullParameter((Object)bundleToLoad, (String)"bundleToLoad");
        return this$0.registerBundle(Path.of(bundleToLoad.getPath(), new String[0]), $newExtensionsMapping, $syntaxTableBuilder, $preferencesBuilder, $snippetsRegistryBuilder, $shellVariablesRegistryBuilder);
    }

    private static final void registerBundles$lambda$4(TextMateUserBundlesSettings $settings, TextMateBundleToLoad bundleToLoad) {
        Intrinsics.checkNotNullParameter((Object)bundleToLoad, (String)"bundleToLoad");
        String bundleName = bundleToLoad.getName();
        Object[] objectArray = new Object[]{bundleName};
        String string = TextMateBundle.message("textmate.cant.register.bundle", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String errorMessage = string;
        Object[] objectArray2 = new Object[]{bundleName};
        Notification notification = new Notification("TextMate Bundles", TextMateBundle.message("textmate.bundle.load.error", objectArray2), errorMessage, NotificationType.ERROR);
        objectArray2 = new Object[]{bundleName};
        notification.addAction((AnAction)NotificationAction.createSimpleExpiring((String)TextMateBundle.message("textmate.disable.bundle.notification.action", objectArray2), () -> TextMateServiceImpl.registerBundles$lambda$4$0($settings, bundleToLoad))).notify(null);
    }

    private static final void registerBundles$lambda$4$0(TextMateUserBundlesSettings $settings, TextMateBundleToLoad $bundleToLoad) {
        $settings.disableBundle($bundleToLoad.getPath());
    }

    private static final void registerBundles$lambda$5(TextMateServiceImpl this$0, ConcurrentHashMap $newExtensionsMapping) {
        Map map = Map.copyOf($newExtensionsMapping);
        Intrinsics.checkNotNullExpressionValue(map, (String)"copyOf(...)");
        this$0.extensionMapping = map;
    }

    private static final void disableBuiltinBundles$lambda$0(TextMateServiceImpl this$0) {
        this$0.builtinBundlesDisabled = false;
        this$0.unregisterAllBundles();
        this$0.isInitialized = false;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BundleType.values().length];
            try {
                nArray[BundleType.TEXTMATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BundleType.SUBLIME.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BundleType.VSCODE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BundleType.UNDEFINED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

