/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.lang.java.lexer;

import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.java.lexer.BasicJavaLexer;
import org.jetbrains.kotlin.com.intellij.pom.java.JavaFeature;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaDocElementTypeFactory;
import org.jetbrains.kotlin.com.intellij.util.containers.CollectionFactory;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public final class JavaLexer
extends BasicJavaLexer {
    private static final Set<String> KEYWORDS = ContainerUtil.immutableSet("abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "true", "false", "null", "non-sealed");
    @NotNull
    private static final Map<CharSequence, JavaFeature> SOFT_KEYWORDS = CollectionFactory.createCharSequenceMap(true);

    public JavaLexer(@NotNull LanguageLevel level) {
        if (level == null) {
            JavaLexer.$$$reportNull$$$0(0);
        }
        super(level, JavaDocElementTypeFactory.INSTANCE);
    }

    public static boolean isKeyword(@NotNull String id, @NotNull LanguageLevel level) {
        if (id == null) {
            JavaLexer.$$$reportNull$$$0(1);
        }
        if (level == null) {
            JavaLexer.$$$reportNull$$$0(2);
        }
        return KEYWORDS.contains(id) || JavaFeature.ASSERTIONS.isSufficient(level) && "assert".equals(id) || JavaFeature.ENUMS.isSufficient(level) && "enum".equals(id);
    }

    public static boolean isSoftKeyword(@NotNull CharSequence id, @NotNull LanguageLevel level) {
        JavaFeature feature;
        if (id == null) {
            JavaLexer.$$$reportNull$$$0(3);
        }
        if (level == null) {
            JavaLexer.$$$reportNull$$$0(4);
        }
        return (feature = JavaLexer.softKeywordFeature(id)) != null && feature.isSufficient(level);
    }

    @Nullable
    public static JavaFeature softKeywordFeature(@NotNull CharSequence keyword) {
        if (keyword == null) {
            JavaLexer.$$$reportNull$$$0(5);
        }
        return SOFT_KEYWORDS.get(keyword);
    }

    static {
        SOFT_KEYWORDS.put("var", JavaFeature.LVTI);
        SOFT_KEYWORDS.put("record", JavaFeature.RECORDS);
        SOFT_KEYWORDS.put("yield", JavaFeature.SWITCH_EXPRESSION);
        SOFT_KEYWORDS.put("sealed", JavaFeature.SEALED_CLASSES);
        SOFT_KEYWORDS.put("permits", JavaFeature.SEALED_CLASSES);
        SOFT_KEYWORDS.put("when", JavaFeature.PATTERN_GUARDS_AND_RECORD_PATTERNS);
        SOFT_KEYWORDS.put("open", JavaFeature.MODULES);
        SOFT_KEYWORDS.put("module", JavaFeature.MODULES);
        SOFT_KEYWORDS.put("requires", JavaFeature.MODULES);
        SOFT_KEYWORDS.put("exports", JavaFeature.MODULES);
        SOFT_KEYWORDS.put("opens", JavaFeature.MODULES);
        SOFT_KEYWORDS.put("uses", JavaFeature.MODULES);
        SOFT_KEYWORDS.put("provides", JavaFeature.MODULES);
        SOFT_KEYWORDS.put("transitive", JavaFeature.MODULES);
        SOFT_KEYWORDS.put("to", JavaFeature.MODULES);
        SOFT_KEYWORDS.put("with", JavaFeature.MODULES);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyword";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/lang/java/lexer/JavaLexer";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isKeyword";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isSoftKeyword";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "softKeywordFeature";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

