/*
 * Decompiled with CFR 0.152.
 */
package mdemangler;

import ghidra.util.Msg;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import mdemangler.MDException;
import mdemangler.MDMang;
import mdemangler.MDParsableItem;
import mdemangler.MDType;
import mdemangler.datatype.MDDataType;
import mdemangler.datatype.MDDataTypeParser;
import mdemangler.functiontype.MDFunctionType;
import mdemangler.typeinfo.MDTypeInfo;
import mdemangler.typeinfo.MDTypeInfoParser;

public class MDFuzzyFit {
    private int numCharsRemaining = 0;
    private List<Class<? extends MDParsableItem>> classList = new ArrayList<Class<? extends MDParsableItem>>();

    public MDFuzzyFit() {
        this.classList.add(MDType.class);
        this.classList.add(MDDataType.class);
        this.classList.add(MDFunctionType.class);
    }

    public boolean fuzz(String mangledArg) {
        Msg.info((Object)this, (Object)("Symbol: " + mangledArg));
        Msg.info((Object)this, (Object)("Length: " + mangledArg.length()));
        int bestTypeInfoLocation = this.getBestTypeInfoLocation(mangledArg);
        Msg.info((Object)this, (Object)("Best type location: " + bestTypeInfoLocation));
        int bestTypeLocation = this.getBestTypeLocation(mangledArg);
        Msg.info((Object)this, (Object)("Best type location: " + bestTypeLocation));
        StringBuilder outputBuilder = new StringBuilder();
        if (mangledArg == null) {
            return false;
        }
        MDMang dmang = new MDMang();
        int offset = mangledArg.length();
        outputBuilder.append("Symbol: ");
        outputBuilder.append(mangledArg);
        while (--offset >= 0) {
            String substring = mangledArg.substring(offset);
            for (Class<? extends MDParsableItem> tryClass : this.classList) {
                boolean pass = true;
                try {
                    dmang.setMangledSymbol(substring);
                    dmang.pushContext();
                    this.numCharsRemaining = substring.length();
                    MDParsableItem tryItem = this.createItem(tryClass, dmang);
                    tryItem.parse();
                    this.numCharsRemaining = dmang.getNumCharsRemaining();
                    dmang.popContext();
                    StringBuilder builder = new StringBuilder();
                    tryItem.insert(builder);
                    String substringDemangled = builder.toString();
                    if (this.numCharsRemaining == 0) {
                        outputBuilder.append("Offset: ");
                        outputBuilder.append(offset);
                        outputBuilder.append("; Class: ");
                        outputBuilder.append(tryClass.getSimpleName());
                        outputBuilder.append("; Output:");
                        outputBuilder.append(substringDemangled);
                    }
                }
                catch (MDException e) {
                    pass = false;
                }
                outputBuilder.append("Offset: ");
                outputBuilder.append(offset);
                outputBuilder.append("; Class: ");
                outputBuilder.append(tryClass.getSimpleName());
                outputBuilder.append("; GoodResult: ");
                outputBuilder.append(pass);
            }
        }
        Msg.info((Object)this, (Object)outputBuilder);
        return true;
    }

    private int getBestTypeInfoLocation(String mangledArg) {
        MDMang dmang = new MDMang();
        int offset = mangledArg.length();
        boolean highest = false;
        int bestOffset = offset;
        while (--offset >= 0) {
            try {
                String substring = mangledArg.substring(offset);
                dmang.setMangledSymbol(substring);
                dmang.pushContext();
                MDTypeInfo typeInfo = MDTypeInfoParser.parse(dmang, -1);
                typeInfo.parse();
                int num = dmang.getNumCharsRemaining();
                dmang.popContext();
                if (num != 0) continue;
                bestOffset = offset;
            }
            catch (MDException mde) {
                int a = 1;
                ++a;
            }
            catch (Exception e) {
                int a = 1;
                ++a;
            }
        }
        return bestOffset;
    }

    private int getBestTypeLocation(String mangledArg) {
        MDMang dmang = new MDMang();
        int offset = mangledArg.length();
        boolean highest = false;
        int bestOffset = offset;
        while (--offset >= 0) {
            try {
                String substring = mangledArg.substring(offset);
                dmang.setMangledSymbol(substring);
                dmang.pushContext();
                MDDataType type = MDDataTypeParser.parseDataType(dmang, highest);
                type.parse();
                int num = dmang.getNumCharsRemaining();
                dmang.popContext();
                if (num != 0) continue;
                bestOffset = offset;
            }
            catch (MDException mde) {
                int a = 1;
                ++a;
            }
            catch (Exception e) {
                int a = 1;
                ++a;
            }
        }
        return bestOffset;
    }

    private MDParsableItem createItem(Class<? extends MDParsableItem> clazz, MDMang dmang) throws MDException {
        MDParsableItem item;
        Constructor<? extends MDParsableItem> constructor;
        Class[] constructorClassArgs = new Class[]{MDMang.class};
        try {
            constructor = clazz.getDeclaredConstructor(constructorClassArgs);
        }
        catch (SecurityException e) {
            throw new MDException("Security exception when getting constructor for class: " + clazz.getName() + ": " + String.valueOf(e));
        }
        catch (NoSuchMethodException e) {
            throw new MDException("Constructor not found for class: " + clazz.getName() + ": " + String.valueOf(e));
        }
        try {
            item = constructor.newInstance(dmang);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new MDException("Cannot create new instance of: " + clazz.getName() + ": " + String.valueOf(e));
        }
        return item;
    }
}

