/*
 * Decompiled with CFR 0.152.
 */
package ghidra.asm.wild.sem;

import ghidra.app.plugin.assembler.sleigh.expr.MaskedLong;
import ghidra.app.plugin.assembler.sleigh.expr.OperandValueSolver;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyPatternBlock;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedPatterns;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyTreeResolver;
import ghidra.app.plugin.processors.sleigh.Constructor;
import ghidra.app.plugin.processors.sleigh.expression.BinaryExpression;
import ghidra.app.plugin.processors.sleigh.expression.ContextField;
import ghidra.app.plugin.processors.sleigh.expression.OperandValue;
import ghidra.app.plugin.processors.sleigh.expression.PatternExpression;
import ghidra.app.plugin.processors.sleigh.expression.TokenField;
import ghidra.app.plugin.processors.sleigh.expression.UnaryExpression;
import ghidra.app.plugin.processors.sleigh.symbol.OperandSymbol;
import ghidra.asm.wild.sem.WildAssemblyResolvedPatterns;

public class PatternUtils {
    private PatternUtils() {
    }

    public static WildAssemblyResolvedPatterns castWild(AssemblyResolvedPatterns rp) {
        return (WildAssemblyResolvedPatterns)rp;
    }

    public static AssemblyPatternBlock collectLocation(PatternExpression exp) {
        if (exp instanceof BinaryExpression) {
            BinaryExpression bin = (BinaryExpression)exp;
            return PatternUtils.collectLocation(bin.getLeft()).combine(PatternUtils.collectLocation(bin.getRight()));
        }
        if (exp instanceof UnaryExpression) {
            UnaryExpression un = (UnaryExpression)exp;
            return PatternUtils.collectLocation(un.getUnary());
        }
        if (exp instanceof ContextField) {
            ContextField cf = (ContextField)exp;
            return AssemblyPatternBlock.nop();
        }
        if (exp instanceof TokenField) {
            TokenField tf = (TokenField)exp;
            return AssemblyPatternBlock.fromTokenField((TokenField)tf, (MaskedLong)MaskedLong.ONES);
        }
        if (exp instanceof OperandValue) {
            OperandValue ov = (OperandValue)exp;
            Constructor cons = ov.getConstructor();
            OperandSymbol sym = cons.getOperand(ov.getIndex());
            PatternExpression patexp = OperandValueSolver.getDefiningExpression((OperandSymbol)sym);
            return PatternUtils.collectLocation(patexp).shift(AssemblyTreeResolver.computeOffset((OperandSymbol)sym, (Constructor)cons));
        }
        return AssemblyPatternBlock.nop();
    }
}

