\name{DanielssonDistanceMapImageFilter}
\alias{DanielssonDistanceMapImageFilter}
\title{DanielssonDistanceMapImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
This filter computes the distance map of the input image as an
approximation with pixel accuracy to the Euclidean distance.
DanielssonDistanceMapImageFilter}
\details{
TInputImage
Input Image Type
TOutputImage
Output Image Type
TVoronoiImage
Voronoi Image Type. Note the default value is TInputImage.
The input is assumed to contain numeric codes defining objects. The
filter will produce as output the following images:
A Voronoi partition using the same numeric codes as the input.
A distance map with the approximation to the euclidean distance. from
a particular pixel to the nearest object to this pixel in the input
image.
A vector map containing the component of the vector relating the
current pixel with the closest point of the closest object to this
pixel. Given that the components of the distance are computed in
"pixels", the vector is represented by an itk::Offset . That is, physical coordinates are not used.
 This filter is N-dimensional and known to be efficient in
computational time. The algorithm is the N-dimensional version of the
4SED algorithm given for two dimensions in:
Danielsson, Per-Erik. Euclidean Distance Mapping. Computer Graphics
and Image Processing 14, 227-248 (1980).
See:
DanielssonDistanceMap for the procedural interface
itk::DanielssonDistanceMapImageFilter for the Doxygen on the original ITK class.
DanielssonDistanceMapImageFilter}
%C++ includes: sitkDanielssonDistanceMapImageFilter.h
\section{Methods}{
\describe{
\item{ DanielssonDistanceMapImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{bool GetInputIsBinary() const:}{
Set/Get if the input is binary. If this variable is set, each nonzero
pixel in the input image will be given a unique numeric code to be
used by the Voronoi partition. If the image is binary but you are not
interested in the Voronoi regions of the different nonzero pixels,
then you need not set this.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{bool GetSquaredDistance() const:}{
Set/Get if the distance should be squared.
}
\item{bool GetUseImageSpacing() const:}{
Set/Get if image spacing should be used in computing distances.
}
\item{Image GetVectorDistanceMap() const:}{
Get vector field of distances.
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{Image GetVoronoiMap() const:}{
Get Voronoi Map This map shows for each pixel what object is closest
to it. Each object should be labeled by a number (larger than 0), so
the map has a value for each pixel corresponding to the label of the
closest object.
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{Self InputIsBinaryOff():}{}
\item{Self InputIsBinaryOn():}{
Set the value of InputIsBinary to true or false respectfully.
}
\item{Self SetInputIsBinary(bool InputIsBinary):}{
Set/Get if the input is binary. If this variable is set, each nonzero
pixel in the input image will be given a unique numeric code to be
used by the Voronoi partition. If the image is binary but you are not
interested in the Voronoi regions of the different nonzero pixels,
then you need not set this.
}
\item{Self SetSquaredDistance(bool SquaredDistance):}{
Set/Get if the distance should be squared.
}
\item{Self SetUseImageSpacing(bool UseImageSpacing):}{
Set/Get if image spacing should be used in computing distances.
}
\item{Self SquaredDistanceOff():}{}
\item{Self SquaredDistanceOn():}{
Set the value of SquaredDistance to true or false respectfully.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{Self UseImageSpacingOff():}{}
\item{Self UseImageSpacingOn():}{
Set the value of UseImageSpacing to true or false respectfully.
}
\item{ ~DanielssonDistanceMapImageFilter():}{
Destructor
}
}
}
