/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class QueryCacheStats
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, QueryCacheStats> {
    private final long cacheCount;
    private final long cacheSize;
    private final long evictions;
    private final long hitCount;
    @Nullable
    private final String memorySize;
    private final long memorySizeInBytes;
    private final long missCount;
    private final long totalCount;
    public static final JsonpDeserializer<QueryCacheStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, QueryCacheStats::setupQueryCacheStatsDeserializer);

    private QueryCacheStats(Builder builder) {
        this.cacheCount = ApiTypeHelper.requireNonNull(builder.cacheCount, this, "cacheCount");
        this.cacheSize = ApiTypeHelper.requireNonNull(builder.cacheSize, this, "cacheSize");
        this.evictions = ApiTypeHelper.requireNonNull(builder.evictions, this, "evictions");
        this.hitCount = ApiTypeHelper.requireNonNull(builder.hitCount, this, "hitCount");
        this.memorySize = builder.memorySize;
        this.memorySizeInBytes = ApiTypeHelper.requireNonNull(builder.memorySizeInBytes, this, "memorySizeInBytes");
        this.missCount = ApiTypeHelper.requireNonNull(builder.missCount, this, "missCount");
        this.totalCount = ApiTypeHelper.requireNonNull(builder.totalCount, this, "totalCount");
    }

    public static QueryCacheStats of(Function<Builder, ObjectBuilder<QueryCacheStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long cacheCount() {
        return this.cacheCount;
    }

    public final long cacheSize() {
        return this.cacheSize;
    }

    public final long evictions() {
        return this.evictions;
    }

    public final long hitCount() {
        return this.hitCount;
    }

    @Nullable
    public final String memorySize() {
        return this.memorySize;
    }

    public final long memorySizeInBytes() {
        return this.memorySizeInBytes;
    }

    public final long missCount() {
        return this.missCount;
    }

    public final long totalCount() {
        return this.totalCount;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("cache_count");
        generator.write(this.cacheCount);
        generator.writeKey("cache_size");
        generator.write(this.cacheSize);
        generator.writeKey("evictions");
        generator.write(this.evictions);
        generator.writeKey("hit_count");
        generator.write(this.hitCount);
        if (this.memorySize != null) {
            generator.writeKey("memory_size");
            generator.write(this.memorySize);
        }
        generator.writeKey("memory_size_in_bytes");
        generator.write(this.memorySizeInBytes);
        generator.writeKey("miss_count");
        generator.write(this.missCount);
        generator.writeKey("total_count");
        generator.write(this.totalCount);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupQueryCacheStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::cacheCount, JsonpDeserializer.longDeserializer(), "cache_count");
        op.add(Builder::cacheSize, JsonpDeserializer.longDeserializer(), "cache_size");
        op.add(Builder::evictions, JsonpDeserializer.longDeserializer(), "evictions");
        op.add(Builder::hitCount, JsonpDeserializer.longDeserializer(), "hit_count");
        op.add(Builder::memorySize, JsonpDeserializer.stringDeserializer(), "memory_size");
        op.add(Builder::memorySizeInBytes, JsonpDeserializer.longDeserializer(), "memory_size_in_bytes");
        op.add(Builder::missCount, JsonpDeserializer.longDeserializer(), "miss_count");
        op.add(Builder::totalCount, JsonpDeserializer.longDeserializer(), "total_count");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Long.hashCode(this.cacheCount);
        result = 31 * result + Long.hashCode(this.cacheSize);
        result = 31 * result + Long.hashCode(this.evictions);
        result = 31 * result + Long.hashCode(this.hitCount);
        result = 31 * result + Objects.hashCode(this.memorySize);
        result = 31 * result + Long.hashCode(this.memorySizeInBytes);
        result = 31 * result + Long.hashCode(this.missCount);
        result = 31 * result + Long.hashCode(this.totalCount);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryCacheStats other = (QueryCacheStats)o;
        return this.cacheCount == other.cacheCount && this.cacheSize == other.cacheSize && this.evictions == other.evictions && this.hitCount == other.hitCount && Objects.equals(this.memorySize, other.memorySize) && this.memorySizeInBytes == other.memorySizeInBytes && this.missCount == other.missCount && this.totalCount == other.totalCount;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, QueryCacheStats> {
        private Long cacheCount;
        private Long cacheSize;
        private Long evictions;
        private Long hitCount;
        @Nullable
        private String memorySize;
        private Long memorySizeInBytes;
        private Long missCount;
        private Long totalCount;

        public Builder() {
        }

        private Builder(QueryCacheStats o) {
            this.cacheCount = o.cacheCount;
            this.cacheSize = o.cacheSize;
            this.evictions = o.evictions;
            this.hitCount = o.hitCount;
            this.memorySize = o.memorySize;
            this.memorySizeInBytes = o.memorySizeInBytes;
            this.missCount = o.missCount;
            this.totalCount = o.totalCount;
        }

        private Builder(Builder o) {
            this.cacheCount = o.cacheCount;
            this.cacheSize = o.cacheSize;
            this.evictions = o.evictions;
            this.hitCount = o.hitCount;
            this.memorySize = o.memorySize;
            this.memorySizeInBytes = o.memorySizeInBytes;
            this.missCount = o.missCount;
            this.totalCount = o.totalCount;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder cacheCount(long value) {
            this.cacheCount = value;
            return this;
        }

        @Nonnull
        public final Builder cacheSize(long value) {
            this.cacheSize = value;
            return this;
        }

        @Nonnull
        public final Builder evictions(long value) {
            this.evictions = value;
            return this;
        }

        @Nonnull
        public final Builder hitCount(long value) {
            this.hitCount = value;
            return this;
        }

        @Nonnull
        public final Builder memorySize(@Nullable String value) {
            this.memorySize = value;
            return this;
        }

        @Nonnull
        public final Builder memorySizeInBytes(long value) {
            this.memorySizeInBytes = value;
            return this;
        }

        @Nonnull
        public final Builder missCount(long value) {
            this.missCount = value;
            return this;
        }

        @Nonnull
        public final Builder totalCount(long value) {
            this.totalCount = value;
            return this;
        }

        @Override
        @Nonnull
        public QueryCacheStats build() {
            this._checkSingleUse();
            return new QueryCacheStats(this);
        }
    }
}

