"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiColorPalettePicker", {
  enumerable: true,
  get: function get() {
    return _color_palette_picker.EuiColorPalettePicker;
  }
});
exports.OuiColorPalettePicker = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _form = require("../../form");
var _color_palette_display = require("../color_palette_display");
var _color_palette_picker = require("../../../eui_components/color_picker/color_palette_picker/color_palette_picker");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) { ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } } return n; }, _extends.apply(null, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) { o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) { if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } } return t; } /*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */ /*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var OuiColorPalettePicker = function OuiColorPalettePicker(_ref) {
  var className = _ref.className,
    _ref$compressed = _ref.compressed,
    compressed = _ref$compressed === void 0 ? false : _ref$compressed,
    disabled = _ref.disabled,
    _ref$fullWidth = _ref.fullWidth,
    fullWidth = _ref$fullWidth === void 0 ? false : _ref$fullWidth,
    _ref$isInvalid = _ref.isInvalid,
    isInvalid = _ref$isInvalid === void 0 ? false : _ref$isInvalid,
    onChange = _ref.onChange,
    _ref$readOnly = _ref.readOnly,
    readOnly = _ref$readOnly === void 0 ? false : _ref$readOnly,
    valueOfSelected = _ref.valueOfSelected,
    palettes = _ref.palettes,
    append = _ref.append,
    prepend = _ref.prepend,
    _ref$selectionDisplay = _ref.selectionDisplay,
    selectionDisplay = _ref$selectionDisplay === void 0 ? 'palette' : _ref$selectionDisplay,
    rest = _objectWithoutProperties(_ref, ["className", "compressed", "disabled", "fullWidth", "isInvalid", "onChange", "readOnly", "valueOfSelected", "palettes", "append", "prepend", "selectionDisplay"]);
  var getPalette = function getPalette(_ref2) {
    var type = _ref2.type,
      palette = _ref2.palette;
    // Working around ExclusiveUnion
    return type === 'gradient' ? /*#__PURE__*/_react.default.createElement(_color_palette_display.OuiColorPaletteDisplay, {
      type: type,
      palette: palette
    }) : /*#__PURE__*/_react.default.createElement(_color_palette_display.OuiColorPaletteDisplay, {
      type: type,
      palette: palette
    });
  };
  var paletteOptions = palettes.map(function (item) {
    var type = item.type,
      value = item.value,
      title = item.title,
      palette = item.palette,
      rest = _objectWithoutProperties(item, ["type", "value", "title", "palette"]);
    var paletteForDisplay = item.type !== 'text' ? getPalette(item) : null;
    return _objectSpread({
      value: String(value),
      inputDisplay: selectionDisplay === 'title' || type === 'text' ? title : paletteForDisplay,
      dropdownDisplay: /*#__PURE__*/_react.default.createElement("div", {
        className: "ouiColorPalettePicker__item"
      }, title && type !== 'text' && /*#__PURE__*/_react.default.createElement("div", {
        className: "ouiColorPalettePicker__itemTitle"
      }, title), type === 'text' ? title : paletteForDisplay)
    }, rest);
  });
  return /*#__PURE__*/_react.default.createElement(_form.OuiSuperSelect, _extends({
    className: className,
    options: paletteOptions,
    valueOfSelected: valueOfSelected,
    onChange: onChange,
    hasDividers: true,
    isInvalid: isInvalid,
    compressed: compressed,
    disabled: disabled,
    readOnly: readOnly,
    fullWidth: fullWidth,
    append: append,
    prepend: prepend
  }, rest));
};

/* OUI -> EUI Aliases: Build-Time */
exports.OuiColorPalettePicker = OuiColorPalettePicker;
OuiColorPalettePicker.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  compressed: _propTypes.default.bool,
  fullWidth: _propTypes.default.bool,
  isInvalid: _propTypes.default.bool,
  isLoading: _propTypes.default.bool,
  readOnly: _propTypes.default.bool,
  name: _propTypes.default.string,
  /**
     * Creates an input group with element(s) coming before input.
     * `string` | `ReactElement` or an array of these
     */
  prepend: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired, _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired).isRequired]),
  /**
     * Creates an input group with element(s) coming after input.
     * `string` | `ReactElement` or an array of these
     */
  append: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired, _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired).isRequired]),
  valueOfSelected: _propTypes.default.any,
  /**
       * Classes for the context menu item
       */
  itemClassName: _propTypes.default.string,
  /**
       * You must pass an `onChange` function to handle the update of the value
       */
  onChange: _propTypes.default.func,
  /**
       * Applied to the outermost wrapper (popover)
       */
  popoverClassName: _propTypes.default.string,
  /**
       * Controls whether the options are shown. Default: false
       */
  isOpen: _propTypes.default.bool,
  /**
       *  Specify what should be displayed after a selection: a `palette` or `title`
       */
  selectionDisplay: _propTypes.default.oneOf(["palette", "title"]),
  /**
       * An array of one of the following objects: #OuiColorPalettePickerPaletteText, #OuiColorPalettePickerPaletteFixed, #OuiColorPalettePickerPaletteGradient
       */
  palettes: _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.shape({
    /**
       *  For storing unique value of item
       */
    value: _propTypes.default.string.isRequired,
    /**
       *  The name of your palette
       */
    title: _propTypes.default.string.isRequired,
    /**
       * `text`: a text only option (a title is required).
       */
    type: _propTypes.default.oneOf(["text"]).isRequired,
    /**
       * Array of color `strings` or an array of #ColorStop. The stops must be numbers in an ordered range.
       */
    palette: _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.string.isRequired).isRequired, _propTypes.default.arrayOf(_propTypes.default.shape({
      stop: _propTypes.default.number.isRequired,
      color: _propTypes.default.string.isRequired
    }).isRequired).isRequired]),
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string
  }).isRequired, _propTypes.default.shape({
    /**
       *  For storing unique value of item
       */
    value: _propTypes.default.string.isRequired,
    /**
       *  The name of your palette
       */
    title: _propTypes.default.string,
    /**
       * `fixed`: individual color blocks
       */
    type: _propTypes.default.oneOf(["fixed"]).isRequired,
    /**
       * Array of color `strings` or an array of #ColorStop. The stops must be numbers in an ordered range.
       */
    palette: _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.string.isRequired).isRequired, _propTypes.default.arrayOf(_propTypes.default.shape({
      stop: _propTypes.default.number.isRequired,
      color: _propTypes.default.string.isRequired
    }).isRequired).isRequired]).isRequired,
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string
  }).isRequired, _propTypes.default.shape({
    /**
       *  For storing unique value of item
       */
    value: _propTypes.default.string.isRequired,
    /**
       *  The name of your palette
       */
    title: _propTypes.default.string,
    /**
       * `gradient`: each color fades into the next
       */
    type: _propTypes.default.oneOf(["gradient"]).isRequired,
    /**
       * Array of color `strings` or an array of #ColorStop. The stops must be numbers in an ordered range.
       */
    palette: _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.string.isRequired).isRequired, _propTypes.default.arrayOf(_propTypes.default.shape({
      stop: _propTypes.default.number.isRequired,
      color: _propTypes.default.string.isRequired
    }).isRequired).isRequired]).isRequired,
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string
  }).isRequired]).isRequired).isRequired
};
/* OUI -> EUI Aliases: Build-Time */