/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing.allocation.decider;

import java.util.function.BiPredicate;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.routing.RoutingNode;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.routing.allocation.RoutingAllocation;
import org.opensearch.cluster.routing.allocation.decider.AllocationDecider;
import org.opensearch.cluster.routing.allocation.decider.Decision;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;

public class ShardsLimitAllocationDecider
extends AllocationDecider {
    public static final String NAME = "shards_limit";
    private volatile int clusterShardLimit;
    private volatile int clusterPrimaryShardLimit;
    public static final Setting<Integer> INDEX_TOTAL_SHARDS_PER_NODE_SETTING = Setting.intSetting("index.routing.allocation.total_shards_per_node", -1, -1, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Integer> INDEX_TOTAL_PRIMARY_SHARDS_PER_NODE_SETTING = Setting.intSetting("index.routing.allocation.total_primary_shards_per_node", -1, -1, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Integer> CLUSTER_TOTAL_SHARDS_PER_NODE_SETTING = Setting.intSetting("cluster.routing.allocation.total_shards_per_node", -1, -1, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Integer> CLUSTER_TOTAL_PRIMARY_SHARDS_PER_NODE_SETTING = Setting.intSetting("cluster.routing.allocation.total_primary_shards_per_node", -1, -1, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private final Settings settings;

    public ShardsLimitAllocationDecider(Settings settings, ClusterSettings clusterSettings) {
        this.settings = settings;
        this.clusterShardLimit = CLUSTER_TOTAL_SHARDS_PER_NODE_SETTING.get(settings);
        this.clusterPrimaryShardLimit = CLUSTER_TOTAL_PRIMARY_SHARDS_PER_NODE_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_TOTAL_SHARDS_PER_NODE_SETTING, this::setClusterShardLimit);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_TOTAL_PRIMARY_SHARDS_PER_NODE_SETTING, this::setClusterPrimaryShardLimit);
    }

    private void setClusterShardLimit(int clusterShardLimit) {
        this.clusterShardLimit = clusterShardLimit;
    }

    private void setClusterPrimaryShardLimit(int clusterPrimaryShardLimit) {
        this.clusterPrimaryShardLimit = clusterPrimaryShardLimit;
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.doDecide(shardRouting, node, allocation, (count, limit) -> count >= limit);
    }

    @Override
    public Decision canRemain(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.doDecide(shardRouting, node, allocation, (count, limit) -> count > limit);
    }

    private Decision doDecide(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation, BiPredicate<Integer, Integer> decider) {
        int indexPrimaryShardCount;
        int indexShardCount;
        int nodePrimaryShardCount;
        IndexMetadata indexMetadata = allocation.metadata().getIndexSafe(shardRouting.index());
        int indexShardLimit = indexMetadata.getIndexTotalShardsPerNodeLimit();
        int indexPrimaryShardLimit = indexMetadata.getIndexTotalPrimaryShardsPerNodeLimit();
        int clusterShardLimit = this.clusterShardLimit;
        int clusterPrimaryShardLimit = this.clusterPrimaryShardLimit;
        if (indexShardLimit <= 0 && indexPrimaryShardLimit <= 0 && clusterShardLimit <= 0 && clusterPrimaryShardLimit <= 0) {
            return allocation.decision(Decision.YES, NAME, "total shard limits are disabled: [index: %d, index primary: %d, cluster: %d, cluster primary: %d] <= 0", indexShardLimit, indexPrimaryShardLimit, clusterShardLimit, clusterPrimaryShardLimit);
        }
        int nodeShardCount = node.numberOfOwningShards();
        if (clusterShardLimit > 0 && decider.test(nodeShardCount, clusterShardLimit)) {
            return allocation.decision(Decision.NO, NAME, "too many shards [%d] allocated to this node, cluster setting [%s=%d]", nodeShardCount, CLUSTER_TOTAL_SHARDS_PER_NODE_SETTING.getKey(), clusterShardLimit);
        }
        if (shardRouting.primary() && clusterPrimaryShardLimit > 0 && decider.test(nodePrimaryShardCount = node.numberOfOwningPrimaryShards(), clusterPrimaryShardLimit)) {
            return allocation.decision(Decision.NO, NAME, "too many primary shards [%d] allocated to this node, cluster setting [%s=%d]", nodePrimaryShardCount, CLUSTER_TOTAL_PRIMARY_SHARDS_PER_NODE_SETTING.getKey(), clusterPrimaryShardLimit);
        }
        if (indexShardLimit > 0 && decider.test(indexShardCount = node.numberOfOwningShardsForIndex(shardRouting.index()), indexShardLimit)) {
            return allocation.decision(Decision.NO, NAME, "too many shards [%d] allocated to this node for index [%s], index setting [%s=%d]", indexShardCount, shardRouting.getIndexName(), INDEX_TOTAL_SHARDS_PER_NODE_SETTING.getKey(), indexShardLimit);
        }
        if (indexPrimaryShardLimit > 0 && shardRouting.primary() && decider.test(indexPrimaryShardCount = node.numberOfOwningPrimaryShardsForIndex(shardRouting.index()), indexPrimaryShardLimit)) {
            return allocation.decision(Decision.NO, NAME, "too many primary shards [%d] allocated to this node for index [%s], index setting [%s=%d]", indexPrimaryShardCount, shardRouting.getIndexName(), INDEX_TOTAL_PRIMARY_SHARDS_PER_NODE_SETTING.getKey(), indexPrimaryShardLimit);
        }
        return allocation.decision(Decision.YES, NAME, "the shard count [%d] for this node is under the index limit [%d], index primary limit [%d], cluster level node limit [%d] and cluster level primary node limit [%d]", nodeShardCount, indexShardLimit, indexPrimaryShardLimit, clusterShardLimit, clusterPrimaryShardLimit);
    }
}

