/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.core.common.io.stream;

import java.io.IOException;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.rest.RestStatus;

public final class NotSerializableExceptionWrapper
extends OpenSearchException {
    private final String name;
    private final RestStatus status;

    public NotSerializableExceptionWrapper(Throwable other) {
        super(OpenSearchException.getExceptionName(other) + ": " + other.getMessage(), other.getCause(), new Object[0]);
        this.name = OpenSearchException.getExceptionName(other);
        this.status = ExceptionsHelper.status(other);
        this.setStackTrace(other.getStackTrace());
        for (Throwable otherSuppressed : other.getSuppressed()) {
            this.addSuppressed(otherSuppressed);
        }
        if (other instanceof OpenSearchException) {
            OpenSearchException ex = (OpenSearchException)other;
            for (String key : ex.getHeaderKeys()) {
                this.addHeader(key, ex.getHeader(key));
            }
            for (String key : ex.getMetadataKeys()) {
                this.addMetadata(key, ex.getMetadata(key));
            }
        }
    }

    public NotSerializableExceptionWrapper(StreamInput in) throws IOException {
        super(in);
        this.name = in.readString();
        this.status = RestStatus.readFrom(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.name);
        RestStatus.writeTo(out, this.status);
    }

    @Override
    protected String getExceptionName() {
        return this.name;
    }

    @Override
    public RestStatus status() {
        return this.status;
    }
}

