/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.util.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class UCPFormatter
extends Formatter {
    @Override
    public String format(LogRecord lr) {
        String msg = lr.getMessage();
        Level level = lr.getLevel();
        return new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss.SSS a Z").format(new Date(lr.getMillis()), new StringBuffer(), new FieldPosition(0)).append(' ').append("UCP ").append(level.toString()).append(' ').append(lr.getSequenceNumber()).append(' ').append(lr.getThreadID()).append(' ').append(lr.getLoggerName()).append(' ').append(lr.getSourceClassName()).append('.').append(lr.getSourceMethodName()).append(' ').append(this.fmtMsgParams(lr)).append(' ').append(this.fmtThrown(lr)).append('\n').toString();
    }

    private String fmtMsgParams(LogRecord lr) {
        String msg = lr.getMessage();
        if (msg == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String[] parts = msg.split("\\{\\d+\\}");
        Object[] params = lr.getParameters();
        int i = 0;
        for (String part : parts) {
            sb.append((Object)part);
            if (params == null || params.length <= i) continue;
            sb.append(params[i++]);
        }
        return sb.toString();
    }

    private String fmtThrown(LogRecord lr) {
        Throwable thrown = lr.getThrown();
        if (thrown == null) {
            return "";
        }
        StringWriter writer = new StringWriter();
        thrown.printStackTrace(new PrintWriter(writer));
        return "" + '\n' + writer + '\n';
    }
}

