/*++

Copyright (C) 2024 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.8.0-alpha.

Abstract: This is an autogenerated Go wrapper file in order to allow an easy
use of the 3MF Library.

Interface version: 2.4.1

*/

// Code generated by Automatic Component Toolkit (ACT); DO NOT EDIT.

package lib3mf

/*
#cgo linux LDFLAGS: -ldl
#include "lib3mf_dynamic.h"

*/
import "C"

import (
	"fmt"
	"unsafe"
	"runtime"
)

type ref = C.Lib3MFHandle


// PropertyType represents a Lib3MF enum.
type PropertyType int

const (
	PropertyType_NoPropertyType = 0
	PropertyType_BaseMaterial = 1
	PropertyType_TexCoord = 2
	PropertyType_Colors = 3
	PropertyType_Composite = 4
	PropertyType_Multi = 5
)

// SlicesMeshResolution represents a Lib3MF enum.
type SlicesMeshResolution int

const (
	SlicesMeshResolution_Fullres = 0
	SlicesMeshResolution_Lowres = 1
)

// ModelUnit represents a Lib3MF enum.
type ModelUnit int

const (
	ModelUnit_MicroMeter = 0
	ModelUnit_MilliMeter = 1
	ModelUnit_CentiMeter = 2
	ModelUnit_Inch = 3
	ModelUnit_Foot = 4
	ModelUnit_Meter = 5
)

// ObjectType represents a Lib3MF enum.
type ObjectType int

const (
	ObjectType_Other = 0
	ObjectType_Model = 1
	ObjectType_Support = 2
	ObjectType_SolidSupport = 3
)

// TextureType represents a Lib3MF enum.
type TextureType int

const (
	TextureType_Unknown = 0
	TextureType_PNG = 1
	TextureType_JPEG = 2
)

// TextureTileStyle represents a Lib3MF enum.
type TextureTileStyle int

const (
	TextureTileStyle_Wrap = 0
	TextureTileStyle_Mirror = 1
	TextureTileStyle_Clamp = 2
	TextureTileStyle_NoTileStyle = 3
)

// TextureFilter represents a Lib3MF enum.
type TextureFilter int

const (
	TextureFilter_Auto = 0
	TextureFilter_Linear = 1
	TextureFilter_Nearest = 2
)

// BeamLatticeCapMode represents a Lib3MF enum.
type BeamLatticeCapMode int

const (
	BeamLatticeCapMode_Sphere = 0
	BeamLatticeCapMode_HemiSphere = 1
	BeamLatticeCapMode_Butt = 2
)

// BeamLatticeClipMode represents a Lib3MF enum.
type BeamLatticeClipMode int

const (
	BeamLatticeClipMode_NoClipMode = 0
	BeamLatticeClipMode_Inside = 1
	BeamLatticeClipMode_Outside = 2
)

// BeamLatticeBallMode represents a Lib3MF enum.
type BeamLatticeBallMode int

const (
	BeamLatticeBallMode_BeamLatticeBallModeNone = 0
	BeamLatticeBallMode_Mixed = 1
	BeamLatticeBallMode_All = 2
)

// ProgressIdentifier represents a Lib3MF enum.
type ProgressIdentifier int

const (
	ProgressIdentifier_QUERYCANCELED = 0
	ProgressIdentifier_DONE = 1
	ProgressIdentifier_CLEANUP = 2
	ProgressIdentifier_READSTREAM = 3
	ProgressIdentifier_EXTRACTOPCPACKAGE = 4
	ProgressIdentifier_READNONROOTMODELS = 5
	ProgressIdentifier_READROOTMODEL = 6
	ProgressIdentifier_READRESOURCES = 7
	ProgressIdentifier_READMESH = 8
	ProgressIdentifier_READSLICES = 9
	ProgressIdentifier_READBUILD = 10
	ProgressIdentifier_READCUSTOMATTACHMENT = 11
	ProgressIdentifier_READTEXTURETACHMENTS = 12
	ProgressIdentifier_CREATEOPCPACKAGE = 13
	ProgressIdentifier_WRITEMODELSTOSTREAM = 14
	ProgressIdentifier_WRITEROOTMODEL = 15
	ProgressIdentifier_WRITENONROOTMODELS = 16
	ProgressIdentifier_WRITEATTACHMENTS = 17
	ProgressIdentifier_WRITECONTENTTYPES = 18
	ProgressIdentifier_WRITENOBJECTS = 19
	ProgressIdentifier_WRITENODES = 20
	ProgressIdentifier_WRITETRIANGLES = 21
	ProgressIdentifier_WRITESLICES = 22
	ProgressIdentifier_WRITEKEYSTORE = 23
)

// BlendMethod represents a Lib3MF enum.
type BlendMethod int

const (
	BlendMethod_NoBlendMethod = 0
	BlendMethod_Mix = 1
	BlendMethod_Multiply = 2
)

// ChannelName represents a Lib3MF enum.
type ChannelName int

const (
	ChannelName_Red = 0
	ChannelName_Green = 1
	ChannelName_Blue = 2
	ChannelName_Alpha = 3
)

// CompositionMethod represents a Lib3MF enum.
type CompositionMethod int

const (
	CompositionMethod_WeightedSum = 0
	CompositionMethod_Multiply = 1
	CompositionMethod_Min = 2
	CompositionMethod_Max = 3
	CompositionMethod_Mask = 4
)

// CompositionSpace represents a Lib3MF enum.
type CompositionSpace int

const (
	CompositionSpace_Raw = 0
	CompositionSpace_LinearColor = 1
)

// ImplicitNodeType represents a Lib3MF enum.
type ImplicitNodeType int

const (
	ImplicitNodeType_Addition = 0
	ImplicitNodeType_Subtraction = 1
	ImplicitNodeType_Multiplication = 2
	ImplicitNodeType_Division = 3
	ImplicitNodeType_Constant = 4
	ImplicitNodeType_ConstVec = 5
	ImplicitNodeType_ConstMat = 6
	ImplicitNodeType_ComposeVector = 7
	ImplicitNodeType_DecomposeVector = 8
	ImplicitNodeType_ComposeMatrix = 9
	ImplicitNodeType_MatrixFromColumns = 10
	ImplicitNodeType_MatrixFromRows = 11
	ImplicitNodeType_Dot = 12
	ImplicitNodeType_Cross = 13
	ImplicitNodeType_MatVecMultiplication = 14
	ImplicitNodeType_Transpose = 15
	ImplicitNodeType_Inverse = 16
	ImplicitNodeType_Sinus = 17
	ImplicitNodeType_Cosinus = 18
	ImplicitNodeType_Tan = 19
	ImplicitNodeType_ArcSin = 20
	ImplicitNodeType_ArcCos = 21
	ImplicitNodeType_ArcTan = 22
	ImplicitNodeType_ArcTan2 = 23
	ImplicitNodeType_Min = 24
	ImplicitNodeType_Max = 25
	ImplicitNodeType_Abs = 26
	ImplicitNodeType_Fmod = 27
	ImplicitNodeType_Pow = 28
	ImplicitNodeType_Sqrt = 29
	ImplicitNodeType_Exp = 30
	ImplicitNodeType_Log = 31
	ImplicitNodeType_Log2 = 32
	ImplicitNodeType_Log10 = 33
	ImplicitNodeType_Select = 34
	ImplicitNodeType_Clamp = 35
	ImplicitNodeType_Sinh = 36
	ImplicitNodeType_Cosh = 37
	ImplicitNodeType_Tanh = 38
	ImplicitNodeType_Round = 39
	ImplicitNodeType_Ceil = 40
	ImplicitNodeType_Floor = 41
	ImplicitNodeType_Sign = 42
	ImplicitNodeType_Fract = 43
	ImplicitNodeType_FunctionCall = 44
	ImplicitNodeType_Mesh = 45
	ImplicitNodeType_Length = 46
	ImplicitNodeType_ConstResourceID = 47
	ImplicitNodeType_VectorFromScalar = 48
	ImplicitNodeType_UnsignedMesh = 49
	ImplicitNodeType_Mod = 50
)

// ImplicitPortType represents a Lib3MF enum.
type ImplicitPortType int

const (
	ImplicitPortType_Scalar = 0
	ImplicitPortType_Vector = 1
	ImplicitPortType_Matrix = 2
	ImplicitPortType_ResourceID = 3
)

// ImplicitNodeConfiguration represents a Lib3MF enum.
type ImplicitNodeConfiguration int

const (
	ImplicitNodeConfiguration_Default = 0
	ImplicitNodeConfiguration_ScalarToScalar = 1
	ImplicitNodeConfiguration_VectorToVector = 2
	ImplicitNodeConfiguration_MatrixToMatrix = 3
)

// EncryptionAlgorithm represents a Lib3MF enum.
type EncryptionAlgorithm int

const (
	EncryptionAlgorithm_AES256_GCM = 1
)

// WrappingAlgorithm represents a Lib3MF enum.
type WrappingAlgorithm int

const (
	WrappingAlgorithm_RSA_OAEP = 0
)

// MgfAlgorithm represents a Lib3MF enum.
type MgfAlgorithm int

const (
	MgfAlgorithm_MGF1_SHA1 = 160
	MgfAlgorithm_MGF1_SHA224 = 224
	MgfAlgorithm_MGF1_SHA256 = 256
	MgfAlgorithm_MGF1_SHA384 = 384
	MgfAlgorithm_MGF1_SHA512 = 512
)

// DigestMethod represents a Lib3MF enum.
type DigestMethod int

const (
	DigestMethod_SHA1 = 160
	DigestMethod_SHA256 = 256
)

// Compression represents a Lib3MF enum.
type Compression int

const (
	Compression_NoCompression = 0
	Compression_Deflate = 1
)

// Triangle represents a Lib3MF struct.
type Triangle struct {
	Indices[3] uint32
}

// TriangleProperties represents a Lib3MF struct.
type TriangleProperties struct {
	ResourceID uint32
	PropertyIDs[3] uint32
}

// Position represents a Lib3MF struct.
type Position struct {
	Coordinates[3] float32
}

// Position2D represents a Lib3MF struct.
type Position2D struct {
	Coordinates[2] float32
}

// CompositeConstituent represents a Lib3MF struct.
type CompositeConstituent struct {
	PropertyID uint32
	MixingRatio float64
}

// MultiPropertyLayer represents a Lib3MF struct.
type MultiPropertyLayer struct {
	ResourceID uint32
	TheBlendMethod BlendMethod
}

// Tex2Coord represents a Lib3MF struct.
type Tex2Coord struct {
	U float64
	V float64
}

// Transform represents a Lib3MF struct.
type Transform struct {
	Fields[4][3] float32
}

// Box represents a Lib3MF struct.
type Box struct {
	MinCoordinate[3] float32
	MaxCoordinate[3] float32
}

// Color represents a Lib3MF struct.
type Color struct {
	Red uint8
	Green uint8
	Blue uint8
	Alpha uint8
}

// Beam represents a Lib3MF struct.
type Beam struct {
	Indices[2] uint32
	Radii[2] float64
	CapModes[2] BeamLatticeCapMode
}

// Ball represents a Lib3MF struct.
type Ball struct {
	Index uint32
	Radius float64
}

// Vector represents a Lib3MF struct.
type Vector struct {
	Coordinates[3] float64
}

// Matrix4x4 represents a Lib3MF struct.
type Matrix4x4 struct {
	Field[4][4] float64
}

// Error constants for Lib3MF.
const LIB3MF_ERROR_NOTIMPLEMENTED = 1;
const LIB3MF_ERROR_INVALIDPARAM = 2;
const LIB3MF_ERROR_INVALIDCAST = 3;
const LIB3MF_ERROR_BUFFERTOOSMALL = 4;
const LIB3MF_ERROR_GENERICEXCEPTION = 5;
const LIB3MF_ERROR_COULDNOTLOADLIBRARY = 6;
const LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT = 7;
const LIB3MF_ERROR_INCOMPATIBLEBINARYVERSION = 8;
const LIB3MF_ERROR_CALCULATIONABORTED = 10;
const LIB3MF_ERROR_SHOULDNOTBECALLED = 11;
const LIB3MF_ERROR_READERCLASSUNKNOWN = 100;
const LIB3MF_ERROR_WRITERCLASSUNKNOWN = 101;
const LIB3MF_ERROR_ITERATORINVALIDINDEX = 102;
const LIB3MF_ERROR_INVALIDMODELRESOURCE = 103;
const LIB3MF_ERROR_RESOURCENOTFOUND = 104;
const LIB3MF_ERROR_INVALIDMODEL = 105;
const LIB3MF_ERROR_INVALIDOBJECT = 106;
const LIB3MF_ERROR_INVALIDMESHOBJECT = 107;
const LIB3MF_ERROR_INVALIDCOMPONENTSOBJECT = 108;
const LIB3MF_ERROR_INVALIDCOMPONENT = 109;
const LIB3MF_ERROR_INVALIDBUILDITEM = 110;
const LIB3MF_ERROR_INVALIDBASEMATERIALGROUP = 111;
const LIB3MF_ERROR_INVALIDSLICESTACKRESOURCE = 112;
const LIB3MF_ERROR_INVALIDTEXTURERESOURCE = 113;
const LIB3MF_ERROR_INVALIDCOLORGROUP = 114;
const LIB3MF_ERROR_INVALIDTEXTURE2DGROUP = 115;
const LIB3MF_ERROR_INVALIDCOMPOSITEMATERIALS = 116;
const LIB3MF_ERROR_INVALIDMULTIPROPERTYGROUP = 117;
const LIB3MF_ERROR_INVALIDRESOURCEINDEX = 120;
const LIB3MF_ERROR_ATTACHMENTNOTFOUND = 121;
const LIB3MF_ERROR_FORBIDDENCYCLICREFERENCE = 130;
const LIB3MF_ERROR_INVALIDATTACHMENTSTREAM = 131;
const LIB3MF_ERROR_INVALIDPROPERTYCOUNT = 132;
const LIB3MF_ERROR_UNKOWNPROGRESSIDENTIFIER = 140;
const LIB3MF_ERROR_ELEMENTCOUNTEXCEEDSLIMIT = 141;
const LIB3MF_ERROR_INVALIDRESOURCE = 142;
const LIB3MF_ERROR_INVALIDLEVELSET = 143;
const LIB3MF_ERROR_COULDNOTFINDTRIANGLESET = 144;
const LIB3MF_ERROR_INVALIDTRIANGLESETINDEX = 145;
const LIB3MF_ERROR_BEAMLATTICE_INVALID_OBJECTTYPE = 2000;
const LIB3MF_ERROR_INVALIDKEYSTORE = 3000;
const LIB3MF_ERROR_INVALIDKEYSTORECONSUMER = 3001;
const LIB3MF_ERROR_KEYSTORECONSUMERNOTFOUND = 3002;
const LIB3MF_ERROR_KEYSTORERESOURCEDATANOTFOUND = 3003;
const LIB3MF_ERROR_SECURECONTEXTNOTREGISTERED = 3004;
const LIB3MF_ERROR_INVALIDKEYSIZE = 3005;
const LIB3MF_ERROR_INCOMPATIBLEPORTTYPES = 4000;
const LIB3MF_ERROR_GRAPHISCYCLIC = 4001;
const LIB3MF_ERROR_INPUTNOTSET = 4002;
const LIB3MF_ERROR_INVALIDNODECONFIGURATION = 4003;

// WrappedError is an error that wraps a Lib3MF error.
type WrappedError struct {
	Code uint32
	Message string
}

func (e *WrappedError) Error() string {
	return fmt.Sprintf("lib3mf: %s (%d)", e.Message, e.Code)
}

func errorMessage(errorcode uint32) string {
	switch (errorcode) {
	case LIB3MF_ERROR_NOTIMPLEMENTED:
		return "functionality not implemented";
	case LIB3MF_ERROR_INVALIDPARAM:
		return "an invalid parameter was passed";
	case LIB3MF_ERROR_INVALIDCAST:
		return "a type cast failed";
	case LIB3MF_ERROR_BUFFERTOOSMALL:
		return "a provided buffer is too small";
	case LIB3MF_ERROR_GENERICEXCEPTION:
		return "a generic exception occurred";
	case LIB3MF_ERROR_COULDNOTLOADLIBRARY:
		return "the library could not be loaded";
	case LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT:
		return "a required exported symbol could not be found in the library";
	case LIB3MF_ERROR_INCOMPATIBLEBINARYVERSION:
		return "the version of the binary interface does not match the bindings interface";
	case LIB3MF_ERROR_CALCULATIONABORTED:
		return "a calculation has been aborted";
	case LIB3MF_ERROR_SHOULDNOTBECALLED:
		return "functionality should not be called";
	case LIB3MF_ERROR_READERCLASSUNKNOWN:
		return "the queried reader class is unknown";
	case LIB3MF_ERROR_WRITERCLASSUNKNOWN:
		return "the queried writer class is unknown";
	case LIB3MF_ERROR_ITERATORINVALIDINDEX:
		return "the current index of an iterator is invalid";
	case LIB3MF_ERROR_INVALIDMODELRESOURCE:
		return "no Model Resource has been given";
	case LIB3MF_ERROR_RESOURCENOTFOUND:
		return "Resource not found";
	case LIB3MF_ERROR_INVALIDMODEL:
		return "A model is invalid";
	case LIB3MF_ERROR_INVALIDOBJECT:
		return "An object is invalid";
	case LIB3MF_ERROR_INVALIDMESHOBJECT:
		return "A mesh object is invalid";
	case LIB3MF_ERROR_INVALIDCOMPONENTSOBJECT:
		return "A components object is invalid";
	case LIB3MF_ERROR_INVALIDCOMPONENT:
		return "A component is invalid";
	case LIB3MF_ERROR_INVALIDBUILDITEM:
		return "A build item is invalid";
	case LIB3MF_ERROR_INVALIDBASEMATERIALGROUP:
		return "A basematerialgroup is invalid";
	case LIB3MF_ERROR_INVALIDSLICESTACKRESOURCE:
		return "A slicestack resource is invalid";
	case LIB3MF_ERROR_INVALIDTEXTURERESOURCE:
		return "A texture resource is invalid";
	case LIB3MF_ERROR_INVALIDCOLORGROUP:
		return "A color group resource is invalid";
	case LIB3MF_ERROR_INVALIDTEXTURE2DGROUP:
		return "A texture2d group resource is invalid";
	case LIB3MF_ERROR_INVALIDCOMPOSITEMATERIALS:
		return "A composite materials resource is invalid";
	case LIB3MF_ERROR_INVALIDMULTIPROPERTYGROUP:
		return "A MultiPropertyGroup resource is invalid";
	case LIB3MF_ERROR_INVALIDRESOURCEINDEX:
		return "A resource index is invalid";
	case LIB3MF_ERROR_ATTACHMENTNOTFOUND:
		return "Attachment not found";
	case LIB3MF_ERROR_FORBIDDENCYCLICREFERENCE:
		return "A component references one of its ancestors";
	case LIB3MF_ERROR_INVALIDATTACHMENTSTREAM:
		return "An attachment stream is invalid";
	case LIB3MF_ERROR_INVALIDPROPERTYCOUNT:
		return "Invalid property count.";
	case LIB3MF_ERROR_UNKOWNPROGRESSIDENTIFIER:
		return "A progress identifier is unknown";
	case LIB3MF_ERROR_ELEMENTCOUNTEXCEEDSLIMIT:
		return "An element buffer exceeds its spec limit";
	case LIB3MF_ERROR_INVALIDRESOURCE:
		return "A resource is invalid";
	case LIB3MF_ERROR_INVALIDLEVELSET:
		return "A level set is invalid";
	case LIB3MF_ERROR_COULDNOTFINDTRIANGLESET:
		return "Could not find triangle set";
	case LIB3MF_ERROR_INVALIDTRIANGLESETINDEX:
		return "Invalid triangle set index";
	case LIB3MF_ERROR_BEAMLATTICE_INVALID_OBJECTTYPE:
		return "This object type is not valid for beamlattices";
	case LIB3MF_ERROR_INVALIDKEYSTORE:
		return "The keystore object is invalid";
	case LIB3MF_ERROR_INVALIDKEYSTORECONSUMER:
		return "The consumer keystore object is invalid";
	case LIB3MF_ERROR_KEYSTORECONSUMERNOTFOUND:
		return "A consumer has not been found";
	case LIB3MF_ERROR_KEYSTORERESOURCEDATANOTFOUND:
		return "A resource data has not been found";
	case LIB3MF_ERROR_SECURECONTEXTNOTREGISTERED:
		return "A Key or Conentent encryption callback has not been registered";
	case LIB3MF_ERROR_INVALIDKEYSIZE:
		return "The key size is invalid";
	case LIB3MF_ERROR_INCOMPATIBLEPORTTYPES:
		return "Link could not be added, the port types are incompatible";
	case LIB3MF_ERROR_GRAPHISCYCLIC:
		return "The functin graph is cyclic. Only dircected graphs are valid and can be topological sorted.";
	case LIB3MF_ERROR_INPUTNOTSET:
		return "The input of a node is not set.";
	case LIB3MF_ERROR_INVALIDNODECONFIGURATION:
		return "The selected node configuration is not supported";
	default:
		return "unknown";
	}
}

func makeError(errorcode uint32) error {
	return &WrappedError{errorcode, errorMessage(uint32(errorcode))}
}

// ProgressCallbackFunc a callback function.
type ProgressCallbackFunc = func(abort *bool, progressValue float64, progressIdentifier ProgressIdentifier, userData uintptr)

var progressCallbackFunc ProgressCallbackFunc

//export progressCallback
func progressCallback(abort *C.bool, progressValue C.double, progressIdentifier C.eLib3MFProgressIdentifier, userData C.Lib3MF_pvoid) {
	if progressCallbackFunc == nil {
		return
	}
	progressCallbackFunc((*bool)(abort), float64(progressValue), ProgressIdentifier(progressIdentifier), uintptr(userData))
}

// WriteCallbackFunc callback to call for writing a data chunk.
type WriteCallbackFunc = func(byteData uint64, numBytes uint64, userData uintptr)

var writeCallbackFunc WriteCallbackFunc

//export writeCallback
func writeCallback(byteData C.uint64_t, numBytes C.uint64_t, userData C.Lib3MF_pvoid) {
	if writeCallbackFunc == nil {
		return
	}
	writeCallbackFunc(uint64(byteData), uint64(numBytes), uintptr(userData))
}

// ReadCallbackFunc callback to call for reading a data chunk.
type ReadCallbackFunc = func(byteData uint64, numBytes uint64, userData uintptr)

var readCallbackFunc ReadCallbackFunc

//export readCallback
func readCallback(byteData C.uint64_t, numBytes C.uint64_t, userData C.Lib3MF_pvoid) {
	if readCallbackFunc == nil {
		return
	}
	readCallbackFunc(uint64(byteData), uint64(numBytes), uintptr(userData))
}

// SeekCallbackFunc callback to call for seeking in the stream.
type SeekCallbackFunc = func(position uint64, userData uintptr)

var seekCallbackFunc SeekCallbackFunc

//export seekCallback
func seekCallback(position C.uint64_t, userData C.Lib3MF_pvoid) {
	if seekCallbackFunc == nil {
		return
	}
	seekCallbackFunc(uint64(position), uintptr(userData))
}

// RandomNumberCallbackFunc callback to generate random numbers.
type RandomNumberCallbackFunc = func(byteData uint64, numBytes uint64, userData uintptr, bytesWritten *uint64)

var randomNumberCallbackFunc RandomNumberCallbackFunc

//export randomNumberCallback
func randomNumberCallback(byteData C.uint64_t, numBytes C.uint64_t, userData C.Lib3MF_pvoid, bytesWritten *C.uint64_t) {
	if randomNumberCallbackFunc == nil {
		return
	}
	randomNumberCallbackFunc(uint64(byteData), uint64(numBytes), uintptr(userData), (*uint64)(bytesWritten))
}

// KeyWrappingCallbackFunc a callback used to wrap (encrypt) the content key available in keystore resource group.
type KeyWrappingCallbackFunc = func(kEKParams AccessRight, inBuffer []uint8, outBuffer []uint8, userData uintptr, status *uint64)

var keyWrappingCallbackFunc KeyWrappingCallbackFunc

//export keyWrappingCallback
func keyWrappingCallback(kEKParams C.Lib3MF_AccessRight, inBuffer *C.uint8_t, outBuffer *C.uint8_t, userData C.Lib3MF_pvoid, status *C.uint64_t) {
	if keyWrappingCallbackFunc == nil {
		return
	}
	keyWrappingCallbackFunc(*(*AccessRight)(unsafe.Pointer(&kEKParams)), *(*[]uint8)(unsafe.Pointer(inBuffer)), *(*[]uint8)(unsafe.Pointer(outBuffer)), uintptr(userData), (*uint64)(status))
}

// ContentEncryptionCallbackFunc a callback to encrypt/decrypt content called on each resource encrypted. This might be called several times depending on content size. If Input is not available(either null or size is 0), clients must return the result of authenticated tag generation/validation.
type ContentEncryptionCallbackFunc = func(cEKParams ContentEncryptionParams, input []uint8, output []uint8, userData uintptr, status *uint64)

var contentEncryptionCallbackFunc ContentEncryptionCallbackFunc

//export contentEncryptionCallback
func contentEncryptionCallback(cEKParams C.Lib3MF_ContentEncryptionParams, input *C.uint8_t, output *C.uint8_t, userData C.Lib3MF_pvoid, status *C.uint64_t) {
	if contentEncryptionCallbackFunc == nil {
		return
	}
	contentEncryptionCallbackFunc(*(*ContentEncryptionParams)(unsafe.Pointer(&cEKParams)), *(*[]uint8)(unsafe.Pointer(input)), *(*[]uint8)(unsafe.Pointer(output)), uintptr(userData), (*uint64)(status))
}

// Wrapper represents the number wrapper
type Wrapper struct {
	_ [0]func() // uncomparable; to make == not compile
	LibraryHandle ref
}

// Base represents a Lib3MF class.
type Base struct {
	_     		[0]func() // uncomparable; to make == not compile
	Ref   		ref       // identifies a C value, see ref type
	wrapperRef Wrapper
	gcPtr 		*ref      // used to trigger the finalizer when the Value is not referenced any more
}

// NewBase creates a new Base.
// The wrapped C pointer will be freed when the Go pointer is finalized,
// but one can release it manually calling Release.
func (wrapper Wrapper) NewBase(r ref) Base {
	gcPtr := new(ref)
	*gcPtr = r
	runtime.SetFinalizer(gcPtr, wrapper.releaseC)
	return Base{Ref: r, gcPtr: gcPtr, wrapperRef: wrapper}
}

// Release releases the C pointer.
func (inst Base) Release() error {
	err := inst.wrapperRef.Release(inst)
	*inst.gcPtr = nil
	return err
}

// Equal reports whether inst and w refer to the same C pointer.
func (inst Base) Equal(w Base) bool {
	return inst.Ref == w.Ref
}
// ClassTypeId get Class Type Id.
func (inst Base) ClassTypeId() (uint64, error) {
	var classTypeId C.uint64_t
	ret := C.CCall_lib3mf_base_classtypeid(inst.wrapperRef.LibraryHandle, inst.Ref, &classTypeId)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint64(classTypeId), nil
}


// Writer represents a Lib3MF class.
type Writer struct {
	Base
}

func (wrapper Wrapper) NewWriter(r ref) Writer {
	return Writer{wrapper.NewBase(r)}
}

// WriteToFile writes out the model as file. The file type is specified by the Model Writer class.
func (inst Writer) WriteToFile(filename string) error {
	ret := C.CCall_lib3mf_writer_writetofile(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(filename)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetStreamSize retrieves the size of the full 3MF file stream.
func (inst Writer) GetStreamSize() (uint64, error) {
	var streamSize C.uint64_t
	ret := C.CCall_lib3mf_writer_getstreamsize(inst.wrapperRef.LibraryHandle, inst.Ref, &streamSize)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint64(streamSize), nil
}

// WriteToBuffer writes out the 3MF file into a memory buffer.
func (inst Writer) WriteToBuffer(buffer []uint8) ([]uint8, error) {
	var neededforbuffer C.uint64_t
	ret := C.CCall_lib3mf_writer_writetobuffer(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforbuffer, nil)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	if len(buffer) < int(neededforbuffer) {
	 buffer = append(buffer, make([]uint8, int(neededforbuffer)-len(buffer))...)
	}
	ret = C.CCall_lib3mf_writer_writetobuffer(inst.wrapperRef.LibraryHandle, inst.Ref, neededforbuffer, nil, (*C.uint8_t)(unsafe.Pointer(&buffer[0])))
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	return buffer[:int(neededforbuffer)], nil
}

// WriteToCallback writes out the model and passes the data to a provided callback function. The file type is specified by the Model Writer class.
func (inst Writer) WriteToCallback(theWriteCallback WriteCallbackFunc, theSeekCallback SeekCallbackFunc, userData uintptr) error {
	ret := C.CCall_lib3mf_writer_writetocallback(inst.wrapperRef.LibraryHandle, inst.Ref, (C.Lib3MFWriteCallback)(unsafe.Pointer(&theWriteCallback)), (C.Lib3MFSeekCallback)(unsafe.Pointer(&theSeekCallback)), (C.Lib3MF_pvoid)(userData))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	writeCallbackFunc = theWriteCallback
	seekCallbackFunc = theSeekCallback
	return nil
}

// SetProgressCallback set the progress callback for calls to this writer.
func (inst Writer) SetProgressCallback(progressCallback ProgressCallbackFunc, userData uintptr) error {
	ret := C.CCall_lib3mf_writer_setprogresscallback(inst.wrapperRef.LibraryHandle, inst.Ref, (C.Lib3MFProgressCallback)(unsafe.Pointer(&progressCallback)), (C.Lib3MF_pvoid)(userData))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	progressCallbackFunc = progressCallback
	return nil
}

// GetDecimalPrecision returns the number of digits after the decimal point to be written in each vertex coordinate-value.
func (inst Writer) GetDecimalPrecision() (uint32, error) {
	var decimalPrecision C.uint32_t
	ret := C.CCall_lib3mf_writer_getdecimalprecision(inst.wrapperRef.LibraryHandle, inst.Ref, &decimalPrecision)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(decimalPrecision), nil
}

// SetDecimalPrecision sets the number of digits after the decimal point to be written in each vertex coordinate-value.
func (inst Writer) SetDecimalPrecision(decimalPrecision uint32) error {
	ret := C.CCall_lib3mf_writer_setdecimalprecision(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(decimalPrecision))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// SetStrictModeActive activates (deactivates) the strict mode of the reader.
func (inst Writer) SetStrictModeActive(strictModeActive bool) error {
	ret := C.CCall_lib3mf_writer_setstrictmodeactive(inst.wrapperRef.LibraryHandle, inst.Ref, C.bool(strictModeActive))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetStrictModeActive queries whether the strict mode of the reader is active or not.
func (inst Writer) GetStrictModeActive() (bool, error) {
	var strictModeActive C.bool
	ret := C.CCall_lib3mf_writer_getstrictmodeactive(inst.wrapperRef.LibraryHandle, inst.Ref, &strictModeActive)
	if ret != 0 {
		return false, makeError(uint32(ret))
	}
	return bool(strictModeActive), nil
}

// GetWarning returns Warning and Error Information of the read process.
func (inst Writer) GetWarning(index uint32) (uint32, string, error) {
	var errorCode C.uint32_t
	var neededforwarning C.uint32_t
	var filledinwarning C.uint32_t
	ret := C.CCall_lib3mf_writer_getwarning(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(index), &errorCode, 0, &neededforwarning, nil)
	if ret != 0 {
		return 0, "", makeError(uint32(ret))
	}
	bufferSizewarning := neededforwarning
	bufferwarning := make([]byte, bufferSizewarning)
	ret = C.CCall_lib3mf_writer_getwarning(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(index), &errorCode, bufferSizewarning, &filledinwarning, (*C.char)(unsafe.Pointer(&bufferwarning[0])))
	if ret != 0 {
		return 0, "", makeError(uint32(ret))
	}
	return uint32(errorCode), string(bufferwarning[:(filledinwarning-1)]), nil
}

// GetWarningCount returns Warning and Error Count of the read process.
func (inst Writer) GetWarningCount() (uint32, error) {
	var count C.uint32_t
	ret := C.CCall_lib3mf_writer_getwarningcount(inst.wrapperRef.LibraryHandle, inst.Ref, &count)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(count), nil
}

// AddKeyWrappingCallback registers a callback to deal with data key encryption/decryption from keystore.
func (inst Writer) AddKeyWrappingCallback(consumerID string, theCallback KeyWrappingCallbackFunc, userData uintptr) error {
	ret := C.CCall_lib3mf_writer_addkeywrappingcallback(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(consumerID)[0])), (C.Lib3MFKeyWrappingCallback)(unsafe.Pointer(&theCallback)), (C.Lib3MF_pvoid)(userData))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	keyWrappingCallbackFunc = theCallback
	return nil
}

// SetContentEncryptionCallback registers a callback to deal with encryption of content.
func (inst Writer) SetContentEncryptionCallback(theCallback ContentEncryptionCallbackFunc, userData uintptr) error {
	ret := C.CCall_lib3mf_writer_setcontentencryptioncallback(inst.wrapperRef.LibraryHandle, inst.Ref, (C.Lib3MFContentEncryptionCallback)(unsafe.Pointer(&theCallback)), (C.Lib3MF_pvoid)(userData))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	contentEncryptionCallbackFunc = theCallback
	return nil
}


// Reader represents a Lib3MF class.
type Reader struct {
	Base
}

func (wrapper Wrapper) NewReader(r ref) Reader {
	return Reader{wrapper.NewBase(r)}
}

// ReadFromFile reads a model from a file. The file type is specified by the Model Reader class.
func (inst Reader) ReadFromFile(filename string) error {
	ret := C.CCall_lib3mf_reader_readfromfile(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(filename)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// ReadFromBuffer reads a model from a memory buffer.
func (inst Reader) ReadFromBuffer(buffer []uint8) error {
	ret := C.CCall_lib3mf_reader_readfrombuffer(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint64_t(len(buffer)), (*C.uint8_t)(unsafe.Pointer(&buffer[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// ReadFromCallback reads a model and from the data provided by a callback function.
func (inst Reader) ReadFromCallback(theReadCallback ReadCallbackFunc, streamSize uint64, theSeekCallback SeekCallbackFunc, userData uintptr) error {
	ret := C.CCall_lib3mf_reader_readfromcallback(inst.wrapperRef.LibraryHandle, inst.Ref, (C.Lib3MFReadCallback)(unsafe.Pointer(&theReadCallback)), C.uint64_t(streamSize), (C.Lib3MFSeekCallback)(unsafe.Pointer(&theSeekCallback)), (C.Lib3MF_pvoid)(userData))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	readCallbackFunc = theReadCallback
	seekCallbackFunc = theSeekCallback
	return nil
}

// SetProgressCallback set the progress callback for calls to this writer.
func (inst Reader) SetProgressCallback(progressCallback ProgressCallbackFunc, userData uintptr) error {
	ret := C.CCall_lib3mf_reader_setprogresscallback(inst.wrapperRef.LibraryHandle, inst.Ref, (C.Lib3MFProgressCallback)(unsafe.Pointer(&progressCallback)), (C.Lib3MF_pvoid)(userData))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	progressCallbackFunc = progressCallback
	return nil
}

// AddRelationToRead adds a relationship type which shall be read as attachment in memory while loading.
func (inst Reader) AddRelationToRead(relationShipType string) error {
	ret := C.CCall_lib3mf_reader_addrelationtoread(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(relationShipType)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// RemoveRelationToRead removes a relationship type which shall be read as attachment in memory while loading.
func (inst Reader) RemoveRelationToRead(relationShipType string) error {
	ret := C.CCall_lib3mf_reader_removerelationtoread(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(relationShipType)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// SetStrictModeActive activates (deactivates) the strict mode of the reader.
func (inst Reader) SetStrictModeActive(strictModeActive bool) error {
	ret := C.CCall_lib3mf_reader_setstrictmodeactive(inst.wrapperRef.LibraryHandle, inst.Ref, C.bool(strictModeActive))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetStrictModeActive queries whether the strict mode of the reader is active or not.
func (inst Reader) GetStrictModeActive() (bool, error) {
	var strictModeActive C.bool
	ret := C.CCall_lib3mf_reader_getstrictmodeactive(inst.wrapperRef.LibraryHandle, inst.Ref, &strictModeActive)
	if ret != 0 {
		return false, makeError(uint32(ret))
	}
	return bool(strictModeActive), nil
}

// GetWarning returns Warning and Error Information of the read process.
func (inst Reader) GetWarning(index uint32) (uint32, string, error) {
	var errorCode C.uint32_t
	var neededforwarning C.uint32_t
	var filledinwarning C.uint32_t
	ret := C.CCall_lib3mf_reader_getwarning(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(index), &errorCode, 0, &neededforwarning, nil)
	if ret != 0 {
		return 0, "", makeError(uint32(ret))
	}
	bufferSizewarning := neededforwarning
	bufferwarning := make([]byte, bufferSizewarning)
	ret = C.CCall_lib3mf_reader_getwarning(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(index), &errorCode, bufferSizewarning, &filledinwarning, (*C.char)(unsafe.Pointer(&bufferwarning[0])))
	if ret != 0 {
		return 0, "", makeError(uint32(ret))
	}
	return uint32(errorCode), string(bufferwarning[:(filledinwarning-1)]), nil
}

// GetWarningCount returns Warning and Error Count of the read process.
func (inst Reader) GetWarningCount() (uint32, error) {
	var count C.uint32_t
	ret := C.CCall_lib3mf_reader_getwarningcount(inst.wrapperRef.LibraryHandle, inst.Ref, &count)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(count), nil
}

// AddKeyWrappingCallback registers a callback to deal with key wrapping mechanism from keystore.
func (inst Reader) AddKeyWrappingCallback(consumerID string, theCallback KeyWrappingCallbackFunc, userData uintptr) error {
	ret := C.CCall_lib3mf_reader_addkeywrappingcallback(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(consumerID)[0])), (C.Lib3MFKeyWrappingCallback)(unsafe.Pointer(&theCallback)), (C.Lib3MF_pvoid)(userData))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	keyWrappingCallbackFunc = theCallback
	return nil
}

// SetContentEncryptionCallback registers a callback to deal with encryption of content.
func (inst Reader) SetContentEncryptionCallback(theCallback ContentEncryptionCallbackFunc, userData uintptr) error {
	ret := C.CCall_lib3mf_reader_setcontentencryptioncallback(inst.wrapperRef.LibraryHandle, inst.Ref, (C.Lib3MFContentEncryptionCallback)(unsafe.Pointer(&theCallback)), (C.Lib3MF_pvoid)(userData))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	contentEncryptionCallbackFunc = theCallback
	return nil
}


// PackagePart represents a Lib3MF class.
type PackagePart struct {
	Base
}

func (wrapper Wrapper) NewPackagePart(r ref) PackagePart {
	return PackagePart{wrapper.NewBase(r)}
}

// GetPath returns the absolute path of this PackagePart.
func (inst PackagePart) GetPath() (string, error) {
	var neededforpath C.uint32_t
	var filledinpath C.uint32_t
	ret := C.CCall_lib3mf_packagepart_getpath(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforpath, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSizepath := neededforpath
	bufferpath := make([]byte, bufferSizepath)
	ret = C.CCall_lib3mf_packagepart_getpath(inst.wrapperRef.LibraryHandle, inst.Ref, bufferSizepath, &filledinpath, (*C.char)(unsafe.Pointer(&bufferpath[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(bufferpath[:(filledinpath-1)]), nil
}

// SetPath sets the absolute path of this PackagePart.
func (inst PackagePart) SetPath(path string) error {
	ret := C.CCall_lib3mf_packagepart_setpath(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(path)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}


// Resource represents a Lib3MF class.
type Resource struct {
	Base
}

func (wrapper Wrapper) NewResource(r ref) Resource {
	return Resource{wrapper.NewBase(r)}
}

// GetResourceID retrieves the unique id of this resource within a package. This function will be removed in a later release in favor of GetUniqueResourceID.
func (inst Resource) GetResourceID() (uint32, error) {
	var uniqueResourceID C.uint32_t
	ret := C.CCall_lib3mf_resource_getresourceid(inst.wrapperRef.LibraryHandle, inst.Ref, &uniqueResourceID)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(uniqueResourceID), nil
}

// GetUniqueResourceID retrieves the unique id of this resource within a package.
func (inst Resource) GetUniqueResourceID() (uint32, error) {
	var uniqueResourceID C.uint32_t
	ret := C.CCall_lib3mf_resource_getuniqueresourceid(inst.wrapperRef.LibraryHandle, inst.Ref, &uniqueResourceID)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(uniqueResourceID), nil
}

// PackagePart returns the PackagePart within which this resource resides.
func (inst Resource) PackagePart() (PackagePart, error) {
	var packagePart ref
	ret := C.CCall_lib3mf_resource_packagepart(inst.wrapperRef.LibraryHandle, inst.Ref, &packagePart)
	if ret != 0 {
		return PackagePart{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewPackagePart(packagePart), nil
}

// SetPackagePart sets the new PackagePart within which this resource resides.
func (inst Resource) SetPackagePart(packagePart PackagePart) error {
	ret := C.CCall_lib3mf_resource_setpackagepart(inst.wrapperRef.LibraryHandle, inst.Ref, packagePart.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetModelResourceID retrieves the id of this resource within a model.
func (inst Resource) GetModelResourceID() (uint32, error) {
	var modelResourceId C.uint32_t
	ret := C.CCall_lib3mf_resource_getmodelresourceid(inst.wrapperRef.LibraryHandle, inst.Ref, &modelResourceId)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(modelResourceId), nil
}


// ResourceIterator represents a Lib3MF class.
type ResourceIterator struct {
	Base
}

func (wrapper Wrapper) NewResourceIterator(r ref) ResourceIterator {
	return ResourceIterator{wrapper.NewBase(r)}
}

// MoveNext iterates to the next resource in the list.
func (inst ResourceIterator) MoveNext() (bool, error) {
	var hasNext C.bool
	ret := C.CCall_lib3mf_resourceiterator_movenext(inst.wrapperRef.LibraryHandle, inst.Ref, &hasNext)
	if ret != 0 {
		return false, makeError(uint32(ret))
	}
	return bool(hasNext), nil
}

// MovePrevious iterates to the previous resource in the list.
func (inst ResourceIterator) MovePrevious() (bool, error) {
	var hasPrevious C.bool
	ret := C.CCall_lib3mf_resourceiterator_moveprevious(inst.wrapperRef.LibraryHandle, inst.Ref, &hasPrevious)
	if ret != 0 {
		return false, makeError(uint32(ret))
	}
	return bool(hasPrevious), nil
}

// GetCurrent returns the resource the iterator points at.
func (inst ResourceIterator) GetCurrent() (Resource, error) {
	var resource ref
	ret := C.CCall_lib3mf_resourceiterator_getcurrent(inst.wrapperRef.LibraryHandle, inst.Ref, &resource)
	if ret != 0 {
		return Resource{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewResource(resource), nil
}

// Clone creates a new resource iterator with the same resource list.
func (inst ResourceIterator) Clone() (ResourceIterator, error) {
	var outResourceIterator ref
	ret := C.CCall_lib3mf_resourceiterator_clone(inst.wrapperRef.LibraryHandle, inst.Ref, &outResourceIterator)
	if ret != 0 {
		return ResourceIterator{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewResourceIterator(outResourceIterator), nil
}

// Count returns the number of resoucres the iterator captures.
func (inst ResourceIterator) Count() (uint64, error) {
	var count C.uint64_t
	ret := C.CCall_lib3mf_resourceiterator_count(inst.wrapperRef.LibraryHandle, inst.Ref, &count)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint64(count), nil
}


// SliceStackIterator represents a Lib3MF class.
type SliceStackIterator struct {
	ResourceIterator
}

func (wrapper Wrapper) NewSliceStackIterator(r ref) SliceStackIterator {
	return SliceStackIterator{wrapper.NewResourceIterator(r)}
}

// GetCurrentSliceStack returns the SliceStack the iterator points at.
func (inst SliceStackIterator) GetCurrentSliceStack() (SliceStack, error) {
	var resource ref
	ret := C.CCall_lib3mf_slicestackiterator_getcurrentslicestack(inst.wrapperRef.LibraryHandle, inst.Ref, &resource)
	if ret != 0 {
		return SliceStack{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewSliceStack(resource), nil
}


// ObjectIterator represents a Lib3MF class.
type ObjectIterator struct {
	ResourceIterator
}

func (wrapper Wrapper) NewObjectIterator(r ref) ObjectIterator {
	return ObjectIterator{wrapper.NewResourceIterator(r)}
}

// GetCurrentObject returns the Object the iterator points at.
func (inst ObjectIterator) GetCurrentObject() (Object, error) {
	var resource ref
	ret := C.CCall_lib3mf_objectiterator_getcurrentobject(inst.wrapperRef.LibraryHandle, inst.Ref, &resource)
	if ret != 0 {
		return Object{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewObject(resource), nil
}


// MeshObjectIterator represents a Lib3MF class.
type MeshObjectIterator struct {
	ResourceIterator
}

func (wrapper Wrapper) NewMeshObjectIterator(r ref) MeshObjectIterator {
	return MeshObjectIterator{wrapper.NewResourceIterator(r)}
}

// GetCurrentMeshObject returns the MeshObject the iterator points at.
func (inst MeshObjectIterator) GetCurrentMeshObject() (MeshObject, error) {
	var resource ref
	ret := C.CCall_lib3mf_meshobjectiterator_getcurrentmeshobject(inst.wrapperRef.LibraryHandle, inst.Ref, &resource)
	if ret != 0 {
		return MeshObject{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewMeshObject(resource), nil
}


// ComponentsObjectIterator represents a Lib3MF class.
type ComponentsObjectIterator struct {
	ResourceIterator
}

func (wrapper Wrapper) NewComponentsObjectIterator(r ref) ComponentsObjectIterator {
	return ComponentsObjectIterator{wrapper.NewResourceIterator(r)}
}

// GetCurrentComponentsObject returns the ComponentsObject the iterator points at.
func (inst ComponentsObjectIterator) GetCurrentComponentsObject() (ComponentsObject, error) {
	var resource ref
	ret := C.CCall_lib3mf_componentsobjectiterator_getcurrentcomponentsobject(inst.wrapperRef.LibraryHandle, inst.Ref, &resource)
	if ret != 0 {
		return ComponentsObject{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewComponentsObject(resource), nil
}


// Texture2DIterator represents a Lib3MF class.
type Texture2DIterator struct {
	ResourceIterator
}

func (wrapper Wrapper) NewTexture2DIterator(r ref) Texture2DIterator {
	return Texture2DIterator{wrapper.NewResourceIterator(r)}
}

// GetCurrentTexture2D returns the Texture2D the iterator points at.
func (inst Texture2DIterator) GetCurrentTexture2D() (Texture2D, error) {
	var resource ref
	ret := C.CCall_lib3mf_texture2diterator_getcurrenttexture2d(inst.wrapperRef.LibraryHandle, inst.Ref, &resource)
	if ret != 0 {
		return Texture2D{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewTexture2D(resource), nil
}


// BaseMaterialGroupIterator represents a Lib3MF class.
type BaseMaterialGroupIterator struct {
	ResourceIterator
}

func (wrapper Wrapper) NewBaseMaterialGroupIterator(r ref) BaseMaterialGroupIterator {
	return BaseMaterialGroupIterator{wrapper.NewResourceIterator(r)}
}

// GetCurrentBaseMaterialGroup returns the MaterialGroup the iterator points at.
func (inst BaseMaterialGroupIterator) GetCurrentBaseMaterialGroup() (BaseMaterialGroup, error) {
	var resource ref
	ret := C.CCall_lib3mf_basematerialgroupiterator_getcurrentbasematerialgroup(inst.wrapperRef.LibraryHandle, inst.Ref, &resource)
	if ret != 0 {
		return BaseMaterialGroup{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewBaseMaterialGroup(resource), nil
}


// ColorGroupIterator represents a Lib3MF class.
type ColorGroupIterator struct {
	ResourceIterator
}

func (wrapper Wrapper) NewColorGroupIterator(r ref) ColorGroupIterator {
	return ColorGroupIterator{wrapper.NewResourceIterator(r)}
}

// GetCurrentColorGroup returns the ColorGroup the iterator points at.
func (inst ColorGroupIterator) GetCurrentColorGroup() (ColorGroup, error) {
	var resource ref
	ret := C.CCall_lib3mf_colorgroupiterator_getcurrentcolorgroup(inst.wrapperRef.LibraryHandle, inst.Ref, &resource)
	if ret != 0 {
		return ColorGroup{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewColorGroup(resource), nil
}


// Texture2DGroupIterator represents a Lib3MF class.
type Texture2DGroupIterator struct {
	ResourceIterator
}

func (wrapper Wrapper) NewTexture2DGroupIterator(r ref) Texture2DGroupIterator {
	return Texture2DGroupIterator{wrapper.NewResourceIterator(r)}
}

// GetCurrentTexture2DGroup returns the Texture2DGroup the iterator points at.
func (inst Texture2DGroupIterator) GetCurrentTexture2DGroup() (Texture2DGroup, error) {
	var resource ref
	ret := C.CCall_lib3mf_texture2dgroupiterator_getcurrenttexture2dgroup(inst.wrapperRef.LibraryHandle, inst.Ref, &resource)
	if ret != 0 {
		return Texture2DGroup{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewTexture2DGroup(resource), nil
}


// CompositeMaterialsIterator represents a Lib3MF class.
type CompositeMaterialsIterator struct {
	ResourceIterator
}

func (wrapper Wrapper) NewCompositeMaterialsIterator(r ref) CompositeMaterialsIterator {
	return CompositeMaterialsIterator{wrapper.NewResourceIterator(r)}
}

// GetCurrentCompositeMaterials returns the CompositeMaterials the iterator points at.
func (inst CompositeMaterialsIterator) GetCurrentCompositeMaterials() (CompositeMaterials, error) {
	var resource ref
	ret := C.CCall_lib3mf_compositematerialsiterator_getcurrentcompositematerials(inst.wrapperRef.LibraryHandle, inst.Ref, &resource)
	if ret != 0 {
		return CompositeMaterials{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewCompositeMaterials(resource), nil
}


// MultiPropertyGroupIterator represents a Lib3MF class.
type MultiPropertyGroupIterator struct {
	ResourceIterator
}

func (wrapper Wrapper) NewMultiPropertyGroupIterator(r ref) MultiPropertyGroupIterator {
	return MultiPropertyGroupIterator{wrapper.NewResourceIterator(r)}
}

// GetCurrentMultiPropertyGroup returns the MultiPropertyGroup the iterator points at.
func (inst MultiPropertyGroupIterator) GetCurrentMultiPropertyGroup() (MultiPropertyGroup, error) {
	var resource ref
	ret := C.CCall_lib3mf_multipropertygroupiterator_getcurrentmultipropertygroup(inst.wrapperRef.LibraryHandle, inst.Ref, &resource)
	if ret != 0 {
		return MultiPropertyGroup{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewMultiPropertyGroup(resource), nil
}


// Image3DIterator represents a Lib3MF class.
type Image3DIterator struct {
	ResourceIterator
}

func (wrapper Wrapper) NewImage3DIterator(r ref) Image3DIterator {
	return Image3DIterator{wrapper.NewResourceIterator(r)}
}

// GetCurrentImage3D returns the Image3D the iterator points at.
func (inst Image3DIterator) GetCurrentImage3D() (Image3D, error) {
	var resource ref
	ret := C.CCall_lib3mf_image3diterator_getcurrentimage3d(inst.wrapperRef.LibraryHandle, inst.Ref, &resource)
	if ret != 0 {
		return Image3D{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImage3D(resource), nil
}


// FunctionIterator represents a Lib3MF class.
type FunctionIterator struct {
	ResourceIterator
}

func (wrapper Wrapper) NewFunctionIterator(r ref) FunctionIterator {
	return FunctionIterator{wrapper.NewResourceIterator(r)}
}

// GetCurrentFunction returns the Function the iterator points at.
func (inst FunctionIterator) GetCurrentFunction() (Function, error) {
	var resource ref
	ret := C.CCall_lib3mf_functioniterator_getcurrentfunction(inst.wrapperRef.LibraryHandle, inst.Ref, &resource)
	if ret != 0 {
		return Function{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewFunction(resource), nil
}


// LevelSetIterator represents a Lib3MF class.
type LevelSetIterator struct {
	ResourceIterator
}

func (wrapper Wrapper) NewLevelSetIterator(r ref) LevelSetIterator {
	return LevelSetIterator{wrapper.NewResourceIterator(r)}
}

// GetCurrentLevelSet returns the LevelSet the iterator points at.
func (inst LevelSetIterator) GetCurrentLevelSet() (LevelSet, error) {
	var resource ref
	ret := C.CCall_lib3mf_levelsetiterator_getcurrentlevelset(inst.wrapperRef.LibraryHandle, inst.Ref, &resource)
	if ret != 0 {
		return LevelSet{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewLevelSet(resource), nil
}


// MetaData represents a Lib3MF class.
type MetaData struct {
	Base
}

func (wrapper Wrapper) NewMetaData(r ref) MetaData {
	return MetaData{wrapper.NewBase(r)}
}

// GetNameSpace returns the namespace URL of the metadata.
func (inst MetaData) GetNameSpace() (string, error) {
	var neededfornameSpace C.uint32_t
	var filledinnameSpace C.uint32_t
	ret := C.CCall_lib3mf_metadata_getnamespace(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededfornameSpace, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSizenameSpace := neededfornameSpace
	buffernameSpace := make([]byte, bufferSizenameSpace)
	ret = C.CCall_lib3mf_metadata_getnamespace(inst.wrapperRef.LibraryHandle, inst.Ref, bufferSizenameSpace, &filledinnameSpace, (*C.char)(unsafe.Pointer(&buffernameSpace[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(buffernameSpace[:(filledinnameSpace-1)]), nil
}

// SetNameSpace sets a new namespace URL of the metadata.
func (inst MetaData) SetNameSpace(nameSpace string) error {
	ret := C.CCall_lib3mf_metadata_setnamespace(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(nameSpace)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetName returns the name of a metadata.
func (inst MetaData) GetName() (string, error) {
	var neededforname C.uint32_t
	var filledinname C.uint32_t
	ret := C.CCall_lib3mf_metadata_getname(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforname, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSizename := neededforname
	buffername := make([]byte, bufferSizename)
	ret = C.CCall_lib3mf_metadata_getname(inst.wrapperRef.LibraryHandle, inst.Ref, bufferSizename, &filledinname, (*C.char)(unsafe.Pointer(&buffername[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(buffername[:(filledinname-1)]), nil
}

// SetName sets a new name of a metadata.
func (inst MetaData) SetName(name string) error {
	ret := C.CCall_lib3mf_metadata_setname(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(name)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetKey returns the (namespace+name) of a metadata.
func (inst MetaData) GetKey() (string, error) {
	var neededforkey C.uint32_t
	var filledinkey C.uint32_t
	ret := C.CCall_lib3mf_metadata_getkey(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforkey, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSizekey := neededforkey
	bufferkey := make([]byte, bufferSizekey)
	ret = C.CCall_lib3mf_metadata_getkey(inst.wrapperRef.LibraryHandle, inst.Ref, bufferSizekey, &filledinkey, (*C.char)(unsafe.Pointer(&bufferkey[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(bufferkey[:(filledinkey-1)]), nil
}

// GetMustPreserve returns, whether a metadata must be preserved.
func (inst MetaData) GetMustPreserve() (bool, error) {
	var mustPreserve C.bool
	ret := C.CCall_lib3mf_metadata_getmustpreserve(inst.wrapperRef.LibraryHandle, inst.Ref, &mustPreserve)
	if ret != 0 {
		return false, makeError(uint32(ret))
	}
	return bool(mustPreserve), nil
}

// SetMustPreserve sets whether a metadata must be preserved.
func (inst MetaData) SetMustPreserve(mustPreserve bool) error {
	ret := C.CCall_lib3mf_metadata_setmustpreserve(inst.wrapperRef.LibraryHandle, inst.Ref, C.bool(mustPreserve))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetType returns the type of a metadata.
func (inst MetaData) GetType() (string, error) {
	var neededfor_type C.uint32_t
	var filledin_type C.uint32_t
	ret := C.CCall_lib3mf_metadata_gettype(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededfor_type, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSize_type := neededfor_type
	buffer_type := make([]byte, bufferSize_type)
	ret = C.CCall_lib3mf_metadata_gettype(inst.wrapperRef.LibraryHandle, inst.Ref, bufferSize_type, &filledin_type, (*C.char)(unsafe.Pointer(&buffer_type[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(buffer_type[:(filledin_type-1)]), nil
}

// SetType sets a new type of a metadata. This must be a simple XML type.
func (inst MetaData) SetType(_type string) error {
	ret := C.CCall_lib3mf_metadata_settype(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(_type)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetValue returns the value of the metadata.
func (inst MetaData) GetValue() (string, error) {
	var neededforvalue C.uint32_t
	var filledinvalue C.uint32_t
	ret := C.CCall_lib3mf_metadata_getvalue(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforvalue, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSizevalue := neededforvalue
	buffervalue := make([]byte, bufferSizevalue)
	ret = C.CCall_lib3mf_metadata_getvalue(inst.wrapperRef.LibraryHandle, inst.Ref, bufferSizevalue, &filledinvalue, (*C.char)(unsafe.Pointer(&buffervalue[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(buffervalue[:(filledinvalue-1)]), nil
}

// SetValue sets a new value of the metadata.
func (inst MetaData) SetValue(value string) error {
	ret := C.CCall_lib3mf_metadata_setvalue(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(value)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}


// MetaDataGroup represents a Lib3MF class.
type MetaDataGroup struct {
	Base
}

func (wrapper Wrapper) NewMetaDataGroup(r ref) MetaDataGroup {
	return MetaDataGroup{wrapper.NewBase(r)}
}

// GetMetaDataCount returns the number of metadata in this metadatagroup.
func (inst MetaDataGroup) GetMetaDataCount() (uint32, error) {
	var count C.uint32_t
	ret := C.CCall_lib3mf_metadatagroup_getmetadatacount(inst.wrapperRef.LibraryHandle, inst.Ref, &count)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(count), nil
}

// GetMetaData returns a metadata value within this metadatagroup.
func (inst MetaDataGroup) GetMetaData(index uint32) (MetaData, error) {
	var metaData ref
	ret := C.CCall_lib3mf_metadatagroup_getmetadata(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(index), &metaData)
	if ret != 0 {
		return MetaData{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewMetaData(metaData), nil
}

// GetMetaDataByKey returns a metadata value within this metadatagroup.
func (inst MetaDataGroup) GetMetaDataByKey(nameSpace string, name string) (MetaData, error) {
	var metaData ref
	ret := C.CCall_lib3mf_metadatagroup_getmetadatabykey(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(nameSpace)[0])), (*C.char)(unsafe.Pointer(&[]byte(name)[0])), &metaData)
	if ret != 0 {
		return MetaData{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewMetaData(metaData), nil
}

// RemoveMetaDataByIndex removes metadata by index from the model.
func (inst MetaDataGroup) RemoveMetaDataByIndex(index uint32) error {
	ret := C.CCall_lib3mf_metadatagroup_removemetadatabyindex(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(index))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// RemoveMetaData removes metadata from the model.
func (inst MetaDataGroup) RemoveMetaData(theMetaData MetaData) error {
	ret := C.CCall_lib3mf_metadatagroup_removemetadata(inst.wrapperRef.LibraryHandle, inst.Ref, theMetaData.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// AddMetaData adds a new metadata to this metadatagroup.
func (inst MetaDataGroup) AddMetaData(nameSpace string, name string, value string, _type string, mustPreserve bool) (MetaData, error) {
	var metaData ref
	ret := C.CCall_lib3mf_metadatagroup_addmetadata(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(nameSpace)[0])), (*C.char)(unsafe.Pointer(&[]byte(name)[0])), (*C.char)(unsafe.Pointer(&[]byte(value)[0])), (*C.char)(unsafe.Pointer(&[]byte(_type)[0])), C.bool(mustPreserve), &metaData)
	if ret != 0 {
		return MetaData{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewMetaData(metaData), nil
}


// TriangleSet represents a Lib3MF class.
type TriangleSet struct {
	Base
}

func (wrapper Wrapper) NewTriangleSet(r ref) TriangleSet {
	return TriangleSet{wrapper.NewBase(r)}
}

// SetName sets the name of the triangle set.
func (inst TriangleSet) SetName(name string) error {
	ret := C.CCall_lib3mf_triangleset_setname(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(name)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetName returns the name of the triangle set.
func (inst TriangleSet) GetName() (string, error) {
	var neededforname C.uint32_t
	var filledinname C.uint32_t
	ret := C.CCall_lib3mf_triangleset_getname(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforname, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSizename := neededforname
	buffername := make([]byte, bufferSizename)
	ret = C.CCall_lib3mf_triangleset_getname(inst.wrapperRef.LibraryHandle, inst.Ref, bufferSizename, &filledinname, (*C.char)(unsafe.Pointer(&buffername[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(buffername[:(filledinname-1)]), nil
}

// SetIdentifier sets the identifier of the triangle set.
func (inst TriangleSet) SetIdentifier(identifier string) error {
	ret := C.CCall_lib3mf_triangleset_setidentifier(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetIdentifier returns the identifier of the triangle set.
func (inst TriangleSet) GetIdentifier() (string, error) {
	var neededforidentifier C.uint32_t
	var filledinidentifier C.uint32_t
	ret := C.CCall_lib3mf_triangleset_getidentifier(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforidentifier, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSizeidentifier := neededforidentifier
	bufferidentifier := make([]byte, bufferSizeidentifier)
	ret = C.CCall_lib3mf_triangleset_getidentifier(inst.wrapperRef.LibraryHandle, inst.Ref, bufferSizeidentifier, &filledinidentifier, (*C.char)(unsafe.Pointer(&bufferidentifier[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(bufferidentifier[:(filledinidentifier-1)]), nil
}

// AddTriangle adds a triangle to the set. Does nothing if triangle is already in the set.
func (inst TriangleSet) AddTriangle(triangleIndex uint32) error {
	ret := C.CCall_lib3mf_triangleset_addtriangle(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(triangleIndex))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// RemoveTriangle removes a triangle from the set.
func (inst TriangleSet) RemoveTriangle(triangleIndex uint32) error {
	ret := C.CCall_lib3mf_triangleset_removetriangle(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(triangleIndex))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// Clear clears all triangles from the list.
func (inst TriangleSet) Clear() error {
	ret := C.CCall_lib3mf_triangleset_clear(inst.wrapperRef.LibraryHandle, inst.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// SetTriangleList sets all triangles in the list, while clearing old values. Duplicates will be merged.
func (inst TriangleSet) SetTriangleList(triangleIndices []uint32) error {
	ret := C.CCall_lib3mf_triangleset_settrianglelist(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint64_t(len(triangleIndices)), (*C.uint32_t)(unsafe.Pointer(&triangleIndices[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetTriangleList retrieves all the triangles in the TriangleSet.
func (inst TriangleSet) GetTriangleList(triangleIndices []uint32) ([]uint32, error) {
	var neededfortriangleIndices C.uint64_t
	ret := C.CCall_lib3mf_triangleset_gettrianglelist(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededfortriangleIndices, nil)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	if len(triangleIndices) < int(neededfortriangleIndices) {
	 triangleIndices = append(triangleIndices, make([]uint32, int(neededfortriangleIndices)-len(triangleIndices))...)
	}
	ret = C.CCall_lib3mf_triangleset_gettrianglelist(inst.wrapperRef.LibraryHandle, inst.Ref, neededfortriangleIndices, nil, (*C.uint32_t)(unsafe.Pointer(&triangleIndices[0])))
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	return triangleIndices[:int(neededfortriangleIndices)], nil
}

// AddTriangleList adds multiple triangles in the list. Duplicates will be merged.
func (inst TriangleSet) AddTriangleList(triangleIndices []uint32) error {
	ret := C.CCall_lib3mf_triangleset_addtrianglelist(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint64_t(len(triangleIndices)), (*C.uint32_t)(unsafe.Pointer(&triangleIndices[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// Merge merges another Triangle set.
func (inst TriangleSet) Merge(otherTriangleSet TriangleSet, deleteOther bool) error {
	ret := C.CCall_lib3mf_triangleset_merge(inst.wrapperRef.LibraryHandle, inst.Ref, otherTriangleSet.Ref, C.bool(deleteOther))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// DeleteSet deletes the whole set from the mesh.
func (inst TriangleSet) DeleteSet() error {
	ret := C.CCall_lib3mf_triangleset_deleteset(inst.wrapperRef.LibraryHandle, inst.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// Duplicate duplicates the set in the mesh.
func (inst TriangleSet) Duplicate(identifier string) (TriangleSet, error) {
	var newSet ref
	ret := C.CCall_lib3mf_triangleset_duplicate(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), &newSet)
	if ret != 0 {
		return TriangleSet{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewTriangleSet(newSet), nil
}


// Object represents a Lib3MF class.
type Object struct {
	Resource
}

func (wrapper Wrapper) NewObject(r ref) Object {
	return Object{wrapper.NewResource(r)}
}

// GetType retrieves an object's type.
func (inst Object) GetType() (ObjectType, error) {
	var objectType C.eLib3MFObjectType
	ret := C.CCall_lib3mf_object_gettype(inst.wrapperRef.LibraryHandle, inst.Ref, &objectType)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return ObjectType(objectType), nil
}

// SetType sets an object's type.
func (inst Object) SetType(objectType ObjectType) error {
	ret := C.CCall_lib3mf_object_settype(inst.wrapperRef.LibraryHandle, inst.Ref, C.eLib3MFObjectType(objectType))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetName retrieves an object's name.
func (inst Object) GetName() (string, error) {
	var neededforname C.uint32_t
	var filledinname C.uint32_t
	ret := C.CCall_lib3mf_object_getname(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforname, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSizename := neededforname
	buffername := make([]byte, bufferSizename)
	ret = C.CCall_lib3mf_object_getname(inst.wrapperRef.LibraryHandle, inst.Ref, bufferSizename, &filledinname, (*C.char)(unsafe.Pointer(&buffername[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(buffername[:(filledinname-1)]), nil
}

// SetName sets an object's name string.
func (inst Object) SetName(name string) error {
	ret := C.CCall_lib3mf_object_setname(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(name)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetPartNumber retrieves an object's part number.
func (inst Object) GetPartNumber() (string, error) {
	var neededforpartNumber C.uint32_t
	var filledinpartNumber C.uint32_t
	ret := C.CCall_lib3mf_object_getpartnumber(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforpartNumber, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSizepartNumber := neededforpartNumber
	bufferpartNumber := make([]byte, bufferSizepartNumber)
	ret = C.CCall_lib3mf_object_getpartnumber(inst.wrapperRef.LibraryHandle, inst.Ref, bufferSizepartNumber, &filledinpartNumber, (*C.char)(unsafe.Pointer(&bufferpartNumber[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(bufferpartNumber[:(filledinpartNumber-1)]), nil
}

// SetPartNumber sets an objects partnumber string.
func (inst Object) SetPartNumber(partNumber string) error {
	ret := C.CCall_lib3mf_object_setpartnumber(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(partNumber)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// IsMeshObject retrieves, if an object is a mesh object.
func (inst Object) IsMeshObject() (bool, error) {
	var isMeshObject C.bool
	ret := C.CCall_lib3mf_object_ismeshobject(inst.wrapperRef.LibraryHandle, inst.Ref, &isMeshObject)
	if ret != 0 {
		return false, makeError(uint32(ret))
	}
	return bool(isMeshObject), nil
}

// IsComponentsObject retrieves, if an object is a components object.
func (inst Object) IsComponentsObject() (bool, error) {
	var isComponentsObject C.bool
	ret := C.CCall_lib3mf_object_iscomponentsobject(inst.wrapperRef.LibraryHandle, inst.Ref, &isComponentsObject)
	if ret != 0 {
		return false, makeError(uint32(ret))
	}
	return bool(isComponentsObject), nil
}

// IsLevelSetObject retrieves, if an object is a level set object.
func (inst Object) IsLevelSetObject() (bool, error) {
	var isLevelSetObject C.bool
	ret := C.CCall_lib3mf_object_islevelsetobject(inst.wrapperRef.LibraryHandle, inst.Ref, &isLevelSetObject)
	if ret != 0 {
		return false, makeError(uint32(ret))
	}
	return bool(isLevelSetObject), nil
}

// IsValid retrieves, if the object is valid according to the core spec. For mesh objects, we distinguish between the type attribute of the object:In case of object type other, this always means false.In case of object type model or solidsupport, this means, if the mesh suffices all requirements of the core spec chapter 4.1.In case of object type support or surface, this always means true.A component objects is valid if and only if it contains at least one component and all child components are valid objects.
func (inst Object) IsValid() (bool, error) {
	var isValid C.bool
	ret := C.CCall_lib3mf_object_isvalid(inst.wrapperRef.LibraryHandle, inst.Ref, &isValid)
	if ret != 0 {
		return false, makeError(uint32(ret))
	}
	return bool(isValid), nil
}

// SetAttachmentAsThumbnail use an existing attachment as thumbnail for this object.
func (inst Object) SetAttachmentAsThumbnail(attachment Attachment) error {
	ret := C.CCall_lib3mf_object_setattachmentasthumbnail(inst.wrapperRef.LibraryHandle, inst.Ref, attachment.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetThumbnailAttachment get the attachment containing the object thumbnail.
func (inst Object) GetThumbnailAttachment() (*Attachment, error) {
	var attachment ref
	ret := C.CCall_lib3mf_object_getthumbnailattachment(inst.wrapperRef.LibraryHandle, inst.Ref, &attachment)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	var _attachmentPtr *Attachment
	if attachment != nil {
		_attachmentPtrVal := inst.wrapperRef.NewAttachment(attachment)
		_attachmentPtr = &_attachmentPtrVal
	}
	return _attachmentPtr, nil
}

// ClearThumbnailAttachment clears the attachment. The attachment instance is not removed from the package.
func (inst Object) ClearThumbnailAttachment() error {
	ret := C.CCall_lib3mf_object_clearthumbnailattachment(inst.wrapperRef.LibraryHandle, inst.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetOutbox returns the outbox of a build item.
func (inst Object) GetOutbox() (Box, error) {
	var outbox C.sLib3MFBox
	ret := C.CCall_lib3mf_object_getoutbox(inst.wrapperRef.LibraryHandle, inst.Ref, &outbox)
	if ret != 0 {
		return Box{}, makeError(uint32(ret))
	}
	return *(*Box)(unsafe.Pointer(&outbox)), nil
}

// GetUUID retrieves an object's uuid string (see production extension specification).
func (inst Object) GetUUID() (bool, string, error) {
	var hasUUID C.bool
	var neededforuUID C.uint32_t
	var filledinuUID C.uint32_t
	ret := C.CCall_lib3mf_object_getuuid(inst.wrapperRef.LibraryHandle, inst.Ref, &hasUUID, 0, &neededforuUID, nil)
	if ret != 0 {
		return false, "", makeError(uint32(ret))
	}
	bufferSizeuUID := neededforuUID
	bufferuUID := make([]byte, bufferSizeuUID)
	ret = C.CCall_lib3mf_object_getuuid(inst.wrapperRef.LibraryHandle, inst.Ref, &hasUUID, bufferSizeuUID, &filledinuUID, (*C.char)(unsafe.Pointer(&bufferuUID[0])))
	if ret != 0 {
		return false, "", makeError(uint32(ret))
	}
	return bool(hasUUID), string(bufferuUID[:(filledinuUID-1)]), nil
}

// SetUUID sets a build object's uuid string (see production extension specification).
func (inst Object) SetUUID(uUID string) error {
	ret := C.CCall_lib3mf_object_setuuid(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(uUID)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetMetaDataGroup returns the metadatagroup of this object.
func (inst Object) GetMetaDataGroup() (MetaDataGroup, error) {
	var metaDataGroup ref
	ret := C.CCall_lib3mf_object_getmetadatagroup(inst.wrapperRef.LibraryHandle, inst.Ref, &metaDataGroup)
	if ret != 0 {
		return MetaDataGroup{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewMetaDataGroup(metaDataGroup), nil
}

// SetSlicesMeshResolution set the meshresolution of the mesh object.
func (inst Object) SetSlicesMeshResolution(meshResolution SlicesMeshResolution) error {
	ret := C.CCall_lib3mf_object_setslicesmeshresolution(inst.wrapperRef.LibraryHandle, inst.Ref, C.eLib3MFSlicesMeshResolution(meshResolution))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetSlicesMeshResolution get the meshresolution of the mesh object.
func (inst Object) GetSlicesMeshResolution() (SlicesMeshResolution, error) {
	var meshResolution C.eLib3MFSlicesMeshResolution
	ret := C.CCall_lib3mf_object_getslicesmeshresolution(inst.wrapperRef.LibraryHandle, inst.Ref, &meshResolution)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return SlicesMeshResolution(meshResolution), nil
}

// HasSlices returns whether the Object has a slice stack. If Recursive is true, also checks whether any references object has a slice stack.
func (inst Object) HasSlices(recursive bool) (bool, error) {
	var hasSlices C.bool
	ret := C.CCall_lib3mf_object_hasslices(inst.wrapperRef.LibraryHandle, inst.Ref, C.bool(recursive), &hasSlices)
	if ret != 0 {
		return false, makeError(uint32(ret))
	}
	return bool(hasSlices), nil
}

// ClearSliceStack unlinks the attached slicestack from this object. If no slice stack is attached, do noting.
func (inst Object) ClearSliceStack() error {
	ret := C.CCall_lib3mf_object_clearslicestack(inst.wrapperRef.LibraryHandle, inst.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetSliceStack get the Slicestack attached to the object.
func (inst Object) GetSliceStack() (SliceStack, error) {
	var sliceStackInstance ref
	ret := C.CCall_lib3mf_object_getslicestack(inst.wrapperRef.LibraryHandle, inst.Ref, &sliceStackInstance)
	if ret != 0 {
		return SliceStack{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewSliceStack(sliceStackInstance), nil
}

// AssignSliceStack assigns a slicestack to the object.
func (inst Object) AssignSliceStack(sliceStackInstance SliceStack) error {
	ret := C.CCall_lib3mf_object_assignslicestack(inst.wrapperRef.LibraryHandle, inst.Ref, sliceStackInstance.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}


// MeshObject represents a Lib3MF class.
type MeshObject struct {
	Object
}

func (wrapper Wrapper) NewMeshObject(r ref) MeshObject {
	return MeshObject{wrapper.NewObject(r)}
}

// GetVertexCount returns the vertex count of a mesh object.
func (inst MeshObject) GetVertexCount() (uint32, error) {
	var vertexCount C.uint32_t
	ret := C.CCall_lib3mf_meshobject_getvertexcount(inst.wrapperRef.LibraryHandle, inst.Ref, &vertexCount)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(vertexCount), nil
}

// GetTriangleCount returns the triangle count of a mesh object.
func (inst MeshObject) GetTriangleCount() (uint32, error) {
	var vertexCount C.uint32_t
	ret := C.CCall_lib3mf_meshobject_gettrianglecount(inst.wrapperRef.LibraryHandle, inst.Ref, &vertexCount)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(vertexCount), nil
}

// GetVertex returns the vertex count of a mesh object.
func (inst MeshObject) GetVertex(index uint32) (Position, error) {
	var coordinates C.sLib3MFPosition
	ret := C.CCall_lib3mf_meshobject_getvertex(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(index), &coordinates)
	if ret != 0 {
		return Position{}, makeError(uint32(ret))
	}
	return *(*Position)(unsafe.Pointer(&coordinates)), nil
}

// SetVertex sets the coordinates of a single vertex of a mesh object.
func (inst MeshObject) SetVertex(index uint32, coordinates Position) error {
	ret := C.CCall_lib3mf_meshobject_setvertex(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(index), (*C.sLib3MFPosition)(unsafe.Pointer(&coordinates)))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// AddVertex adds a single vertex to a mesh object.
func (inst MeshObject) AddVertex(coordinates Position) (uint32, error) {
	var newIndex C.uint32_t
	ret := C.CCall_lib3mf_meshobject_addvertex(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.sLib3MFPosition)(unsafe.Pointer(&coordinates)), &newIndex)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(newIndex), nil
}

// GetVertices obtains all vertex positions of a mesh object.
func (inst MeshObject) GetVertices(vertices []Position) ([]Position, error) {
	var neededforvertices C.uint64_t
	ret := C.CCall_lib3mf_meshobject_getvertices(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforvertices, nil)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	if len(vertices) < int(neededforvertices) {
	 vertices = append(vertices, make([]Position, int(neededforvertices)-len(vertices))...)
	}
	ret = C.CCall_lib3mf_meshobject_getvertices(inst.wrapperRef.LibraryHandle, inst.Ref, neededforvertices, nil, (*C.sLib3MFPosition)(unsafe.Pointer(&vertices[0])))
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	return vertices[:int(neededforvertices)], nil
}

// GetTriangle returns indices of a single triangle of a mesh object.
func (inst MeshObject) GetTriangle(index uint32) (Triangle, error) {
	var indices C.sLib3MFTriangle
	ret := C.CCall_lib3mf_meshobject_gettriangle(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(index), &indices)
	if ret != 0 {
		return Triangle{}, makeError(uint32(ret))
	}
	return *(*Triangle)(unsafe.Pointer(&indices)), nil
}

// SetTriangle sets the indices of a single triangle of a mesh object.
func (inst MeshObject) SetTriangle(index uint32, indices Triangle) error {
	ret := C.CCall_lib3mf_meshobject_settriangle(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(index), (*C.sLib3MFTriangle)(unsafe.Pointer(&indices)))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// AddTriangle adds a single triangle to a mesh object.
func (inst MeshObject) AddTriangle(indices Triangle) (uint32, error) {
	var newIndex C.uint32_t
	ret := C.CCall_lib3mf_meshobject_addtriangle(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.sLib3MFTriangle)(unsafe.Pointer(&indices)), &newIndex)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(newIndex), nil
}

// GetTriangleIndices get all triangles of a mesh object.
func (inst MeshObject) GetTriangleIndices(indices []Triangle) ([]Triangle, error) {
	var neededforindices C.uint64_t
	ret := C.CCall_lib3mf_meshobject_gettriangleindices(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforindices, nil)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	if len(indices) < int(neededforindices) {
	 indices = append(indices, make([]Triangle, int(neededforindices)-len(indices))...)
	}
	ret = C.CCall_lib3mf_meshobject_gettriangleindices(inst.wrapperRef.LibraryHandle, inst.Ref, neededforindices, nil, (*C.sLib3MFTriangle)(unsafe.Pointer(&indices[0])))
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	return indices[:int(neededforindices)], nil
}

// SetObjectLevelProperty sets the property at the object-level of the mesh object.
func (inst MeshObject) SetObjectLevelProperty(uniqueResourceID uint32, propertyID uint32) error {
	ret := C.CCall_lib3mf_meshobject_setobjectlevelproperty(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(uniqueResourceID), C.uint32_t(propertyID))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetObjectLevelProperty gets the property at the object-level of the mesh object.
func (inst MeshObject) GetObjectLevelProperty() (uint32, uint32, bool, error) {
	var uniqueResourceID C.uint32_t
	var propertyID C.uint32_t
	var hasObjectLevelProperty C.bool
	ret := C.CCall_lib3mf_meshobject_getobjectlevelproperty(inst.wrapperRef.LibraryHandle, inst.Ref, &uniqueResourceID, &propertyID, &hasObjectLevelProperty)
	if ret != 0 {
		return 0, 0, false, makeError(uint32(ret))
	}
	return uint32(uniqueResourceID), uint32(propertyID), bool(hasObjectLevelProperty), nil
}

// SetTriangleProperties sets the properties of a single triangle of a mesh object.
func (inst MeshObject) SetTriangleProperties(index uint32, properties TriangleProperties) error {
	ret := C.CCall_lib3mf_meshobject_settriangleproperties(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(index), (*C.sLib3MFTriangleProperties)(unsafe.Pointer(&properties)))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetTriangleProperties gets the properties of a single triangle of a mesh object.
func (inst MeshObject) GetTriangleProperties(index uint32) (TriangleProperties, error) {
	var property C.sLib3MFTriangleProperties
	ret := C.CCall_lib3mf_meshobject_gettriangleproperties(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(index), &property)
	if ret != 0 {
		return TriangleProperties{}, makeError(uint32(ret))
	}
	return *(*TriangleProperties)(unsafe.Pointer(&property)), nil
}

// SetAllTriangleProperties sets the properties of all triangles of a mesh object. Sets the object level property to the first entry of the passed triangle properties, if not yet specified.
func (inst MeshObject) SetAllTriangleProperties(propertiesArray []TriangleProperties) error {
	ret := C.CCall_lib3mf_meshobject_setalltriangleproperties(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint64_t(len(propertiesArray)), (*C.sLib3MFTriangleProperties)(unsafe.Pointer(&propertiesArray[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetAllTriangleProperties gets the properties of all triangles of a mesh object.
func (inst MeshObject) GetAllTriangleProperties(propertiesArray []TriangleProperties) ([]TriangleProperties, error) {
	var neededforpropertiesArray C.uint64_t
	ret := C.CCall_lib3mf_meshobject_getalltriangleproperties(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforpropertiesArray, nil)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	if len(propertiesArray) < int(neededforpropertiesArray) {
	 propertiesArray = append(propertiesArray, make([]TriangleProperties, int(neededforpropertiesArray)-len(propertiesArray))...)
	}
	ret = C.CCall_lib3mf_meshobject_getalltriangleproperties(inst.wrapperRef.LibraryHandle, inst.Ref, neededforpropertiesArray, nil, (*C.sLib3MFTriangleProperties)(unsafe.Pointer(&propertiesArray[0])))
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	return propertiesArray[:int(neededforpropertiesArray)], nil
}

// ClearAllProperties clears all properties of this mesh object (triangle and object-level).
func (inst MeshObject) ClearAllProperties() error {
	ret := C.CCall_lib3mf_meshobject_clearallproperties(inst.wrapperRef.LibraryHandle, inst.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// SetGeometry set all triangles of a mesh object.
func (inst MeshObject) SetGeometry(vertices []Position, indices []Triangle) error {
	ret := C.CCall_lib3mf_meshobject_setgeometry(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint64_t(len(vertices)), (*C.sLib3MFPosition)(unsafe.Pointer(&vertices[0])), C.uint64_t(len(indices)), (*C.sLib3MFTriangle)(unsafe.Pointer(&indices[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// IsManifoldAndOriented retrieves, if an object describes a topologically oriented and manifold mesh, according to the core spec.
func (inst MeshObject) IsManifoldAndOriented() (bool, error) {
	var isManifoldAndOriented C.bool
	ret := C.CCall_lib3mf_meshobject_ismanifoldandoriented(inst.wrapperRef.LibraryHandle, inst.Ref, &isManifoldAndOriented)
	if ret != 0 {
		return false, makeError(uint32(ret))
	}
	return bool(isManifoldAndOriented), nil
}

// BeamLattice retrieves the BeamLattice within this MeshObject.
func (inst MeshObject) BeamLattice() (BeamLattice, error) {
	var theBeamLattice ref
	ret := C.CCall_lib3mf_meshobject_beamlattice(inst.wrapperRef.LibraryHandle, inst.Ref, &theBeamLattice)
	if ret != 0 {
		return BeamLattice{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewBeamLattice(theBeamLattice), nil
}

// GetVolumeData retrieves the VolumeData of this MeshObject.
func (inst MeshObject) GetVolumeData() (*VolumeData, error) {
	var theVolumeData ref
	ret := C.CCall_lib3mf_meshobject_getvolumedata(inst.wrapperRef.LibraryHandle, inst.Ref, &theVolumeData)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	var _theVolumeDataPtr *VolumeData
	if theVolumeData != nil {
		_theVolumeDataPtrVal := inst.wrapperRef.NewVolumeData(theVolumeData)
		_theVolumeDataPtr = &_theVolumeDataPtrVal
	}
	return _theVolumeDataPtr, nil
}

// SetVolumeData sets the VolumeData of this MeshObject.
func (inst MeshObject) SetVolumeData(theVolumeData VolumeData) error {
	ret := C.CCall_lib3mf_meshobject_setvolumedata(inst.wrapperRef.LibraryHandle, inst.Ref, theVolumeData.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// AddTriangleSet adds a new triangle set.
func (inst MeshObject) AddTriangleSet(identifier string, name string) (TriangleSet, error) {
	var theTriangleSet ref
	ret := C.CCall_lib3mf_meshobject_addtriangleset(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), (*C.char)(unsafe.Pointer(&[]byte(name)[0])), &theTriangleSet)
	if ret != 0 {
		return TriangleSet{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewTriangleSet(theTriangleSet), nil
}

// HasTriangleSet checks if a triangle set exists.
func (inst MeshObject) HasTriangleSet(identifier string) (bool, error) {
	var triangleSetExists C.bool
	ret := C.CCall_lib3mf_meshobject_hastriangleset(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), &triangleSetExists)
	if ret != 0 {
		return false, makeError(uint32(ret))
	}
	return bool(triangleSetExists), nil
}

// FindTriangleSet finds a new triangle set by identifier. Fails if not existing.
func (inst MeshObject) FindTriangleSet(identifier string) (TriangleSet, error) {
	var theTriangleSet ref
	ret := C.CCall_lib3mf_meshobject_findtriangleset(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), &theTriangleSet)
	if ret != 0 {
		return TriangleSet{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewTriangleSet(theTriangleSet), nil
}

// GetTriangleSetCount returns number of triangle sets.
func (inst MeshObject) GetTriangleSetCount() (uint32, error) {
	var count C.uint32_t
	ret := C.CCall_lib3mf_meshobject_gettrianglesetcount(inst.wrapperRef.LibraryHandle, inst.Ref, &count)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(count), nil
}

// GetTriangleSet returns a specific triangle set by index.
func (inst MeshObject) GetTriangleSet(index uint32) (TriangleSet, error) {
	var theTriangleSet ref
	ret := C.CCall_lib3mf_meshobject_gettriangleset(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(index), &theTriangleSet)
	if ret != 0 {
		return TriangleSet{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewTriangleSet(theTriangleSet), nil
}


// LevelSet represents a Lib3MF class.
type LevelSet struct {
	Object
}

func (wrapper Wrapper) NewLevelSet(r ref) LevelSet {
	return LevelSet{wrapper.NewObject(r)}
}

// GetFunction returns the function that is used as boundary shape.
func (inst LevelSet) GetFunction() (*Function, error) {
	var theFunction ref
	ret := C.CCall_lib3mf_levelset_getfunction(inst.wrapperRef.LibraryHandle, inst.Ref, &theFunction)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	var _theFunctionPtr *Function
	if theFunction != nil {
		_theFunctionPtrVal := inst.wrapperRef.NewFunction(theFunction)
		_theFunctionPtr = &_theFunctionPtrVal
	}
	return _theFunctionPtr, nil
}

// SetFunction sets the function to use as boundary shape.
func (inst LevelSet) SetFunction(theFunction Function) error {
	ret := C.CCall_lib3mf_levelset_setfunction(inst.wrapperRef.LibraryHandle, inst.Ref, theFunction.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetTransform returns the transformation matrix into the coordinate system of the referenced Function.
func (inst LevelSet) GetTransform() (Transform, error) {
	var transform C.sLib3MFTransform
	ret := C.CCall_lib3mf_levelset_gettransform(inst.wrapperRef.LibraryHandle, inst.Ref, &transform)
	if ret != 0 {
		return Transform{}, makeError(uint32(ret))
	}
	return *(*Transform)(unsafe.Pointer(&transform)), nil
}

// SetTransform sets the transformation matrix into the coordinate system of the referenced Function.
func (inst LevelSet) SetTransform(transform Transform) error {
	ret := C.CCall_lib3mf_levelset_settransform(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.sLib3MFTransform)(unsafe.Pointer(&transform)))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetChannelName returns the name of the function output channel to use.
func (inst LevelSet) GetChannelName() (string, error) {
	var neededforchannelName C.uint32_t
	var filledinchannelName C.uint32_t
	ret := C.CCall_lib3mf_levelset_getchannelname(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforchannelName, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSizechannelName := neededforchannelName
	bufferchannelName := make([]byte, bufferSizechannelName)
	ret = C.CCall_lib3mf_levelset_getchannelname(inst.wrapperRef.LibraryHandle, inst.Ref, bufferSizechannelName, &filledinchannelName, (*C.char)(unsafe.Pointer(&bufferchannelName[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(bufferchannelName[:(filledinchannelName-1)]), nil
}

// SetChannelName sets the name of the function output channel to use.
func (inst LevelSet) SetChannelName(channelName string) error {
	ret := C.CCall_lib3mf_levelset_setchannelname(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(channelName)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// SetMinFeatureSize sets the minimal feature size as a hint for the function evaluator.
func (inst LevelSet) SetMinFeatureSize(minFeatureSize float64) error {
	ret := C.CCall_lib3mf_levelset_setminfeaturesize(inst.wrapperRef.LibraryHandle, inst.Ref, C.double(minFeatureSize))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetMinFeatureSize returns the minimal feature size as a hint for the function evaluator.
func (inst LevelSet) GetMinFeatureSize() (float64, error) {
	var minFeatureSize C.double
	ret := C.CCall_lib3mf_levelset_getminfeaturesize(inst.wrapperRef.LibraryHandle, inst.Ref, &minFeatureSize)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return float64(minFeatureSize), nil
}

// SetFallBackValue sets the fallback value to use if the function evaluation fails (e.g. evaluates to NaN or Inf).
func (inst LevelSet) SetFallBackValue(fallBackValue float64) error {
	ret := C.CCall_lib3mf_levelset_setfallbackvalue(inst.wrapperRef.LibraryHandle, inst.Ref, C.double(fallBackValue))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetFallBackValue returns the fallback value to use if the function evaluation fails (e.g. evaluates to NaN or Inf).
func (inst LevelSet) GetFallBackValue() (float64, error) {
	var fallBackValue C.double
	ret := C.CCall_lib3mf_levelset_getfallbackvalue(inst.wrapperRef.LibraryHandle, inst.Ref, &fallBackValue)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return float64(fallBackValue), nil
}

// SetMeshBBoxOnly if set only the bounding box of the mesh is intersected with the boundary.
func (inst LevelSet) SetMeshBBoxOnly(meshBBoxOnly bool) error {
	ret := C.CCall_lib3mf_levelset_setmeshbboxonly(inst.wrapperRef.LibraryHandle, inst.Ref, C.bool(meshBBoxOnly))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetMeshBBoxOnly if set only the bounding box of the mesh is intersected with the boundary.
func (inst LevelSet) GetMeshBBoxOnly() (bool, error) {
	var meshBBoxOnly C.bool
	ret := C.CCall_lib3mf_levelset_getmeshbboxonly(inst.wrapperRef.LibraryHandle, inst.Ref, &meshBBoxOnly)
	if ret != 0 {
		return false, makeError(uint32(ret))
	}
	return bool(meshBBoxOnly), nil
}

// SetMesh sets the mesh to use as evaluation domain.
func (inst LevelSet) SetMesh(theMesh MeshObject) error {
	ret := C.CCall_lib3mf_levelset_setmesh(inst.wrapperRef.LibraryHandle, inst.Ref, theMesh.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetMesh returns the mesh that is used as evaluation domain.
func (inst LevelSet) GetMesh() (*MeshObject, error) {
	var theMesh ref
	ret := C.CCall_lib3mf_levelset_getmesh(inst.wrapperRef.LibraryHandle, inst.Ref, &theMesh)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	var _theMeshPtr *MeshObject
	if theMesh != nil {
		_theMeshPtrVal := inst.wrapperRef.NewMeshObject(theMesh)
		_theMeshPtr = &_theMeshPtrVal
	}
	return _theMeshPtr, nil
}

// GetVolumeData retrieves the VolumeData this Object.
func (inst LevelSet) GetVolumeData() (*VolumeData, error) {
	var theVolumeData ref
	ret := C.CCall_lib3mf_levelset_getvolumedata(inst.wrapperRef.LibraryHandle, inst.Ref, &theVolumeData)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	var _theVolumeDataPtr *VolumeData
	if theVolumeData != nil {
		_theVolumeDataPtrVal := inst.wrapperRef.NewVolumeData(theVolumeData)
		_theVolumeDataPtr = &_theVolumeDataPtrVal
	}
	return _theVolumeDataPtr, nil
}

// SetVolumeData sets the VolumeData of this LevelSet.
func (inst LevelSet) SetVolumeData(theVolumeData VolumeData) error {
	ret := C.CCall_lib3mf_levelset_setvolumedata(inst.wrapperRef.LibraryHandle, inst.Ref, theVolumeData.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}


// BeamLattice represents a Lib3MF class.
type BeamLattice struct {
	Base
}

func (wrapper Wrapper) NewBeamLattice(r ref) BeamLattice {
	return BeamLattice{wrapper.NewBase(r)}
}

// GetMinLength returns the minimal length of beams for the beamlattice.
func (inst BeamLattice) GetMinLength() (float64, error) {
	var minLength C.double
	ret := C.CCall_lib3mf_beamlattice_getminlength(inst.wrapperRef.LibraryHandle, inst.Ref, &minLength)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return float64(minLength), nil
}

// SetMinLength sets the minimal length of beams for the beamlattice.
func (inst BeamLattice) SetMinLength(minLength float64) error {
	ret := C.CCall_lib3mf_beamlattice_setminlength(inst.wrapperRef.LibraryHandle, inst.Ref, C.double(minLength))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetClipping returns the clipping mode and the clipping-mesh for the beamlattice of this mesh.
func (inst BeamLattice) GetClipping() (BeamLatticeClipMode, uint32, error) {
	var clipMode C.eLib3MFBeamLatticeClipMode
	var uniqueResourceID C.uint32_t
	ret := C.CCall_lib3mf_beamlattice_getclipping(inst.wrapperRef.LibraryHandle, inst.Ref, &clipMode, &uniqueResourceID)
	if ret != 0 {
		return 0, 0, makeError(uint32(ret))
	}
	return BeamLatticeClipMode(clipMode), uint32(uniqueResourceID), nil
}

// SetClipping sets the clipping mode and the clipping-mesh for the beamlattice of this mesh.
func (inst BeamLattice) SetClipping(clipMode BeamLatticeClipMode, uniqueResourceID uint32) error {
	ret := C.CCall_lib3mf_beamlattice_setclipping(inst.wrapperRef.LibraryHandle, inst.Ref, C.eLib3MFBeamLatticeClipMode(clipMode), C.uint32_t(uniqueResourceID))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetRepresentation returns the representation-mesh for the beamlattice of this mesh.
func (inst BeamLattice) GetRepresentation() (bool, uint32, error) {
	var hasRepresentation C.bool
	var uniqueResourceID C.uint32_t
	ret := C.CCall_lib3mf_beamlattice_getrepresentation(inst.wrapperRef.LibraryHandle, inst.Ref, &hasRepresentation, &uniqueResourceID)
	if ret != 0 {
		return false, 0, makeError(uint32(ret))
	}
	return bool(hasRepresentation), uint32(uniqueResourceID), nil
}

// SetRepresentation sets the representation-mesh for the beamlattice of this mesh.
func (inst BeamLattice) SetRepresentation(uniqueResourceID uint32) error {
	ret := C.CCall_lib3mf_beamlattice_setrepresentation(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(uniqueResourceID))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetBallOptions returns the ball mode and the default ball radius for the beamlattice of this mesh.
func (inst BeamLattice) GetBallOptions() (BeamLatticeBallMode, float64, error) {
	var ballMode C.eLib3MFBeamLatticeBallMode
	var ballRadius C.double
	ret := C.CCall_lib3mf_beamlattice_getballoptions(inst.wrapperRef.LibraryHandle, inst.Ref, &ballMode, &ballRadius)
	if ret != 0 {
		return 0, 0, makeError(uint32(ret))
	}
	return BeamLatticeBallMode(ballMode), float64(ballRadius), nil
}

// SetBallOptions sets the ball mode and thedefault ball radius for the beamlattice.
func (inst BeamLattice) SetBallOptions(ballMode BeamLatticeBallMode, ballRadius float64) error {
	ret := C.CCall_lib3mf_beamlattice_setballoptions(inst.wrapperRef.LibraryHandle, inst.Ref, C.eLib3MFBeamLatticeBallMode(ballMode), C.double(ballRadius))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetBeamCount returns the beam count of a mesh object.
func (inst BeamLattice) GetBeamCount() (uint32, error) {
	var count C.uint32_t
	ret := C.CCall_lib3mf_beamlattice_getbeamcount(inst.wrapperRef.LibraryHandle, inst.Ref, &count)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(count), nil
}

// GetBeam returns indices, radii and capmodes of a single beam of a mesh object.
func (inst BeamLattice) GetBeam(index uint32) (Beam, error) {
	var beamInfo C.sLib3MFBeam
	ret := C.CCall_lib3mf_beamlattice_getbeam(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(index), &beamInfo)
	if ret != 0 {
		return Beam{}, makeError(uint32(ret))
	}
	return *(*Beam)(unsafe.Pointer(&beamInfo)), nil
}

// AddBeam adds a single beam to a mesh object.
func (inst BeamLattice) AddBeam(beamInfo Beam) (uint32, error) {
	var index C.uint32_t
	ret := C.CCall_lib3mf_beamlattice_addbeam(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.sLib3MFBeam)(unsafe.Pointer(&beamInfo)), &index)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(index), nil
}

// SetBeam sets the indices, radii and capmodes of a single beam of a mesh object.
func (inst BeamLattice) SetBeam(index uint32, beamInfo Beam) error {
	ret := C.CCall_lib3mf_beamlattice_setbeam(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(index), (*C.sLib3MFBeam)(unsafe.Pointer(&beamInfo)))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// SetBeams sets all beam indices, radii and capmodes of a mesh object.
func (inst BeamLattice) SetBeams(beamInfo []Beam) error {
	ret := C.CCall_lib3mf_beamlattice_setbeams(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint64_t(len(beamInfo)), (*C.sLib3MFBeam)(unsafe.Pointer(&beamInfo[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetBeams obtains all beam indices, radii and capmodes of a mesh object.
func (inst BeamLattice) GetBeams(beamInfo []Beam) ([]Beam, error) {
	var neededforbeamInfo C.uint64_t
	ret := C.CCall_lib3mf_beamlattice_getbeams(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforbeamInfo, nil)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	if len(beamInfo) < int(neededforbeamInfo) {
	 beamInfo = append(beamInfo, make([]Beam, int(neededforbeamInfo)-len(beamInfo))...)
	}
	ret = C.CCall_lib3mf_beamlattice_getbeams(inst.wrapperRef.LibraryHandle, inst.Ref, neededforbeamInfo, nil, (*C.sLib3MFBeam)(unsafe.Pointer(&beamInfo[0])))
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	return beamInfo[:int(neededforbeamInfo)], nil
}

// GetBallCount returns the ball count of a mesh object.
func (inst BeamLattice) GetBallCount() (uint32, error) {
	var count C.uint32_t
	ret := C.CCall_lib3mf_beamlattice_getballcount(inst.wrapperRef.LibraryHandle, inst.Ref, &count)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(count), nil
}

// GetBall returns index and radius of a single ball of a mesh object.
func (inst BeamLattice) GetBall(index uint32) (Ball, error) {
	var ballInfo C.sLib3MFBall
	ret := C.CCall_lib3mf_beamlattice_getball(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(index), &ballInfo)
	if ret != 0 {
		return Ball{}, makeError(uint32(ret))
	}
	return *(*Ball)(unsafe.Pointer(&ballInfo)), nil
}

// AddBall adds a single ball to a mesh object.
func (inst BeamLattice) AddBall(ballInfo Ball) (uint32, error) {
	var index C.uint32_t
	ret := C.CCall_lib3mf_beamlattice_addball(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.sLib3MFBall)(unsafe.Pointer(&ballInfo)), &index)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(index), nil
}

// SetBall sets the index and radius of a single ball of a mesh object.
func (inst BeamLattice) SetBall(index uint32, ballInfo Ball) error {
	ret := C.CCall_lib3mf_beamlattice_setball(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(index), (*C.sLib3MFBall)(unsafe.Pointer(&ballInfo)))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// SetBalls sets all ball indices and radii of a mesh object.
func (inst BeamLattice) SetBalls(ballInfo []Ball) error {
	ret := C.CCall_lib3mf_beamlattice_setballs(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint64_t(len(ballInfo)), (*C.sLib3MFBall)(unsafe.Pointer(&ballInfo[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetBalls obtains all ball indices and radii of a mesh object.
func (inst BeamLattice) GetBalls(ballInfo []Ball) ([]Ball, error) {
	var neededforballInfo C.uint64_t
	ret := C.CCall_lib3mf_beamlattice_getballs(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforballInfo, nil)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	if len(ballInfo) < int(neededforballInfo) {
	 ballInfo = append(ballInfo, make([]Ball, int(neededforballInfo)-len(ballInfo))...)
	}
	ret = C.CCall_lib3mf_beamlattice_getballs(inst.wrapperRef.LibraryHandle, inst.Ref, neededforballInfo, nil, (*C.sLib3MFBall)(unsafe.Pointer(&ballInfo[0])))
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	return ballInfo[:int(neededforballInfo)], nil
}

// GetBeamSetCount returns the number of beamsets of a mesh object.
func (inst BeamLattice) GetBeamSetCount() (uint32, error) {
	var count C.uint32_t
	ret := C.CCall_lib3mf_beamlattice_getbeamsetcount(inst.wrapperRef.LibraryHandle, inst.Ref, &count)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(count), nil
}

// AddBeamSet adds an empty beamset to a mesh object.
func (inst BeamLattice) AddBeamSet() (BeamSet, error) {
	var beamSet ref
	ret := C.CCall_lib3mf_beamlattice_addbeamset(inst.wrapperRef.LibraryHandle, inst.Ref, &beamSet)
	if ret != 0 {
		return BeamSet{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewBeamSet(beamSet), nil
}

// GetBeamSet returns a beamset of a mesh object.
func (inst BeamLattice) GetBeamSet(index uint32) (BeamSet, error) {
	var beamSet ref
	ret := C.CCall_lib3mf_beamlattice_getbeamset(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(index), &beamSet)
	if ret != 0 {
		return BeamSet{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewBeamSet(beamSet), nil
}


// FunctionReference represents a Lib3MF class.
type FunctionReference struct {
	Base
}

func (wrapper Wrapper) NewFunctionReference(r ref) FunctionReference {
	return FunctionReference{wrapper.NewBase(r)}
}

// GetFunctionResourceID returns the UniqueResourceID of the Function. Only functions with a 'pos'-input are allowed.
func (inst FunctionReference) GetFunctionResourceID() (uint32, error) {
	var uniqueResourceID C.uint32_t
	ret := C.CCall_lib3mf_functionreference_getfunctionresourceid(inst.wrapperRef.LibraryHandle, inst.Ref, &uniqueResourceID)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(uniqueResourceID), nil
}

// SetFunctionResourceID sets the UniqueResourceID to refer to.
func (inst FunctionReference) SetFunctionResourceID(uniqueResourceID uint32) error {
	ret := C.CCall_lib3mf_functionreference_setfunctionresourceid(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(uniqueResourceID))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetTransform returns the transformation matrix into the coordinate system of the referenced Function.
func (inst FunctionReference) GetTransform() (Transform, error) {
	var transform C.sLib3MFTransform
	ret := C.CCall_lib3mf_functionreference_gettransform(inst.wrapperRef.LibraryHandle, inst.Ref, &transform)
	if ret != 0 {
		return Transform{}, makeError(uint32(ret))
	}
	return *(*Transform)(unsafe.Pointer(&transform)), nil
}

// SetTransform sets the transformation matrix into the coordinate system of the referenced Function.
func (inst FunctionReference) SetTransform(transform Transform) error {
	ret := C.CCall_lib3mf_functionreference_settransform(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.sLib3MFTransform)(unsafe.Pointer(&transform)))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetChannelName returns the name of the function output channel to use.
func (inst FunctionReference) GetChannelName() (string, error) {
	var neededforchannelName C.uint32_t
	var filledinchannelName C.uint32_t
	ret := C.CCall_lib3mf_functionreference_getchannelname(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforchannelName, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSizechannelName := neededforchannelName
	bufferchannelName := make([]byte, bufferSizechannelName)
	ret = C.CCall_lib3mf_functionreference_getchannelname(inst.wrapperRef.LibraryHandle, inst.Ref, bufferSizechannelName, &filledinchannelName, (*C.char)(unsafe.Pointer(&bufferchannelName[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(bufferchannelName[:(filledinchannelName-1)]), nil
}

// SetChannelName sets the name of the function output channel to use.
func (inst FunctionReference) SetChannelName(channelName string) error {
	ret := C.CCall_lib3mf_functionreference_setchannelname(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(channelName)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// SetMinFeatureSize sets the minimal feature size as a hint for the function evaluator.
func (inst FunctionReference) SetMinFeatureSize(minFeatureSize float64) error {
	ret := C.CCall_lib3mf_functionreference_setminfeaturesize(inst.wrapperRef.LibraryHandle, inst.Ref, C.double(minFeatureSize))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetMinFeatureSize returns the minimal feature size as a hint for the function evaluator.
func (inst FunctionReference) GetMinFeatureSize() (float64, error) {
	var minFeatureSize C.double
	ret := C.CCall_lib3mf_functionreference_getminfeaturesize(inst.wrapperRef.LibraryHandle, inst.Ref, &minFeatureSize)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return float64(minFeatureSize), nil
}

// SetFallBackValue sets the fallback value to use if the function evaluation fails (e.g. evaluates to NaN or Inf).
func (inst FunctionReference) SetFallBackValue(fallBackValue float64) error {
	ret := C.CCall_lib3mf_functionreference_setfallbackvalue(inst.wrapperRef.LibraryHandle, inst.Ref, C.double(fallBackValue))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetFallBackValue returns the fallback value to use if the function evaluation fails (e.g. evaluates to NaN or Inf).
func (inst FunctionReference) GetFallBackValue() (float64, error) {
	var fallBackValue C.double
	ret := C.CCall_lib3mf_functionreference_getfallbackvalue(inst.wrapperRef.LibraryHandle, inst.Ref, &fallBackValue)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return float64(fallBackValue), nil
}


// VolumeDataColor represents a Lib3MF class.
type VolumeDataColor struct {
	FunctionReference
}

func (wrapper Wrapper) NewVolumeDataColor(r ref) VolumeDataColor {
	return VolumeDataColor{wrapper.NewFunctionReference(r)}
}


// MaterialMapping represents a Lib3MF class.
type MaterialMapping struct {
	FunctionReference
}

func (wrapper Wrapper) NewMaterialMapping(r ref) MaterialMapping {
	return MaterialMapping{wrapper.NewFunctionReference(r)}
}


// VolumeDataComposite represents a Lib3MF class.
type VolumeDataComposite struct {
	Base
}

func (wrapper Wrapper) NewVolumeDataComposite(r ref) VolumeDataComposite {
	return VolumeDataComposite{wrapper.NewBase(r)}
}

// GetBaseMaterialGroup returns the BaseMaterialGroup used within this volume data item.
func (inst VolumeDataComposite) GetBaseMaterialGroup() (BaseMaterialGroup, error) {
	var baseMaterialGroupInstance ref
	ret := C.CCall_lib3mf_volumedatacomposite_getbasematerialgroup(inst.wrapperRef.LibraryHandle, inst.Ref, &baseMaterialGroupInstance)
	if ret != 0 {
		return BaseMaterialGroup{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewBaseMaterialGroup(baseMaterialGroupInstance), nil
}

// SetBaseMaterialGroup sets the BaseMaterialGroup to use within this volume data item.
func (inst VolumeDataComposite) SetBaseMaterialGroup(baseMaterialGroupInstance BaseMaterialGroup) error {
	ret := C.CCall_lib3mf_volumedatacomposite_setbasematerialgroup(inst.wrapperRef.LibraryHandle, inst.Ref, baseMaterialGroupInstance.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetMaterialMappingCount returns the number of material mappings of this VolumeDataComposite element.
func (inst VolumeDataComposite) GetMaterialMappingCount() (uint32, error) {
	var count C.uint32_t
	ret := C.CCall_lib3mf_volumedatacomposite_getmaterialmappingcount(inst.wrapperRef.LibraryHandle, inst.Ref, &count)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(count), nil
}

// GetMaterialMapping returns MaterialMappting with given index.
func (inst VolumeDataComposite) GetMaterialMapping(index uint32) (MaterialMapping, error) {
	var theMaterialMapping ref
	ret := C.CCall_lib3mf_volumedatacomposite_getmaterialmapping(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(index), &theMaterialMapping)
	if ret != 0 {
		return MaterialMapping{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewMaterialMapping(theMaterialMapping), nil
}

// AddMaterialMapping adds a the MaterialMapping.
func (inst VolumeDataComposite) AddMaterialMapping(transform Transform) (MaterialMapping, error) {
	var theMaterialMapping ref
	ret := C.CCall_lib3mf_volumedatacomposite_addmaterialmapping(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.sLib3MFTransform)(unsafe.Pointer(&transform)), &theMaterialMapping)
	if ret != 0 {
		return MaterialMapping{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewMaterialMapping(theMaterialMapping), nil
}

// RemoveMaterialMapping removes the MaterialMapping with given index.
func (inst VolumeDataComposite) RemoveMaterialMapping(index uint32) error {
	ret := C.CCall_lib3mf_volumedatacomposite_removematerialmapping(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(index))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}


// VolumeDataProperty represents a Lib3MF class.
type VolumeDataProperty struct {
	FunctionReference
}

func (wrapper Wrapper) NewVolumeDataProperty(r ref) VolumeDataProperty {
	return VolumeDataProperty{wrapper.NewFunctionReference(r)}
}

// GetName gets the qualified name of this property.
func (inst VolumeDataProperty) GetName() (string, error) {
	var neededforpropertyName C.uint32_t
	var filledinpropertyName C.uint32_t
	ret := C.CCall_lib3mf_volumedataproperty_getname(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforpropertyName, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSizepropertyName := neededforpropertyName
	bufferpropertyName := make([]byte, bufferSizepropertyName)
	ret = C.CCall_lib3mf_volumedataproperty_getname(inst.wrapperRef.LibraryHandle, inst.Ref, bufferSizepropertyName, &filledinpropertyName, (*C.char)(unsafe.Pointer(&bufferpropertyName[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(bufferpropertyName[:(filledinpropertyName-1)]), nil
}

// SetIsRequired sets whether this property is required to process this 3MF document instance.
func (inst VolumeDataProperty) SetIsRequired(isRequired bool) error {
	ret := C.CCall_lib3mf_volumedataproperty_setisrequired(inst.wrapperRef.LibraryHandle, inst.Ref, C.bool(isRequired))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// IsRequired returns whether this property is required to process this 3MF document instance.
func (inst VolumeDataProperty) IsRequired() (bool, error) {
	var isRequired C.bool
	ret := C.CCall_lib3mf_volumedataproperty_isrequired(inst.wrapperRef.LibraryHandle, inst.Ref, &isRequired)
	if ret != 0 {
		return false, makeError(uint32(ret))
	}
	return bool(isRequired), nil
}


// VolumeData represents a Lib3MF class.
type VolumeData struct {
	Resource
}

func (wrapper Wrapper) NewVolumeData(r ref) VolumeData {
	return VolumeData{wrapper.NewResource(r)}
}

// GetComposite returns the VolumeDataComposite of this VolumeData instance.
func (inst VolumeData) GetComposite() (*VolumeDataComposite, error) {
	var theCompositeData ref
	ret := C.CCall_lib3mf_volumedata_getcomposite(inst.wrapperRef.LibraryHandle, inst.Ref, &theCompositeData)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	var _theCompositeDataPtr *VolumeDataComposite
	if theCompositeData != nil {
		_theCompositeDataPtrVal := inst.wrapperRef.NewVolumeDataComposite(theCompositeData)
		_theCompositeDataPtr = &_theCompositeDataPtrVal
	}
	return _theCompositeDataPtr, nil
}

// CreateNewComposite creates a new VolumeDataComposite for this VolumeData instance.
func (inst VolumeData) CreateNewComposite() (VolumeDataComposite, error) {
	var theCompositeData ref
	ret := C.CCall_lib3mf_volumedata_createnewcomposite(inst.wrapperRef.LibraryHandle, inst.Ref, &theCompositeData)
	if ret != 0 {
		return VolumeDataComposite{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewVolumeDataComposite(theCompositeData), nil
}

// RemoveComposite removes the VolumeDataComposite of this VolumeData instance.
func (inst VolumeData) RemoveComposite() error {
	ret := C.CCall_lib3mf_volumedata_removecomposite(inst.wrapperRef.LibraryHandle, inst.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetColor returns the VolumeDataColor of this VolumeData instance.
func (inst VolumeData) GetColor() (*VolumeDataColor, error) {
	var theColorData ref
	ret := C.CCall_lib3mf_volumedata_getcolor(inst.wrapperRef.LibraryHandle, inst.Ref, &theColorData)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	var _theColorDataPtr *VolumeDataColor
	if theColorData != nil {
		_theColorDataPtrVal := inst.wrapperRef.NewVolumeDataColor(theColorData)
		_theColorDataPtr = &_theColorDataPtrVal
	}
	return _theColorDataPtr, nil
}

// CreateNewColor creates a new VolumeDataColor for this VolumeData instance.
func (inst VolumeData) CreateNewColor(theFunction Function) (VolumeDataColor, error) {
	var theColorData ref
	ret := C.CCall_lib3mf_volumedata_createnewcolor(inst.wrapperRef.LibraryHandle, inst.Ref, theFunction.Ref, &theColorData)
	if ret != 0 {
		return VolumeDataColor{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewVolumeDataColor(theColorData), nil
}

// RemoveColor removes the VolumeDataColor of this VolumeData instance.
func (inst VolumeData) RemoveColor() error {
	ret := C.CCall_lib3mf_volumedata_removecolor(inst.wrapperRef.LibraryHandle, inst.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetPropertyCount returns the number of VolumeDataProperty.
func (inst VolumeData) GetPropertyCount() (uint32, error) {
	var count C.uint32_t
	ret := C.CCall_lib3mf_volumedata_getpropertycount(inst.wrapperRef.LibraryHandle, inst.Ref, &count)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(count), nil
}

// GetProperty returns the VolumeDataProperty at a given Index.
func (inst VolumeData) GetProperty(index uint32) (VolumeDataProperty, error) {
	var theVolumeDataProperty ref
	ret := C.CCall_lib3mf_volumedata_getproperty(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(index), &theVolumeDataProperty)
	if ret != 0 {
		return VolumeDataProperty{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewVolumeDataProperty(theVolumeDataProperty), nil
}

// AddPropertyFromFunction adds a new VolumeDataProperty from a Function.
func (inst VolumeData) AddPropertyFromFunction(name string, theFunction Function) (VolumeDataProperty, error) {
	var theVolumeDataProperty ref
	ret := C.CCall_lib3mf_volumedata_addpropertyfromfunction(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(name)[0])), theFunction.Ref, &theVolumeDataProperty)
	if ret != 0 {
		return VolumeDataProperty{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewVolumeDataProperty(theVolumeDataProperty), nil
}

// RemoveProperty removes the VolumeDataProperty with a given index.
func (inst VolumeData) RemoveProperty(index uint32) error {
	ret := C.CCall_lib3mf_volumedata_removeproperty(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(index))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}


// Component represents a Lib3MF class.
type Component struct {
	Base
}

func (wrapper Wrapper) NewComponent(r ref) Component {
	return Component{wrapper.NewBase(r)}
}

// GetObjectResource returns the Resource Instance of the component.
func (inst Component) GetObjectResource() (Object, error) {
	var objectResource ref
	ret := C.CCall_lib3mf_component_getobjectresource(inst.wrapperRef.LibraryHandle, inst.Ref, &objectResource)
	if ret != 0 {
		return Object{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewObject(objectResource), nil
}

// GetObjectResourceID returns the UniqueResourceID of the component.
func (inst Component) GetObjectResourceID() (uint32, error) {
	var uniqueResourceID C.uint32_t
	ret := C.CCall_lib3mf_component_getobjectresourceid(inst.wrapperRef.LibraryHandle, inst.Ref, &uniqueResourceID)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(uniqueResourceID), nil
}

// GetUUID returns, whether a component has a UUID and, if true, the component's UUID.
func (inst Component) GetUUID() (bool, string, error) {
	var hasUUID C.bool
	var neededforuUID C.uint32_t
	var filledinuUID C.uint32_t
	ret := C.CCall_lib3mf_component_getuuid(inst.wrapperRef.LibraryHandle, inst.Ref, &hasUUID, 0, &neededforuUID, nil)
	if ret != 0 {
		return false, "", makeError(uint32(ret))
	}
	bufferSizeuUID := neededforuUID
	bufferuUID := make([]byte, bufferSizeuUID)
	ret = C.CCall_lib3mf_component_getuuid(inst.wrapperRef.LibraryHandle, inst.Ref, &hasUUID, bufferSizeuUID, &filledinuUID, (*C.char)(unsafe.Pointer(&bufferuUID[0])))
	if ret != 0 {
		return false, "", makeError(uint32(ret))
	}
	return bool(hasUUID), string(bufferuUID[:(filledinuUID-1)]), nil
}

// SetUUID sets the component's UUID.
func (inst Component) SetUUID(uUID string) error {
	ret := C.CCall_lib3mf_component_setuuid(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(uUID)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// HasTransform returns, if the component has a different transformation than the identity matrix.
func (inst Component) HasTransform() (bool, error) {
	var hasTransform C.bool
	ret := C.CCall_lib3mf_component_hastransform(inst.wrapperRef.LibraryHandle, inst.Ref, &hasTransform)
	if ret != 0 {
		return false, makeError(uint32(ret))
	}
	return bool(hasTransform), nil
}

// GetTransform returns the transformation matrix of the component.
func (inst Component) GetTransform() (Transform, error) {
	var transform C.sLib3MFTransform
	ret := C.CCall_lib3mf_component_gettransform(inst.wrapperRef.LibraryHandle, inst.Ref, &transform)
	if ret != 0 {
		return Transform{}, makeError(uint32(ret))
	}
	return *(*Transform)(unsafe.Pointer(&transform)), nil
}

// SetTransform sets the transformation matrix of the component.
func (inst Component) SetTransform(transform Transform) error {
	ret := C.CCall_lib3mf_component_settransform(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.sLib3MFTransform)(unsafe.Pointer(&transform)))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}


// ComponentsObject represents a Lib3MF class.
type ComponentsObject struct {
	Object
}

func (wrapper Wrapper) NewComponentsObject(r ref) ComponentsObject {
	return ComponentsObject{wrapper.NewObject(r)}
}

// AddComponent adds a new component to a components object.
func (inst ComponentsObject) AddComponent(objectResource Object, transform Transform) (Component, error) {
	var componentInstance ref
	ret := C.CCall_lib3mf_componentsobject_addcomponent(inst.wrapperRef.LibraryHandle, inst.Ref, objectResource.Ref, (*C.sLib3MFTransform)(unsafe.Pointer(&transform)), &componentInstance)
	if ret != 0 {
		return Component{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewComponent(componentInstance), nil
}

// GetComponent retrieves a component from a component object.
func (inst ComponentsObject) GetComponent(index uint32) (Component, error) {
	var componentInstance ref
	ret := C.CCall_lib3mf_componentsobject_getcomponent(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(index), &componentInstance)
	if ret != 0 {
		return Component{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewComponent(componentInstance), nil
}

// GetComponentCount retrieves a component count of a component object.
func (inst ComponentsObject) GetComponentCount() (uint32, error) {
	var count C.uint32_t
	ret := C.CCall_lib3mf_componentsobject_getcomponentcount(inst.wrapperRef.LibraryHandle, inst.Ref, &count)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(count), nil
}


// BeamSet represents a Lib3MF class.
type BeamSet struct {
	Base
}

func (wrapper Wrapper) NewBeamSet(r ref) BeamSet {
	return BeamSet{wrapper.NewBase(r)}
}

// SetName sets a beamset's name string.
func (inst BeamSet) SetName(name string) error {
	ret := C.CCall_lib3mf_beamset_setname(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(name)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetName retrieves a beamset's name string.
func (inst BeamSet) GetName() (string, error) {
	var neededforname C.uint32_t
	var filledinname C.uint32_t
	ret := C.CCall_lib3mf_beamset_getname(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforname, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSizename := neededforname
	buffername := make([]byte, bufferSizename)
	ret = C.CCall_lib3mf_beamset_getname(inst.wrapperRef.LibraryHandle, inst.Ref, bufferSizename, &filledinname, (*C.char)(unsafe.Pointer(&buffername[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(buffername[:(filledinname-1)]), nil
}

// SetIdentifier sets a beamset's identifier string.
func (inst BeamSet) SetIdentifier(identifier string) error {
	ret := C.CCall_lib3mf_beamset_setidentifier(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetIdentifier retrieves a beamset's identifier string.
func (inst BeamSet) GetIdentifier() (string, error) {
	var neededforidentifier C.uint32_t
	var filledinidentifier C.uint32_t
	ret := C.CCall_lib3mf_beamset_getidentifier(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforidentifier, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSizeidentifier := neededforidentifier
	bufferidentifier := make([]byte, bufferSizeidentifier)
	ret = C.CCall_lib3mf_beamset_getidentifier(inst.wrapperRef.LibraryHandle, inst.Ref, bufferSizeidentifier, &filledinidentifier, (*C.char)(unsafe.Pointer(&bufferidentifier[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(bufferidentifier[:(filledinidentifier-1)]), nil
}

// GetReferenceCount retrieves the reference count of a beamset.
func (inst BeamSet) GetReferenceCount() (uint32, error) {
	var count C.uint32_t
	ret := C.CCall_lib3mf_beamset_getreferencecount(inst.wrapperRef.LibraryHandle, inst.Ref, &count)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(count), nil
}

// SetReferences sets the references of a beamset.
func (inst BeamSet) SetReferences(references []uint32) error {
	ret := C.CCall_lib3mf_beamset_setreferences(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint64_t(len(references)), (*C.uint32_t)(unsafe.Pointer(&references[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetReferences retrieves the references of a beamset.
func (inst BeamSet) GetReferences(references []uint32) ([]uint32, error) {
	var neededforreferences C.uint64_t
	ret := C.CCall_lib3mf_beamset_getreferences(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforreferences, nil)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	if len(references) < int(neededforreferences) {
	 references = append(references, make([]uint32, int(neededforreferences)-len(references))...)
	}
	ret = C.CCall_lib3mf_beamset_getreferences(inst.wrapperRef.LibraryHandle, inst.Ref, neededforreferences, nil, (*C.uint32_t)(unsafe.Pointer(&references[0])))
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	return references[:int(neededforreferences)], nil
}

// GetBallReferenceCount retrieves the ball reference count of a beamset.
func (inst BeamSet) GetBallReferenceCount() (uint32, error) {
	var count C.uint32_t
	ret := C.CCall_lib3mf_beamset_getballreferencecount(inst.wrapperRef.LibraryHandle, inst.Ref, &count)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(count), nil
}

// SetBallReferences sets the ball references of a beamset.
func (inst BeamSet) SetBallReferences(ballReferences []uint32) error {
	ret := C.CCall_lib3mf_beamset_setballreferences(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint64_t(len(ballReferences)), (*C.uint32_t)(unsafe.Pointer(&ballReferences[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetBallReferences retrieves the ball references of a beamset.
func (inst BeamSet) GetBallReferences(ballReferences []uint32) ([]uint32, error) {
	var neededforballReferences C.uint64_t
	ret := C.CCall_lib3mf_beamset_getballreferences(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforballReferences, nil)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	if len(ballReferences) < int(neededforballReferences) {
	 ballReferences = append(ballReferences, make([]uint32, int(neededforballReferences)-len(ballReferences))...)
	}
	ret = C.CCall_lib3mf_beamset_getballreferences(inst.wrapperRef.LibraryHandle, inst.Ref, neededforballReferences, nil, (*C.uint32_t)(unsafe.Pointer(&ballReferences[0])))
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	return ballReferences[:int(neededforballReferences)], nil
}


// BaseMaterialGroup represents a Lib3MF class.
type BaseMaterialGroup struct {
	Resource
}

func (wrapper Wrapper) NewBaseMaterialGroup(r ref) BaseMaterialGroup {
	return BaseMaterialGroup{wrapper.NewResource(r)}
}

// GetCount retrieves the count of base materials in the material group.
func (inst BaseMaterialGroup) GetCount() (uint32, error) {
	var count C.uint32_t
	ret := C.CCall_lib3mf_basematerialgroup_getcount(inst.wrapperRef.LibraryHandle, inst.Ref, &count)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(count), nil
}

// GetAllPropertyIDs returns all the PropertyIDs of all materials in this group.
func (inst BaseMaterialGroup) GetAllPropertyIDs(propertyIDs []uint32) ([]uint32, error) {
	var neededforpropertyIDs C.uint64_t
	ret := C.CCall_lib3mf_basematerialgroup_getallpropertyids(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforpropertyIDs, nil)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	if len(propertyIDs) < int(neededforpropertyIDs) {
	 propertyIDs = append(propertyIDs, make([]uint32, int(neededforpropertyIDs)-len(propertyIDs))...)
	}
	ret = C.CCall_lib3mf_basematerialgroup_getallpropertyids(inst.wrapperRef.LibraryHandle, inst.Ref, neededforpropertyIDs, nil, (*C.uint32_t)(unsafe.Pointer(&propertyIDs[0])))
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	return propertyIDs[:int(neededforpropertyIDs)], nil
}

// AddMaterial adds a new material to the material group.
func (inst BaseMaterialGroup) AddMaterial(name string, displayColor Color) (uint32, error) {
	var propertyID C.uint32_t
	ret := C.CCall_lib3mf_basematerialgroup_addmaterial(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(name)[0])), (*C.sLib3MFColor)(unsafe.Pointer(&displayColor)), &propertyID)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(propertyID), nil
}

// RemoveMaterial removes a material from the material group.
func (inst BaseMaterialGroup) RemoveMaterial(propertyID uint32) error {
	ret := C.CCall_lib3mf_basematerialgroup_removematerial(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(propertyID))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetName returns the base material's name.
func (inst BaseMaterialGroup) GetName(propertyID uint32) (string, error) {
	var neededforname C.uint32_t
	var filledinname C.uint32_t
	ret := C.CCall_lib3mf_basematerialgroup_getname(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(propertyID), 0, &neededforname, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSizename := neededforname
	buffername := make([]byte, bufferSizename)
	ret = C.CCall_lib3mf_basematerialgroup_getname(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(propertyID), bufferSizename, &filledinname, (*C.char)(unsafe.Pointer(&buffername[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(buffername[:(filledinname-1)]), nil
}

// SetName sets a base material's name.
func (inst BaseMaterialGroup) SetName(propertyID uint32, name string) error {
	ret := C.CCall_lib3mf_basematerialgroup_setname(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(propertyID), (*C.char)(unsafe.Pointer(&[]byte(name)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// SetDisplayColor sets a base material's display color.
func (inst BaseMaterialGroup) SetDisplayColor(propertyID uint32, theColor Color) error {
	ret := C.CCall_lib3mf_basematerialgroup_setdisplaycolor(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(propertyID), (*C.sLib3MFColor)(unsafe.Pointer(&theColor)))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetDisplayColor returns a base material's display color.
func (inst BaseMaterialGroup) GetDisplayColor(propertyID uint32) (Color, error) {
	var theColor C.sLib3MFColor
	ret := C.CCall_lib3mf_basematerialgroup_getdisplaycolor(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(propertyID), &theColor)
	if ret != 0 {
		return Color{}, makeError(uint32(ret))
	}
	return *(*Color)(unsafe.Pointer(&theColor)), nil
}


// ColorGroup represents a Lib3MF class.
type ColorGroup struct {
	Resource
}

func (wrapper Wrapper) NewColorGroup(r ref) ColorGroup {
	return ColorGroup{wrapper.NewResource(r)}
}

// GetCount retrieves the count of base materials in this Color Group.
func (inst ColorGroup) GetCount() (uint32, error) {
	var count C.uint32_t
	ret := C.CCall_lib3mf_colorgroup_getcount(inst.wrapperRef.LibraryHandle, inst.Ref, &count)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(count), nil
}

// GetAllPropertyIDs returns all the PropertyIDs of all colors within this group.
func (inst ColorGroup) GetAllPropertyIDs(propertyIDs []uint32) ([]uint32, error) {
	var neededforpropertyIDs C.uint64_t
	ret := C.CCall_lib3mf_colorgroup_getallpropertyids(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforpropertyIDs, nil)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	if len(propertyIDs) < int(neededforpropertyIDs) {
	 propertyIDs = append(propertyIDs, make([]uint32, int(neededforpropertyIDs)-len(propertyIDs))...)
	}
	ret = C.CCall_lib3mf_colorgroup_getallpropertyids(inst.wrapperRef.LibraryHandle, inst.Ref, neededforpropertyIDs, nil, (*C.uint32_t)(unsafe.Pointer(&propertyIDs[0])))
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	return propertyIDs[:int(neededforpropertyIDs)], nil
}

// AddColor adds a new value.
func (inst ColorGroup) AddColor(theColor Color) (uint32, error) {
	var propertyID C.uint32_t
	ret := C.CCall_lib3mf_colorgroup_addcolor(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.sLib3MFColor)(unsafe.Pointer(&theColor)), &propertyID)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(propertyID), nil
}

// RemoveColor removes a color from the color group.
func (inst ColorGroup) RemoveColor(propertyID uint32) error {
	ret := C.CCall_lib3mf_colorgroup_removecolor(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(propertyID))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// SetColor sets a color value.
func (inst ColorGroup) SetColor(propertyID uint32, theColor Color) error {
	ret := C.CCall_lib3mf_colorgroup_setcolor(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(propertyID), (*C.sLib3MFColor)(unsafe.Pointer(&theColor)))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetColor sets a color value.
func (inst ColorGroup) GetColor(propertyID uint32) (Color, error) {
	var theColor C.sLib3MFColor
	ret := C.CCall_lib3mf_colorgroup_getcolor(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(propertyID), &theColor)
	if ret != 0 {
		return Color{}, makeError(uint32(ret))
	}
	return *(*Color)(unsafe.Pointer(&theColor)), nil
}


// Texture2DGroup represents a Lib3MF class.
type Texture2DGroup struct {
	Resource
}

func (wrapper Wrapper) NewTexture2DGroup(r ref) Texture2DGroup {
	return Texture2DGroup{wrapper.NewResource(r)}
}

// GetCount retrieves the count of tex2coords in the Texture2DGroup.
func (inst Texture2DGroup) GetCount() (uint32, error) {
	var count C.uint32_t
	ret := C.CCall_lib3mf_texture2dgroup_getcount(inst.wrapperRef.LibraryHandle, inst.Ref, &count)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(count), nil
}

// GetAllPropertyIDs returns all the PropertyIDs of all tex2coords in this Texture2DGroup.
func (inst Texture2DGroup) GetAllPropertyIDs(propertyIDs []uint32) ([]uint32, error) {
	var neededforpropertyIDs C.uint64_t
	ret := C.CCall_lib3mf_texture2dgroup_getallpropertyids(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforpropertyIDs, nil)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	if len(propertyIDs) < int(neededforpropertyIDs) {
	 propertyIDs = append(propertyIDs, make([]uint32, int(neededforpropertyIDs)-len(propertyIDs))...)
	}
	ret = C.CCall_lib3mf_texture2dgroup_getallpropertyids(inst.wrapperRef.LibraryHandle, inst.Ref, neededforpropertyIDs, nil, (*C.uint32_t)(unsafe.Pointer(&propertyIDs[0])))
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	return propertyIDs[:int(neededforpropertyIDs)], nil
}

// AddTex2Coord adds a new tex2coord to the Texture2DGroup.
func (inst Texture2DGroup) AddTex2Coord(uVCoordinate Tex2Coord) (uint32, error) {
	var propertyID C.uint32_t
	ret := C.CCall_lib3mf_texture2dgroup_addtex2coord(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.sLib3MFTex2Coord)(unsafe.Pointer(&uVCoordinate)), &propertyID)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(propertyID), nil
}

// GetTex2Coord obtains a tex2coord to the Texture2DGroup.
func (inst Texture2DGroup) GetTex2Coord(propertyID uint32) (Tex2Coord, error) {
	var uVCoordinate C.sLib3MFTex2Coord
	ret := C.CCall_lib3mf_texture2dgroup_gettex2coord(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(propertyID), &uVCoordinate)
	if ret != 0 {
		return Tex2Coord{}, makeError(uint32(ret))
	}
	return *(*Tex2Coord)(unsafe.Pointer(&uVCoordinate)), nil
}

// RemoveTex2Coord removes a tex2coords from the Texture2DGroup.
func (inst Texture2DGroup) RemoveTex2Coord(propertyID uint32) error {
	ret := C.CCall_lib3mf_texture2dgroup_removetex2coord(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(propertyID))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetTexture2D obtains the texture2D instance of this group.
func (inst Texture2DGroup) GetTexture2D() (Texture2D, error) {
	var texture2DInstance ref
	ret := C.CCall_lib3mf_texture2dgroup_gettexture2d(inst.wrapperRef.LibraryHandle, inst.Ref, &texture2DInstance)
	if ret != 0 {
		return Texture2D{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewTexture2D(texture2DInstance), nil
}


// CompositeMaterials represents a Lib3MF class.
type CompositeMaterials struct {
	Resource
}

func (wrapper Wrapper) NewCompositeMaterials(r ref) CompositeMaterials {
	return CompositeMaterials{wrapper.NewResource(r)}
}

// GetCount retrieves the count of Composite-s in the CompositeMaterials.
func (inst CompositeMaterials) GetCount() (uint32, error) {
	var count C.uint32_t
	ret := C.CCall_lib3mf_compositematerials_getcount(inst.wrapperRef.LibraryHandle, inst.Ref, &count)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(count), nil
}

// GetAllPropertyIDs returns all the PropertyIDs of all Composite-Mixing Values in this CompositeMaterials.
func (inst CompositeMaterials) GetAllPropertyIDs(propertyIDs []uint32) ([]uint32, error) {
	var neededforpropertyIDs C.uint64_t
	ret := C.CCall_lib3mf_compositematerials_getallpropertyids(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforpropertyIDs, nil)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	if len(propertyIDs) < int(neededforpropertyIDs) {
	 propertyIDs = append(propertyIDs, make([]uint32, int(neededforpropertyIDs)-len(propertyIDs))...)
	}
	ret = C.CCall_lib3mf_compositematerials_getallpropertyids(inst.wrapperRef.LibraryHandle, inst.Ref, neededforpropertyIDs, nil, (*C.uint32_t)(unsafe.Pointer(&propertyIDs[0])))
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	return propertyIDs[:int(neededforpropertyIDs)], nil
}

// GetBaseMaterialGroup obtains the BaseMaterialGroup instance of this CompositeMaterials.
func (inst CompositeMaterials) GetBaseMaterialGroup() (BaseMaterialGroup, error) {
	var baseMaterialGroupInstance ref
	ret := C.CCall_lib3mf_compositematerials_getbasematerialgroup(inst.wrapperRef.LibraryHandle, inst.Ref, &baseMaterialGroupInstance)
	if ret != 0 {
		return BaseMaterialGroup{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewBaseMaterialGroup(baseMaterialGroupInstance), nil
}

// AddComposite adds a new Composite-Mixing Values to the CompositeMaterials.
func (inst CompositeMaterials) AddComposite(composite []CompositeConstituent) (uint32, error) {
	var propertyID C.uint32_t
	ret := C.CCall_lib3mf_compositematerials_addcomposite(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint64_t(len(composite)), (*C.sLib3MFCompositeConstituent)(unsafe.Pointer(&composite[0])), &propertyID)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(propertyID), nil
}

// RemoveComposite removes a Composite-Maxing Ratio from the CompositeMaterials.
func (inst CompositeMaterials) RemoveComposite(propertyID uint32) error {
	ret := C.CCall_lib3mf_compositematerials_removecomposite(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(propertyID))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetComposite obtains a Composite-Maxing Ratio of this CompositeMaterials.
func (inst CompositeMaterials) GetComposite(propertyID uint32, composite []CompositeConstituent) ([]CompositeConstituent, error) {
	var neededforcomposite C.uint64_t
	ret := C.CCall_lib3mf_compositematerials_getcomposite(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(propertyID), 0, &neededforcomposite, nil)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	if len(composite) < int(neededforcomposite) {
	 composite = append(composite, make([]CompositeConstituent, int(neededforcomposite)-len(composite))...)
	}
	ret = C.CCall_lib3mf_compositematerials_getcomposite(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(propertyID), neededforcomposite, nil, (*C.sLib3MFCompositeConstituent)(unsafe.Pointer(&composite[0])))
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	return composite[:int(neededforcomposite)], nil
}


// MultiPropertyGroup represents a Lib3MF class.
type MultiPropertyGroup struct {
	Resource
}

func (wrapper Wrapper) NewMultiPropertyGroup(r ref) MultiPropertyGroup {
	return MultiPropertyGroup{wrapper.NewResource(r)}
}

// GetCount retrieves the count of MultiProperty-s in the MultiPropertyGroup.
func (inst MultiPropertyGroup) GetCount() (uint32, error) {
	var count C.uint32_t
	ret := C.CCall_lib3mf_multipropertygroup_getcount(inst.wrapperRef.LibraryHandle, inst.Ref, &count)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(count), nil
}

// GetAllPropertyIDs returns all the PropertyIDs of all MultiProperty-s in this MultiPropertyGroup.
func (inst MultiPropertyGroup) GetAllPropertyIDs(propertyIDs []uint32) ([]uint32, error) {
	var neededforpropertyIDs C.uint64_t
	ret := C.CCall_lib3mf_multipropertygroup_getallpropertyids(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforpropertyIDs, nil)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	if len(propertyIDs) < int(neededforpropertyIDs) {
	 propertyIDs = append(propertyIDs, make([]uint32, int(neededforpropertyIDs)-len(propertyIDs))...)
	}
	ret = C.CCall_lib3mf_multipropertygroup_getallpropertyids(inst.wrapperRef.LibraryHandle, inst.Ref, neededforpropertyIDs, nil, (*C.uint32_t)(unsafe.Pointer(&propertyIDs[0])))
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	return propertyIDs[:int(neededforpropertyIDs)], nil
}

// AddMultiProperty adds a new MultiProperty to the MultiPropertyGroup.
func (inst MultiPropertyGroup) AddMultiProperty(propertyIDs []uint32) (uint32, error) {
	var propertyID C.uint32_t
	ret := C.CCall_lib3mf_multipropertygroup_addmultiproperty(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint64_t(len(propertyIDs)), (*C.uint32_t)(unsafe.Pointer(&propertyIDs[0])), &propertyID)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(propertyID), nil
}

// SetMultiProperty sets the PropertyIDs of a MultiProperty.
func (inst MultiPropertyGroup) SetMultiProperty(propertyID uint32, propertyIDs []uint32) error {
	ret := C.CCall_lib3mf_multipropertygroup_setmultiproperty(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(propertyID), C.uint64_t(len(propertyIDs)), (*C.uint32_t)(unsafe.Pointer(&propertyIDs[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetMultiProperty obtains the PropertyIDs of a MultiProperty.
func (inst MultiPropertyGroup) GetMultiProperty(propertyID uint32, propertyIDs []uint32) ([]uint32, error) {
	var neededforpropertyIDs C.uint64_t
	ret := C.CCall_lib3mf_multipropertygroup_getmultiproperty(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(propertyID), 0, &neededforpropertyIDs, nil)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	if len(propertyIDs) < int(neededforpropertyIDs) {
	 propertyIDs = append(propertyIDs, make([]uint32, int(neededforpropertyIDs)-len(propertyIDs))...)
	}
	ret = C.CCall_lib3mf_multipropertygroup_getmultiproperty(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(propertyID), neededforpropertyIDs, nil, (*C.uint32_t)(unsafe.Pointer(&propertyIDs[0])))
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	return propertyIDs[:int(neededforpropertyIDs)], nil
}

// RemoveMultiProperty removes a MultiProperty from this MultiPropertyGroup.
func (inst MultiPropertyGroup) RemoveMultiProperty(propertyID uint32) error {
	ret := C.CCall_lib3mf_multipropertygroup_removemultiproperty(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(propertyID))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetLayerCount retrieves the number of layers of this MultiPropertyGroup.
func (inst MultiPropertyGroup) GetLayerCount() (uint32, error) {
	var count C.uint32_t
	ret := C.CCall_lib3mf_multipropertygroup_getlayercount(inst.wrapperRef.LibraryHandle, inst.Ref, &count)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(count), nil
}

// AddLayer adds a MultiPropertyLayer to this MultiPropertyGroup.
func (inst MultiPropertyGroup) AddLayer(theLayer MultiPropertyLayer) (uint32, error) {
	var layerIndex C.uint32_t
	ret := C.CCall_lib3mf_multipropertygroup_addlayer(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.sLib3MFMultiPropertyLayer)(unsafe.Pointer(&theLayer)), &layerIndex)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(layerIndex), nil
}

// GetLayer obtains a MultiPropertyLayer of this MultiPropertyGroup.
func (inst MultiPropertyGroup) GetLayer(layerIndex uint32) (MultiPropertyLayer, error) {
	var theLayer C.sLib3MFMultiPropertyLayer
	ret := C.CCall_lib3mf_multipropertygroup_getlayer(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(layerIndex), &theLayer)
	if ret != 0 {
		return MultiPropertyLayer{}, makeError(uint32(ret))
	}
	return *(*MultiPropertyLayer)(unsafe.Pointer(&theLayer)), nil
}

// RemoveLayer removes a MultiPropertyLayer from this MultiPropertyGroup.
func (inst MultiPropertyGroup) RemoveLayer(layerIndex uint32) error {
	ret := C.CCall_lib3mf_multipropertygroup_removelayer(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(layerIndex))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}


// Image3D represents a Lib3MF class.
type Image3D struct {
	Resource
}

func (wrapper Wrapper) NewImage3D(r ref) Image3D {
	return Image3D{wrapper.NewResource(r)}
}

// GetName returns the name of this Image3D.
func (inst Image3D) GetName() (string, error) {
	var neededforname C.uint32_t
	var filledinname C.uint32_t
	ret := C.CCall_lib3mf_image3d_getname(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforname, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSizename := neededforname
	buffername := make([]byte, bufferSizename)
	ret = C.CCall_lib3mf_image3d_getname(inst.wrapperRef.LibraryHandle, inst.Ref, bufferSizename, &filledinname, (*C.char)(unsafe.Pointer(&buffername[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(buffername[:(filledinname-1)]), nil
}

// SetName sets a new name of this Image3D.
func (inst Image3D) SetName(name string) error {
	ret := C.CCall_lib3mf_image3d_setname(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(name)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// IsImageStack retrieves, if this Image3D is a ImageStack.
func (inst Image3D) IsImageStack() (bool, error) {
	var isImageStack C.bool
	ret := C.CCall_lib3mf_image3d_isimagestack(inst.wrapperRef.LibraryHandle, inst.Ref, &isImageStack)
	if ret != 0 {
		return false, makeError(uint32(ret))
	}
	return bool(isImageStack), nil
}


// ImageStack represents a Lib3MF class.
type ImageStack struct {
	Image3D
}

func (wrapper Wrapper) NewImageStack(r ref) ImageStack {
	return ImageStack{wrapper.NewImage3D(r)}
}

// GetRowCount retrieves the number of rows in each image of this image3d.
func (inst ImageStack) GetRowCount() (uint32, error) {
	var rowCount C.uint32_t
	ret := C.CCall_lib3mf_imagestack_getrowcount(inst.wrapperRef.LibraryHandle, inst.Ref, &rowCount)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(rowCount), nil
}

// SetRowCount sets the number of rows in each image of this image3d.
func (inst ImageStack) SetRowCount(rowCount uint32) error {
	ret := C.CCall_lib3mf_imagestack_setrowcount(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(rowCount))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetColumnCount retrieves the number of columns in each image of this image3d.
func (inst ImageStack) GetColumnCount() (uint32, error) {
	var columnCount C.uint32_t
	ret := C.CCall_lib3mf_imagestack_getcolumncount(inst.wrapperRef.LibraryHandle, inst.Ref, &columnCount)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(columnCount), nil
}

// SetColumnCount sets the number of columns in each image of this image3d.
func (inst ImageStack) SetColumnCount(columnCount uint32) error {
	ret := C.CCall_lib3mf_imagestack_setcolumncount(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(columnCount))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetSheetCount retrieves the number of images in the stack.
func (inst ImageStack) GetSheetCount() (uint32, error) {
	var sheetCount C.uint32_t
	ret := C.CCall_lib3mf_imagestack_getsheetcount(inst.wrapperRef.LibraryHandle, inst.Ref, &sheetCount)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(sheetCount), nil
}

// GetSheet retrieves a sheet of the stack. Raises an error if sheet is not set.
func (inst ImageStack) GetSheet(index uint32) (Attachment, error) {
	var sheet ref
	ret := C.CCall_lib3mf_imagestack_getsheet(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(index), &sheet)
	if ret != 0 {
		return Attachment{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewAttachment(sheet), nil
}

// SetSheet sets a sheet to an existing attachment.
func (inst ImageStack) SetSheet(index uint32, sheet Attachment) error {
	ret := C.CCall_lib3mf_imagestack_setsheet(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(index), sheet.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// CreateEmptySheet creates a new sheet attachment with empty data.
func (inst ImageStack) CreateEmptySheet(index uint32, path string) (Attachment, error) {
	var sheet ref
	ret := C.CCall_lib3mf_imagestack_createemptysheet(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(index), (*C.char)(unsafe.Pointer(&[]byte(path)[0])), &sheet)
	if ret != 0 {
		return Attachment{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewAttachment(sheet), nil
}

// CreateSheetFromBuffer creates a new sheet attachment from a memory buffer.
func (inst ImageStack) CreateSheetFromBuffer(index uint32, path string, data []uint8) (Attachment, error) {
	var sheet ref
	ret := C.CCall_lib3mf_imagestack_createsheetfrombuffer(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(index), (*C.char)(unsafe.Pointer(&[]byte(path)[0])), C.uint64_t(len(data)), (*C.uint8_t)(unsafe.Pointer(&data[0])), &sheet)
	if ret != 0 {
		return Attachment{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewAttachment(sheet), nil
}

// CreateSheetFromFile creates a new sheet attachment from a file on disk.
func (inst ImageStack) CreateSheetFromFile(index uint32, path string, fileName string) (Attachment, error) {
	var sheet ref
	ret := C.CCall_lib3mf_imagestack_createsheetfromfile(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(index), (*C.char)(unsafe.Pointer(&[]byte(path)[0])), (*C.char)(unsafe.Pointer(&[]byte(fileName)[0])), &sheet)
	if ret != 0 {
		return Attachment{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewAttachment(sheet), nil
}


// Attachment represents a Lib3MF class.
type Attachment struct {
	Base
}

func (wrapper Wrapper) NewAttachment(r ref) Attachment {
	return Attachment{wrapper.NewBase(r)}
}

// GetPath retrieves an attachment's package path. This function will be removed in a later release.
func (inst Attachment) GetPath() (string, error) {
	var neededforpath C.uint32_t
	var filledinpath C.uint32_t
	ret := C.CCall_lib3mf_attachment_getpath(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforpath, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSizepath := neededforpath
	bufferpath := make([]byte, bufferSizepath)
	ret = C.CCall_lib3mf_attachment_getpath(inst.wrapperRef.LibraryHandle, inst.Ref, bufferSizepath, &filledinpath, (*C.char)(unsafe.Pointer(&bufferpath[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(bufferpath[:(filledinpath-1)]), nil
}

// SetPath sets an attachment's package path. This function will be removed in a later release.
func (inst Attachment) SetPath(path string) error {
	ret := C.CCall_lib3mf_attachment_setpath(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(path)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// PackagePart returns the PackagePart that is this attachment.
func (inst Attachment) PackagePart() (PackagePart, error) {
	var packagePart ref
	ret := C.CCall_lib3mf_attachment_packagepart(inst.wrapperRef.LibraryHandle, inst.Ref, &packagePart)
	if ret != 0 {
		return PackagePart{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewPackagePart(packagePart), nil
}

// GetRelationShipType retrieves an attachment's relationship type.
func (inst Attachment) GetRelationShipType() (string, error) {
	var neededforpath C.uint32_t
	var filledinpath C.uint32_t
	ret := C.CCall_lib3mf_attachment_getrelationshiptype(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforpath, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSizepath := neededforpath
	bufferpath := make([]byte, bufferSizepath)
	ret = C.CCall_lib3mf_attachment_getrelationshiptype(inst.wrapperRef.LibraryHandle, inst.Ref, bufferSizepath, &filledinpath, (*C.char)(unsafe.Pointer(&bufferpath[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(bufferpath[:(filledinpath-1)]), nil
}

// SetRelationShipType sets an attachment's relationship type.
func (inst Attachment) SetRelationShipType(path string) error {
	ret := C.CCall_lib3mf_attachment_setrelationshiptype(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(path)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// WriteToFile writes out the attachment as file.
func (inst Attachment) WriteToFile(fileName string) error {
	ret := C.CCall_lib3mf_attachment_writetofile(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(fileName)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// ReadFromFile reads an attachment from a file. The path of this file is only read when this attachment is being written as part of the 3MF package, or via the WriteToFile or WriteToBuffer-methods.
func (inst Attachment) ReadFromFile(fileName string) error {
	ret := C.CCall_lib3mf_attachment_readfromfile(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(fileName)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// ReadFromCallback reads an attachment from the data provided by a callback function. This callback function is only invoked when this attachment is being written as part of the 3MF package, or via the WriteToFile or WriteToBuffer-methods.
func (inst Attachment) ReadFromCallback(theReadCallback ReadCallbackFunc, streamSize uint64, theSeekCallback SeekCallbackFunc, userData uintptr) error {
	ret := C.CCall_lib3mf_attachment_readfromcallback(inst.wrapperRef.LibraryHandle, inst.Ref, (C.Lib3MFReadCallback)(unsafe.Pointer(&theReadCallback)), C.uint64_t(streamSize), (C.Lib3MFSeekCallback)(unsafe.Pointer(&theSeekCallback)), (C.Lib3MF_pvoid)(userData))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	readCallbackFunc = theReadCallback
	seekCallbackFunc = theSeekCallback
	return nil
}

// GetStreamSize retrieves the size of the attachment stream.
func (inst Attachment) GetStreamSize() (uint64, error) {
	var streamSize C.uint64_t
	ret := C.CCall_lib3mf_attachment_getstreamsize(inst.wrapperRef.LibraryHandle, inst.Ref, &streamSize)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint64(streamSize), nil
}

// WriteToBuffer writes out the attachment into a buffer.
func (inst Attachment) WriteToBuffer(buffer []uint8) ([]uint8, error) {
	var neededforbuffer C.uint64_t
	ret := C.CCall_lib3mf_attachment_writetobuffer(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforbuffer, nil)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	if len(buffer) < int(neededforbuffer) {
	 buffer = append(buffer, make([]uint8, int(neededforbuffer)-len(buffer))...)
	}
	ret = C.CCall_lib3mf_attachment_writetobuffer(inst.wrapperRef.LibraryHandle, inst.Ref, neededforbuffer, nil, (*C.uint8_t)(unsafe.Pointer(&buffer[0])))
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	return buffer[:int(neededforbuffer)], nil
}

// ReadFromBuffer reads an attachment from a memory buffer. This buffer is immediatly read (in contrast to the ReadFromCallback and ReadFromFile-methods).
func (inst Attachment) ReadFromBuffer(buffer []uint8) error {
	ret := C.CCall_lib3mf_attachment_readfrombuffer(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint64_t(len(buffer)), (*C.uint8_t)(unsafe.Pointer(&buffer[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}


// Texture2D represents a Lib3MF class.
type Texture2D struct {
	Resource
}

func (wrapper Wrapper) NewTexture2D(r ref) Texture2D {
	return Texture2D{wrapper.NewResource(r)}
}

// GetAttachment retrieves the attachment located at the path of the texture.
func (inst Texture2D) GetAttachment() (Attachment, error) {
	var attachment ref
	ret := C.CCall_lib3mf_texture2d_getattachment(inst.wrapperRef.LibraryHandle, inst.Ref, &attachment)
	if ret != 0 {
		return Attachment{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewAttachment(attachment), nil
}

// SetAttachment sets the texture's package path to the path of the attachment.
func (inst Texture2D) SetAttachment(attachment Attachment) error {
	ret := C.CCall_lib3mf_texture2d_setattachment(inst.wrapperRef.LibraryHandle, inst.Ref, attachment.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetContentType retrieves a texture's content type.
func (inst Texture2D) GetContentType() (TextureType, error) {
	var contentType C.eLib3MFTextureType
	ret := C.CCall_lib3mf_texture2d_getcontenttype(inst.wrapperRef.LibraryHandle, inst.Ref, &contentType)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return TextureType(contentType), nil
}

// SetContentType retrieves a texture's content type.
func (inst Texture2D) SetContentType(contentType TextureType) error {
	ret := C.CCall_lib3mf_texture2d_setcontenttype(inst.wrapperRef.LibraryHandle, inst.Ref, C.eLib3MFTextureType(contentType))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetTileStyleUV retrieves a texture's tilestyle type.
func (inst Texture2D) GetTileStyleUV() (TextureTileStyle, TextureTileStyle, error) {
	var tileStyleU C.eLib3MFTextureTileStyle
	var tileStyleV C.eLib3MFTextureTileStyle
	ret := C.CCall_lib3mf_texture2d_gettilestyleuv(inst.wrapperRef.LibraryHandle, inst.Ref, &tileStyleU, &tileStyleV)
	if ret != 0 {
		return 0, 0, makeError(uint32(ret))
	}
	return TextureTileStyle(tileStyleU), TextureTileStyle(tileStyleV), nil
}

// SetTileStyleUV sets a texture's tilestyle type.
func (inst Texture2D) SetTileStyleUV(tileStyleU TextureTileStyle, tileStyleV TextureTileStyle) error {
	ret := C.CCall_lib3mf_texture2d_settilestyleuv(inst.wrapperRef.LibraryHandle, inst.Ref, C.eLib3MFTextureTileStyle(tileStyleU), C.eLib3MFTextureTileStyle(tileStyleV))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetFilter retrieves a texture's filter type.
func (inst Texture2D) GetFilter() (TextureFilter, error) {
	var filter C.eLib3MFTextureFilter
	ret := C.CCall_lib3mf_texture2d_getfilter(inst.wrapperRef.LibraryHandle, inst.Ref, &filter)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return TextureFilter(filter), nil
}

// SetFilter sets a texture's filter type.
func (inst Texture2D) SetFilter(filter TextureFilter) error {
	ret := C.CCall_lib3mf_texture2d_setfilter(inst.wrapperRef.LibraryHandle, inst.Ref, C.eLib3MFTextureFilter(filter))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}


// ImplicitPort represents a Lib3MF class.
type ImplicitPort struct {
	Base
}

func (wrapper Wrapper) NewImplicitPort(r ref) ImplicitPort {
	return ImplicitPort{wrapper.NewBase(r)}
}

// GetIdentifier retrieves the identifier of the port.
func (inst ImplicitPort) GetIdentifier() (string, error) {
	var neededforidentifier C.uint32_t
	var filledinidentifier C.uint32_t
	ret := C.CCall_lib3mf_implicitport_getidentifier(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforidentifier, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSizeidentifier := neededforidentifier
	bufferidentifier := make([]byte, bufferSizeidentifier)
	ret = C.CCall_lib3mf_implicitport_getidentifier(inst.wrapperRef.LibraryHandle, inst.Ref, bufferSizeidentifier, &filledinidentifier, (*C.char)(unsafe.Pointer(&bufferidentifier[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(bufferidentifier[:(filledinidentifier-1)]), nil
}

// SetIdentifier sets the identifier of the port.
func (inst ImplicitPort) SetIdentifier(identifier string) error {
	ret := C.CCall_lib3mf_implicitport_setidentifier(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetDisplayName retrieves the display name of the port.
func (inst ImplicitPort) GetDisplayName() (string, error) {
	var neededfordisplayName C.uint32_t
	var filledindisplayName C.uint32_t
	ret := C.CCall_lib3mf_implicitport_getdisplayname(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededfordisplayName, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSizedisplayName := neededfordisplayName
	bufferdisplayName := make([]byte, bufferSizedisplayName)
	ret = C.CCall_lib3mf_implicitport_getdisplayname(inst.wrapperRef.LibraryHandle, inst.Ref, bufferSizedisplayName, &filledindisplayName, (*C.char)(unsafe.Pointer(&bufferdisplayName[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(bufferdisplayName[:(filledindisplayName-1)]), nil
}

// SetDisplayName sets the display name of the port.
func (inst ImplicitPort) SetDisplayName(displayName string) error {
	ret := C.CCall_lib3mf_implicitport_setdisplayname(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(displayName)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// SetType sets the type of the port.
func (inst ImplicitPort) SetType(implicitPortType ImplicitPortType) error {
	ret := C.CCall_lib3mf_implicitport_settype(inst.wrapperRef.LibraryHandle, inst.Ref, C.eLib3MFImplicitPortType(implicitPortType))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetType retrieves the type of the port.
func (inst ImplicitPort) GetType() (ImplicitPortType, error) {
	var implicitPortType C.eLib3MFImplicitPortType
	ret := C.CCall_lib3mf_implicitport_gettype(inst.wrapperRef.LibraryHandle, inst.Ref, &implicitPortType)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return ImplicitPortType(implicitPortType), nil
}

// GetReference retrieves the reference of the port, only used for input ports.
func (inst ImplicitPort) GetReference() (string, error) {
	var neededforreference C.uint32_t
	var filledinreference C.uint32_t
	ret := C.CCall_lib3mf_implicitport_getreference(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforreference, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSizereference := neededforreference
	bufferreference := make([]byte, bufferSizereference)
	ret = C.CCall_lib3mf_implicitport_getreference(inst.wrapperRef.LibraryHandle, inst.Ref, bufferSizereference, &filledinreference, (*C.char)(unsafe.Pointer(&bufferreference[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(bufferreference[:(filledinreference-1)]), nil
}

// SetReference sets the reference of the port, only used for input ports.
func (inst ImplicitPort) SetReference(reference string) error {
	ret := C.CCall_lib3mf_implicitport_setreference(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(reference)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}


// Iterator represents a Lib3MF class.
type Iterator struct {
	Base
}

func (wrapper Wrapper) NewIterator(r ref) Iterator {
	return Iterator{wrapper.NewBase(r)}
}

// MoveNext iterates to the next item in the list.
func (inst Iterator) MoveNext() (bool, error) {
	var hasNext C.bool
	ret := C.CCall_lib3mf_iterator_movenext(inst.wrapperRef.LibraryHandle, inst.Ref, &hasNext)
	if ret != 0 {
		return false, makeError(uint32(ret))
	}
	return bool(hasNext), nil
}

// MovePrevious iterates to the previous item in the list.
func (inst Iterator) MovePrevious() (bool, error) {
	var hasPrevious C.bool
	ret := C.CCall_lib3mf_iterator_moveprevious(inst.wrapperRef.LibraryHandle, inst.Ref, &hasPrevious)
	if ret != 0 {
		return false, makeError(uint32(ret))
	}
	return bool(hasPrevious), nil
}

// Count returns the number of items the iterator captures.
func (inst Iterator) Count() (uint64, error) {
	var count C.uint64_t
	ret := C.CCall_lib3mf_iterator_count(inst.wrapperRef.LibraryHandle, inst.Ref, &count)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint64(count), nil
}


// ImplicitPortIterator represents a Lib3MF class.
type ImplicitPortIterator struct {
	Iterator
}

func (wrapper Wrapper) NewImplicitPortIterator(r ref) ImplicitPortIterator {
	return ImplicitPortIterator{wrapper.NewIterator(r)}
}

// GetCurrent returns the current element.
func (inst ImplicitPortIterator) GetCurrent() (ImplicitPort, error) {
	var port ref
	ret := C.CCall_lib3mf_implicitportiterator_getcurrent(inst.wrapperRef.LibraryHandle, inst.Ref, &port)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(port), nil
}


// ImplicitNode represents a Lib3MF class.
type ImplicitNode struct {
	Base
}

func (wrapper Wrapper) NewImplicitNode(r ref) ImplicitNode {
	return ImplicitNode{wrapper.NewBase(r)}
}

// GetIdentifier retrieves the identifier of the node.
func (inst ImplicitNode) GetIdentifier() (string, error) {
	var neededforidentifier C.uint32_t
	var filledinidentifier C.uint32_t
	ret := C.CCall_lib3mf_implicitnode_getidentifier(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforidentifier, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSizeidentifier := neededforidentifier
	bufferidentifier := make([]byte, bufferSizeidentifier)
	ret = C.CCall_lib3mf_implicitnode_getidentifier(inst.wrapperRef.LibraryHandle, inst.Ref, bufferSizeidentifier, &filledinidentifier, (*C.char)(unsafe.Pointer(&bufferidentifier[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(bufferidentifier[:(filledinidentifier-1)]), nil
}

// SetIdentifier sets the identifier of the node.
func (inst ImplicitNode) SetIdentifier(identifier string) error {
	ret := C.CCall_lib3mf_implicitnode_setidentifier(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetDisplayName retrieves the display name of the node.
func (inst ImplicitNode) GetDisplayName() (string, error) {
	var neededfordisplayName C.uint32_t
	var filledindisplayName C.uint32_t
	ret := C.CCall_lib3mf_implicitnode_getdisplayname(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededfordisplayName, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSizedisplayName := neededfordisplayName
	bufferdisplayName := make([]byte, bufferSizedisplayName)
	ret = C.CCall_lib3mf_implicitnode_getdisplayname(inst.wrapperRef.LibraryHandle, inst.Ref, bufferSizedisplayName, &filledindisplayName, (*C.char)(unsafe.Pointer(&bufferdisplayName[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(bufferdisplayName[:(filledindisplayName-1)]), nil
}

// SetDisplayName sets the display name of the node.
func (inst ImplicitNode) SetDisplayName(displayName string) error {
	ret := C.CCall_lib3mf_implicitnode_setdisplayname(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(displayName)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetTag retrieves the tag of the node.
func (inst ImplicitNode) GetTag() (string, error) {
	var neededfortag C.uint32_t
	var filledintag C.uint32_t
	ret := C.CCall_lib3mf_implicitnode_gettag(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededfortag, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSizetag := neededfortag
	buffertag := make([]byte, bufferSizetag)
	ret = C.CCall_lib3mf_implicitnode_gettag(inst.wrapperRef.LibraryHandle, inst.Ref, bufferSizetag, &filledintag, (*C.char)(unsafe.Pointer(&buffertag[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(buffertag[:(filledintag-1)]), nil
}

// SetTag sets the tag of the node.
func (inst ImplicitNode) SetTag(tag string) error {
	ret := C.CCall_lib3mf_implicitnode_settag(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(tag)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetNodeType retrieves the type of the node.
func (inst ImplicitNode) GetNodeType() (ImplicitNodeType, error) {
	var _type C.eLib3MFImplicitNodeType
	ret := C.CCall_lib3mf_implicitnode_getnodetype(inst.wrapperRef.LibraryHandle, inst.Ref, &_type)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return ImplicitNodeType(_type), nil
}

// AddInput add an input.
func (inst ImplicitNode) AddInput(identifier string, displayName string) (ImplicitPort, error) {
	var port ref
	ret := C.CCall_lib3mf_implicitnode_addinput(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), (*C.char)(unsafe.Pointer(&[]byte(displayName)[0])), &port)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(port), nil
}

// GetInputs retrieves the inputs.
func (inst ImplicitNode) GetInputs() (ImplicitPortIterator, error) {
	var iterator ref
	ret := C.CCall_lib3mf_implicitnode_getinputs(inst.wrapperRef.LibraryHandle, inst.Ref, &iterator)
	if ret != 0 {
		return ImplicitPortIterator{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPortIterator(iterator), nil
}

// AddOutput add an output.
func (inst ImplicitNode) AddOutput(identifier string, displayName string) (ImplicitPort, error) {
	var port ref
	ret := C.CCall_lib3mf_implicitnode_addoutput(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), (*C.char)(unsafe.Pointer(&[]byte(displayName)[0])), &port)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(port), nil
}

// GetOutputs retrieves the outputs.
func (inst ImplicitNode) GetOutputs() (ImplicitPortIterator, error) {
	var iterator ref
	ret := C.CCall_lib3mf_implicitnode_getoutputs(inst.wrapperRef.LibraryHandle, inst.Ref, &iterator)
	if ret != 0 {
		return ImplicitPortIterator{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPortIterator(iterator), nil
}

// FindInput retrieves an input.
func (inst ImplicitNode) FindInput(identifier string) (*ImplicitPort, error) {
	var input ref
	ret := C.CCall_lib3mf_implicitnode_findinput(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), &input)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	var _inputPtr *ImplicitPort
	if input != nil {
		_inputPtrVal := inst.wrapperRef.NewImplicitPort(input)
		_inputPtr = &_inputPtrVal
	}
	return _inputPtr, nil
}

// FindOutput retrieves an output.
func (inst ImplicitNode) FindOutput(identifier string) (*ImplicitPort, error) {
	var output ref
	ret := C.CCall_lib3mf_implicitnode_findoutput(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), &output)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	var _outputPtr *ImplicitPort
	if output != nil {
		_outputPtrVal := inst.wrapperRef.NewImplicitPort(output)
		_outputPtr = &_outputPtrVal
	}
	return _outputPtr, nil
}

// AreTypesValid checks if the types of the input and output ports are valid for the node type.
func (inst ImplicitNode) AreTypesValid() (bool, error) {
	var valid C.bool
	ret := C.CCall_lib3mf_implicitnode_aretypesvalid(inst.wrapperRef.LibraryHandle, inst.Ref, &valid)
	if ret != 0 {
		return false, makeError(uint32(ret))
	}
	return bool(valid), nil
}


// OneInputNode represents a Lib3MF class.
type OneInputNode struct {
	ImplicitNode
}

func (wrapper Wrapper) NewOneInputNode(r ref) OneInputNode {
	return OneInputNode{wrapper.NewImplicitNode(r)}
}

// GetInputA retrieves the input.
func (inst OneInputNode) GetInputA() (ImplicitPort, error) {
	var input ref
	ret := C.CCall_lib3mf_oneinputnode_getinputa(inst.wrapperRef.LibraryHandle, inst.Ref, &input)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(input), nil
}

// GetOutputResult retrieves the output.
func (inst OneInputNode) GetOutputResult() (ImplicitPort, error) {
	var result ref
	ret := C.CCall_lib3mf_oneinputnode_getoutputresult(inst.wrapperRef.LibraryHandle, inst.Ref, &result)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(result), nil
}


// SinNode represents a Lib3MF class.
type SinNode struct {
	OneInputNode
}

func (wrapper Wrapper) NewSinNode(r ref) SinNode {
	return SinNode{wrapper.NewOneInputNode(r)}
}


// CosNode represents a Lib3MF class.
type CosNode struct {
	OneInputNode
}

func (wrapper Wrapper) NewCosNode(r ref) CosNode {
	return CosNode{wrapper.NewOneInputNode(r)}
}


// TanNode represents a Lib3MF class.
type TanNode struct {
	OneInputNode
}

func (wrapper Wrapper) NewTanNode(r ref) TanNode {
	return TanNode{wrapper.NewOneInputNode(r)}
}


// ArcSinNode represents a Lib3MF class.
type ArcSinNode struct {
	OneInputNode
}

func (wrapper Wrapper) NewArcSinNode(r ref) ArcSinNode {
	return ArcSinNode{wrapper.NewOneInputNode(r)}
}


// ArcCosNode represents a Lib3MF class.
type ArcCosNode struct {
	OneInputNode
}

func (wrapper Wrapper) NewArcCosNode(r ref) ArcCosNode {
	return ArcCosNode{wrapper.NewOneInputNode(r)}
}


// ArcTanNode represents a Lib3MF class.
type ArcTanNode struct {
	OneInputNode
}

func (wrapper Wrapper) NewArcTanNode(r ref) ArcTanNode {
	return ArcTanNode{wrapper.NewOneInputNode(r)}
}


// SinhNode represents a Lib3MF class.
type SinhNode struct {
	OneInputNode
}

func (wrapper Wrapper) NewSinhNode(r ref) SinhNode {
	return SinhNode{wrapper.NewOneInputNode(r)}
}


// CoshNode represents a Lib3MF class.
type CoshNode struct {
	OneInputNode
}

func (wrapper Wrapper) NewCoshNode(r ref) CoshNode {
	return CoshNode{wrapper.NewOneInputNode(r)}
}


// TanhNode represents a Lib3MF class.
type TanhNode struct {
	OneInputNode
}

func (wrapper Wrapper) NewTanhNode(r ref) TanhNode {
	return TanhNode{wrapper.NewOneInputNode(r)}
}


// RoundNode represents a Lib3MF class.
type RoundNode struct {
	OneInputNode
}

func (wrapper Wrapper) NewRoundNode(r ref) RoundNode {
	return RoundNode{wrapper.NewOneInputNode(r)}
}


// CeilNode represents a Lib3MF class.
type CeilNode struct {
	OneInputNode
}

func (wrapper Wrapper) NewCeilNode(r ref) CeilNode {
	return CeilNode{wrapper.NewOneInputNode(r)}
}


// FloorNode represents a Lib3MF class.
type FloorNode struct {
	OneInputNode
}

func (wrapper Wrapper) NewFloorNode(r ref) FloorNode {
	return FloorNode{wrapper.NewOneInputNode(r)}
}


// SignNode represents a Lib3MF class.
type SignNode struct {
	OneInputNode
}

func (wrapper Wrapper) NewSignNode(r ref) SignNode {
	return SignNode{wrapper.NewOneInputNode(r)}
}


// FractNode represents a Lib3MF class.
type FractNode struct {
	OneInputNode
}

func (wrapper Wrapper) NewFractNode(r ref) FractNode {
	return FractNode{wrapper.NewOneInputNode(r)}
}


// AbsNode represents a Lib3MF class.
type AbsNode struct {
	OneInputNode
}

func (wrapper Wrapper) NewAbsNode(r ref) AbsNode {
	return AbsNode{wrapper.NewOneInputNode(r)}
}


// ExpNode represents a Lib3MF class.
type ExpNode struct {
	OneInputNode
}

func (wrapper Wrapper) NewExpNode(r ref) ExpNode {
	return ExpNode{wrapper.NewOneInputNode(r)}
}


// LogNode represents a Lib3MF class.
type LogNode struct {
	OneInputNode
}

func (wrapper Wrapper) NewLogNode(r ref) LogNode {
	return LogNode{wrapper.NewOneInputNode(r)}
}


// Log2Node represents a Lib3MF class.
type Log2Node struct {
	OneInputNode
}

func (wrapper Wrapper) NewLog2Node(r ref) Log2Node {
	return Log2Node{wrapper.NewOneInputNode(r)}
}


// Log10Node represents a Lib3MF class.
type Log10Node struct {
	OneInputNode
}

func (wrapper Wrapper) NewLog10Node(r ref) Log10Node {
	return Log10Node{wrapper.NewOneInputNode(r)}
}


// LengthNode represents a Lib3MF class.
type LengthNode struct {
	OneInputNode
}

func (wrapper Wrapper) NewLengthNode(r ref) LengthNode {
	return LengthNode{wrapper.NewOneInputNode(r)}
}


// TransposeNode represents a Lib3MF class.
type TransposeNode struct {
	OneInputNode
}

func (wrapper Wrapper) NewTransposeNode(r ref) TransposeNode {
	return TransposeNode{wrapper.NewOneInputNode(r)}
}


// InverseNode represents a Lib3MF class.
type InverseNode struct {
	OneInputNode
}

func (wrapper Wrapper) NewInverseNode(r ref) InverseNode {
	return InverseNode{wrapper.NewOneInputNode(r)}
}


// SqrtNode represents a Lib3MF class.
type SqrtNode struct {
	OneInputNode
}

func (wrapper Wrapper) NewSqrtNode(r ref) SqrtNode {
	return SqrtNode{wrapper.NewOneInputNode(r)}
}


// ResourceIdNode represents a Lib3MF class.
type ResourceIdNode struct {
	ImplicitNode
}

func (wrapper Wrapper) NewResourceIdNode(r ref) ResourceIdNode {
	return ResourceIdNode{wrapper.NewImplicitNode(r)}
}

// SetResource sets the Resource that the resourceid attribute of the node will point to.
func (inst ResourceIdNode) SetResource(resource Resource) error {
	ret := C.CCall_lib3mf_resourceidnode_setresource(inst.wrapperRef.LibraryHandle, inst.Ref, resource.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetResource retrieves the resource of the node.
func (inst ResourceIdNode) GetResource() (Resource, error) {
	var resource ref
	ret := C.CCall_lib3mf_resourceidnode_getresource(inst.wrapperRef.LibraryHandle, inst.Ref, &resource)
	if ret != 0 {
		return Resource{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewResource(resource), nil
}

// GetOutputValue retrieves the output.
func (inst ResourceIdNode) GetOutputValue() (ImplicitPort, error) {
	var value ref
	ret := C.CCall_lib3mf_resourceidnode_getoutputvalue(inst.wrapperRef.LibraryHandle, inst.Ref, &value)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(value), nil
}


// TwoInputNode represents a Lib3MF class.
type TwoInputNode struct {
	OneInputNode
}

func (wrapper Wrapper) NewTwoInputNode(r ref) TwoInputNode {
	return TwoInputNode{wrapper.NewOneInputNode(r)}
}

// GetInputB retrieves the second input.
func (inst TwoInputNode) GetInputB() (ImplicitPort, error) {
	var b ref
	ret := C.CCall_lib3mf_twoinputnode_getinputb(inst.wrapperRef.LibraryHandle, inst.Ref, &b)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(b), nil
}


// AdditionNode represents a Lib3MF class.
type AdditionNode struct {
	TwoInputNode
}

func (wrapper Wrapper) NewAdditionNode(r ref) AdditionNode {
	return AdditionNode{wrapper.NewTwoInputNode(r)}
}


// SubtractionNode represents a Lib3MF class.
type SubtractionNode struct {
	TwoInputNode
}

func (wrapper Wrapper) NewSubtractionNode(r ref) SubtractionNode {
	return SubtractionNode{wrapper.NewTwoInputNode(r)}
}


// MultiplicationNode represents a Lib3MF class.
type MultiplicationNode struct {
	TwoInputNode
}

func (wrapper Wrapper) NewMultiplicationNode(r ref) MultiplicationNode {
	return MultiplicationNode{wrapper.NewTwoInputNode(r)}
}


// DivisionNode represents a Lib3MF class.
type DivisionNode struct {
	TwoInputNode
}

func (wrapper Wrapper) NewDivisionNode(r ref) DivisionNode {
	return DivisionNode{wrapper.NewTwoInputNode(r)}
}


// DotNode represents a Lib3MF class.
type DotNode struct {
	TwoInputNode
}

func (wrapper Wrapper) NewDotNode(r ref) DotNode {
	return DotNode{wrapper.NewTwoInputNode(r)}
}


// CrossNode represents a Lib3MF class.
type CrossNode struct {
	TwoInputNode
}

func (wrapper Wrapper) NewCrossNode(r ref) CrossNode {
	return CrossNode{wrapper.NewTwoInputNode(r)}
}


// ArcTan2Node represents a Lib3MF class.
type ArcTan2Node struct {
	TwoInputNode
}

func (wrapper Wrapper) NewArcTan2Node(r ref) ArcTan2Node {
	return ArcTan2Node{wrapper.NewTwoInputNode(r)}
}


// MatVecMultiplicationNode represents a Lib3MF class.
type MatVecMultiplicationNode struct {
	TwoInputNode
}

func (wrapper Wrapper) NewMatVecMultiplicationNode(r ref) MatVecMultiplicationNode {
	return MatVecMultiplicationNode{wrapper.NewTwoInputNode(r)}
}


// MinNode represents a Lib3MF class.
type MinNode struct {
	TwoInputNode
}

func (wrapper Wrapper) NewMinNode(r ref) MinNode {
	return MinNode{wrapper.NewTwoInputNode(r)}
}


// MaxNode represents a Lib3MF class.
type MaxNode struct {
	TwoInputNode
}

func (wrapper Wrapper) NewMaxNode(r ref) MaxNode {
	return MaxNode{wrapper.NewTwoInputNode(r)}
}


// FmodNode represents a Lib3MF class.
type FmodNode struct {
	TwoInputNode
}

func (wrapper Wrapper) NewFmodNode(r ref) FmodNode {
	return FmodNode{wrapper.NewTwoInputNode(r)}
}


// ModNode represents a Lib3MF class.
type ModNode struct {
	TwoInputNode
}

func (wrapper Wrapper) NewModNode(r ref) ModNode {
	return ModNode{wrapper.NewTwoInputNode(r)}
}


// PowNode represents a Lib3MF class.
type PowNode struct {
	TwoInputNode
}

func (wrapper Wrapper) NewPowNode(r ref) PowNode {
	return PowNode{wrapper.NewTwoInputNode(r)}
}


// SelectNode represents a Lib3MF class.
type SelectNode struct {
	OneInputNode
}

func (wrapper Wrapper) NewSelectNode(r ref) SelectNode {
	return SelectNode{wrapper.NewOneInputNode(r)}
}

// GetInputB retrieves the second input.
func (inst SelectNode) GetInputB() (ImplicitPort, error) {
	var b ref
	ret := C.CCall_lib3mf_selectnode_getinputb(inst.wrapperRef.LibraryHandle, inst.Ref, &b)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(b), nil
}

// GetInputC retrieves the third input.
func (inst SelectNode) GetInputC() (ImplicitPort, error) {
	var c ref
	ret := C.CCall_lib3mf_selectnode_getinputc(inst.wrapperRef.LibraryHandle, inst.Ref, &c)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(c), nil
}

// GetInputD retrieves the fourth input.
func (inst SelectNode) GetInputD() (ImplicitPort, error) {
	var d ref
	ret := C.CCall_lib3mf_selectnode_getinputd(inst.wrapperRef.LibraryHandle, inst.Ref, &d)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(d), nil
}


// ClampNode represents a Lib3MF class.
type ClampNode struct {
	OneInputNode
}

func (wrapper Wrapper) NewClampNode(r ref) ClampNode {
	return ClampNode{wrapper.NewOneInputNode(r)}
}

// GetInputMin retrieves the input for the lower limit.
func (inst ClampNode) GetInputMin() (ImplicitPort, error) {
	var min ref
	ret := C.CCall_lib3mf_clampnode_getinputmin(inst.wrapperRef.LibraryHandle, inst.Ref, &min)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(min), nil
}

// GetInputMax retrieves the input for the upper limit.
func (inst ClampNode) GetInputMax() (ImplicitPort, error) {
	var max ref
	ret := C.CCall_lib3mf_clampnode_getinputmax(inst.wrapperRef.LibraryHandle, inst.Ref, &max)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(max), nil
}


// ComposeVectorNode represents a Lib3MF class.
type ComposeVectorNode struct {
	ImplicitNode
}

func (wrapper Wrapper) NewComposeVectorNode(r ref) ComposeVectorNode {
	return ComposeVectorNode{wrapper.NewImplicitNode(r)}
}

// GetInputX retrieves the input for the x component.
func (inst ComposeVectorNode) GetInputX() (ImplicitPort, error) {
	var x ref
	ret := C.CCall_lib3mf_composevectornode_getinputx(inst.wrapperRef.LibraryHandle, inst.Ref, &x)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(x), nil
}

// GetInputY retrieves the input for the y component.
func (inst ComposeVectorNode) GetInputY() (ImplicitPort, error) {
	var y ref
	ret := C.CCall_lib3mf_composevectornode_getinputy(inst.wrapperRef.LibraryHandle, inst.Ref, &y)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(y), nil
}

// GetInputZ retrieves the input for the z component.
func (inst ComposeVectorNode) GetInputZ() (ImplicitPort, error) {
	var z ref
	ret := C.CCall_lib3mf_composevectornode_getinputz(inst.wrapperRef.LibraryHandle, inst.Ref, &z)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(z), nil
}

// GetOutputResult retrieves the output.
func (inst ComposeVectorNode) GetOutputResult() (ImplicitPort, error) {
	var result ref
	ret := C.CCall_lib3mf_composevectornode_getoutputresult(inst.wrapperRef.LibraryHandle, inst.Ref, &result)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(result), nil
}


// VectorFromScalarNode represents a Lib3MF class.
type VectorFromScalarNode struct {
	OneInputNode
}

func (wrapper Wrapper) NewVectorFromScalarNode(r ref) VectorFromScalarNode {
	return VectorFromScalarNode{wrapper.NewOneInputNode(r)}
}


// DecomposeVectorNode represents a Lib3MF class.
type DecomposeVectorNode struct {
	ImplicitNode
}

func (wrapper Wrapper) NewDecomposeVectorNode(r ref) DecomposeVectorNode {
	return DecomposeVectorNode{wrapper.NewImplicitNode(r)}
}

// GetInputA retrieves the input.
func (inst DecomposeVectorNode) GetInputA() (ImplicitPort, error) {
	var a ref
	ret := C.CCall_lib3mf_decomposevectornode_getinputa(inst.wrapperRef.LibraryHandle, inst.Ref, &a)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(a), nil
}

// GetOutputX retrieves the output for the x component.
func (inst DecomposeVectorNode) GetOutputX() (ImplicitPort, error) {
	var x ref
	ret := C.CCall_lib3mf_decomposevectornode_getoutputx(inst.wrapperRef.LibraryHandle, inst.Ref, &x)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(x), nil
}

// GetOutputY retrieves the output for the y component.
func (inst DecomposeVectorNode) GetOutputY() (ImplicitPort, error) {
	var y ref
	ret := C.CCall_lib3mf_decomposevectornode_getoutputy(inst.wrapperRef.LibraryHandle, inst.Ref, &y)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(y), nil
}

// GetOutputZ retrieves the output for the z component.
func (inst DecomposeVectorNode) GetOutputZ() (ImplicitPort, error) {
	var z ref
	ret := C.CCall_lib3mf_decomposevectornode_getoutputz(inst.wrapperRef.LibraryHandle, inst.Ref, &z)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(z), nil
}


// ComposeMatrixNode represents a Lib3MF class.
type ComposeMatrixNode struct {
	ImplicitNode
}

func (wrapper Wrapper) NewComposeMatrixNode(r ref) ComposeMatrixNode {
	return ComposeMatrixNode{wrapper.NewImplicitNode(r)}
}

// GetInputM00 retrieves the input for the element 0 0.
func (inst ComposeMatrixNode) GetInputM00() (ImplicitPort, error) {
	var m00 ref
	ret := C.CCall_lib3mf_composematrixnode_getinputm00(inst.wrapperRef.LibraryHandle, inst.Ref, &m00)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(m00), nil
}

// GetInputM01 retrieves the input for the element 0 1.
func (inst ComposeMatrixNode) GetInputM01() (ImplicitPort, error) {
	var m01 ref
	ret := C.CCall_lib3mf_composematrixnode_getinputm01(inst.wrapperRef.LibraryHandle, inst.Ref, &m01)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(m01), nil
}

// GetInputM02 retrieves the input for the element 0 2.
func (inst ComposeMatrixNode) GetInputM02() (ImplicitPort, error) {
	var m02 ref
	ret := C.CCall_lib3mf_composematrixnode_getinputm02(inst.wrapperRef.LibraryHandle, inst.Ref, &m02)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(m02), nil
}

// GetInputM03 retrieves the input for the element 0 3.
func (inst ComposeMatrixNode) GetInputM03() (ImplicitPort, error) {
	var m03 ref
	ret := C.CCall_lib3mf_composematrixnode_getinputm03(inst.wrapperRef.LibraryHandle, inst.Ref, &m03)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(m03), nil
}

// GetInputM10 retrieves the input for the element 1 0.
func (inst ComposeMatrixNode) GetInputM10() (ImplicitPort, error) {
	var m10 ref
	ret := C.CCall_lib3mf_composematrixnode_getinputm10(inst.wrapperRef.LibraryHandle, inst.Ref, &m10)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(m10), nil
}

// GetInputM11 retrieves the input for the element 1 1.
func (inst ComposeMatrixNode) GetInputM11() (ImplicitPort, error) {
	var m11 ref
	ret := C.CCall_lib3mf_composematrixnode_getinputm11(inst.wrapperRef.LibraryHandle, inst.Ref, &m11)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(m11), nil
}

// GetInputM12 retrieves the input for the element 1 2.
func (inst ComposeMatrixNode) GetInputM12() (ImplicitPort, error) {
	var m12 ref
	ret := C.CCall_lib3mf_composematrixnode_getinputm12(inst.wrapperRef.LibraryHandle, inst.Ref, &m12)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(m12), nil
}

// GetInputM13 retrieves the input for the element 1 3.
func (inst ComposeMatrixNode) GetInputM13() (ImplicitPort, error) {
	var m13 ref
	ret := C.CCall_lib3mf_composematrixnode_getinputm13(inst.wrapperRef.LibraryHandle, inst.Ref, &m13)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(m13), nil
}

// GetInputM20 retrieves the input for the element 2 0.
func (inst ComposeMatrixNode) GetInputM20() (ImplicitPort, error) {
	var m20 ref
	ret := C.CCall_lib3mf_composematrixnode_getinputm20(inst.wrapperRef.LibraryHandle, inst.Ref, &m20)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(m20), nil
}

// GetInputM21 retrieves the input for the element 2 1.
func (inst ComposeMatrixNode) GetInputM21() (ImplicitPort, error) {
	var m21 ref
	ret := C.CCall_lib3mf_composematrixnode_getinputm21(inst.wrapperRef.LibraryHandle, inst.Ref, &m21)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(m21), nil
}

// GetInputM22 retrieves the input for the element 2 2.
func (inst ComposeMatrixNode) GetInputM22() (ImplicitPort, error) {
	var m22 ref
	ret := C.CCall_lib3mf_composematrixnode_getinputm22(inst.wrapperRef.LibraryHandle, inst.Ref, &m22)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(m22), nil
}

// GetInputM23 retrieves the input for the element 2 3.
func (inst ComposeMatrixNode) GetInputM23() (ImplicitPort, error) {
	var m23 ref
	ret := C.CCall_lib3mf_composematrixnode_getinputm23(inst.wrapperRef.LibraryHandle, inst.Ref, &m23)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(m23), nil
}

// GetInputM30 retrieves the input for the element 3 0.
func (inst ComposeMatrixNode) GetInputM30() (ImplicitPort, error) {
	var m30 ref
	ret := C.CCall_lib3mf_composematrixnode_getinputm30(inst.wrapperRef.LibraryHandle, inst.Ref, &m30)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(m30), nil
}

// GetInputM31 retrieves the input for the element 3 1.
func (inst ComposeMatrixNode) GetInputM31() (ImplicitPort, error) {
	var m31 ref
	ret := C.CCall_lib3mf_composematrixnode_getinputm31(inst.wrapperRef.LibraryHandle, inst.Ref, &m31)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(m31), nil
}

// GetInputM32 retrieves the input for the element 3 2.
func (inst ComposeMatrixNode) GetInputM32() (ImplicitPort, error) {
	var m32 ref
	ret := C.CCall_lib3mf_composematrixnode_getinputm32(inst.wrapperRef.LibraryHandle, inst.Ref, &m32)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(m32), nil
}

// GetInputM33 retrieves the input for the element 3 3.
func (inst ComposeMatrixNode) GetInputM33() (ImplicitPort, error) {
	var m33 ref
	ret := C.CCall_lib3mf_composematrixnode_getinputm33(inst.wrapperRef.LibraryHandle, inst.Ref, &m33)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(m33), nil
}

// GetOutputResult retrieves the output.
func (inst ComposeMatrixNode) GetOutputResult() (ImplicitPort, error) {
	var result ref
	ret := C.CCall_lib3mf_composematrixnode_getoutputresult(inst.wrapperRef.LibraryHandle, inst.Ref, &result)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(result), nil
}


// MatrixFromRowsNode represents a Lib3MF class.
type MatrixFromRowsNode struct {
	ImplicitNode
}

func (wrapper Wrapper) NewMatrixFromRowsNode(r ref) MatrixFromRowsNode {
	return MatrixFromRowsNode{wrapper.NewImplicitNode(r)}
}

// GetInputA retrieves the input for the first row.
func (inst MatrixFromRowsNode) GetInputA() (ImplicitPort, error) {
	var row0 ref
	ret := C.CCall_lib3mf_matrixfromrowsnode_getinputa(inst.wrapperRef.LibraryHandle, inst.Ref, &row0)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(row0), nil
}

// GetInputB retrieves the input for the second row.
func (inst MatrixFromRowsNode) GetInputB() (ImplicitPort, error) {
	var row1 ref
	ret := C.CCall_lib3mf_matrixfromrowsnode_getinputb(inst.wrapperRef.LibraryHandle, inst.Ref, &row1)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(row1), nil
}

// GetInputC retrieves the input for the third row.
func (inst MatrixFromRowsNode) GetInputC() (ImplicitPort, error) {
	var row2 ref
	ret := C.CCall_lib3mf_matrixfromrowsnode_getinputc(inst.wrapperRef.LibraryHandle, inst.Ref, &row2)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(row2), nil
}

// GetInputD retrieves the input for the fourth row.
func (inst MatrixFromRowsNode) GetInputD() (ImplicitPort, error) {
	var row3 ref
	ret := C.CCall_lib3mf_matrixfromrowsnode_getinputd(inst.wrapperRef.LibraryHandle, inst.Ref, &row3)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(row3), nil
}

// GetOutputResult retrieves the output.
func (inst MatrixFromRowsNode) GetOutputResult() (ImplicitPort, error) {
	var result ref
	ret := C.CCall_lib3mf_matrixfromrowsnode_getoutputresult(inst.wrapperRef.LibraryHandle, inst.Ref, &result)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(result), nil
}


// MatrixFromColumnsNode represents a Lib3MF class.
type MatrixFromColumnsNode struct {
	ImplicitNode
}

func (wrapper Wrapper) NewMatrixFromColumnsNode(r ref) MatrixFromColumnsNode {
	return MatrixFromColumnsNode{wrapper.NewImplicitNode(r)}
}

// GetInputA retrieves the input for the first column.
func (inst MatrixFromColumnsNode) GetInputA() (ImplicitPort, error) {
	var column0 ref
	ret := C.CCall_lib3mf_matrixfromcolumnsnode_getinputa(inst.wrapperRef.LibraryHandle, inst.Ref, &column0)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(column0), nil
}

// GetInputB retrieves the input for the second column.
func (inst MatrixFromColumnsNode) GetInputB() (ImplicitPort, error) {
	var column1 ref
	ret := C.CCall_lib3mf_matrixfromcolumnsnode_getinputb(inst.wrapperRef.LibraryHandle, inst.Ref, &column1)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(column1), nil
}

// GetInputC retrieves the input for the third column.
func (inst MatrixFromColumnsNode) GetInputC() (ImplicitPort, error) {
	var column2 ref
	ret := C.CCall_lib3mf_matrixfromcolumnsnode_getinputc(inst.wrapperRef.LibraryHandle, inst.Ref, &column2)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(column2), nil
}

// GetInputD retrieves the input for the fourth column.
func (inst MatrixFromColumnsNode) GetInputD() (ImplicitPort, error) {
	var column3 ref
	ret := C.CCall_lib3mf_matrixfromcolumnsnode_getinputd(inst.wrapperRef.LibraryHandle, inst.Ref, &column3)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(column3), nil
}

// GetOutputResult retrieves the output.
func (inst MatrixFromColumnsNode) GetOutputResult() (ImplicitPort, error) {
	var result ref
	ret := C.CCall_lib3mf_matrixfromcolumnsnode_getoutputresult(inst.wrapperRef.LibraryHandle, inst.Ref, &result)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(result), nil
}


// ConstantNode represents a Lib3MF class.
type ConstantNode struct {
	ImplicitNode
}

func (wrapper Wrapper) NewConstantNode(r ref) ConstantNode {
	return ConstantNode{wrapper.NewImplicitNode(r)}
}

// SetConstant sets the constant value of the node.
func (inst ConstantNode) SetConstant(value float64) error {
	ret := C.CCall_lib3mf_constantnode_setconstant(inst.wrapperRef.LibraryHandle, inst.Ref, C.double(value))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetConstant retrieves the constant value of the node.
func (inst ConstantNode) GetConstant() (float64, error) {
	var value C.double
	ret := C.CCall_lib3mf_constantnode_getconstant(inst.wrapperRef.LibraryHandle, inst.Ref, &value)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return float64(value), nil
}

// GetOutputValue retrieves the output.
func (inst ConstantNode) GetOutputValue() (ImplicitPort, error) {
	var value ref
	ret := C.CCall_lib3mf_constantnode_getoutputvalue(inst.wrapperRef.LibraryHandle, inst.Ref, &value)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(value), nil
}


// ConstVecNode represents a Lib3MF class.
type ConstVecNode struct {
	ImplicitNode
}

func (wrapper Wrapper) NewConstVecNode(r ref) ConstVecNode {
	return ConstVecNode{wrapper.NewImplicitNode(r)}
}

// SetVector sets the vector value of the node.
func (inst ConstVecNode) SetVector(value Vector) error {
	ret := C.CCall_lib3mf_constvecnode_setvector(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.sLib3MFVector)(unsafe.Pointer(&value)))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetVector retrieves the vector value of the node.
func (inst ConstVecNode) GetVector() (Vector, error) {
	var value C.sLib3MFVector
	ret := C.CCall_lib3mf_constvecnode_getvector(inst.wrapperRef.LibraryHandle, inst.Ref, &value)
	if ret != 0 {
		return Vector{}, makeError(uint32(ret))
	}
	return *(*Vector)(unsafe.Pointer(&value)), nil
}

// GetOutputVector retrieves the output.
func (inst ConstVecNode) GetOutputVector() (ImplicitPort, error) {
	var vector ref
	ret := C.CCall_lib3mf_constvecnode_getoutputvector(inst.wrapperRef.LibraryHandle, inst.Ref, &vector)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(vector), nil
}


// ConstMatNode represents a Lib3MF class.
type ConstMatNode struct {
	ImplicitNode
}

func (wrapper Wrapper) NewConstMatNode(r ref) ConstMatNode {
	return ConstMatNode{wrapper.NewImplicitNode(r)}
}

// SetMatrix sets the matrix value of the node.
func (inst ConstMatNode) SetMatrix(value Matrix4x4) error {
	ret := C.CCall_lib3mf_constmatnode_setmatrix(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.sLib3MFMatrix4x4)(unsafe.Pointer(&value)))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetMatrix retrieves the matrix value of the node.
func (inst ConstMatNode) GetMatrix() (Matrix4x4, error) {
	var value C.sLib3MFMatrix4x4
	ret := C.CCall_lib3mf_constmatnode_getmatrix(inst.wrapperRef.LibraryHandle, inst.Ref, &value)
	if ret != 0 {
		return Matrix4x4{}, makeError(uint32(ret))
	}
	return *(*Matrix4x4)(unsafe.Pointer(&value)), nil
}

// GetOutputMatrix retrieves the output.
func (inst ConstMatNode) GetOutputMatrix() (ImplicitPort, error) {
	var matrix ref
	ret := C.CCall_lib3mf_constmatnode_getoutputmatrix(inst.wrapperRef.LibraryHandle, inst.Ref, &matrix)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(matrix), nil
}


// MeshNode represents a Lib3MF class.
type MeshNode struct {
	ImplicitNode
}

func (wrapper Wrapper) NewMeshNode(r ref) MeshNode {
	return MeshNode{wrapper.NewImplicitNode(r)}
}

// GetInputMesh retrieves the input for the model resource id of the mesh.
func (inst MeshNode) GetInputMesh() (ImplicitPort, error) {
	var mesh ref
	ret := C.CCall_lib3mf_meshnode_getinputmesh(inst.wrapperRef.LibraryHandle, inst.Ref, &mesh)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(mesh), nil
}

// GetInputPos retrieves the input for the position.
func (inst MeshNode) GetInputPos() (ImplicitPort, error) {
	var pos ref
	ret := C.CCall_lib3mf_meshnode_getinputpos(inst.wrapperRef.LibraryHandle, inst.Ref, &pos)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(pos), nil
}

// GetOutputDistance retrieves the output.
func (inst MeshNode) GetOutputDistance() (ImplicitPort, error) {
	var distance ref
	ret := C.CCall_lib3mf_meshnode_getoutputdistance(inst.wrapperRef.LibraryHandle, inst.Ref, &distance)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(distance), nil
}


// UnsignedMeshNode represents a Lib3MF class.
type UnsignedMeshNode struct {
	ImplicitNode
}

func (wrapper Wrapper) NewUnsignedMeshNode(r ref) UnsignedMeshNode {
	return UnsignedMeshNode{wrapper.NewImplicitNode(r)}
}

// GetInputMesh retrieves the input for the model resource id of the mesh.
func (inst UnsignedMeshNode) GetInputMesh() (ImplicitPort, error) {
	var mesh ref
	ret := C.CCall_lib3mf_unsignedmeshnode_getinputmesh(inst.wrapperRef.LibraryHandle, inst.Ref, &mesh)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(mesh), nil
}

// GetInputPos retrieves the input for the position.
func (inst UnsignedMeshNode) GetInputPos() (ImplicitPort, error) {
	var pos ref
	ret := C.CCall_lib3mf_unsignedmeshnode_getinputpos(inst.wrapperRef.LibraryHandle, inst.Ref, &pos)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(pos), nil
}

// GetOutputDistance retrieves the output.
func (inst UnsignedMeshNode) GetOutputDistance() (ImplicitPort, error) {
	var distance ref
	ret := C.CCall_lib3mf_unsignedmeshnode_getoutputdistance(inst.wrapperRef.LibraryHandle, inst.Ref, &distance)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(distance), nil
}


// FunctionCallNode represents a Lib3MF class.
type FunctionCallNode struct {
	ImplicitNode
}

func (wrapper Wrapper) NewFunctionCallNode(r ref) FunctionCallNode {
	return FunctionCallNode{wrapper.NewImplicitNode(r)}
}

// GetInputFunctionID retrieves the input for the function id.
func (inst FunctionCallNode) GetInputFunctionID() (ImplicitPort, error) {
	var function ref
	ret := C.CCall_lib3mf_functioncallnode_getinputfunctionid(inst.wrapperRef.LibraryHandle, inst.Ref, &function)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(function), nil
}


// NodeIterator represents a Lib3MF class.
type NodeIterator struct {
	Iterator
}

func (wrapper Wrapper) NewNodeIterator(r ref) NodeIterator {
	return NodeIterator{wrapper.NewIterator(r)}
}

// GetCurrent returns the current element.
func (inst NodeIterator) GetCurrent() (ImplicitNode, error) {
	var node ref
	ret := C.CCall_lib3mf_nodeiterator_getcurrent(inst.wrapperRef.LibraryHandle, inst.Ref, &node)
	if ret != 0 {
		return ImplicitNode{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitNode(node), nil
}


// Function represents a Lib3MF class.
type Function struct {
	Resource
}

func (wrapper Wrapper) NewFunction(r ref) Function {
	return Function{wrapper.NewResource(r)}
}

// GetDisplayName retrieves the display name of the function.
func (inst Function) GetDisplayName() (string, error) {
	var neededfordisplayName C.uint32_t
	var filledindisplayName C.uint32_t
	ret := C.CCall_lib3mf_function_getdisplayname(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededfordisplayName, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSizedisplayName := neededfordisplayName
	bufferdisplayName := make([]byte, bufferSizedisplayName)
	ret = C.CCall_lib3mf_function_getdisplayname(inst.wrapperRef.LibraryHandle, inst.Ref, bufferSizedisplayName, &filledindisplayName, (*C.char)(unsafe.Pointer(&bufferdisplayName[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(bufferdisplayName[:(filledindisplayName-1)]), nil
}

// SetDisplayName sets the display name of the function.
func (inst Function) SetDisplayName(displayName string) error {
	ret := C.CCall_lib3mf_function_setdisplayname(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(displayName)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// AddInput add an input.
func (inst Function) AddInput(identifier string, displayName string, _type ImplicitPortType) (ImplicitPort, error) {
	var port ref
	ret := C.CCall_lib3mf_function_addinput(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), (*C.char)(unsafe.Pointer(&[]byte(displayName)[0])), C.eLib3MFImplicitPortType(_type), &port)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(port), nil
}

// GetInputs retrieves the inputs.
func (inst Function) GetInputs() (ImplicitPortIterator, error) {
	var iterator ref
	ret := C.CCall_lib3mf_function_getinputs(inst.wrapperRef.LibraryHandle, inst.Ref, &iterator)
	if ret != 0 {
		return ImplicitPortIterator{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPortIterator(iterator), nil
}

// RemoveInput removes an input.
func (inst Function) RemoveInput(input ImplicitPort) error {
	ret := C.CCall_lib3mf_function_removeinput(inst.wrapperRef.LibraryHandle, inst.Ref, input.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// AddOutput add an output.
func (inst Function) AddOutput(identifier string, displayName string, _type ImplicitPortType) (ImplicitPort, error) {
	var port ref
	ret := C.CCall_lib3mf_function_addoutput(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), (*C.char)(unsafe.Pointer(&[]byte(displayName)[0])), C.eLib3MFImplicitPortType(_type), &port)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(port), nil
}

// GetOutputs retrieves the outputs.
func (inst Function) GetOutputs() (ImplicitPortIterator, error) {
	var iterator ref
	ret := C.CCall_lib3mf_function_getoutputs(inst.wrapperRef.LibraryHandle, inst.Ref, &iterator)
	if ret != 0 {
		return ImplicitPortIterator{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPortIterator(iterator), nil
}

// RemoveOutput removes an output.
func (inst Function) RemoveOutput(output ImplicitPort) error {
	ret := C.CCall_lib3mf_function_removeoutput(inst.wrapperRef.LibraryHandle, inst.Ref, output.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// FindInput retrieves an input.
func (inst Function) FindInput(identifier string) (ImplicitPort, error) {
	var input ref
	ret := C.CCall_lib3mf_function_findinput(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), &input)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(input), nil
}

// FindOutput retrieves an output.
func (inst Function) FindOutput(identifier string) (ImplicitPort, error) {
	var output ref
	ret := C.CCall_lib3mf_function_findoutput(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), &output)
	if ret != 0 {
		return ImplicitPort{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitPort(output), nil
}


// ImplicitFunction represents a Lib3MF class.
type ImplicitFunction struct {
	Function
}

func (wrapper Wrapper) NewImplicitFunction(r ref) ImplicitFunction {
	return ImplicitFunction{wrapper.NewFunction(r)}
}

// GetIdentifier retrieves the identifier of the function.
func (inst ImplicitFunction) GetIdentifier() (string, error) {
	var neededforidentifier C.uint32_t
	var filledinidentifier C.uint32_t
	ret := C.CCall_lib3mf_implicitfunction_getidentifier(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforidentifier, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSizeidentifier := neededforidentifier
	bufferidentifier := make([]byte, bufferSizeidentifier)
	ret = C.CCall_lib3mf_implicitfunction_getidentifier(inst.wrapperRef.LibraryHandle, inst.Ref, bufferSizeidentifier, &filledinidentifier, (*C.char)(unsafe.Pointer(&bufferidentifier[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(bufferidentifier[:(filledinidentifier-1)]), nil
}

// SetIdentifier sets the identifier of the function.
func (inst ImplicitFunction) SetIdentifier(identifier string) error {
	ret := C.CCall_lib3mf_implicitfunction_setidentifier(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// AddNode add a node.
func (inst ImplicitFunction) AddNode(nodeType ImplicitNodeType, identifier string, configuration ImplicitNodeConfiguration, displayName string, tag string) (ImplicitNode, error) {
	var node ref
	ret := C.CCall_lib3mf_implicitfunction_addnode(inst.wrapperRef.LibraryHandle, inst.Ref, C.eLib3MFImplicitNodeType(nodeType), (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), C.eLib3MFImplicitNodeConfiguration(configuration), (*C.char)(unsafe.Pointer(&[]byte(displayName)[0])), (*C.char)(unsafe.Pointer(&[]byte(tag)[0])), &node)
	if ret != 0 {
		return ImplicitNode{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitNode(node), nil
}

// AddSinNode add a SinNode.
func (inst ImplicitFunction) AddSinNode(identifier string, configuration ImplicitNodeConfiguration, displayName string, tag string) (SinNode, error) {
	var node ref
	ret := C.CCall_lib3mf_implicitfunction_addsinnode(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), C.eLib3MFImplicitNodeConfiguration(configuration), (*C.char)(unsafe.Pointer(&[]byte(displayName)[0])), (*C.char)(unsafe.Pointer(&[]byte(tag)[0])), &node)
	if ret != 0 {
		return SinNode{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewSinNode(node), nil
}

// AddCosNode add a CosNode.
func (inst ImplicitFunction) AddCosNode(identifier string, configuration ImplicitNodeConfiguration, displayName string, tag string) (CosNode, error) {
	var node ref
	ret := C.CCall_lib3mf_implicitfunction_addcosnode(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), C.eLib3MFImplicitNodeConfiguration(configuration), (*C.char)(unsafe.Pointer(&[]byte(displayName)[0])), (*C.char)(unsafe.Pointer(&[]byte(tag)[0])), &node)
	if ret != 0 {
		return CosNode{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewCosNode(node), nil
}

// AddTanNode add a TanNode.
func (inst ImplicitFunction) AddTanNode(identifier string, configuration ImplicitNodeConfiguration, displayName string, tag string) (TanNode, error) {
	var node ref
	ret := C.CCall_lib3mf_implicitfunction_addtannode(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), C.eLib3MFImplicitNodeConfiguration(configuration), (*C.char)(unsafe.Pointer(&[]byte(displayName)[0])), (*C.char)(unsafe.Pointer(&[]byte(tag)[0])), &node)
	if ret != 0 {
		return TanNode{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewTanNode(node), nil
}

// AddArcSinNode add a ArcSinNode.
func (inst ImplicitFunction) AddArcSinNode(identifier string, configuration ImplicitNodeConfiguration, displayName string, tag string) (ArcSinNode, error) {
	var node ref
	ret := C.CCall_lib3mf_implicitfunction_addarcsinnode(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), C.eLib3MFImplicitNodeConfiguration(configuration), (*C.char)(unsafe.Pointer(&[]byte(displayName)[0])), (*C.char)(unsafe.Pointer(&[]byte(tag)[0])), &node)
	if ret != 0 {
		return ArcSinNode{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewArcSinNode(node), nil
}

// AddArcCosNode add a ArcCosNode.
func (inst ImplicitFunction) AddArcCosNode(identifier string, configuration ImplicitNodeConfiguration, displayName string, tag string) (ArcCosNode, error) {
	var node ref
	ret := C.CCall_lib3mf_implicitfunction_addarccosnode(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), C.eLib3MFImplicitNodeConfiguration(configuration), (*C.char)(unsafe.Pointer(&[]byte(displayName)[0])), (*C.char)(unsafe.Pointer(&[]byte(tag)[0])), &node)
	if ret != 0 {
		return ArcCosNode{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewArcCosNode(node), nil
}

// AddArcTan2Node add a ArcTan2Node.
func (inst ImplicitFunction) AddArcTan2Node(identifier string, configuration ImplicitNodeConfiguration, displayName string, tag string) (ArcTan2Node, error) {
	var node ref
	ret := C.CCall_lib3mf_implicitfunction_addarctan2node(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), C.eLib3MFImplicitNodeConfiguration(configuration), (*C.char)(unsafe.Pointer(&[]byte(displayName)[0])), (*C.char)(unsafe.Pointer(&[]byte(tag)[0])), &node)
	if ret != 0 {
		return ArcTan2Node{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewArcTan2Node(node), nil
}

// AddSinhNode add a SinhNode.
func (inst ImplicitFunction) AddSinhNode(identifier string, configuration ImplicitNodeConfiguration, displayName string, tag string) (SinhNode, error) {
	var node ref
	ret := C.CCall_lib3mf_implicitfunction_addsinhnode(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), C.eLib3MFImplicitNodeConfiguration(configuration), (*C.char)(unsafe.Pointer(&[]byte(displayName)[0])), (*C.char)(unsafe.Pointer(&[]byte(tag)[0])), &node)
	if ret != 0 {
		return SinhNode{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewSinhNode(node), nil
}

// AddCoshNode add a CoshNode.
func (inst ImplicitFunction) AddCoshNode(identifier string, configuration ImplicitNodeConfiguration, displayName string, tag string) (CoshNode, error) {
	var node ref
	ret := C.CCall_lib3mf_implicitfunction_addcoshnode(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), C.eLib3MFImplicitNodeConfiguration(configuration), (*C.char)(unsafe.Pointer(&[]byte(displayName)[0])), (*C.char)(unsafe.Pointer(&[]byte(tag)[0])), &node)
	if ret != 0 {
		return CoshNode{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewCoshNode(node), nil
}

// AddTanhNode add a TanhNode.
func (inst ImplicitFunction) AddTanhNode(identifier string, configuration ImplicitNodeConfiguration, displayName string, tag string) (TanhNode, error) {
	var node ref
	ret := C.CCall_lib3mf_implicitfunction_addtanhnode(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), C.eLib3MFImplicitNodeConfiguration(configuration), (*C.char)(unsafe.Pointer(&[]byte(displayName)[0])), (*C.char)(unsafe.Pointer(&[]byte(tag)[0])), &node)
	if ret != 0 {
		return TanhNode{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewTanhNode(node), nil
}

// AddRoundNode add a RoundNode.
func (inst ImplicitFunction) AddRoundNode(identifier string, configuration ImplicitNodeConfiguration, displayName string, tag string) (RoundNode, error) {
	var node ref
	ret := C.CCall_lib3mf_implicitfunction_addroundnode(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), C.eLib3MFImplicitNodeConfiguration(configuration), (*C.char)(unsafe.Pointer(&[]byte(displayName)[0])), (*C.char)(unsafe.Pointer(&[]byte(tag)[0])), &node)
	if ret != 0 {
		return RoundNode{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewRoundNode(node), nil
}

// AddCeilNode add a CeilNode.
func (inst ImplicitFunction) AddCeilNode(identifier string, configuration ImplicitNodeConfiguration, displayName string, tag string) (CeilNode, error) {
	var node ref
	ret := C.CCall_lib3mf_implicitfunction_addceilnode(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), C.eLib3MFImplicitNodeConfiguration(configuration), (*C.char)(unsafe.Pointer(&[]byte(displayName)[0])), (*C.char)(unsafe.Pointer(&[]byte(tag)[0])), &node)
	if ret != 0 {
		return CeilNode{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewCeilNode(node), nil
}

// AddFloorNode add a FloorNode.
func (inst ImplicitFunction) AddFloorNode(identifier string, configuration ImplicitNodeConfiguration, displayName string, tag string) (FloorNode, error) {
	var node ref
	ret := C.CCall_lib3mf_implicitfunction_addfloornode(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), C.eLib3MFImplicitNodeConfiguration(configuration), (*C.char)(unsafe.Pointer(&[]byte(displayName)[0])), (*C.char)(unsafe.Pointer(&[]byte(tag)[0])), &node)
	if ret != 0 {
		return FloorNode{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewFloorNode(node), nil
}

// AddSignNode add a SignNode.
func (inst ImplicitFunction) AddSignNode(identifier string, configuration ImplicitNodeConfiguration, displayName string, tag string) (SignNode, error) {
	var node ref
	ret := C.CCall_lib3mf_implicitfunction_addsignnode(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), C.eLib3MFImplicitNodeConfiguration(configuration), (*C.char)(unsafe.Pointer(&[]byte(displayName)[0])), (*C.char)(unsafe.Pointer(&[]byte(tag)[0])), &node)
	if ret != 0 {
		return SignNode{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewSignNode(node), nil
}

// AddFractNode add a FractNode.
func (inst ImplicitFunction) AddFractNode(identifier string, configuration ImplicitNodeConfiguration, displayName string, tag string) (FractNode, error) {
	var node ref
	ret := C.CCall_lib3mf_implicitfunction_addfractnode(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), C.eLib3MFImplicitNodeConfiguration(configuration), (*C.char)(unsafe.Pointer(&[]byte(displayName)[0])), (*C.char)(unsafe.Pointer(&[]byte(tag)[0])), &node)
	if ret != 0 {
		return FractNode{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewFractNode(node), nil
}

// AddAbsNode add a AbsNode.
func (inst ImplicitFunction) AddAbsNode(identifier string, configuration ImplicitNodeConfiguration, displayName string, tag string) (AbsNode, error) {
	var node ref
	ret := C.CCall_lib3mf_implicitfunction_addabsnode(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), C.eLib3MFImplicitNodeConfiguration(configuration), (*C.char)(unsafe.Pointer(&[]byte(displayName)[0])), (*C.char)(unsafe.Pointer(&[]byte(tag)[0])), &node)
	if ret != 0 {
		return AbsNode{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewAbsNode(node), nil
}

// AddExpNode add a ExpNode.
func (inst ImplicitFunction) AddExpNode(identifier string, configuration ImplicitNodeConfiguration, displayName string, tag string) (ExpNode, error) {
	var node ref
	ret := C.CCall_lib3mf_implicitfunction_addexpnode(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), C.eLib3MFImplicitNodeConfiguration(configuration), (*C.char)(unsafe.Pointer(&[]byte(displayName)[0])), (*C.char)(unsafe.Pointer(&[]byte(tag)[0])), &node)
	if ret != 0 {
		return ExpNode{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewExpNode(node), nil
}

// AddLogNode add a LogNode.
func (inst ImplicitFunction) AddLogNode(identifier string, configuration ImplicitNodeConfiguration, displayName string, tag string) (LogNode, error) {
	var node ref
	ret := C.CCall_lib3mf_implicitfunction_addlognode(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), C.eLib3MFImplicitNodeConfiguration(configuration), (*C.char)(unsafe.Pointer(&[]byte(displayName)[0])), (*C.char)(unsafe.Pointer(&[]byte(tag)[0])), &node)
	if ret != 0 {
		return LogNode{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewLogNode(node), nil
}

// AddLog2Node add a Log2Node.
func (inst ImplicitFunction) AddLog2Node(identifier string, configuration ImplicitNodeConfiguration, displayName string, tag string) (Log2Node, error) {
	var node ref
	ret := C.CCall_lib3mf_implicitfunction_addlog2node(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), C.eLib3MFImplicitNodeConfiguration(configuration), (*C.char)(unsafe.Pointer(&[]byte(displayName)[0])), (*C.char)(unsafe.Pointer(&[]byte(tag)[0])), &node)
	if ret != 0 {
		return Log2Node{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewLog2Node(node), nil
}

// AddLog10Node add a Log10Node.
func (inst ImplicitFunction) AddLog10Node(identifier string, configuration ImplicitNodeConfiguration, displayName string, tag string) (Log10Node, error) {
	var node ref
	ret := C.CCall_lib3mf_implicitfunction_addlog10node(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), C.eLib3MFImplicitNodeConfiguration(configuration), (*C.char)(unsafe.Pointer(&[]byte(displayName)[0])), (*C.char)(unsafe.Pointer(&[]byte(tag)[0])), &node)
	if ret != 0 {
		return Log10Node{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewLog10Node(node), nil
}

// AddLengthNode add a LengthNode.
func (inst ImplicitFunction) AddLengthNode(identifier string, displayName string, tag string) (LengthNode, error) {
	var node ref
	ret := C.CCall_lib3mf_implicitfunction_addlengthnode(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), (*C.char)(unsafe.Pointer(&[]byte(displayName)[0])), (*C.char)(unsafe.Pointer(&[]byte(tag)[0])), &node)
	if ret != 0 {
		return LengthNode{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewLengthNode(node), nil
}

// AddTransposeNode add a TransposeNode.
func (inst ImplicitFunction) AddTransposeNode(identifier string, configuration ImplicitNodeConfiguration, displayName string, tag string) (TransposeNode, error) {
	var node ref
	ret := C.CCall_lib3mf_implicitfunction_addtransposenode(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), C.eLib3MFImplicitNodeConfiguration(configuration), (*C.char)(unsafe.Pointer(&[]byte(displayName)[0])), (*C.char)(unsafe.Pointer(&[]byte(tag)[0])), &node)
	if ret != 0 {
		return TransposeNode{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewTransposeNode(node), nil
}

// AddInverseNode add a InverseNode.
func (inst ImplicitFunction) AddInverseNode(identifier string, displayName string, tag string) (InverseNode, error) {
	var node ref
	ret := C.CCall_lib3mf_implicitfunction_addinversenode(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), (*C.char)(unsafe.Pointer(&[]byte(displayName)[0])), (*C.char)(unsafe.Pointer(&[]byte(tag)[0])), &node)
	if ret != 0 {
		return InverseNode{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewInverseNode(node), nil
}

// AddSqrtNode add a SqrtNode.
func (inst ImplicitFunction) AddSqrtNode(identifier string, configuration ImplicitNodeConfiguration, displayName string, tag string) (SqrtNode, error) {
	var node ref
	ret := C.CCall_lib3mf_implicitfunction_addsqrtnode(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), C.eLib3MFImplicitNodeConfiguration(configuration), (*C.char)(unsafe.Pointer(&[]byte(displayName)[0])), (*C.char)(unsafe.Pointer(&[]byte(tag)[0])), &node)
	if ret != 0 {
		return SqrtNode{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewSqrtNode(node), nil
}

// AddResourceIdNode add a ResourceIdNode.
func (inst ImplicitFunction) AddResourceIdNode(identifier string, displayName string, tag string) (ResourceIdNode, error) {
	var node ref
	ret := C.CCall_lib3mf_implicitfunction_addresourceidnode(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), (*C.char)(unsafe.Pointer(&[]byte(displayName)[0])), (*C.char)(unsafe.Pointer(&[]byte(tag)[0])), &node)
	if ret != 0 {
		return ResourceIdNode{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewResourceIdNode(node), nil
}

// AddAdditionNode add an AdditionNode.
func (inst ImplicitFunction) AddAdditionNode(identifier string, configuration ImplicitNodeConfiguration, displayName string, tag string) (AdditionNode, error) {
	var node ref
	ret := C.CCall_lib3mf_implicitfunction_addadditionnode(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), C.eLib3MFImplicitNodeConfiguration(configuration), (*C.char)(unsafe.Pointer(&[]byte(displayName)[0])), (*C.char)(unsafe.Pointer(&[]byte(tag)[0])), &node)
	if ret != 0 {
		return AdditionNode{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewAdditionNode(node), nil
}

// AddSubtractionNode add a SubtractionNode.
func (inst ImplicitFunction) AddSubtractionNode(identifier string, configuration ImplicitNodeConfiguration, displayName string, tag string) (SubtractionNode, error) {
	var node ref
	ret := C.CCall_lib3mf_implicitfunction_addsubtractionnode(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), C.eLib3MFImplicitNodeConfiguration(configuration), (*C.char)(unsafe.Pointer(&[]byte(displayName)[0])), (*C.char)(unsafe.Pointer(&[]byte(tag)[0])), &node)
	if ret != 0 {
		return SubtractionNode{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewSubtractionNode(node), nil
}

// AddMultiplicationNode add a MultiplicationNode.
func (inst ImplicitFunction) AddMultiplicationNode(identifier string, configuration ImplicitNodeConfiguration, displayName string, tag string) (MultiplicationNode, error) {
	var node ref
	ret := C.CCall_lib3mf_implicitfunction_addmultiplicationnode(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), C.eLib3MFImplicitNodeConfiguration(configuration), (*C.char)(unsafe.Pointer(&[]byte(displayName)[0])), (*C.char)(unsafe.Pointer(&[]byte(tag)[0])), &node)
	if ret != 0 {
		return MultiplicationNode{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewMultiplicationNode(node), nil
}

// AddDivisionNode add a DivisionNode.
func (inst ImplicitFunction) AddDivisionNode(identifier string, configuration ImplicitNodeConfiguration, displayName string, tag string) (DivisionNode, error) {
	var node ref
	ret := C.CCall_lib3mf_implicitfunction_adddivisionnode(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), C.eLib3MFImplicitNodeConfiguration(configuration), (*C.char)(unsafe.Pointer(&[]byte(displayName)[0])), (*C.char)(unsafe.Pointer(&[]byte(tag)[0])), &node)
	if ret != 0 {
		return DivisionNode{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewDivisionNode(node), nil
}

// AddDotNode add a DotNode.
func (inst ImplicitFunction) AddDotNode(identifier string, displayName string, tag string) (DotNode, error) {
	var node ref
	ret := C.CCall_lib3mf_implicitfunction_adddotnode(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), (*C.char)(unsafe.Pointer(&[]byte(displayName)[0])), (*C.char)(unsafe.Pointer(&[]byte(tag)[0])), &node)
	if ret != 0 {
		return DotNode{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewDotNode(node), nil
}

// AddCrossNode add a CrossNode.
func (inst ImplicitFunction) AddCrossNode(identifier string, displayName string, tag string) (CrossNode, error) {
	var node ref
	ret := C.CCall_lib3mf_implicitfunction_addcrossnode(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), (*C.char)(unsafe.Pointer(&[]byte(displayName)[0])), (*C.char)(unsafe.Pointer(&[]byte(tag)[0])), &node)
	if ret != 0 {
		return CrossNode{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewCrossNode(node), nil
}

// AddMatVecMultiplicationNode add a MatVecMultiplicationNode.
func (inst ImplicitFunction) AddMatVecMultiplicationNode(identifier string, displayName string, tag string) (MatVecMultiplicationNode, error) {
	var node ref
	ret := C.CCall_lib3mf_implicitfunction_addmatvecmultiplicationnode(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), (*C.char)(unsafe.Pointer(&[]byte(displayName)[0])), (*C.char)(unsafe.Pointer(&[]byte(tag)[0])), &node)
	if ret != 0 {
		return MatVecMultiplicationNode{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewMatVecMultiplicationNode(node), nil
}

// AddMinNode add a MinNode.
func (inst ImplicitFunction) AddMinNode(identifier string, configuration ImplicitNodeConfiguration, displayName string, tag string) (MinNode, error) {
	var node ref
	ret := C.CCall_lib3mf_implicitfunction_addminnode(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), C.eLib3MFImplicitNodeConfiguration(configuration), (*C.char)(unsafe.Pointer(&[]byte(displayName)[0])), (*C.char)(unsafe.Pointer(&[]byte(tag)[0])), &node)
	if ret != 0 {
		return MinNode{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewMinNode(node), nil
}

// AddMaxNode add a MaxNode.
func (inst ImplicitFunction) AddMaxNode(identifier string, configuration ImplicitNodeConfiguration, displayName string, tag string) (MaxNode, error) {
	var node ref
	ret := C.CCall_lib3mf_implicitfunction_addmaxnode(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), C.eLib3MFImplicitNodeConfiguration(configuration), (*C.char)(unsafe.Pointer(&[]byte(displayName)[0])), (*C.char)(unsafe.Pointer(&[]byte(tag)[0])), &node)
	if ret != 0 {
		return MaxNode{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewMaxNode(node), nil
}

// AddFmodNode add a FmodNode.
func (inst ImplicitFunction) AddFmodNode(identifier string, configuration ImplicitNodeConfiguration, displayName string, tag string) (FmodNode, error) {
	var node ref
	ret := C.CCall_lib3mf_implicitfunction_addfmodnode(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), C.eLib3MFImplicitNodeConfiguration(configuration), (*C.char)(unsafe.Pointer(&[]byte(displayName)[0])), (*C.char)(unsafe.Pointer(&[]byte(tag)[0])), &node)
	if ret != 0 {
		return FmodNode{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewFmodNode(node), nil
}

// AddPowNode add a PowNode.
func (inst ImplicitFunction) AddPowNode(identifier string, configuration ImplicitNodeConfiguration, displayName string, tag string) (PowNode, error) {
	var node ref
	ret := C.CCall_lib3mf_implicitfunction_addpownode(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), C.eLib3MFImplicitNodeConfiguration(configuration), (*C.char)(unsafe.Pointer(&[]byte(displayName)[0])), (*C.char)(unsafe.Pointer(&[]byte(tag)[0])), &node)
	if ret != 0 {
		return PowNode{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewPowNode(node), nil
}

// AddSelectNode add a SelectNode.
func (inst ImplicitFunction) AddSelectNode(identifier string, configuration ImplicitNodeConfiguration, displayName string, tag string) (SelectNode, error) {
	var node ref
	ret := C.CCall_lib3mf_implicitfunction_addselectnode(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), C.eLib3MFImplicitNodeConfiguration(configuration), (*C.char)(unsafe.Pointer(&[]byte(displayName)[0])), (*C.char)(unsafe.Pointer(&[]byte(tag)[0])), &node)
	if ret != 0 {
		return SelectNode{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewSelectNode(node), nil
}

// AddClampNode add a ClampNode.
func (inst ImplicitFunction) AddClampNode(identifier string, configuration ImplicitNodeConfiguration, displayName string, tag string) (ClampNode, error) {
	var node ref
	ret := C.CCall_lib3mf_implicitfunction_addclampnode(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), C.eLib3MFImplicitNodeConfiguration(configuration), (*C.char)(unsafe.Pointer(&[]byte(displayName)[0])), (*C.char)(unsafe.Pointer(&[]byte(tag)[0])), &node)
	if ret != 0 {
		return ClampNode{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewClampNode(node), nil
}

// AddComposeVectorNode add a ComposeVectorNode.
func (inst ImplicitFunction) AddComposeVectorNode(identifier string, displayName string, tag string) (ComposeVectorNode, error) {
	var node ref
	ret := C.CCall_lib3mf_implicitfunction_addcomposevectornode(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), (*C.char)(unsafe.Pointer(&[]byte(displayName)[0])), (*C.char)(unsafe.Pointer(&[]byte(tag)[0])), &node)
	if ret != 0 {
		return ComposeVectorNode{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewComposeVectorNode(node), nil
}

// AddVectorFromScalarNode add a VectorFromScalar.
func (inst ImplicitFunction) AddVectorFromScalarNode(identifier string, displayName string, tag string) (VectorFromScalarNode, error) {
	var node ref
	ret := C.CCall_lib3mf_implicitfunction_addvectorfromscalarnode(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), (*C.char)(unsafe.Pointer(&[]byte(displayName)[0])), (*C.char)(unsafe.Pointer(&[]byte(tag)[0])), &node)
	if ret != 0 {
		return VectorFromScalarNode{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewVectorFromScalarNode(node), nil
}

// AddDecomposeVectorNode add a DecomposeVectorNode.
func (inst ImplicitFunction) AddDecomposeVectorNode(identifier string, displayName string, tag string) (DecomposeVectorNode, error) {
	var node ref
	ret := C.CCall_lib3mf_implicitfunction_adddecomposevectornode(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), (*C.char)(unsafe.Pointer(&[]byte(displayName)[0])), (*C.char)(unsafe.Pointer(&[]byte(tag)[0])), &node)
	if ret != 0 {
		return DecomposeVectorNode{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewDecomposeVectorNode(node), nil
}

// AddComposeMatrixNode add a ComposeMatrixNode.
func (inst ImplicitFunction) AddComposeMatrixNode(identifier string, displayName string, tag string) (ComposeMatrixNode, error) {
	var node ref
	ret := C.CCall_lib3mf_implicitfunction_addcomposematrixnode(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), (*C.char)(unsafe.Pointer(&[]byte(displayName)[0])), (*C.char)(unsafe.Pointer(&[]byte(tag)[0])), &node)
	if ret != 0 {
		return ComposeMatrixNode{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewComposeMatrixNode(node), nil
}

// AddMatrixFromRowsNode add a MatrixFromRowsNode.
func (inst ImplicitFunction) AddMatrixFromRowsNode(identifier string, displayName string, tag string) (MatrixFromRowsNode, error) {
	var node ref
	ret := C.CCall_lib3mf_implicitfunction_addmatrixfromrowsnode(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), (*C.char)(unsafe.Pointer(&[]byte(displayName)[0])), (*C.char)(unsafe.Pointer(&[]byte(tag)[0])), &node)
	if ret != 0 {
		return MatrixFromRowsNode{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewMatrixFromRowsNode(node), nil
}

// AddMatrixFromColumnsNode add a MatrixFromColumnsNode.
func (inst ImplicitFunction) AddMatrixFromColumnsNode(identifier string, displayName string, tag string) (MatrixFromColumnsNode, error) {
	var node ref
	ret := C.CCall_lib3mf_implicitfunction_addmatrixfromcolumnsnode(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), (*C.char)(unsafe.Pointer(&[]byte(displayName)[0])), (*C.char)(unsafe.Pointer(&[]byte(tag)[0])), &node)
	if ret != 0 {
		return MatrixFromColumnsNode{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewMatrixFromColumnsNode(node), nil
}

// AddConstantNode add a ConstantNode.
func (inst ImplicitFunction) AddConstantNode(identifier string, displayName string, tag string) (ConstantNode, error) {
	var node ref
	ret := C.CCall_lib3mf_implicitfunction_addconstantnode(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), (*C.char)(unsafe.Pointer(&[]byte(displayName)[0])), (*C.char)(unsafe.Pointer(&[]byte(tag)[0])), &node)
	if ret != 0 {
		return ConstantNode{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewConstantNode(node), nil
}

// AddConstVecNode add a ConstVecNode.
func (inst ImplicitFunction) AddConstVecNode(identifier string, displayName string, tag string) (ConstVecNode, error) {
	var node ref
	ret := C.CCall_lib3mf_implicitfunction_addconstvecnode(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), (*C.char)(unsafe.Pointer(&[]byte(displayName)[0])), (*C.char)(unsafe.Pointer(&[]byte(tag)[0])), &node)
	if ret != 0 {
		return ConstVecNode{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewConstVecNode(node), nil
}

// AddConstMatNode add a ConstMatNode.
func (inst ImplicitFunction) AddConstMatNode(identifier string, displayName string, tag string) (ConstMatNode, error) {
	var node ref
	ret := C.CCall_lib3mf_implicitfunction_addconstmatnode(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), (*C.char)(unsafe.Pointer(&[]byte(displayName)[0])), (*C.char)(unsafe.Pointer(&[]byte(tag)[0])), &node)
	if ret != 0 {
		return ConstMatNode{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewConstMatNode(node), nil
}

// AddMeshNode add a MeshNode.
func (inst ImplicitFunction) AddMeshNode(identifier string, displayName string, tag string) (MeshNode, error) {
	var node ref
	ret := C.CCall_lib3mf_implicitfunction_addmeshnode(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), (*C.char)(unsafe.Pointer(&[]byte(displayName)[0])), (*C.char)(unsafe.Pointer(&[]byte(tag)[0])), &node)
	if ret != 0 {
		return MeshNode{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewMeshNode(node), nil
}

// AddUnsignedMeshNode add a UnsignedMeshNode.
func (inst ImplicitFunction) AddUnsignedMeshNode(identifier string, displayName string, tag string) (UnsignedMeshNode, error) {
	var node ref
	ret := C.CCall_lib3mf_implicitfunction_addunsignedmeshnode(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), (*C.char)(unsafe.Pointer(&[]byte(displayName)[0])), (*C.char)(unsafe.Pointer(&[]byte(tag)[0])), &node)
	if ret != 0 {
		return UnsignedMeshNode{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewUnsignedMeshNode(node), nil
}

// AddFunctionCallNode add a FunctionCallNode.
func (inst ImplicitFunction) AddFunctionCallNode(identifier string, displayName string, tag string) (FunctionCallNode, error) {
	var node ref
	ret := C.CCall_lib3mf_implicitfunction_addfunctioncallnode(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(identifier)[0])), (*C.char)(unsafe.Pointer(&[]byte(displayName)[0])), (*C.char)(unsafe.Pointer(&[]byte(tag)[0])), &node)
	if ret != 0 {
		return FunctionCallNode{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewFunctionCallNode(node), nil
}

// GetNodes retrieves the nodes.
func (inst ImplicitFunction) GetNodes() (NodeIterator, error) {
	var iterator ref
	ret := C.CCall_lib3mf_implicitfunction_getnodes(inst.wrapperRef.LibraryHandle, inst.Ref, &iterator)
	if ret != 0 {
		return NodeIterator{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewNodeIterator(iterator), nil
}

// RemoveNode removes a node.
func (inst ImplicitFunction) RemoveNode(node ImplicitNode) error {
	ret := C.CCall_lib3mf_implicitfunction_removenode(inst.wrapperRef.LibraryHandle, inst.Ref, node.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// AddLink add a link.
func (inst ImplicitFunction) AddLink(source ImplicitPort, target ImplicitPort) error {
	ret := C.CCall_lib3mf_implicitfunction_addlink(inst.wrapperRef.LibraryHandle, inst.Ref, source.Ref, target.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// AddLinkByNames add a link.
func (inst ImplicitFunction) AddLinkByNames(source string, target string) error {
	ret := C.CCall_lib3mf_implicitfunction_addlinkbynames(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(source)[0])), (*C.char)(unsafe.Pointer(&[]byte(target)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// Clear clears the function.
func (inst ImplicitFunction) Clear() error {
	ret := C.CCall_lib3mf_implicitfunction_clear(inst.wrapperRef.LibraryHandle, inst.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// SortNodesTopologically sorts the nodes topologically.
func (inst ImplicitFunction) SortNodesTopologically() error {
	ret := C.CCall_lib3mf_implicitfunction_sortnodestopologically(inst.wrapperRef.LibraryHandle, inst.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}


// FunctionFromImage3D represents a Lib3MF class.
type FunctionFromImage3D struct {
	Function
}

func (wrapper Wrapper) NewFunctionFromImage3D(r ref) FunctionFromImage3D {
	return FunctionFromImage3D{wrapper.NewFunction(r)}
}

// GetImage3D returns the selected 3D image.
func (inst FunctionFromImage3D) GetImage3D() (Image3D, error) {
	var image3D ref
	ret := C.CCall_lib3mf_functionfromimage3d_getimage3d(inst.wrapperRef.LibraryHandle, inst.Ref, &image3D)
	if ret != 0 {
		return Image3D{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImage3D(image3D), nil
}

// SetImage3D sets the 3D image of the selector.
func (inst FunctionFromImage3D) SetImage3D(image3D Image3D) error {
	ret := C.CCall_lib3mf_functionfromimage3d_setimage3d(inst.wrapperRef.LibraryHandle, inst.Ref, image3D.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// SetFilter sets the texture filter of the selector.
func (inst FunctionFromImage3D) SetFilter(filter TextureFilter) error {
	ret := C.CCall_lib3mf_functionfromimage3d_setfilter(inst.wrapperRef.LibraryHandle, inst.Ref, C.eLib3MFTextureFilter(filter))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetFilter returns the texture filter of the selector.
func (inst FunctionFromImage3D) GetFilter() (TextureFilter, error) {
	var filter C.eLib3MFTextureFilter
	ret := C.CCall_lib3mf_functionfromimage3d_getfilter(inst.wrapperRef.LibraryHandle, inst.Ref, &filter)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return TextureFilter(filter), nil
}

// SetTileStyles sets the tile styles of the selector.
func (inst FunctionFromImage3D) SetTileStyles(tileStyleU TextureTileStyle, tileStyleV TextureTileStyle, tileStyleW TextureTileStyle) error {
	ret := C.CCall_lib3mf_functionfromimage3d_settilestyles(inst.wrapperRef.LibraryHandle, inst.Ref, C.eLib3MFTextureTileStyle(tileStyleU), C.eLib3MFTextureTileStyle(tileStyleV), C.eLib3MFTextureTileStyle(tileStyleW))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetTileStyles retrieves the tile styles of the selector.
func (inst FunctionFromImage3D) GetTileStyles() (TextureTileStyle, TextureTileStyle, TextureTileStyle, error) {
	var tileStyleU C.eLib3MFTextureTileStyle
	var tileStyleV C.eLib3MFTextureTileStyle
	var tileStyleW C.eLib3MFTextureTileStyle
	ret := C.CCall_lib3mf_functionfromimage3d_gettilestyles(inst.wrapperRef.LibraryHandle, inst.Ref, &tileStyleU, &tileStyleV, &tileStyleW)
	if ret != 0 {
		return 0, 0, 0, makeError(uint32(ret))
	}
	return TextureTileStyle(tileStyleU), TextureTileStyle(tileStyleV), TextureTileStyle(tileStyleW), nil
}

// GetOffset returns the offset value for the pixel values in the Image3D.
func (inst FunctionFromImage3D) GetOffset() (float64, error) {
	var offset C.double
	ret := C.CCall_lib3mf_functionfromimage3d_getoffset(inst.wrapperRef.LibraryHandle, inst.Ref, &offset)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return float64(offset), nil
}

// SetOffset sets the offset value for the pixel values in the Image3D.
func (inst FunctionFromImage3D) SetOffset(offset float64) error {
	ret := C.CCall_lib3mf_functionfromimage3d_setoffset(inst.wrapperRef.LibraryHandle, inst.Ref, C.double(offset))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetScale returns the scale value for the pixel values in the Image3D.
func (inst FunctionFromImage3D) GetScale() (float64, error) {
	var scale C.double
	ret := C.CCall_lib3mf_functionfromimage3d_getscale(inst.wrapperRef.LibraryHandle, inst.Ref, &scale)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return float64(scale), nil
}

// SetScale sets the scale value for the pixel values in the Image3D.
func (inst FunctionFromImage3D) SetScale(scale float64) error {
	ret := C.CCall_lib3mf_functionfromimage3d_setscale(inst.wrapperRef.LibraryHandle, inst.Ref, C.double(scale))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}


// BuildItem represents a Lib3MF class.
type BuildItem struct {
	Base
}

func (wrapper Wrapper) NewBuildItem(r ref) BuildItem {
	return BuildItem{wrapper.NewBase(r)}
}

// GetObjectResource retrieves the object resource associated to a build item.
func (inst BuildItem) GetObjectResource() (Object, error) {
	var objectResource ref
	ret := C.CCall_lib3mf_builditem_getobjectresource(inst.wrapperRef.LibraryHandle, inst.Ref, &objectResource)
	if ret != 0 {
		return Object{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewObject(objectResource), nil
}

// GetUUID returns, whether a build item has a UUID and, if true, the build item's UUID.
func (inst BuildItem) GetUUID() (bool, string, error) {
	var hasUUID C.bool
	var neededforuUID C.uint32_t
	var filledinuUID C.uint32_t
	ret := C.CCall_lib3mf_builditem_getuuid(inst.wrapperRef.LibraryHandle, inst.Ref, &hasUUID, 0, &neededforuUID, nil)
	if ret != 0 {
		return false, "", makeError(uint32(ret))
	}
	bufferSizeuUID := neededforuUID
	bufferuUID := make([]byte, bufferSizeuUID)
	ret = C.CCall_lib3mf_builditem_getuuid(inst.wrapperRef.LibraryHandle, inst.Ref, &hasUUID, bufferSizeuUID, &filledinuUID, (*C.char)(unsafe.Pointer(&bufferuUID[0])))
	if ret != 0 {
		return false, "", makeError(uint32(ret))
	}
	return bool(hasUUID), string(bufferuUID[:(filledinuUID-1)]), nil
}

// SetUUID sets the build item's UUID.
func (inst BuildItem) SetUUID(uUID string) error {
	ret := C.CCall_lib3mf_builditem_setuuid(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(uUID)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetObjectResourceID retrieves the object UniqueResourceID associated to a build item.
func (inst BuildItem) GetObjectResourceID() (uint32, error) {
	var uniqueResourceID C.uint32_t
	ret := C.CCall_lib3mf_builditem_getobjectresourceid(inst.wrapperRef.LibraryHandle, inst.Ref, &uniqueResourceID)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(uniqueResourceID), nil
}

// HasObjectTransform checks, if a build item has a non-identity transformation matrix.
func (inst BuildItem) HasObjectTransform() (bool, error) {
	var hasTransform C.bool
	ret := C.CCall_lib3mf_builditem_hasobjecttransform(inst.wrapperRef.LibraryHandle, inst.Ref, &hasTransform)
	if ret != 0 {
		return false, makeError(uint32(ret))
	}
	return bool(hasTransform), nil
}

// GetObjectTransform retrieves a build item's transformation matrix.
func (inst BuildItem) GetObjectTransform() (Transform, error) {
	var transform C.sLib3MFTransform
	ret := C.CCall_lib3mf_builditem_getobjecttransform(inst.wrapperRef.LibraryHandle, inst.Ref, &transform)
	if ret != 0 {
		return Transform{}, makeError(uint32(ret))
	}
	return *(*Transform)(unsafe.Pointer(&transform)), nil
}

// SetObjectTransform sets a build item's transformation matrix.
func (inst BuildItem) SetObjectTransform(transform Transform) error {
	ret := C.CCall_lib3mf_builditem_setobjecttransform(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.sLib3MFTransform)(unsafe.Pointer(&transform)))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetPartNumber retrieves a build item's part number string.
func (inst BuildItem) GetPartNumber() (string, error) {
	var neededforpartNumber C.uint32_t
	var filledinpartNumber C.uint32_t
	ret := C.CCall_lib3mf_builditem_getpartnumber(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforpartNumber, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSizepartNumber := neededforpartNumber
	bufferpartNumber := make([]byte, bufferSizepartNumber)
	ret = C.CCall_lib3mf_builditem_getpartnumber(inst.wrapperRef.LibraryHandle, inst.Ref, bufferSizepartNumber, &filledinpartNumber, (*C.char)(unsafe.Pointer(&bufferpartNumber[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(bufferpartNumber[:(filledinpartNumber-1)]), nil
}

// SetPartNumber sets a build item's part number string.
func (inst BuildItem) SetPartNumber(setPartnumber string) error {
	ret := C.CCall_lib3mf_builditem_setpartnumber(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(setPartnumber)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetMetaDataGroup returns the metadatagroup of this build item.
func (inst BuildItem) GetMetaDataGroup() (MetaDataGroup, error) {
	var metaDataGroup ref
	ret := C.CCall_lib3mf_builditem_getmetadatagroup(inst.wrapperRef.LibraryHandle, inst.Ref, &metaDataGroup)
	if ret != 0 {
		return MetaDataGroup{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewMetaDataGroup(metaDataGroup), nil
}

// GetOutbox returns the outbox of a build item.
func (inst BuildItem) GetOutbox() (Box, error) {
	var outbox C.sLib3MFBox
	ret := C.CCall_lib3mf_builditem_getoutbox(inst.wrapperRef.LibraryHandle, inst.Ref, &outbox)
	if ret != 0 {
		return Box{}, makeError(uint32(ret))
	}
	return *(*Box)(unsafe.Pointer(&outbox)), nil
}


// BuildItemIterator represents a Lib3MF class.
type BuildItemIterator struct {
	Base
}

func (wrapper Wrapper) NewBuildItemIterator(r ref) BuildItemIterator {
	return BuildItemIterator{wrapper.NewBase(r)}
}

// MoveNext iterates to the next build item in the list.
func (inst BuildItemIterator) MoveNext() (bool, error) {
	var hasNext C.bool
	ret := C.CCall_lib3mf_builditemiterator_movenext(inst.wrapperRef.LibraryHandle, inst.Ref, &hasNext)
	if ret != 0 {
		return false, makeError(uint32(ret))
	}
	return bool(hasNext), nil
}

// MovePrevious iterates to the previous build item in the list.
func (inst BuildItemIterator) MovePrevious() (bool, error) {
	var hasPrevious C.bool
	ret := C.CCall_lib3mf_builditemiterator_moveprevious(inst.wrapperRef.LibraryHandle, inst.Ref, &hasPrevious)
	if ret != 0 {
		return false, makeError(uint32(ret))
	}
	return bool(hasPrevious), nil
}

// GetCurrent returns the build item the iterator points at.
func (inst BuildItemIterator) GetCurrent() (BuildItem, error) {
	var buildItem ref
	ret := C.CCall_lib3mf_builditemiterator_getcurrent(inst.wrapperRef.LibraryHandle, inst.Ref, &buildItem)
	if ret != 0 {
		return BuildItem{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewBuildItem(buildItem), nil
}

// Clone creates a new build item iterator with the same build item list.
func (inst BuildItemIterator) Clone() (BuildItemIterator, error) {
	var outBuildItemIterator ref
	ret := C.CCall_lib3mf_builditemiterator_clone(inst.wrapperRef.LibraryHandle, inst.Ref, &outBuildItemIterator)
	if ret != 0 {
		return BuildItemIterator{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewBuildItemIterator(outBuildItemIterator), nil
}

// Count returns the number of build items the iterator captures.
func (inst BuildItemIterator) Count() (uint64, error) {
	var count C.uint64_t
	ret := C.CCall_lib3mf_builditemiterator_count(inst.wrapperRef.LibraryHandle, inst.Ref, &count)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint64(count), nil
}


// Slice represents a Lib3MF class.
type Slice struct {
	Base
}

func (wrapper Wrapper) NewSlice(r ref) Slice {
	return Slice{wrapper.NewBase(r)}
}

// SetVertices set all vertices of a slice. All polygons will be cleared.
func (inst Slice) SetVertices(vertices []Position2D) error {
	ret := C.CCall_lib3mf_slice_setvertices(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint64_t(len(vertices)), (*C.sLib3MFPosition2D)(unsafe.Pointer(&vertices[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetVertices get all vertices of a slice.
func (inst Slice) GetVertices(vertices []Position2D) ([]Position2D, error) {
	var neededforvertices C.uint64_t
	ret := C.CCall_lib3mf_slice_getvertices(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforvertices, nil)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	if len(vertices) < int(neededforvertices) {
	 vertices = append(vertices, make([]Position2D, int(neededforvertices)-len(vertices))...)
	}
	ret = C.CCall_lib3mf_slice_getvertices(inst.wrapperRef.LibraryHandle, inst.Ref, neededforvertices, nil, (*C.sLib3MFPosition2D)(unsafe.Pointer(&vertices[0])))
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	return vertices[:int(neededforvertices)], nil
}

// GetVertexCount get the number of vertices in a slice.
func (inst Slice) GetVertexCount() (uint64, error) {
	var count C.uint64_t
	ret := C.CCall_lib3mf_slice_getvertexcount(inst.wrapperRef.LibraryHandle, inst.Ref, &count)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint64(count), nil
}

// AddPolygon add a new polygon to this slice.
func (inst Slice) AddPolygon(indices []uint32) (uint64, error) {
	var index C.uint64_t
	ret := C.CCall_lib3mf_slice_addpolygon(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint64_t(len(indices)), (*C.uint32_t)(unsafe.Pointer(&indices[0])), &index)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint64(index), nil
}

// GetPolygonCount get the number of polygons in the slice.
func (inst Slice) GetPolygonCount() (uint64, error) {
	var count C.uint64_t
	ret := C.CCall_lib3mf_slice_getpolygoncount(inst.wrapperRef.LibraryHandle, inst.Ref, &count)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint64(count), nil
}

// SetPolygonIndices set all indices of a polygon.
func (inst Slice) SetPolygonIndices(index uint64, indices []uint32) error {
	ret := C.CCall_lib3mf_slice_setpolygonindices(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint64_t(index), C.uint64_t(len(indices)), (*C.uint32_t)(unsafe.Pointer(&indices[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetPolygonIndices get all vertices of a slice.
func (inst Slice) GetPolygonIndices(index uint64, indices []uint32) ([]uint32, error) {
	var neededforindices C.uint64_t
	ret := C.CCall_lib3mf_slice_getpolygonindices(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint64_t(index), 0, &neededforindices, nil)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	if len(indices) < int(neededforindices) {
	 indices = append(indices, make([]uint32, int(neededforindices)-len(indices))...)
	}
	ret = C.CCall_lib3mf_slice_getpolygonindices(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint64_t(index), neededforindices, nil, (*C.uint32_t)(unsafe.Pointer(&indices[0])))
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	return indices[:int(neededforindices)], nil
}

// GetPolygonIndexCount get the number of vertices in a slice.
func (inst Slice) GetPolygonIndexCount(index uint64) (uint64, error) {
	var count C.uint64_t
	ret := C.CCall_lib3mf_slice_getpolygonindexcount(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint64_t(index), &count)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint64(count), nil
}

// GetZTop get the upper Z-Coordinate of this slice.
func (inst Slice) GetZTop() (float64, error) {
	var zTop C.double
	ret := C.CCall_lib3mf_slice_getztop(inst.wrapperRef.LibraryHandle, inst.Ref, &zTop)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return float64(zTop), nil
}


// SliceStack represents a Lib3MF class.
type SliceStack struct {
	Resource
}

func (wrapper Wrapper) NewSliceStack(r ref) SliceStack {
	return SliceStack{wrapper.NewResource(r)}
}

// GetBottomZ get the lower Z-Coordinate of the slice stack.
func (inst SliceStack) GetBottomZ() (float64, error) {
	var zBottom C.double
	ret := C.CCall_lib3mf_slicestack_getbottomz(inst.wrapperRef.LibraryHandle, inst.Ref, &zBottom)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return float64(zBottom), nil
}

// GetSliceCount returns the number of slices.
func (inst SliceStack) GetSliceCount() (uint64, error) {
	var count C.uint64_t
	ret := C.CCall_lib3mf_slicestack_getslicecount(inst.wrapperRef.LibraryHandle, inst.Ref, &count)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint64(count), nil
}

// GetSlice query a slice from the slice stack.
func (inst SliceStack) GetSlice(sliceIndex uint64) (Slice, error) {
	var theSlice ref
	ret := C.CCall_lib3mf_slicestack_getslice(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint64_t(sliceIndex), &theSlice)
	if ret != 0 {
		return Slice{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewSlice(theSlice), nil
}

// AddSlice returns the number of slices.
func (inst SliceStack) AddSlice(zTop float64) (Slice, error) {
	var theSlice ref
	ret := C.CCall_lib3mf_slicestack_addslice(inst.wrapperRef.LibraryHandle, inst.Ref, C.double(zTop), &theSlice)
	if ret != 0 {
		return Slice{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewSlice(theSlice), nil
}

// GetSliceRefCount returns the number of slice refs.
func (inst SliceStack) GetSliceRefCount() (uint64, error) {
	var count C.uint64_t
	ret := C.CCall_lib3mf_slicestack_getslicerefcount(inst.wrapperRef.LibraryHandle, inst.Ref, &count)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint64(count), nil
}

// AddSliceStackReference adds another existing slicestack as sliceref in this slicestack.
func (inst SliceStack) AddSliceStackReference(theSliceStack SliceStack) error {
	ret := C.CCall_lib3mf_slicestack_addslicestackreference(inst.wrapperRef.LibraryHandle, inst.Ref, theSliceStack.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetSliceStackReference adds another existing slicestack as sliceref in this slicestack.
func (inst SliceStack) GetSliceStackReference(sliceRefIndex uint64) (SliceStack, error) {
	var theSliceStack ref
	ret := C.CCall_lib3mf_slicestack_getslicestackreference(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint64_t(sliceRefIndex), &theSliceStack)
	if ret != 0 {
		return SliceStack{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewSliceStack(theSliceStack), nil
}

// CollapseSliceReferences removes the indirection of slices via slice-refs, i.e. creates the slices of all slice refs of this SliceStack as actual slices of this SliceStack. All previously existing slices or slicerefs will be removed.
func (inst SliceStack) CollapseSliceReferences() error {
	ret := C.CCall_lib3mf_slicestack_collapseslicereferences(inst.wrapperRef.LibraryHandle, inst.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// SetOwnPath sets the package path where this Slice should be stored. Input an empty string to reset the path.
func (inst SliceStack) SetOwnPath(path string) error {
	ret := C.CCall_lib3mf_slicestack_setownpath(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(path)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetOwnPath obtains the package path where this Slice should be stored. Returns an empty string if the slicestack is stored within the root model.
func (inst SliceStack) GetOwnPath() (string, error) {
	var neededforpath C.uint32_t
	var filledinpath C.uint32_t
	ret := C.CCall_lib3mf_slicestack_getownpath(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforpath, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSizepath := neededforpath
	bufferpath := make([]byte, bufferSizepath)
	ret = C.CCall_lib3mf_slicestack_getownpath(inst.wrapperRef.LibraryHandle, inst.Ref, bufferSizepath, &filledinpath, (*C.char)(unsafe.Pointer(&bufferpath[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(bufferpath[:(filledinpath-1)]), nil
}


// Consumer represents a Lib3MF class.
type Consumer struct {
	Base
}

func (wrapper Wrapper) NewConsumer(r ref) Consumer {
	return Consumer{wrapper.NewBase(r)}
}

// GetConsumerID gets the consumerid.
func (inst Consumer) GetConsumerID() (string, error) {
	var neededforconsumerID C.uint32_t
	var filledinconsumerID C.uint32_t
	ret := C.CCall_lib3mf_consumer_getconsumerid(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforconsumerID, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSizeconsumerID := neededforconsumerID
	bufferconsumerID := make([]byte, bufferSizeconsumerID)
	ret = C.CCall_lib3mf_consumer_getconsumerid(inst.wrapperRef.LibraryHandle, inst.Ref, bufferSizeconsumerID, &filledinconsumerID, (*C.char)(unsafe.Pointer(&bufferconsumerID[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(bufferconsumerID[:(filledinconsumerID-1)]), nil
}

// GetKeyID getts the keyid.
func (inst Consumer) GetKeyID() (string, error) {
	var neededforkeyID C.uint32_t
	var filledinkeyID C.uint32_t
	ret := C.CCall_lib3mf_consumer_getkeyid(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforkeyID, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSizekeyID := neededforkeyID
	bufferkeyID := make([]byte, bufferSizekeyID)
	ret = C.CCall_lib3mf_consumer_getkeyid(inst.wrapperRef.LibraryHandle, inst.Ref, bufferSizekeyID, &filledinkeyID, (*C.char)(unsafe.Pointer(&bufferkeyID[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(bufferkeyID[:(filledinkeyID-1)]), nil
}

// GetKeyValue gets the keyvalue associated with this consumer.
func (inst Consumer) GetKeyValue() (string, error) {
	var neededforkeyValue C.uint32_t
	var filledinkeyValue C.uint32_t
	ret := C.CCall_lib3mf_consumer_getkeyvalue(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforkeyValue, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSizekeyValue := neededforkeyValue
	bufferkeyValue := make([]byte, bufferSizekeyValue)
	ret = C.CCall_lib3mf_consumer_getkeyvalue(inst.wrapperRef.LibraryHandle, inst.Ref, bufferSizekeyValue, &filledinkeyValue, (*C.char)(unsafe.Pointer(&bufferkeyValue[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(bufferkeyValue[:(filledinkeyValue-1)]), nil
}


// AccessRight represents a Lib3MF class.
type AccessRight struct {
	Base
}

func (wrapper Wrapper) NewAccessRight(r ref) AccessRight {
	return AccessRight{wrapper.NewBase(r)}
}

// GetConsumer gets the consumer associated with this access right.
func (inst AccessRight) GetConsumer() (Consumer, error) {
	var consumer ref
	ret := C.CCall_lib3mf_accessright_getconsumer(inst.wrapperRef.LibraryHandle, inst.Ref, &consumer)
	if ret != 0 {
		return Consumer{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewConsumer(consumer), nil
}

// GetWrappingAlgorithm gets the associated encryption algorithm.
func (inst AccessRight) GetWrappingAlgorithm() (WrappingAlgorithm, error) {
	var algorithm C.eLib3MFWrappingAlgorithm
	ret := C.CCall_lib3mf_accessright_getwrappingalgorithm(inst.wrapperRef.LibraryHandle, inst.Ref, &algorithm)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return WrappingAlgorithm(algorithm), nil
}

// GetMgfAlgorithm gets the associated mask generation function algorithm.
func (inst AccessRight) GetMgfAlgorithm() (MgfAlgorithm, error) {
	var algorithm C.eLib3MFMgfAlgorithm
	ret := C.CCall_lib3mf_accessright_getmgfalgorithm(inst.wrapperRef.LibraryHandle, inst.Ref, &algorithm)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return MgfAlgorithm(algorithm), nil
}

// GetDigestMethod gets the digest method assoicated.
func (inst AccessRight) GetDigestMethod() (DigestMethod, error) {
	var algorithm C.eLib3MFDigestMethod
	ret := C.CCall_lib3mf_accessright_getdigestmethod(inst.wrapperRef.LibraryHandle, inst.Ref, &algorithm)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return DigestMethod(algorithm), nil
}


// ContentEncryptionParams represents a Lib3MF class.
type ContentEncryptionParams struct {
	Base
}

func (wrapper Wrapper) NewContentEncryptionParams(r ref) ContentEncryptionParams {
	return ContentEncryptionParams{wrapper.NewBase(r)}
}

// GetEncryptionAlgorithm returns the encryption method to be used in this encryption process.
func (inst ContentEncryptionParams) GetEncryptionAlgorithm() (EncryptionAlgorithm, error) {
	var algorithm C.eLib3MFEncryptionAlgorithm
	ret := C.CCall_lib3mf_contentencryptionparams_getencryptionalgorithm(inst.wrapperRef.LibraryHandle, inst.Ref, &algorithm)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return EncryptionAlgorithm(algorithm), nil
}

// GetKey gets the key for the resource associated.
func (inst ContentEncryptionParams) GetKey(byteData []uint8) ([]uint8, error) {
	var neededforbyteData C.uint64_t
	ret := C.CCall_lib3mf_contentencryptionparams_getkey(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforbyteData, nil)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	if len(byteData) < int(neededforbyteData) {
	 byteData = append(byteData, make([]uint8, int(neededforbyteData)-len(byteData))...)
	}
	ret = C.CCall_lib3mf_contentencryptionparams_getkey(inst.wrapperRef.LibraryHandle, inst.Ref, neededforbyteData, nil, (*C.uint8_t)(unsafe.Pointer(&byteData[0])))
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	return byteData[:int(neededforbyteData)], nil
}

// GetInitializationVector gets the IV data.
func (inst ContentEncryptionParams) GetInitializationVector(byteData []uint8) ([]uint8, error) {
	var neededforbyteData C.uint64_t
	ret := C.CCall_lib3mf_contentencryptionparams_getinitializationvector(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforbyteData, nil)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	if len(byteData) < int(neededforbyteData) {
	 byteData = append(byteData, make([]uint8, int(neededforbyteData)-len(byteData))...)
	}
	ret = C.CCall_lib3mf_contentencryptionparams_getinitializationvector(inst.wrapperRef.LibraryHandle, inst.Ref, neededforbyteData, nil, (*C.uint8_t)(unsafe.Pointer(&byteData[0])))
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	return byteData[:int(neededforbyteData)], nil
}

// GetAuthenticationTag a handler descriptor that uniquely identifies the context of the resource. Each resource will be assigned a different value.
func (inst ContentEncryptionParams) GetAuthenticationTag(byteData []uint8) ([]uint8, error) {
	var neededforbyteData C.uint64_t
	ret := C.CCall_lib3mf_contentencryptionparams_getauthenticationtag(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforbyteData, nil)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	if len(byteData) < int(neededforbyteData) {
	 byteData = append(byteData, make([]uint8, int(neededforbyteData)-len(byteData))...)
	}
	ret = C.CCall_lib3mf_contentencryptionparams_getauthenticationtag(inst.wrapperRef.LibraryHandle, inst.Ref, neededforbyteData, nil, (*C.uint8_t)(unsafe.Pointer(&byteData[0])))
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	return byteData[:int(neededforbyteData)], nil
}

// SetAuthenticationTag sets the authentication tag.
func (inst ContentEncryptionParams) SetAuthenticationTag(byteData []uint8) error {
	ret := C.CCall_lib3mf_contentencryptionparams_setauthenticationtag(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint64_t(len(byteData)), (*C.uint8_t)(unsafe.Pointer(&byteData[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetAdditionalAuthenticationData a handler descriptor that uniquely identifies the context of the resource. Each resource will be assigned a different value.
func (inst ContentEncryptionParams) GetAdditionalAuthenticationData(byteData []uint8) ([]uint8, error) {
	var neededforbyteData C.uint64_t
	ret := C.CCall_lib3mf_contentencryptionparams_getadditionalauthenticationdata(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforbyteData, nil)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	if len(byteData) < int(neededforbyteData) {
	 byteData = append(byteData, make([]uint8, int(neededforbyteData)-len(byteData))...)
	}
	ret = C.CCall_lib3mf_contentencryptionparams_getadditionalauthenticationdata(inst.wrapperRef.LibraryHandle, inst.Ref, neededforbyteData, nil, (*C.uint8_t)(unsafe.Pointer(&byteData[0])))
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	return byteData[:int(neededforbyteData)], nil
}

// GetDescriptor a handler descriptor that uniquely identifies the context of the resource. Each resource will be assigned a different value.
func (inst ContentEncryptionParams) GetDescriptor() (uint64, error) {
	var descriptor C.uint64_t
	ret := C.CCall_lib3mf_contentencryptionparams_getdescriptor(inst.wrapperRef.LibraryHandle, inst.Ref, &descriptor)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint64(descriptor), nil
}

// GetKeyUUID gets the resourcedatagroup keyuuid.
func (inst ContentEncryptionParams) GetKeyUUID() (string, error) {
	var neededforuUID C.uint32_t
	var filledinuUID C.uint32_t
	ret := C.CCall_lib3mf_contentencryptionparams_getkeyuuid(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforuUID, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSizeuUID := neededforuUID
	bufferuUID := make([]byte, bufferSizeuUID)
	ret = C.CCall_lib3mf_contentencryptionparams_getkeyuuid(inst.wrapperRef.LibraryHandle, inst.Ref, bufferSizeuUID, &filledinuUID, (*C.char)(unsafe.Pointer(&bufferuUID[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(bufferuUID[:(filledinuUID-1)]), nil
}


// ResourceData represents a Lib3MF class.
type ResourceData struct {
	Base
}

func (wrapper Wrapper) NewResourceData(r ref) ResourceData {
	return ResourceData{wrapper.NewBase(r)}
}

// GetPath gets the encrypted part path.
func (inst ResourceData) GetPath() (PackagePart, error) {
	var path ref
	ret := C.CCall_lib3mf_resourcedata_getpath(inst.wrapperRef.LibraryHandle, inst.Ref, &path)
	if ret != 0 {
		return PackagePart{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewPackagePart(path), nil
}

// GetEncryptionAlgorithm gets the encryption algorithm used to encrypt this ResourceData.
func (inst ResourceData) GetEncryptionAlgorithm() (EncryptionAlgorithm, error) {
	var encryptionAlgorithm C.eLib3MFEncryptionAlgorithm
	ret := C.CCall_lib3mf_resourcedata_getencryptionalgorithm(inst.wrapperRef.LibraryHandle, inst.Ref, &encryptionAlgorithm)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return EncryptionAlgorithm(encryptionAlgorithm), nil
}

// GetCompression tells whether this ResourceData is compressed or not.
func (inst ResourceData) GetCompression() (Compression, error) {
	var compression C.eLib3MFCompression
	ret := C.CCall_lib3mf_resourcedata_getcompression(inst.wrapperRef.LibraryHandle, inst.Ref, &compression)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return Compression(compression), nil
}

// GetAdditionalAuthenticationData tells whether this ResourceData is compressed or not.
func (inst ResourceData) GetAdditionalAuthenticationData(byteData []uint8) ([]uint8, error) {
	var neededforbyteData C.uint64_t
	ret := C.CCall_lib3mf_resourcedata_getadditionalauthenticationdata(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforbyteData, nil)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	if len(byteData) < int(neededforbyteData) {
	 byteData = append(byteData, make([]uint8, int(neededforbyteData)-len(byteData))...)
	}
	ret = C.CCall_lib3mf_resourcedata_getadditionalauthenticationdata(inst.wrapperRef.LibraryHandle, inst.Ref, neededforbyteData, nil, (*C.uint8_t)(unsafe.Pointer(&byteData[0])))
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	return byteData[:int(neededforbyteData)], nil
}


// ResourceDataGroup represents a Lib3MF class.
type ResourceDataGroup struct {
	Base
}

func (wrapper Wrapper) NewResourceDataGroup(r ref) ResourceDataGroup {
	return ResourceDataGroup{wrapper.NewBase(r)}
}

// GetKeyUUID sets the resourcedatagroup keyuuid.
func (inst ResourceDataGroup) GetKeyUUID() (string, error) {
	var neededforuUID C.uint32_t
	var filledinuUID C.uint32_t
	ret := C.CCall_lib3mf_resourcedatagroup_getkeyuuid(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforuUID, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSizeuUID := neededforuUID
	bufferuUID := make([]byte, bufferSizeuUID)
	ret = C.CCall_lib3mf_resourcedatagroup_getkeyuuid(inst.wrapperRef.LibraryHandle, inst.Ref, bufferSizeuUID, &filledinuUID, (*C.char)(unsafe.Pointer(&bufferuUID[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(bufferuUID[:(filledinuUID-1)]), nil
}

// AddAccessRight add accessright to resourcedatagroup element.
func (inst ResourceDataGroup) AddAccessRight(consumer Consumer, wrappingAlgorithm WrappingAlgorithm, mgfAlgorithm MgfAlgorithm, digestMethod DigestMethod) (AccessRight, error) {
	var theAccessRight ref
	ret := C.CCall_lib3mf_resourcedatagroup_addaccessright(inst.wrapperRef.LibraryHandle, inst.Ref, consumer.Ref, C.eLib3MFWrappingAlgorithm(wrappingAlgorithm), C.eLib3MFMgfAlgorithm(mgfAlgorithm), C.eLib3MFDigestMethod(digestMethod), &theAccessRight)
	if ret != 0 {
		return AccessRight{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewAccessRight(theAccessRight), nil
}

// FindAccessRightByConsumer finds the AccessRight associated with a Consumer.
func (inst ResourceDataGroup) FindAccessRightByConsumer(consumer Consumer) (*AccessRight, error) {
	var theAccessRight ref
	ret := C.CCall_lib3mf_resourcedatagroup_findaccessrightbyconsumer(inst.wrapperRef.LibraryHandle, inst.Ref, consumer.Ref, &theAccessRight)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	var _theAccessRightPtr *AccessRight
	if theAccessRight != nil {
		_theAccessRightPtrVal := inst.wrapperRef.NewAccessRight(theAccessRight)
		_theAccessRightPtr = &_theAccessRightPtrVal
	}
	return _theAccessRightPtr, nil
}

// RemoveAccessRight removes access from a Consumer on this resource data group.
func (inst ResourceDataGroup) RemoveAccessRight(consumer Consumer) error {
	ret := C.CCall_lib3mf_resourcedatagroup_removeaccessright(inst.wrapperRef.LibraryHandle, inst.Ref, consumer.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}


// KeyStore represents a Lib3MF class.
type KeyStore struct {
	Base
}

func (wrapper Wrapper) NewKeyStore(r ref) KeyStore {
	return KeyStore{wrapper.NewBase(r)}
}

// AddConsumer adds a consumer to the keystore.
func (inst KeyStore) AddConsumer(consumerID string, keyID string, keyValue string) (Consumer, error) {
	var consumer ref
	ret := C.CCall_lib3mf_keystore_addconsumer(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(consumerID)[0])), (*C.char)(unsafe.Pointer(&[]byte(keyID)[0])), (*C.char)(unsafe.Pointer(&[]byte(keyValue)[0])), &consumer)
	if ret != 0 {
		return Consumer{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewConsumer(consumer), nil
}

// GetConsumerCount gets the number of consumers in the keystore.
func (inst KeyStore) GetConsumerCount() (uint64, error) {
	var count C.uint64_t
	ret := C.CCall_lib3mf_keystore_getconsumercount(inst.wrapperRef.LibraryHandle, inst.Ref, &count)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint64(count), nil
}

// GetConsumer get a consumer from the keystore.
func (inst KeyStore) GetConsumer(consumerIndex uint64) (Consumer, error) {
	var consumer ref
	ret := C.CCall_lib3mf_keystore_getconsumer(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint64_t(consumerIndex), &consumer)
	if ret != 0 {
		return Consumer{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewConsumer(consumer), nil
}

// RemoveConsumer removes a consumer from the keystore.
func (inst KeyStore) RemoveConsumer(consumer Consumer) error {
	ret := C.CCall_lib3mf_keystore_removeconsumer(inst.wrapperRef.LibraryHandle, inst.Ref, consumer.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// FindConsumer finds a consumer by ID.
func (inst KeyStore) FindConsumer(consumerID string) (*Consumer, error) {
	var consumer ref
	ret := C.CCall_lib3mf_keystore_findconsumer(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(consumerID)[0])), &consumer)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	var _consumerPtr *Consumer
	if consumer != nil {
		_consumerPtrVal := inst.wrapperRef.NewConsumer(consumer)
		_consumerPtr = &_consumerPtrVal
	}
	return _consumerPtr, nil
}

// GetResourceDataGroupCount gets the number of resource data group in the keysore.
func (inst KeyStore) GetResourceDataGroupCount() (uint64, error) {
	var count C.uint64_t
	ret := C.CCall_lib3mf_keystore_getresourcedatagroupcount(inst.wrapperRef.LibraryHandle, inst.Ref, &count)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint64(count), nil
}

// AddResourceDataGroup adds a resource data group into the keystore.
func (inst KeyStore) AddResourceDataGroup() (ResourceDataGroup, error) {
	var resourceDataGroup ref
	ret := C.CCall_lib3mf_keystore_addresourcedatagroup(inst.wrapperRef.LibraryHandle, inst.Ref, &resourceDataGroup)
	if ret != 0 {
		return ResourceDataGroup{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewResourceDataGroup(resourceDataGroup), nil
}

// GetResourceDataGroup gets a resource data group.
func (inst KeyStore) GetResourceDataGroup(resourceDataIndex uint64) (ResourceDataGroup, error) {
	var resourceDataGroup ref
	ret := C.CCall_lib3mf_keystore_getresourcedatagroup(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint64_t(resourceDataIndex), &resourceDataGroup)
	if ret != 0 {
		return ResourceDataGroup{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewResourceDataGroup(resourceDataGroup), nil
}

// RemoveResourceDataGroup removes a resource data group.
func (inst KeyStore) RemoveResourceDataGroup(resourceDataGroup ResourceDataGroup) error {
	ret := C.CCall_lib3mf_keystore_removeresourcedatagroup(inst.wrapperRef.LibraryHandle, inst.Ref, resourceDataGroup.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// FindResourceDataGroup finds a resource data group that contains a particular resourcedata.
func (inst KeyStore) FindResourceDataGroup(partPath PackagePart) (*ResourceDataGroup, error) {
	var resourceDataGroup ref
	ret := C.CCall_lib3mf_keystore_findresourcedatagroup(inst.wrapperRef.LibraryHandle, inst.Ref, partPath.Ref, &resourceDataGroup)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	var _resourceDataGroupPtr *ResourceDataGroup
	if resourceDataGroup != nil {
		_resourceDataGroupPtrVal := inst.wrapperRef.NewResourceDataGroup(resourceDataGroup)
		_resourceDataGroupPtr = &_resourceDataGroupPtrVal
	}
	return _resourceDataGroupPtr, nil
}

// AddResourceData add resourcedata to resourcedatagroup element.
func (inst KeyStore) AddResourceData(resourceDataGroup ResourceDataGroup, partPath PackagePart, algorithm EncryptionAlgorithm, compression Compression, additionalAuthenticationData []uint8) (ResourceData, error) {
	var resourceData ref
	ret := C.CCall_lib3mf_keystore_addresourcedata(inst.wrapperRef.LibraryHandle, inst.Ref, resourceDataGroup.Ref, partPath.Ref, C.eLib3MFEncryptionAlgorithm(algorithm), C.eLib3MFCompression(compression), C.uint64_t(len(additionalAuthenticationData)), (*C.uint8_t)(unsafe.Pointer(&additionalAuthenticationData[0])), &resourceData)
	if ret != 0 {
		return ResourceData{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewResourceData(resourceData), nil
}

// RemoveResourceData removes a resource data.
func (inst KeyStore) RemoveResourceData(resourceData ResourceData) error {
	ret := C.CCall_lib3mf_keystore_removeresourcedata(inst.wrapperRef.LibraryHandle, inst.Ref, resourceData.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// FindResourceData finds a resource data on this resource group.
func (inst KeyStore) FindResourceData(resourcePath PackagePart) (*ResourceData, error) {
	var resourceData ref
	ret := C.CCall_lib3mf_keystore_findresourcedata(inst.wrapperRef.LibraryHandle, inst.Ref, resourcePath.Ref, &resourceData)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	var _resourceDataPtr *ResourceData
	if resourceData != nil {
		_resourceDataPtrVal := inst.wrapperRef.NewResourceData(resourceData)
		_resourceDataPtr = &_resourceDataPtrVal
	}
	return _resourceDataPtr, nil
}

// GetResourceDataCount gets the number of resource data in the keysore.
func (inst KeyStore) GetResourceDataCount() (uint64, error) {
	var count C.uint64_t
	ret := C.CCall_lib3mf_keystore_getresourcedatacount(inst.wrapperRef.LibraryHandle, inst.Ref, &count)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint64(count), nil
}

// GetResourceData gets a resource data.
func (inst KeyStore) GetResourceData(resourceDataIndex uint64) (ResourceData, error) {
	var resourceData ref
	ret := C.CCall_lib3mf_keystore_getresourcedata(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint64_t(resourceDataIndex), &resourceData)
	if ret != 0 {
		return ResourceData{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewResourceData(resourceData), nil
}

// GetUUID gets the keystore UUID.
func (inst KeyStore) GetUUID() (bool, string, error) {
	var hasUUID C.bool
	var neededforuUID C.uint32_t
	var filledinuUID C.uint32_t
	ret := C.CCall_lib3mf_keystore_getuuid(inst.wrapperRef.LibraryHandle, inst.Ref, &hasUUID, 0, &neededforuUID, nil)
	if ret != 0 {
		return false, "", makeError(uint32(ret))
	}
	bufferSizeuUID := neededforuUID
	bufferuUID := make([]byte, bufferSizeuUID)
	ret = C.CCall_lib3mf_keystore_getuuid(inst.wrapperRef.LibraryHandle, inst.Ref, &hasUUID, bufferSizeuUID, &filledinuUID, (*C.char)(unsafe.Pointer(&bufferuUID[0])))
	if ret != 0 {
		return false, "", makeError(uint32(ret))
	}
	return bool(hasUUID), string(bufferuUID[:(filledinuUID-1)]), nil
}

// SetUUID sets the keystore UUID.
func (inst KeyStore) SetUUID(uUID string) error {
	ret := C.CCall_lib3mf_keystore_setuuid(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(uUID)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}


// Model represents a Lib3MF class.
type Model struct {
	Base
}

func (wrapper Wrapper) NewModel(r ref) Model {
	return Model{wrapper.NewBase(r)}
}

// RootModelPart returns the PackagePart within the OPC package that holds the root model.
func (inst Model) RootModelPart() (PackagePart, error) {
	var rootModelPart ref
	ret := C.CCall_lib3mf_model_rootmodelpart(inst.wrapperRef.LibraryHandle, inst.Ref, &rootModelPart)
	if ret != 0 {
		return PackagePart{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewPackagePart(rootModelPart), nil
}

// FindOrCreatePackagePart returns a new PackagePart for use within the OPC package.
func (inst Model) FindOrCreatePackagePart(absolutePath string) (PackagePart, error) {
	var modelPart ref
	ret := C.CCall_lib3mf_model_findorcreatepackagepart(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(absolutePath)[0])), &modelPart)
	if ret != 0 {
		return PackagePart{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewPackagePart(modelPart), nil
}

// SetUnit sets the units of a model.
func (inst Model) SetUnit(unit ModelUnit) error {
	ret := C.CCall_lib3mf_model_setunit(inst.wrapperRef.LibraryHandle, inst.Ref, C.eLib3MFModelUnit(unit))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetUnit returns the units of a model.
func (inst Model) GetUnit() (ModelUnit, error) {
	var unit C.eLib3MFModelUnit
	ret := C.CCall_lib3mf_model_getunit(inst.wrapperRef.LibraryHandle, inst.Ref, &unit)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return ModelUnit(unit), nil
}

// GetLanguage retrieves the language of a model.
func (inst Model) GetLanguage() (string, error) {
	var neededforlanguage C.uint32_t
	var filledinlanguage C.uint32_t
	ret := C.CCall_lib3mf_model_getlanguage(inst.wrapperRef.LibraryHandle, inst.Ref, 0, &neededforlanguage, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSizelanguage := neededforlanguage
	bufferlanguage := make([]byte, bufferSizelanguage)
	ret = C.CCall_lib3mf_model_getlanguage(inst.wrapperRef.LibraryHandle, inst.Ref, bufferSizelanguage, &filledinlanguage, (*C.char)(unsafe.Pointer(&bufferlanguage[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(bufferlanguage[:(filledinlanguage-1)]), nil
}

// SetLanguage sets the language of a model.
func (inst Model) SetLanguage(language string) error {
	ret := C.CCall_lib3mf_model_setlanguage(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(language)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// QueryWriter creates a model writer instance for a specific file type.
func (inst Model) QueryWriter(writerClass string) (Writer, error) {
	var writerInstance ref
	ret := C.CCall_lib3mf_model_querywriter(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(writerClass)[0])), &writerInstance)
	if ret != 0 {
		return Writer{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewWriter(writerInstance), nil
}

// QueryReader creates a model reader instance for a specific file type.
func (inst Model) QueryReader(readerClass string) (Reader, error) {
	var readerInstance ref
	ret := C.CCall_lib3mf_model_queryreader(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(readerClass)[0])), &readerInstance)
	if ret != 0 {
		return Reader{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewReader(readerInstance), nil
}

// GetResourceByID finds a model resource by its UniqueResourceID.
func (inst Model) GetResourceByID(uniqueResourceID uint32) (Resource, error) {
	var resource ref
	ret := C.CCall_lib3mf_model_getresourcebyid(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(uniqueResourceID), &resource)
	if ret != 0 {
		return Resource{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewResource(resource), nil
}

// GetTexture2DByID finds a model texture by its UniqueResourceID.
func (inst Model) GetTexture2DByID(uniqueResourceID uint32) (Texture2D, error) {
	var textureInstance ref
	ret := C.CCall_lib3mf_model_gettexture2dbyid(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(uniqueResourceID), &textureInstance)
	if ret != 0 {
		return Texture2D{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewTexture2D(textureInstance), nil
}

// GetPropertyTypeByID returns a Property's type.
func (inst Model) GetPropertyTypeByID(uniqueResourceID uint32) (PropertyType, error) {
	var thePropertyType C.eLib3MFPropertyType
	ret := C.CCall_lib3mf_model_getpropertytypebyid(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(uniqueResourceID), &thePropertyType)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return PropertyType(thePropertyType), nil
}

// GetBaseMaterialGroupByID finds a model base material group by its UniqueResourceID.
func (inst Model) GetBaseMaterialGroupByID(uniqueResourceID uint32) (BaseMaterialGroup, error) {
	var baseMaterialGroupInstance ref
	ret := C.CCall_lib3mf_model_getbasematerialgroupbyid(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(uniqueResourceID), &baseMaterialGroupInstance)
	if ret != 0 {
		return BaseMaterialGroup{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewBaseMaterialGroup(baseMaterialGroupInstance), nil
}

// GetTexture2DGroupByID finds a model texture2d group by its UniqueResourceID.
func (inst Model) GetTexture2DGroupByID(uniqueResourceID uint32) (Texture2DGroup, error) {
	var texture2DGroupInstance ref
	ret := C.CCall_lib3mf_model_gettexture2dgroupbyid(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(uniqueResourceID), &texture2DGroupInstance)
	if ret != 0 {
		return Texture2DGroup{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewTexture2DGroup(texture2DGroupInstance), nil
}

// GetCompositeMaterialsByID finds a model CompositeMaterials by its UniqueResourceID.
func (inst Model) GetCompositeMaterialsByID(uniqueResourceID uint32) (CompositeMaterials, error) {
	var compositeMaterialsInstance ref
	ret := C.CCall_lib3mf_model_getcompositematerialsbyid(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(uniqueResourceID), &compositeMaterialsInstance)
	if ret != 0 {
		return CompositeMaterials{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewCompositeMaterials(compositeMaterialsInstance), nil
}

// GetMultiPropertyGroupByID finds a model MultiPropertyGroup by its UniqueResourceID.
func (inst Model) GetMultiPropertyGroupByID(uniqueResourceID uint32) (MultiPropertyGroup, error) {
	var multiPropertyGroupInstance ref
	ret := C.CCall_lib3mf_model_getmultipropertygroupbyid(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(uniqueResourceID), &multiPropertyGroupInstance)
	if ret != 0 {
		return MultiPropertyGroup{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewMultiPropertyGroup(multiPropertyGroupInstance), nil
}

// GetMeshObjectByID finds a mesh object by its UniqueResourceID.
func (inst Model) GetMeshObjectByID(uniqueResourceID uint32) (MeshObject, error) {
	var meshObjectInstance ref
	ret := C.CCall_lib3mf_model_getmeshobjectbyid(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(uniqueResourceID), &meshObjectInstance)
	if ret != 0 {
		return MeshObject{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewMeshObject(meshObjectInstance), nil
}

// GetComponentsObjectByID finds a components object by its UniqueResourceID.
func (inst Model) GetComponentsObjectByID(uniqueResourceID uint32) (ComponentsObject, error) {
	var componentsObjectInstance ref
	ret := C.CCall_lib3mf_model_getcomponentsobjectbyid(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(uniqueResourceID), &componentsObjectInstance)
	if ret != 0 {
		return ComponentsObject{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewComponentsObject(componentsObjectInstance), nil
}

// GetColorGroupByID finds a model color group by its UniqueResourceID.
func (inst Model) GetColorGroupByID(uniqueResourceID uint32) (ColorGroup, error) {
	var colorGroupInstance ref
	ret := C.CCall_lib3mf_model_getcolorgroupbyid(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(uniqueResourceID), &colorGroupInstance)
	if ret != 0 {
		return ColorGroup{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewColorGroup(colorGroupInstance), nil
}

// GetSliceStackByID finds a model slicestack by its UniqueResourceID.
func (inst Model) GetSliceStackByID(uniqueResourceID uint32) (SliceStack, error) {
	var sliceStacInstance ref
	ret := C.CCall_lib3mf_model_getslicestackbyid(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(uniqueResourceID), &sliceStacInstance)
	if ret != 0 {
		return SliceStack{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewSliceStack(sliceStacInstance), nil
}

// GetLevelSetByID finds a level set object by its UniqueResourceID.
func (inst Model) GetLevelSetByID(uniqueResourceID uint32) (LevelSet, error) {
	var levelSetObjectInstance ref
	ret := C.CCall_lib3mf_model_getlevelsetbyid(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(uniqueResourceID), &levelSetObjectInstance)
	if ret != 0 {
		return LevelSet{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewLevelSet(levelSetObjectInstance), nil
}

// GetBuildUUID returns, whether a build has a UUID and, if true, the build's UUID.
func (inst Model) GetBuildUUID() (bool, string, error) {
	var hasUUID C.bool
	var neededforuUID C.uint32_t
	var filledinuUID C.uint32_t
	ret := C.CCall_lib3mf_model_getbuilduuid(inst.wrapperRef.LibraryHandle, inst.Ref, &hasUUID, 0, &neededforuUID, nil)
	if ret != 0 {
		return false, "", makeError(uint32(ret))
	}
	bufferSizeuUID := neededforuUID
	bufferuUID := make([]byte, bufferSizeuUID)
	ret = C.CCall_lib3mf_model_getbuilduuid(inst.wrapperRef.LibraryHandle, inst.Ref, &hasUUID, bufferSizeuUID, &filledinuUID, (*C.char)(unsafe.Pointer(&bufferuUID[0])))
	if ret != 0 {
		return false, "", makeError(uint32(ret))
	}
	return bool(hasUUID), string(bufferuUID[:(filledinuUID-1)]), nil
}

// SetBuildUUID sets the build's UUID.
func (inst Model) SetBuildUUID(uUID string) error {
	ret := C.CCall_lib3mf_model_setbuilduuid(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(uUID)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetBuildItems creates a build item iterator instance with all build items.
func (inst Model) GetBuildItems() (BuildItemIterator, error) {
	var buildItemIterator ref
	ret := C.CCall_lib3mf_model_getbuilditems(inst.wrapperRef.LibraryHandle, inst.Ref, &buildItemIterator)
	if ret != 0 {
		return BuildItemIterator{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewBuildItemIterator(buildItemIterator), nil
}

// GetOutbox returns the outbox of a Model.
func (inst Model) GetOutbox() (Box, error) {
	var outbox C.sLib3MFBox
	ret := C.CCall_lib3mf_model_getoutbox(inst.wrapperRef.LibraryHandle, inst.Ref, &outbox)
	if ret != 0 {
		return Box{}, makeError(uint32(ret))
	}
	return *(*Box)(unsafe.Pointer(&outbox)), nil
}

// GetResources creates a resource iterator instance with all resources.
func (inst Model) GetResources() (ResourceIterator, error) {
	var resourceIterator ref
	ret := C.CCall_lib3mf_model_getresources(inst.wrapperRef.LibraryHandle, inst.Ref, &resourceIterator)
	if ret != 0 {
		return ResourceIterator{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewResourceIterator(resourceIterator), nil
}

// GetObjects creates a resource iterator instance with all object resources.
func (inst Model) GetObjects() (ObjectIterator, error) {
	var resourceIterator ref
	ret := C.CCall_lib3mf_model_getobjects(inst.wrapperRef.LibraryHandle, inst.Ref, &resourceIterator)
	if ret != 0 {
		return ObjectIterator{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewObjectIterator(resourceIterator), nil
}

// GetMeshObjects creates a resource iterator instance with all mesh object resources.
func (inst Model) GetMeshObjects() (MeshObjectIterator, error) {
	var resourceIterator ref
	ret := C.CCall_lib3mf_model_getmeshobjects(inst.wrapperRef.LibraryHandle, inst.Ref, &resourceIterator)
	if ret != 0 {
		return MeshObjectIterator{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewMeshObjectIterator(resourceIterator), nil
}

// GetComponentsObjects creates a resource iterator instance with all components object resources.
func (inst Model) GetComponentsObjects() (ComponentsObjectIterator, error) {
	var resourceIterator ref
	ret := C.CCall_lib3mf_model_getcomponentsobjects(inst.wrapperRef.LibraryHandle, inst.Ref, &resourceIterator)
	if ret != 0 {
		return ComponentsObjectIterator{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewComponentsObjectIterator(resourceIterator), nil
}

// GetTexture2Ds creates a Texture2DIterator instance with all texture2d resources.
func (inst Model) GetTexture2Ds() (Texture2DIterator, error) {
	var resourceIterator ref
	ret := C.CCall_lib3mf_model_gettexture2ds(inst.wrapperRef.LibraryHandle, inst.Ref, &resourceIterator)
	if ret != 0 {
		return Texture2DIterator{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewTexture2DIterator(resourceIterator), nil
}

// GetBaseMaterialGroups creates a BaseMaterialGroupIterator instance with all base material resources.
func (inst Model) GetBaseMaterialGroups() (BaseMaterialGroupIterator, error) {
	var resourceIterator ref
	ret := C.CCall_lib3mf_model_getbasematerialgroups(inst.wrapperRef.LibraryHandle, inst.Ref, &resourceIterator)
	if ret != 0 {
		return BaseMaterialGroupIterator{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewBaseMaterialGroupIterator(resourceIterator), nil
}

// GetColorGroups creates a ColorGroupIterator instance with all ColorGroup resources.
func (inst Model) GetColorGroups() (ColorGroupIterator, error) {
	var resourceIterator ref
	ret := C.CCall_lib3mf_model_getcolorgroups(inst.wrapperRef.LibraryHandle, inst.Ref, &resourceIterator)
	if ret != 0 {
		return ColorGroupIterator{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewColorGroupIterator(resourceIterator), nil
}

// GetTexture2DGroups creates a Texture2DGroupIterator instance with all base material resources.
func (inst Model) GetTexture2DGroups() (Texture2DGroupIterator, error) {
	var resourceIterator ref
	ret := C.CCall_lib3mf_model_gettexture2dgroups(inst.wrapperRef.LibraryHandle, inst.Ref, &resourceIterator)
	if ret != 0 {
		return Texture2DGroupIterator{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewTexture2DGroupIterator(resourceIterator), nil
}

// GetCompositeMaterials creates a CompositeMaterialsIterator instance with all CompositeMaterials resources.
func (inst Model) GetCompositeMaterials() (CompositeMaterialsIterator, error) {
	var resourceIterator ref
	ret := C.CCall_lib3mf_model_getcompositematerials(inst.wrapperRef.LibraryHandle, inst.Ref, &resourceIterator)
	if ret != 0 {
		return CompositeMaterialsIterator{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewCompositeMaterialsIterator(resourceIterator), nil
}

// GetMultiPropertyGroups creates a MultiPropertyGroupsIterator instance with all MultiPropertyGroup resources.
func (inst Model) GetMultiPropertyGroups() (MultiPropertyGroupIterator, error) {
	var resourceIterator ref
	ret := C.CCall_lib3mf_model_getmultipropertygroups(inst.wrapperRef.LibraryHandle, inst.Ref, &resourceIterator)
	if ret != 0 {
		return MultiPropertyGroupIterator{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewMultiPropertyGroupIterator(resourceIterator), nil
}

// GetSliceStacks creates a resource iterator instance with all slice stack resources.
func (inst Model) GetSliceStacks() (SliceStackIterator, error) {
	var resourceIterator ref
	ret := C.CCall_lib3mf_model_getslicestacks(inst.wrapperRef.LibraryHandle, inst.Ref, &resourceIterator)
	if ret != 0 {
		return SliceStackIterator{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewSliceStackIterator(resourceIterator), nil
}

// GetImage3Ds creates a resource iterator instance with all image3d resources.
func (inst Model) GetImage3Ds() (Image3DIterator, error) {
	var resourceIterator ref
	ret := C.CCall_lib3mf_model_getimage3ds(inst.wrapperRef.LibraryHandle, inst.Ref, &resourceIterator)
	if ret != 0 {
		return Image3DIterator{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImage3DIterator(resourceIterator), nil
}

// MergeToModel merges all components and objects which are referenced by a build item into a mesh. The memory is duplicated and a new model is created.
func (inst Model) MergeToModel() (Model, error) {
	var mergedModelInstance ref
	ret := C.CCall_lib3mf_model_mergetomodel(inst.wrapperRef.LibraryHandle, inst.Ref, &mergedModelInstance)
	if ret != 0 {
		return Model{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewModel(mergedModelInstance), nil
}

// MergeFromModel merges the given model into this model.
func (inst Model) MergeFromModel(modelInstance Model) error {
	ret := C.CCall_lib3mf_model_mergefrommodel(inst.wrapperRef.LibraryHandle, inst.Ref, modelInstance.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// AddMeshObject adds an empty mesh object to the model.
func (inst Model) AddMeshObject() (MeshObject, error) {
	var meshObjectInstance ref
	ret := C.CCall_lib3mf_model_addmeshobject(inst.wrapperRef.LibraryHandle, inst.Ref, &meshObjectInstance)
	if ret != 0 {
		return MeshObject{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewMeshObject(meshObjectInstance), nil
}

// AddComponentsObject adds an empty component object to the model.
func (inst Model) AddComponentsObject() (ComponentsObject, error) {
	var componentsObjectInstance ref
	ret := C.CCall_lib3mf_model_addcomponentsobject(inst.wrapperRef.LibraryHandle, inst.Ref, &componentsObjectInstance)
	if ret != 0 {
		return ComponentsObject{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewComponentsObject(componentsObjectInstance), nil
}

// AddSliceStack creates a new model slicestack by its id.
func (inst Model) AddSliceStack(zBottom float64) (SliceStack, error) {
	var sliceStackInstance ref
	ret := C.CCall_lib3mf_model_addslicestack(inst.wrapperRef.LibraryHandle, inst.Ref, C.double(zBottom), &sliceStackInstance)
	if ret != 0 {
		return SliceStack{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewSliceStack(sliceStackInstance), nil
}

// AddTexture2DFromAttachment adds a texture2d resource to the model. Its path is given by that of an existing attachment.
func (inst Model) AddTexture2DFromAttachment(textureAttachment Attachment) (Texture2D, error) {
	var texture2DInstance ref
	ret := C.CCall_lib3mf_model_addtexture2dfromattachment(inst.wrapperRef.LibraryHandle, inst.Ref, textureAttachment.Ref, &texture2DInstance)
	if ret != 0 {
		return Texture2D{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewTexture2D(texture2DInstance), nil
}

// AddBaseMaterialGroup adds an empty BaseMaterialGroup resource to the model.
func (inst Model) AddBaseMaterialGroup() (BaseMaterialGroup, error) {
	var baseMaterialGroupInstance ref
	ret := C.CCall_lib3mf_model_addbasematerialgroup(inst.wrapperRef.LibraryHandle, inst.Ref, &baseMaterialGroupInstance)
	if ret != 0 {
		return BaseMaterialGroup{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewBaseMaterialGroup(baseMaterialGroupInstance), nil
}

// AddColorGroup adds an empty ColorGroup resource to the model.
func (inst Model) AddColorGroup() (ColorGroup, error) {
	var colorGroupInstance ref
	ret := C.CCall_lib3mf_model_addcolorgroup(inst.wrapperRef.LibraryHandle, inst.Ref, &colorGroupInstance)
	if ret != 0 {
		return ColorGroup{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewColorGroup(colorGroupInstance), nil
}

// AddTexture2DGroup adds an empty Texture2DGroup resource to the model.
func (inst Model) AddTexture2DGroup(texture2DInstance Texture2D) (Texture2DGroup, error) {
	var texture2DGroupInstance ref
	ret := C.CCall_lib3mf_model_addtexture2dgroup(inst.wrapperRef.LibraryHandle, inst.Ref, texture2DInstance.Ref, &texture2DGroupInstance)
	if ret != 0 {
		return Texture2DGroup{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewTexture2DGroup(texture2DGroupInstance), nil
}

// AddCompositeMaterials adds an empty CompositeMaterials resource to the model.
func (inst Model) AddCompositeMaterials(baseMaterialGroupInstance BaseMaterialGroup) (CompositeMaterials, error) {
	var compositeMaterialsInstance ref
	ret := C.CCall_lib3mf_model_addcompositematerials(inst.wrapperRef.LibraryHandle, inst.Ref, baseMaterialGroupInstance.Ref, &compositeMaterialsInstance)
	if ret != 0 {
		return CompositeMaterials{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewCompositeMaterials(compositeMaterialsInstance), nil
}

// AddMultiPropertyGroup adds an empty MultiPropertyGroup resource to the model.
func (inst Model) AddMultiPropertyGroup() (MultiPropertyGroup, error) {
	var multiPropertyGroupInstance ref
	ret := C.CCall_lib3mf_model_addmultipropertygroup(inst.wrapperRef.LibraryHandle, inst.Ref, &multiPropertyGroupInstance)
	if ret != 0 {
		return MultiPropertyGroup{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewMultiPropertyGroup(multiPropertyGroupInstance), nil
}

// AddImageStack creates a new 3D Image Resource.
func (inst Model) AddImageStack(columnCount uint32, rowCount uint32, sheetCount uint32) (ImageStack, error) {
	var instance ref
	ret := C.CCall_lib3mf_model_addimagestack(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(columnCount), C.uint32_t(rowCount), C.uint32_t(sheetCount), &instance)
	if ret != 0 {
		return ImageStack{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImageStack(instance), nil
}

// GetImageStackByID finds an ImageStack object by its UniqueResourceID.
func (inst Model) GetImageStackByID(uniqueResourceID uint32) (ImageStack, error) {
	var imageStackInstance ref
	ret := C.CCall_lib3mf_model_getimagestackbyid(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(uniqueResourceID), &imageStackInstance)
	if ret != 0 {
		return ImageStack{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImageStack(imageStackInstance), nil
}

// AddBuildItem adds a build item to the model.
func (inst Model) AddBuildItem(object Object, transform Transform) (BuildItem, error) {
	var buildItemInstance ref
	ret := C.CCall_lib3mf_model_addbuilditem(inst.wrapperRef.LibraryHandle, inst.Ref, object.Ref, (*C.sLib3MFTransform)(unsafe.Pointer(&transform)), &buildItemInstance)
	if ret != 0 {
		return BuildItem{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewBuildItem(buildItemInstance), nil
}

// RemoveBuildItem removes a build item from the model.
func (inst Model) RemoveBuildItem(buildItemInstance BuildItem) error {
	ret := C.CCall_lib3mf_model_removebuilditem(inst.wrapperRef.LibraryHandle, inst.Ref, buildItemInstance.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetMetaDataGroup returns the metadata of the model as MetaDataGroup.
func (inst Model) GetMetaDataGroup() (MetaDataGroup, error) {
	var theMetaDataGroup ref
	ret := C.CCall_lib3mf_model_getmetadatagroup(inst.wrapperRef.LibraryHandle, inst.Ref, &theMetaDataGroup)
	if ret != 0 {
		return MetaDataGroup{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewMetaDataGroup(theMetaDataGroup), nil
}

// AddAttachment adds an attachment stream to the model. The OPC part will be related to the model stream with a certain relationship type.
func (inst Model) AddAttachment(uRI string, relationShipType string) (Attachment, error) {
	var attachmentInstance ref
	ret := C.CCall_lib3mf_model_addattachment(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(uRI)[0])), (*C.char)(unsafe.Pointer(&[]byte(relationShipType)[0])), &attachmentInstance)
	if ret != 0 {
		return Attachment{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewAttachment(attachmentInstance), nil
}

// RemoveAttachment removes attachment from the model.
func (inst Model) RemoveAttachment(attachmentInstance Attachment) error {
	ret := C.CCall_lib3mf_model_removeattachment(inst.wrapperRef.LibraryHandle, inst.Ref, attachmentInstance.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetAttachment retrieves an attachment stream object from the model..
func (inst Model) GetAttachment(index uint32) (Attachment, error) {
	var attachmentInstance ref
	ret := C.CCall_lib3mf_model_getattachment(inst.wrapperRef.LibraryHandle, inst.Ref, C.uint32_t(index), &attachmentInstance)
	if ret != 0 {
		return Attachment{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewAttachment(attachmentInstance), nil
}

// FindAttachment retrieves an attachment stream object from the model.
func (inst Model) FindAttachment(uRI string) (Attachment, error) {
	var attachmentInstance ref
	ret := C.CCall_lib3mf_model_findattachment(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(uRI)[0])), &attachmentInstance)
	if ret != 0 {
		return Attachment{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewAttachment(attachmentInstance), nil
}

// GetAttachmentCount retrieves the number of attachments of the model.
func (inst Model) GetAttachmentCount() (uint32, error) {
	var attachmentCount C.uint32_t
	ret := C.CCall_lib3mf_model_getattachmentcount(inst.wrapperRef.LibraryHandle, inst.Ref, &attachmentCount)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uint32(attachmentCount), nil
}

// HasPackageThumbnailAttachment retrieve whether the OPC package contains a package thumbnail.
func (inst Model) HasPackageThumbnailAttachment() (bool, error) {
	var hasThumbnail C.bool
	ret := C.CCall_lib3mf_model_haspackagethumbnailattachment(inst.wrapperRef.LibraryHandle, inst.Ref, &hasThumbnail)
	if ret != 0 {
		return false, makeError(uint32(ret))
	}
	return bool(hasThumbnail), nil
}

// CreatePackageThumbnailAttachment create a new or the existing package thumbnail for the OPC package.
func (inst Model) CreatePackageThumbnailAttachment() (Attachment, error) {
	var attachment ref
	ret := C.CCall_lib3mf_model_createpackagethumbnailattachment(inst.wrapperRef.LibraryHandle, inst.Ref, &attachment)
	if ret != 0 {
		return Attachment{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewAttachment(attachment), nil
}

// GetPackageThumbnailAttachment get the attachment to the OPC package containing the package thumbnail.
func (inst Model) GetPackageThumbnailAttachment() (*Attachment, error) {
	var attachment ref
	ret := C.CCall_lib3mf_model_getpackagethumbnailattachment(inst.wrapperRef.LibraryHandle, inst.Ref, &attachment)
	if ret != 0 {
		return nil, makeError(uint32(ret))
	}
	var _attachmentPtr *Attachment
	if attachment != nil {
		_attachmentPtrVal := inst.wrapperRef.NewAttachment(attachment)
		_attachmentPtr = &_attachmentPtrVal
	}
	return _attachmentPtr, nil
}

// RemovePackageThumbnailAttachment remove the attachment to the OPC package containing the package thumbnail.
func (inst Model) RemovePackageThumbnailAttachment() error {
	ret := C.CCall_lib3mf_model_removepackagethumbnailattachment(inst.wrapperRef.LibraryHandle, inst.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// AddCustomContentType adds a new Content Type to the model.
func (inst Model) AddCustomContentType(extension string, contentType string) error {
	ret := C.CCall_lib3mf_model_addcustomcontenttype(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(extension)[0])), (*C.char)(unsafe.Pointer(&[]byte(contentType)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// RemoveCustomContentType removes a custom Content Type from the model (UTF8 version).
func (inst Model) RemoveCustomContentType(extension string) error {
	ret := C.CCall_lib3mf_model_removecustomcontenttype(inst.wrapperRef.LibraryHandle, inst.Ref, (*C.char)(unsafe.Pointer(&[]byte(extension)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// SetRandomNumberCallback sets the random number generator callback for use in the library.
func (inst Model) SetRandomNumberCallback(theCallback RandomNumberCallbackFunc, userData uintptr) error {
	ret := C.CCall_lib3mf_model_setrandomnumbercallback(inst.wrapperRef.LibraryHandle, inst.Ref, (C.Lib3MFRandomNumberCallback)(unsafe.Pointer(&theCallback)), (C.Lib3MF_pvoid)(userData))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	randomNumberCallbackFunc = theCallback
	return nil
}

// GetKeyStore gets the keystore associated with this model.
func (inst Model) GetKeyStore() (KeyStore, error) {
	var keyStore ref
	ret := C.CCall_lib3mf_model_getkeystore(inst.wrapperRef.LibraryHandle, inst.Ref, &keyStore)
	if ret != 0 {
		return KeyStore{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewKeyStore(keyStore), nil
}

// GetFunctions creates a resource iterator for all functions.
func (inst Model) GetFunctions() (FunctionIterator, error) {
	var theResourceIterator ref
	ret := C.CCall_lib3mf_model_getfunctions(inst.wrapperRef.LibraryHandle, inst.Ref, &theResourceIterator)
	if ret != 0 {
		return FunctionIterator{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewFunctionIterator(theResourceIterator), nil
}

// AddImplicitFunction adds a function described by nodes to the model.
func (inst Model) AddImplicitFunction() (ImplicitFunction, error) {
	var functionInstance ref
	ret := C.CCall_lib3mf_model_addimplicitfunction(inst.wrapperRef.LibraryHandle, inst.Ref, &functionInstance)
	if ret != 0 {
		return ImplicitFunction{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewImplicitFunction(functionInstance), nil
}

// AddFunctionFromImage3D adds a function defined by an image3d to the model.
func (inst Model) AddFunctionFromImage3D(image3DInstance Image3D) (FunctionFromImage3D, error) {
	var functionInstance ref
	ret := C.CCall_lib3mf_model_addfunctionfromimage3d(inst.wrapperRef.LibraryHandle, inst.Ref, image3DInstance.Ref, &functionInstance)
	if ret != 0 {
		return FunctionFromImage3D{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewFunctionFromImage3D(functionInstance), nil
}

// AddVolumeData adds a volume data resource to the model.
func (inst Model) AddVolumeData() (VolumeData, error) {
	var volumeDataInstance ref
	ret := C.CCall_lib3mf_model_addvolumedata(inst.wrapperRef.LibraryHandle, inst.Ref, &volumeDataInstance)
	if ret != 0 {
		return VolumeData{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewVolumeData(volumeDataInstance), nil
}

// AddLevelSet adds an empty boundary shape object to the model.
func (inst Model) AddLevelSet() (LevelSet, error) {
	var levelSetInstance ref
	ret := C.CCall_lib3mf_model_addlevelset(inst.wrapperRef.LibraryHandle, inst.Ref, &levelSetInstance)
	if ret != 0 {
		return LevelSet{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewLevelSet(levelSetInstance), nil
}

// GetLevelSets creates a resource iterator instance with all boundary shape resources.
func (inst Model) GetLevelSets() (LevelSetIterator, error) {
	var resourceIterator ref
	ret := C.CCall_lib3mf_model_getlevelsets(inst.wrapperRef.LibraryHandle, inst.Ref, &resourceIterator)
	if ret != 0 {
		return LevelSetIterator{}, makeError(uint32(ret))
	}
	return inst.wrapperRef.NewLevelSetIterator(resourceIterator), nil
}

// RemoveResource removes a resource from the model.
func (inst Model) RemoveResource(resource Resource) error {
	ret := C.CCall_lib3mf_model_removeresource(inst.wrapperRef.LibraryHandle, inst.Ref, resource.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}


// GetLibraryVersion retrieves the binary version of this library.
func (wrapper Wrapper) GetLibraryVersion() (uint32, uint32, uint32, error) {
	var major C.uint32_t
	var minor C.uint32_t
	var micro C.uint32_t
	ret := C.CCall_lib3mf_getlibraryversion(wrapper.LibraryHandle, &major, &minor, &micro)
	if ret != 0 {
		return 0, 0, 0, makeError(uint32(ret))
	}
	return uint32(major), uint32(minor), uint32(micro), nil
}

// GetPrereleaseInformation retrieves prerelease information of this library.
func (wrapper Wrapper) GetPrereleaseInformation() (bool, string, error) {
	var hasPrereleaseInfo C.bool
	var neededforprereleaseInfo C.uint32_t
	var filledinprereleaseInfo C.uint32_t
	ret := C.CCall_lib3mf_getprereleaseinformation(wrapper.LibraryHandle, &hasPrereleaseInfo, 0, &neededforprereleaseInfo, nil)
	if ret != 0 {
		return false, "", makeError(uint32(ret))
	}
	bufferSizeprereleaseInfo := neededforprereleaseInfo
	bufferprereleaseInfo := make([]byte, bufferSizeprereleaseInfo)
	ret = C.CCall_lib3mf_getprereleaseinformation(wrapper.LibraryHandle, &hasPrereleaseInfo, bufferSizeprereleaseInfo, &filledinprereleaseInfo, (*C.char)(unsafe.Pointer(&bufferprereleaseInfo[0])))
	if ret != 0 {
		return false, "", makeError(uint32(ret))
	}
	return bool(hasPrereleaseInfo), string(bufferprereleaseInfo[:(filledinprereleaseInfo-1)]), nil
}

// GetBuildInformation retrieves build information of this library.
func (wrapper Wrapper) GetBuildInformation() (bool, string, error) {
	var hasBuildInfo C.bool
	var neededforbuildInformation C.uint32_t
	var filledinbuildInformation C.uint32_t
	ret := C.CCall_lib3mf_getbuildinformation(wrapper.LibraryHandle, &hasBuildInfo, 0, &neededforbuildInformation, nil)
	if ret != 0 {
		return false, "", makeError(uint32(ret))
	}
	bufferSizebuildInformation := neededforbuildInformation
	bufferbuildInformation := make([]byte, bufferSizebuildInformation)
	ret = C.CCall_lib3mf_getbuildinformation(wrapper.LibraryHandle, &hasBuildInfo, bufferSizebuildInformation, &filledinbuildInformation, (*C.char)(unsafe.Pointer(&bufferbuildInformation[0])))
	if ret != 0 {
		return false, "", makeError(uint32(ret))
	}
	return bool(hasBuildInfo), string(bufferbuildInformation[:(filledinbuildInformation-1)]), nil
}

// GetSpecificationVersion retrieves whether a specification is supported, and if so, which version.
func (wrapper Wrapper) GetSpecificationVersion(specificationURL string) (bool, uint32, uint32, uint32, error) {
	var isSupported C.bool
	var major C.uint32_t
	var minor C.uint32_t
	var micro C.uint32_t
	ret := C.CCall_lib3mf_getspecificationversion(wrapper.LibraryHandle, (*C.char)(unsafe.Pointer(&[]byte(specificationURL)[0])), &isSupported, &major, &minor, &micro)
	if ret != 0 {
		return false, 0, 0, 0, makeError(uint32(ret))
	}
	return bool(isSupported), uint32(major), uint32(minor), uint32(micro), nil
}

// CreateModel creates an empty model instance.
func (wrapper Wrapper) CreateModel() (Model, error) {
	var model ref
	ret := C.CCall_lib3mf_createmodel(wrapper.LibraryHandle, &model)
	if ret != 0 {
		return Model{}, makeError(uint32(ret))
	}
	return wrapper.NewModel(model), nil
}

// Release releases shared ownership of an object instance.
func (wrapper Wrapper) Release(instance Base) error {
	ret := C.CCall_lib3mf_release(wrapper.LibraryHandle, instance.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// Acquire acquires shared ownership of an object instance.
func (wrapper Wrapper) Acquire(instance Base) error {
	ret := C.CCall_lib3mf_acquire(wrapper.LibraryHandle, instance.Ref)
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// SetJournal sets the journal file path.
func (wrapper Wrapper) SetJournal(journalPath string) error {
	ret := C.CCall_lib3mf_setjournal(wrapper.LibraryHandle, (*C.char)(unsafe.Pointer(&[]byte(journalPath)[0])))
	if ret != 0 {
		return makeError(uint32(ret))
	}
	return nil
}

// GetLastError retrieves the last error string of an instance.
func (wrapper Wrapper) GetLastError(instance Base) (string, bool, error) {
	var neededforlastErrorString C.uint32_t
	var filledinlastErrorString C.uint32_t
	var hasLastError C.bool
	ret := C.CCall_lib3mf_getlasterror(wrapper.LibraryHandle, instance.Ref, 0, &neededforlastErrorString, nil, &hasLastError)
	if ret != 0 {
		return "", false, makeError(uint32(ret))
	}
	bufferSizelastErrorString := neededforlastErrorString
	bufferlastErrorString := make([]byte, bufferSizelastErrorString)
	ret = C.CCall_lib3mf_getlasterror(wrapper.LibraryHandle, instance.Ref, bufferSizelastErrorString, &filledinlastErrorString, (*C.char)(unsafe.Pointer(&bufferlastErrorString[0])), &hasLastError)
	if ret != 0 {
		return "", false, makeError(uint32(ret))
	}
	return string(bufferlastErrorString[:(filledinlastErrorString-1)]), bool(hasLastError), nil
}

// GetSymbolLookupMethod returns the address of the SymbolLookupMethod.
func (wrapper Wrapper) GetSymbolLookupMethod() (uintptr, error) {
	var symbolLookupMethod C.Lib3MF_pvoid
	ret := C.CCall_lib3mf_getsymbollookupmethod(wrapper.LibraryHandle, &symbolLookupMethod)
	if ret != 0 {
		return 0, makeError(uint32(ret))
	}
	return uintptr(symbolLookupMethod), nil
}

// RetrieveProgressMessage return an English text for a progress identifier.|Note: this is the only function you can call from your callback function.
func (wrapper Wrapper) RetrieveProgressMessage(theProgressIdentifier ProgressIdentifier) (string, error) {
	var neededforprogressMessage C.uint32_t
	var filledinprogressMessage C.uint32_t
	ret := C.CCall_lib3mf_retrieveprogressmessage(wrapper.LibraryHandle, C.eLib3MFProgressIdentifier(theProgressIdentifier), 0, &neededforprogressMessage, nil)
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	bufferSizeprogressMessage := neededforprogressMessage
	bufferprogressMessage := make([]byte, bufferSizeprogressMessage)
	ret = C.CCall_lib3mf_retrieveprogressmessage(wrapper.LibraryHandle, C.eLib3MFProgressIdentifier(theProgressIdentifier), bufferSizeprogressMessage, &filledinprogressMessage, (*C.char)(unsafe.Pointer(&bufferprogressMessage[0])))
	if ret != 0 {
		return "", makeError(uint32(ret))
	}
	return string(bufferprogressMessage[:(filledinprogressMessage-1)]), nil
}

// RGBAToColor creates a Color from uint8 RGBA values.
func (wrapper Wrapper) RGBAToColor(red uint8, green uint8, blue uint8, alpha uint8) (Color, error) {
	var theColor C.sLib3MFColor
	ret := C.CCall_lib3mf_rgbatocolor(wrapper.LibraryHandle, C.uint8_t(red), C.uint8_t(green), C.uint8_t(blue), C.uint8_t(alpha), &theColor)
	if ret != 0 {
		return Color{}, makeError(uint32(ret))
	}
	return *(*Color)(unsafe.Pointer(&theColor)), nil
}

// FloatRGBAToColor creates a Color from uint8 RGBA values.
func (wrapper Wrapper) FloatRGBAToColor(red float32, green float32, blue float32, alpha float32) (Color, error) {
	var theColor C.sLib3MFColor
	ret := C.CCall_lib3mf_floatrgbatocolor(wrapper.LibraryHandle, C.float(red), C.float(green), C.float(blue), C.float(alpha), &theColor)
	if ret != 0 {
		return Color{}, makeError(uint32(ret))
	}
	return *(*Color)(unsafe.Pointer(&theColor)), nil
}

// ColorToRGBA calculates uint8-RGBA-values from a Color.
func (wrapper Wrapper) ColorToRGBA(theColor Color) (uint8, uint8, uint8, uint8, error) {
	var red C.uint8_t
	var green C.uint8_t
	var blue C.uint8_t
	var alpha C.uint8_t
	ret := C.CCall_lib3mf_colortorgba(wrapper.LibraryHandle, (*C.sLib3MFColor)(unsafe.Pointer(&theColor)), &red, &green, &blue, &alpha)
	if ret != 0 {
		return 0, 0, 0, 0, makeError(uint32(ret))
	}
	return uint8(red), uint8(green), uint8(blue), uint8(alpha), nil
}

// ColorToFloatRGBA calculates float-RGBA-values from a Color.
func (wrapper Wrapper) ColorToFloatRGBA(theColor Color) (float32, float32, float32, float32, error) {
	var red C.float
	var green C.float
	var blue C.float
	var alpha C.float
	ret := C.CCall_lib3mf_colortofloatrgba(wrapper.LibraryHandle, (*C.sLib3MFColor)(unsafe.Pointer(&theColor)), &red, &green, &blue, &alpha)
	if ret != 0 {
		return 0, 0, 0, 0, makeError(uint32(ret))
	}
	return float32(red), float32(green), float32(blue), float32(alpha), nil
}

// GetIdentityTransform creates an identity transform.
func (wrapper Wrapper) GetIdentityTransform() (Transform, error) {
	var transform C.sLib3MFTransform
	ret := C.CCall_lib3mf_getidentitytransform(wrapper.LibraryHandle, &transform)
	if ret != 0 {
		return Transform{}, makeError(uint32(ret))
	}
	return *(*Transform)(unsafe.Pointer(&transform)), nil
}

// GetUniformScaleTransform creates a uniform scale transform.
func (wrapper Wrapper) GetUniformScaleTransform(factor float32) (Transform, error) {
	var transform C.sLib3MFTransform
	ret := C.CCall_lib3mf_getuniformscaletransform(wrapper.LibraryHandle, C.float(factor), &transform)
	if ret != 0 {
		return Transform{}, makeError(uint32(ret))
	}
	return *(*Transform)(unsafe.Pointer(&transform)), nil
}

// GetScaleTransform creates a scale transform.
func (wrapper Wrapper) GetScaleTransform(factorX float32, factorY float32, factorZ float32) (Transform, error) {
	var transform C.sLib3MFTransform
	ret := C.CCall_lib3mf_getscaletransform(wrapper.LibraryHandle, C.float(factorX), C.float(factorY), C.float(factorZ), &transform)
	if ret != 0 {
		return Transform{}, makeError(uint32(ret))
	}
	return *(*Transform)(unsafe.Pointer(&transform)), nil
}

// GetTranslationTransform creates an translation transform.
func (wrapper Wrapper) GetTranslationTransform(vectorX float32, vectorY float32, vectorZ float32) (Transform, error) {
	var transform C.sLib3MFTransform
	ret := C.CCall_lib3mf_gettranslationtransform(wrapper.LibraryHandle, C.float(vectorX), C.float(vectorY), C.float(vectorZ), &transform)
	if ret != 0 {
		return Transform{}, makeError(uint32(ret))
	}
	return *(*Transform)(unsafe.Pointer(&transform)), nil
}

func (wrapper Wrapper) releaseC(r *ref) error {
	if r == nil || *r == nil {
		return nil
	}
	return wrapper.Release(Base{Ref: *r})
}

func (wrapper Wrapper) CheckBinaryVersion() error {
	var nBindingMajor uint32 = 2;
	var nBindingMinor uint32 = 4;
	nMajor, nMinor, _, err := wrapper.GetLibraryVersion()
	if err != nil {
		return err;
	}
	if (nMajor != nBindingMajor) || (nMinor < nBindingMinor) {
		return makeError(0)
	}
	return nil
}

func LoadLibrary (libraryPath string) (Wrapper, error) {
	var wrapper Wrapper;
	wrapper.LibraryHandle = C.loadLib3MFLibrary (C.CString (libraryPath));
	if (wrapper.LibraryHandle == nil) {
		return wrapper, makeError (LIB3MF_ERROR_COULDNOTLOADLIBRARY)
	}
	
	return wrapper, nil
	
}
