/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.nativeintegration.jansi;

import java.io.File;
import org.fusesource.jansi.Ansi;
import org.gradle.internal.nativeintegration.jansi.JansiLibrary;
import org.gradle.internal.nativeintegration.jansi.JansiLibraryFactory;
import org.gradle.internal.nativeintegration.jansi.JansiStorage;

public class JansiStorageLocator {
    private JansiLibraryFactory factory = new JansiLibraryFactory();

    void setFactory(JansiLibraryFactory factory) {
        this.factory = factory;
    }

    public JansiStorage locate(File storageDir) {
        JansiLibrary jansiLibrary = this.factory.create();
        if (jansiLibrary != null) {
            File jansiDir = this.makeVersionSpecificDir(storageDir);
            File targetLibFile = new File(jansiDir, jansiLibrary.getPath());
            return new JansiStorage(jansiLibrary, targetLibFile);
        }
        return null;
    }

    private File makeVersionSpecificDir(File storageDir) {
        String jansiVersion = Ansi.class.getPackage().getImplementationVersion();
        return new File(storageDir, "jansi/" + jansiVersion);
    }
}

