/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.echosvg.bridge.RhinoInterpreter;
import io.sf.carte.echosvg.bridge.SVG12RhinoInterpreter;
import io.sf.carte.echosvg.script.ImportInfo;
import io.sf.carte.echosvg.script.Interpreter;
import io.sf.carte.echosvg.script.InterpreterFactory;
import java.net.URL;

public class RhinoInterpreterFactory
implements InterpreterFactory {
    public static final String[] RHINO_MIMETYPES = new String[]{"application/ecmascript", "application/javascript", "text/ecmascript", "text/javascript"};

    public String[] getMimeTypes() {
        return RHINO_MIMETYPES;
    }

    public Interpreter createInterpreter(URL documentURL, boolean svg12) {
        return this.createInterpreter(documentURL, svg12, null);
    }

    public Interpreter createInterpreter(URL documentURL, boolean svg12, ImportInfo imports) {
        if (svg12) {
            return new SVG12RhinoInterpreter(documentURL, imports);
        }
        return new RhinoInterpreter(documentURL, imports);
    }
}

