/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css;

import io.sf.carte.doc.style.css.CSSStyleDeclaration;
import io.sf.carte.doc.style.css.CSSUnit;
import java.text.NumberFormat;
import java.util.Locale;

public interface BoxValues {
    public float getMarginTop();

    public float getMarginRight();

    public float getMarginBottom();

    public float getMarginLeft();

    public float getPaddingTop();

    public float getPaddingRight();

    public float getPaddingBottom();

    public float getPaddingLeft();

    public float getBorderTopWidth();

    public float getBorderRightWidth();

    public float getBorderBottomWidth();

    public float getBorderLeftWidth();

    public float getWidth();

    public short getUnitType();

    default public void fillBoxValues(CSSStyleDeclaration style) {
        NumberFormat format = NumberFormat.getNumberInstance(Locale.ROOT);
        format.setMinimumFractionDigits(0);
        format.setMaximumFractionDigits(4);
        String unitStr = CSSUnit.dimensionUnitString(this.getUnitType());
        style.setProperty("margin-top", format.format(this.getMarginTop()) + unitStr, null);
        style.setProperty("margin-right", format.format(this.getMarginRight()) + unitStr, null);
        style.setProperty("margin-bottom", format.format(this.getMarginBottom()) + unitStr, null);
        style.setProperty("margin-left", format.format(this.getMarginLeft()) + unitStr, null);
        style.setProperty("padding-top", format.format(this.getPaddingTop()) + unitStr, null);
        style.setProperty("padding-right", format.format(this.getPaddingRight()) + unitStr, null);
        style.setProperty("padding-bottom", format.format(this.getPaddingBottom()) + unitStr, null);
        style.setProperty("padding-left", format.format(this.getPaddingLeft()) + unitStr, null);
        style.setProperty("border-top-width", format.format(this.getBorderTopWidth()) + unitStr, null);
        style.setProperty("border-right-width", format.format(this.getBorderRightWidth()) + unitStr, null);
        style.setProperty("border-bottom-width", format.format(this.getBorderBottomWidth()) + unitStr, null);
        style.setProperty("border-left-width", format.format(this.getBorderLeftWidth()) + unitStr, null);
        style.setProperty("width", format.format(this.getWidth()) + unitStr, null);
    }

    public static interface TableBoxValues
    extends BoxValues {
        public float[] getColumnsContentWidth();
    }
}

