/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.crt.internal;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.crt.http.HttpClientConnectionManager;
import software.amazon.awssdk.http.async.AsyncExecuteRequest;
import software.amazon.awssdk.metrics.MetricCollector;

@SdkInternalApi
public final class CrtAsyncRequestContext {
    private final AsyncExecuteRequest request;
    private final long readBufferSize;
    private final HttpClientConnectionManager crtConnPool;
    private final MetricCollector metricCollector;

    private CrtAsyncRequestContext(Builder builder) {
        this.request = builder.request;
        this.readBufferSize = builder.readBufferSize;
        this.crtConnPool = builder.crtConnPool;
        this.metricCollector = this.request.metricCollector().orElse(null);
    }

    public static Builder builder() {
        return new Builder();
    }

    public AsyncExecuteRequest sdkRequest() {
        return this.request;
    }

    public long readBufferSize() {
        return this.readBufferSize;
    }

    public HttpClientConnectionManager crtConnPool() {
        return this.crtConnPool;
    }

    public MetricCollector metricCollector() {
        return this.metricCollector;
    }

    public static final class Builder {
        private AsyncExecuteRequest request;
        private long readBufferSize;
        private HttpClientConnectionManager crtConnPool;

        private Builder() {
        }

        public Builder request(AsyncExecuteRequest request) {
            this.request = request;
            return this;
        }

        public Builder readBufferSize(long readBufferSize) {
            this.readBufferSize = readBufferSize;
            return this;
        }

        public Builder crtConnPool(HttpClientConnectionManager crtConnPool) {
            this.crtConnPool = crtConnPool;
            return this;
        }

        public CrtAsyncRequestContext build() {
            return new CrtAsyncRequestContext(this);
        }
    }
}

