/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseTokensRequest;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelTokensRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CountTokensInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CountTokensInput> {
    private static final SdkField<InvokeModelTokensRequest> INVOKE_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("invokeModel").getter(CountTokensInput.getter(CountTokensInput::invokeModel)).setter(CountTokensInput.setter(Builder::invokeModel)).constructor(InvokeModelTokensRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invokeModel").build()}).build();
    private static final SdkField<ConverseTokensRequest> CONVERSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("converse").getter(CountTokensInput.getter(CountTokensInput::converse)).setter(CountTokensInput.setter(Builder::converse)).constructor(ConverseTokensRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("converse").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVOKE_MODEL_FIELD, CONVERSE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CountTokensInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final InvokeModelTokensRequest invokeModel;
    private final ConverseTokensRequest converse;
    private final Type type;

    private CountTokensInput(BuilderImpl builder) {
        this.invokeModel = builder.invokeModel;
        this.converse = builder.converse;
        this.type = builder.type;
    }

    public final InvokeModelTokensRequest invokeModel() {
        return this.invokeModel;
    }

    public final ConverseTokensRequest converse() {
        return this.converse;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.invokeModel());
        hashCode = 31 * hashCode + Objects.hashCode(this.converse());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CountTokensInput)) {
            return false;
        }
        CountTokensInput other = (CountTokensInput)obj;
        return Objects.equals(this.invokeModel(), other.invokeModel()) && Objects.equals(this.converse(), other.converse());
    }

    public final String toString() {
        return ToString.builder((String)"CountTokensInput").add("InvokeModel", (Object)this.invokeModel()).add("Converse", (Object)this.converse()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "invokeModel": {
                return Optional.ofNullable(clazz.cast(this.invokeModel()));
            }
            case "converse": {
                return Optional.ofNullable(clazz.cast(this.converse()));
            }
        }
        return Optional.empty();
    }

    public static CountTokensInput fromInvokeModel(InvokeModelTokensRequest invokeModel) {
        return (CountTokensInput)CountTokensInput.builder().invokeModel(invokeModel).build();
    }

    public static CountTokensInput fromInvokeModel(Consumer<InvokeModelTokensRequest.Builder> invokeModel) {
        InvokeModelTokensRequest.Builder builder = InvokeModelTokensRequest.builder();
        invokeModel.accept(builder);
        return CountTokensInput.fromInvokeModel((InvokeModelTokensRequest)builder.build());
    }

    public static CountTokensInput fromConverse(ConverseTokensRequest converse) {
        return (CountTokensInput)CountTokensInput.builder().converse(converse).build();
    }

    public static CountTokensInput fromConverse(Consumer<ConverseTokensRequest.Builder> converse) {
        ConverseTokensRequest.Builder builder = ConverseTokensRequest.builder();
        converse.accept(builder);
        return CountTokensInput.fromConverse((ConverseTokensRequest)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("invokeModel", INVOKE_MODEL_FIELD);
        map.put("converse", CONVERSE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CountTokensInput, T> g) {
        return obj -> g.apply((CountTokensInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        INVOKE_MODEL,
        CONVERSE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private InvokeModelTokensRequest invokeModel;
        private ConverseTokensRequest converse;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(CountTokensInput model) {
            this.invokeModel(model.invokeModel);
            this.converse(model.converse);
        }

        public final InvokeModelTokensRequest.Builder getInvokeModel() {
            return this.invokeModel != null ? this.invokeModel.toBuilder() : null;
        }

        public final void setInvokeModel(InvokeModelTokensRequest.BuilderImpl invokeModel) {
            InvokeModelTokensRequest oldValue = this.invokeModel;
            this.invokeModel = invokeModel != null ? invokeModel.build() : null;
            this.handleUnionValueChange(Type.INVOKE_MODEL, oldValue, this.invokeModel);
        }

        @Override
        public final Builder invokeModel(InvokeModelTokensRequest invokeModel) {
            InvokeModelTokensRequest oldValue = this.invokeModel;
            this.invokeModel = invokeModel;
            this.handleUnionValueChange(Type.INVOKE_MODEL, oldValue, this.invokeModel);
            return this;
        }

        public final ConverseTokensRequest.Builder getConverse() {
            return this.converse != null ? this.converse.toBuilder() : null;
        }

        public final void setConverse(ConverseTokensRequest.BuilderImpl converse) {
            ConverseTokensRequest oldValue = this.converse;
            this.converse = converse != null ? converse.build() : null;
            this.handleUnionValueChange(Type.CONVERSE, oldValue, this.converse);
        }

        @Override
        public final Builder converse(ConverseTokensRequest converse) {
            ConverseTokensRequest oldValue = this.converse;
            this.converse = converse;
            this.handleUnionValueChange(Type.CONVERSE, oldValue, this.converse);
            return this;
        }

        public CountTokensInput build() {
            return new CountTokensInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CountTokensInput> {
        public Builder invokeModel(InvokeModelTokensRequest var1);

        default public Builder invokeModel(Consumer<InvokeModelTokensRequest.Builder> invokeModel) {
            return this.invokeModel((InvokeModelTokensRequest)((InvokeModelTokensRequest.Builder)InvokeModelTokensRequest.builder().applyMutation(invokeModel)).build());
        }

        public Builder converse(ConverseTokensRequest var1);

        default public Builder converse(Consumer<ConverseTokensRequest.Builder> converse) {
            return this.converse((ConverseTokensRequest)((ConverseTokensRequest.Builder)ConverseTokensRequest.builder().applyMutation(converse)).build());
        }
    }
}

