/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Vector;
import java.util.stream.Collectors;
import javax.swing.JFrame;
import mediathek.config.Daten;
import mediathek.config.MVConfig;
import mediathek.controller.history.AboHistoryController;
import mediathek.controller.starter.Start;
import mediathek.daten.DatenDownload;
import mediathek.daten.DatenFilm;
import mediathek.daten.DatenPset;
import mediathek.daten.DownloadStartInfo;
import mediathek.daten.FilmResolution;
import mediathek.daten.ListeAbo;
import mediathek.daten.ListeFilme;
import mediathek.daten.abo.DatenAbo;
import mediathek.daten.blacklist.ListeBlacklist;
import mediathek.gui.dialog.DialogAboNoSet;
import mediathek.gui.messages.ButtonStartEvent;
import mediathek.gui.messages.DownloadListChangedEvent;
import mediathek.gui.messages.DownloadQueueRankChangedEvent;
import mediathek.gui.messages.StartEvent;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.MessageBus;
import mediathek.tool.models.TModelDownload;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ListeDownloads
extends LinkedList<DatenDownload> {
    private static final Logger logger = LogManager.getLogger(ListeDownloads.class);

    public synchronized void addMitNummer(DatenDownload e) {
        this.add(e);
        this.listeNummerieren();
    }

    public synchronized void filmEintragen() {
        logger.info("Filme in Downloads eintragen");
        ListeFilme listeFilme = Daten.getInstance().getListeFilme();
        this.stream().filter(d -> d.film == null).forEach(d -> {
            d.film = listeFilme.getFilmByUrl_klein_hoch_hd(d.arr[21]);
            d.setGroesse("");
        });
    }

    public synchronized void listePutzen() {
        boolean gefunden = false;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            DatenDownload d = (DatenDownload)it.next();
            if (d.start == null) continue;
            if (d.start.status == 3) {
                it.remove();
                gefunden = true;
                continue;
            }
            if (d.start.status != 4) continue;
            d.resetDownload();
            gefunden = true;
        }
        if (gefunden) {
            MessageBus.getMessageBus().publishAsync((Object)new DownloadListChangedEvent());
        }
    }

    public synchronized void listePutzen(DatenDownload datenDownload) {
        boolean gefunden = false;
        if (datenDownload.start != null) {
            if (datenDownload.start.status == 3) {
                this.remove(datenDownload);
                gefunden = true;
            } else if (datenDownload.start.status == 4) {
                datenDownload.resetDownload();
                gefunden = true;
            }
        }
        if (gefunden) {
            MessageBus.getMessageBus().publishAsync((Object)new DownloadListChangedEvent());
        }
    }

    public synchronized void abosAuffrischen() {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            DatenDownload d2 = (DatenDownload)it.next();
            if (d2.isInterrupted()) {
                d2.setGroesseFromFilm();
                continue;
            }
            if (!d2.isFromAbo()) continue;
            if (d2.start == null) {
                it.remove();
                continue;
            }
            if (d2.start.status != 4) continue;
            d2.resetDownload();
        }
        this.forEach(d -> {
            d.arr[34] = Boolean.FALSE.toString();
        });
    }

    public synchronized long unfinishedDownloads() {
        return this.stream().filter(DatenDownload::runNotFinished).count();
    }

    public synchronized void downloadsVorziehen(ArrayList<DatenDownload> download) {
        for (DatenDownload datenDownload : download) {
            this.remove(datenDownload);
            this.addFirst(datenDownload);
        }
        MessageBus.getMessageBus().publishAsync((Object)new DownloadQueueRankChangedEvent());
    }

    public synchronized void delDownloadButton(String url) {
        for (DatenDownload datenDownload : this) {
            if (!datenDownload.arr[21].equals(url)) continue;
            if (datenDownload.start != null && datenDownload.start.status < 3) {
                datenDownload.start.stoppen = true;
            }
            datenDownload.mVFilmSize.reset();
            datenDownload.start = null;
            MessageBus.getMessageBus().publishAsync((Object)new DownloadListChangedEvent());
            break;
        }
    }

    public synchronized void downloadAbbrechen(ArrayList<DatenDownload> download) {
        boolean gefunden = false;
        if (download != null) {
            for (DatenDownload down : download) {
                if (!this.contains(down)) continue;
                if (down.start != null) {
                    if (down.start.status < 3) {
                        down.start.stoppen = true;
                    }
                    if (down.start.status == 2) {
                        down.interrupt();
                    }
                }
                down.resetDownload();
                gefunden = true;
            }
        }
        if (gefunden) {
            MessageBus.getMessageBus().publishAsync((Object)new StartEvent());
        }
    }

    public synchronized void downloadLoeschen(ArrayList<DatenDownload> download) {
        boolean gefunden = false;
        if (download != null) {
            for (DatenDownload down : download) {
                if (down.start != null && down.start.status < 3) {
                    down.start.stoppen = true;
                }
                if (!this.remove(down)) continue;
                gefunden = true;
            }
        }
        if (gefunden) {
            MessageBus.getMessageBus().publishAsync((Object)new DownloadListChangedEvent());
        }
    }

    public synchronized DatenDownload getDownloadUrlFilm(String urlFilm) {
        for (DatenDownload datenDownload : this) {
            if (!datenDownload.arr[19].equals(urlFilm)) continue;
            return datenDownload;
        }
        return null;
    }

    public synchronized void getModel(TModelDownload tModel, boolean onlyAbos, boolean onlyDownloads, boolean onlyNotStarted, boolean onlyStarted, boolean onlyWaiting, boolean onlyRun, boolean onlyFinished) {
        tModel.setRowCount(0);
        tModel.getDataVector().clear();
        for (DatenDownload download : this) {
            if (download.istZurueckgestellt()) continue;
            boolean istAbo = download.isFromAbo();
            if (onlyAbos && !istAbo || onlyDownloads && istAbo) continue;
            boolean notStarted = download.notStarted();
            if (onlyNotStarted && !notStarted || onlyStarted && notStarted || onlyWaiting && !download.isWaiting() || onlyRun && !download.running() || onlyFinished && !download.isFinished()) continue;
            Object[] object = new Object[40];
            for (int i = 0; i < 40; ++i) {
                if (i == 0) {
                    object[i] = download.nr;
                    continue;
                }
                if (i == 1) {
                    if (download.film != null) {
                        object[i] = download.film.getFilmNr();
                        continue;
                    }
                    object[i] = 0;
                    continue;
                }
                object[i] = i == 28 || i == 17 || i == 36 || i == 35 || i == 37 || i == 34 || i == 38 ? "" : (i == 12 ? download.datumFilm : (i == 9 ? download.getTextRestzeit() : (i == 10 ? download.getTextBandbreite() : (i == 8 ? this.setProgress(download) : (i == 11 ? download.mVFilmSize : (i == 39 ? download : (i != 21 && !DatenDownload.anzeigen(i) ? "" : download.arr[i])))))));
            }
            tModel.addRow(object);
        }
    }

    private String setProgress(DatenDownload download) {
        if (download.start != null) {
            if (1 < download.start.percent && download.start.percent < 1000) {
                StringBuilder s = new StringBuilder(Double.toString((double)download.start.percent / 10.0) + "%");
                while (s.length() < 5) {
                    s.insert(0, '0');
                }
                return s.toString();
            }
            return Start.getTextProgress(download.isDownloadManager(), download.start);
        }
        return "";
    }

    public synchronized void setModelProgress(TModelDownload tModel) {
        int row = 0;
        for (Vector item : tModel.getDataVector()) {
            DatenDownload datenDownload = (DatenDownload)item.get(39);
            if (datenDownload.start != null && datenDownload.start.status == 2) {
                tModel.setValueAt(datenDownload.getTextRestzeit(), row, 9);
                tModel.setValueAt(datenDownload.getTextBandbreite(), row, 10);
                tModel.setValueAt(this.setProgress(datenDownload), row, 8);
                tModel.setValueAt(datenDownload.mVFilmSize, row, 11);
            }
            ++row;
        }
    }

    public synchronized void abosSuchen(JFrame parent) {
        HashSet<String> listeUrls = new HashSet<String>();
        this.forEach(download -> listeUrls.add(download.arr[21]));
        boolean gefunden = false;
        boolean checkWithBlackList = Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_BLACKLIST_AUCH_ABO));
        DatenPset pSet_ = Daten.listePset.getPsetAbo("");
        String todayDateStr = DateTimeFormatter.ofPattern("dd.MM.yyyy").format(LocalDateTime.now());
        Daten daten = Daten.getInstance();
        ListeAbo listeAbo = daten.getListeAbo();
        ListeBlacklist listeBlacklist = daten.getListeBlacklist();
        AboHistoryController aboHistoryController = daten.getAboHistoryController();
        ListeFilme listeFilme = daten.getListeFilme();
        for (DatenFilm film : listeFilme) {
            DatenPset pSet;
            DatenAbo abo = listeAbo.getAboFuerFilm_schnell(film, true);
            if (abo == null || !abo.isActive() || checkWithBlackList && !listeBlacklist.checkBlackOkFilme_Downloads(film) || aboHistoryController.urlExists(film.getUrlNormalQuality())) continue;
            DatenPset datenPset = pSet = abo.getPsetName().isEmpty() ? pSet_ : Daten.listePset.getPsetAbo(abo.getPsetName());
            if (pSet != null) {
                String urlDownload = film.getUrlFuerAufloesung(FilmResolution.Enum.fromLegacyString(pSet.arr[15]));
                if (listeUrls.contains(urlDownload)) continue;
                listeUrls.add(urlDownload);
                abo.setDownDatum(todayDateStr);
                if (!abo.getPsetName().equals(pSet.getName())) {
                    abo.setPsetName(pSet.getName());
                }
                this.add(new DatenDownload(pSet, film, 3, abo, "", "", ""));
                gefunden = true;
                continue;
            }
            new DialogAboNoSet(parent).setVisible(true);
            break;
        }
        if (gefunden) {
            this.listeNummerieren();
        }
        listeUrls.clear();
    }

    public synchronized void listeNummerieren() {
        int i = 1;
        for (DatenDownload datenDownload : this) {
            datenDownload.nr = i++;
        }
    }

    public synchronized DownloadStartInfo getStarts() {
        DownloadStartInfo info = new DownloadStartInfo();
        info.total_num_download_list_entries = this.size();
        for (DatenDownload download : this) {
            if (!download.istZurueckgestellt()) {
                ++info.total_starts;
            }
            if (download.isFromAbo()) {
                ++info.num_abos;
            } else {
                ++info.num_downloads;
            }
            if (download.start == null || download.quelle != 3 && download.quelle != 2) continue;
            switch (download.start.status) {
                case 1: {
                    ++info.initialized;
                    break;
                }
                case 2: {
                    ++info.running;
                    break;
                }
                case 3: {
                    ++info.finished;
                    break;
                }
                case 4: {
                    ++info.error;
                }
            }
        }
        return info;
    }

    public synchronized List<DatenDownload> getListOfStartsNotFinished(int quelle) {
        List<DatenDownload> activeDownloads = this.stream().filter(download -> download.start != null).filter(download -> download.start.status < 3).filter(download -> quelle == -1 || download.quelle == quelle).collect(Collectors.toList());
        return activeDownloads;
    }

    public synchronized void buttonStartsPutzen() {
        boolean gefunden = false;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            DatenDownload d = (DatenDownload)it.next();
            if (d.start == null || d.quelle != 1 || d.start.status < 3) continue;
            it.remove();
            gefunden = true;
        }
        if (gefunden) {
            MessageBus.getMessageBus().publishAsync((Object)new ButtonStartEvent());
        }
    }

    public synchronized DatenDownload getNextStart() {
        DatenDownload[] ret = new DatenDownload[1];
        int maxNumDownloads = ApplicationConfiguration.getConfiguration().getInt("download.max_simultaneous.number", 1);
        if (this.size() > 0 && this.getDown(maxNumDownloads)) {
            this.nextPossibleDownload().ifPresent(datenDownload -> {
                if (datenDownload.start != null && datenDownload.start.status == 1) {
                    ret[0] = datenDownload;
                }
            });
        }
        return ret[0];
    }

    public DatenDownload getRestartDownload() {
        if (!this.getDown(1)) {
            return null;
        }
        for (DatenDownload datenDownload : this) {
            if (datenDownload.start == null || datenDownload.start.status != 4 || datenDownload.start.countRestarted >= 2) continue;
            int restarted = datenDownload.start.countRestarted;
            if (datenDownload.art != 1) continue;
            datenDownload.resetDownload();
            datenDownload.startDownload();
            datenDownload.start.countRestarted = ++restarted;
            return datenDownload;
        }
        return null;
    }

    private boolean getDown(int max) {
        int count = 0;
        for (DatenDownload datenDownload : this) {
            Start s = datenDownload.start;
            if (s == null || s.status != 2 || ++count < max) continue;
            return false;
        }
        return true;
    }

    private Optional<DatenDownload> nextPossibleDownload() {
        for (DatenDownload datenDownload : this) {
            if (datenDownload.start == null || datenDownload.start.status != 1) continue;
            return Optional.of(datenDownload);
        }
        return Optional.empty();
    }
}

