\name{ExtractImageFilter}
\alias{ExtractImageFilter}
\title{ExtractImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Decrease the image size by cropping the image to the selected region
bounds.
ExtractImageFilter}
\details{
ExtractImageFilter changes the image boundary of an image by removing pixels outside the
target region. The region is specified as a Size and Index. The Size must be specified, while the Index defaults to zeros.
ExtractImageFilter can collapses dimensions so that the input image may have more
dimensions than the output image (i.e. 4-D input image to a 3-D output
image). To specify what dimensions to collapse, the Size must be specified. For any dimension dim where the Size[dim] == 0, that dimension is collapsed. The index to collapse on is
specified by Index[dim]. For example, we have a image 4D = a 4x4x4x4 image, and we want
to get a 3D image, 3D = a 4x4x4 image, specified as [x,y,z,2] from 4D
(i.e. the 3rd "time" slice from 4D). The Size = [4,4,4,0] and Index = [0,0,0,2].
The number of dimension in Size and Index must at least dimension of the input image. The number of non-zero
dimensions in Size determines the output dimension.
Determining the direction of the collapsed output image from an larger
dimensional input space is an ill defined problem in general. It is
required that the application developer select the desired
transformation strategy for collapsing direction cosines. The strategy
defaults to the guess approach. Direction Collapsing Strategies: 1)
DirectionCollapseToUnknown(); This is the default in ITK and the
filter can not run when this is set. 1) DirectionCollapseToIdentity();
Output has identity direction no matter what 2)
DirectionCollapseToSubmatrix(); Output direction is the sub-matrix if
it is positive definite, else throw an exception.
This filter is implemented as a multithreaded filter. It provides a
DynamicThreadedGenerateData() method for its implementation.
See:
CropImageFilter
Extract for the procedural interface
itk::ExtractImageFilter for the Doxygen on the original ITK class.
ExtractImageFilter}
%C++ includes: sitkExtractImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{}
\item{Image Execute(Image &&image1):}{
Execute the filter on the input image
}
\item{ ExtractImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{DirectionCollapseToStrategyType GetDirectionCollapseToStrategy() const:}{
Get the currently set strategy for collapsing directions of physical
space.
}
\item{std::vector< int > GetIndex() const:}{
Get the starting index to extract.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{std::vector< unsigned int > GetSize() const:}{
Get the size of the region to extract.
}
\item{Self SetDirectionCollapseToStrategy(DirectionCollapseToStrategyType DirectionCollapseToStrategy):}{
Set the strategy to be used to collapse physical space dimensions.
DIRECTIONCOLLAPSETOIDENTITY Set the strategy so that all collapsed
images have an identity direction. Use this strategy when you know
that retention of the physical space orientation of the collapsed
image is not important.
DIRECTIONCOLLAPSETOGUESS Set the strategy so that all collapsed images
where output direction is the sub-matrix if it is positive definite,
else return identity. This is backwards compatible with ITKv3, but is
highly discouraged because the results are difficult to anticipate
under differing data scenarios.
DIRECTIONCOLLAPSETOSUBMATRIX Set the strategy so that all collapsed
images where output direction is the sub-matrix if it is positive
definite, else throw an exception. Use this strategy when it is known
that properly identified physical space sub-volumes can be reliably
extracted from a higher dimensional space. For example when the
application programmer knows that a 4D image is 3D+time, and that the
3D sub-space is properly defined.
}
\item{Self SetIndex(std::vector< int > Index):}{
Set the starting index of the input image to extract.
The index defaults to all zeros.
}
\item{Self SetSize(std::vector< unsigned int > Size):}{
Set the size of the region to extract.
The size of the region to extract should be specified. Dimensions
which have a size of 0 are collapsed. The number of non-zero sized
determines the output dimension.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~ExtractImageFilter():}{
Destructor
}
}
}
