/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.memoryoptsearch.faiss;

import java.io.IOException;
import lombok.Generated;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.store.IndexInput;
import org.opensearch.common.Nullable;
import org.opensearch.knn.memoryoptsearch.faiss.MMapVectorValues;
import org.opensearch.knn.memoryoptsearch.faiss.reconstruct.FaissQuantizedValueReconstructor;

public class MMapFloatVectorValues
extends FloatVectorValues
implements MMapVectorValues {
    private final IndexInput indexInput;
    private final long oneVectorByteSize;
    private final long baseOffset;
    private final int dimension;
    private final int totalNumberOfVectors;
    private final long[] addressAndSize;
    private float[] floatBuffer;
    private byte[] bytesBuffer;
    @Nullable
    private final FaissQuantizedValueReconstructor reconstructor;

    public MMapFloatVectorValues(IndexInput indexInput, long oneVectorByteSize, long baseOffset, int dimension, int totalNumberOfVectors, long[] addressAndSize, FaissQuantizedValueReconstructor reconstructor) {
        this.indexInput = indexInput;
        this.oneVectorByteSize = oneVectorByteSize;
        this.baseOffset = baseOffset;
        this.dimension = dimension;
        this.totalNumberOfVectors = totalNumberOfVectors;
        if (addressAndSize == null || addressAndSize.length == 0) {
            throw new IllegalArgumentException("Empty `addressAndSize` was provided in " + MMapFloatVectorValues.class.getSimpleName() + ". Is null?=" + (addressAndSize == null));
        }
        this.addressAndSize = addressAndSize;
        this.reconstructor = reconstructor;
    }

    public float[] vectorValue(int internalVectorId) throws IOException {
        this.indexInput.seek(this.baseOffset + (long)internalVectorId * this.oneVectorByteSize);
        if (this.floatBuffer == null) {
            this.floatBuffer = new float[this.dimension];
        }
        if (this.reconstructor != null) {
            if (this.bytesBuffer == null) {
                this.bytesBuffer = new byte[(int)this.oneVectorByteSize];
            }
            this.indexInput.readBytes(this.bytesBuffer, 0, this.bytesBuffer.length);
            this.reconstructor.reconstruct(this.bytesBuffer, this.floatBuffer);
        } else {
            this.indexInput.readFloats(this.floatBuffer, 0, this.floatBuffer.length);
        }
        return this.floatBuffer;
    }

    public int dimension() {
        return this.dimension;
    }

    public int size() {
        return this.totalNumberOfVectors;
    }

    public FloatVectorValues copy() throws IOException {
        return new MMapFloatVectorValues(this.indexInput.clone(), this.oneVectorByteSize, this.baseOffset, this.dimension, this.totalNumberOfVectors, this.addressAndSize, this.reconstructor);
    }

    @Override
    @Generated
    public long[] getAddressAndSize() {
        return this.addressAndSize;
    }
}

