# Interface methods for submodule: CellInterface
from typing import Union, Any
# additional imports
from .support.template_class import itkTemplate as _itkTemplate



# Interface methods for class: CellInterface
class CellInterfaceProxy():
	def Accept(self, cellId: int, arg1) -> None:
		""""""
		...

	def GetType(self):
		""""""
		...

	def MakeCopy(self, arg0) -> None:
		""""""
		...

	def GetDimension(self) -> int:
		""""""
		...

	def GetInterpolationOrder(self) -> int:
		""""""
		...

	def GetNumberOfPoints(self) -> int:
		""""""
		...

	def GetNumberOfBoundaryFeatures(self, dimension: int) -> int:
		""""""
		...

	def GetBoundaryFeature(self, dimension: int, arg1: int, arg2) -> bool:
		""""""
		...

	def GetPointIds(self):
		""""""
		...

	@overload
	def SetPointIds(self, first) -> None:
		""""""
		...

	@overload
	def SetPointIds(self, first, last) -> None:
		""""""
		...

	def SetPointId(self, localId: int, arg1: int) -> None:
		""""""
		...

	def PointIdsBegin(self):
		""""""
		...

	def PointIdsEnd(self):
		""""""
		...

	def GetPointIdsContainer(self) -> Sequence[int]:
		""""""
		...

	def SetPointIdsContainer(self, arg0: Sequence[int]) -> None:
		""""""
		...

	def GetClosestBoundary(self, arg0, arg1, arg2) -> bool:
		""""""
		...

	def EvaluatePosition(self, arg0, arg1, arg2, arg3, arg4, arg5) -> bool:
		""""""
		...

	def EvaluateShapeFunctions(self, arg0: Sequence[float], arg1: Sequence[float]) -> None:
		""""""
		...

	def IntersectWithLine(self, arg0, arg1, arg2: float, arg3, arg4, arg5) -> bool:
		""""""
		...

	def GetBoundingBox(self, arg0):
		""""""
		...

	def GetBoundingBoxDiagonalLength2(self) -> float:
		""""""
		...

	def IntersectBoundingBoxWithLine(self, arg0, arg1, arg2, arg3, arg4) -> bool:
		""""""
		...

	def IsExplicitBoundary(self) -> bool:
		""""""
		...

	def AddUsingCell(self, cellId: int) -> None:
		""""""
		...

	def RemoveUsingCell(self, cellId: int) -> None:
		""""""
		...

	def IsUsingCell(self, cellId: int) -> bool:
		""""""
		...

	def GetNumberOfUsingCells(self) -> int:
		""""""
		...

	def GetNameOfClass(self):
		""""""
		...

