/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.AnnotateDataKeys;
import com.intellij.openapi.vcs.actions.AnnotationWarningUserData;
import com.intellij.openapi.vcs.annotate.AnnotationWarning;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.EditorNotifications;
import java.util.function.Function;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J(\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/vcs/actions/AnnotateWarningsProvider;", "Lcom/intellij/ui/EditorNotificationProvider;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "collectNotificationData", "Ljava/util/function/Function;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "NotificationPanel", "intellij.platform.vcs.impl"})
public final class AnnotateWarningsProvider
implements EditorNotificationProvider,
DumbAware {
    @Nullable
    public Function<FileEditor, JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return arg_0 -> AnnotateWarningsProvider.collectNotificationData$lambda$0(this, project, arg_0);
    }

    private static final JComponent collectNotificationData$lambda$0(AnnotateWarningsProvider this$0, Project $project, FileEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        TextEditor textEditor = editor instanceof TextEditor ? (TextEditor)editor : null;
        if (textEditor == null || (textEditor = textEditor.getEditor()) == null) {
            return null;
        }
        TextEditor editor2 = textEditor;
        AnnotationWarningUserData annotationWarningUserData = (AnnotationWarningUserData)editor2.getUserData(AnnotateDataKeys.WARNING_DATA);
        if (annotationWarningUserData == null) {
            return null;
        }
        AnnotationWarningUserData warning = annotationWarningUserData;
        return (JComponent)((Object)this$0.new NotificationPanel($project, (Editor)editor2, warning.getWarning(), warning.getForceAnnotate()));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/vcs/actions/AnnotateWarningsProvider$NotificationPanel;", "Lcom/intellij/ui/EditorNotificationPanel;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "warning", "Lcom/intellij/openapi/vcs/annotate/AnnotationWarning;", "forceAnnotate", "Ljava/lang/Runnable;", "<init>", "(Lcom/intellij/openapi/vcs/actions/AnnotateWarningsProvider;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/vcs/annotate/AnnotationWarning;Ljava/lang/Runnable;)V", "showAnnotations", "", "hideNotification", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nAnnotateWarningsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotateWarningsProvider.kt\ncom/intellij/openapi/vcs/actions/AnnotateWarningsProvider$NotificationPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n1869#2,2:83\n*S KotlinDebug\n*F\n+ 1 AnnotateWarningsProvider.kt\ncom/intellij/openapi/vcs/actions/AnnotateWarningsProvider$NotificationPanel\n*L\n42#1:83,2\n*E\n"})
    private final class NotificationPanel
    extends EditorNotificationPanel {
        @NotNull
        private final Project project;
        @NotNull
        private final Editor editor;
        @NotNull
        private final Runnable forceAnnotate;

        public NotificationPanel(@NotNull Project project, @NotNull Editor editor, @NotNull AnnotationWarning warning, Runnable forceAnnotate) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)warning, (String)"warning");
            Intrinsics.checkNotNullParameter((Object)forceAnnotate, (String)"forceAnnotate");
            super(warning.getBackgroundColor(), warning.getStatus());
            this.project = project;
            this.editor = editor;
            this.forceAnnotate = forceAnnotate;
            this.setText(warning.getMessage());
            Iterable $this$forEach$iv = warning.getActions();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AnnotationWarning.Action action = (AnnotationWarning.Action)element$iv;
                boolean bl = false;
                this.createActionLabel(action.getText(), () -> NotificationPanel.lambda$0$0(action, this));
            }
            if (!warning.getShowAnnotation()) {
                this.createActionLabel(VcsBundle.message((String)"link.label.display.anyway", (Object[])new Object[0]), () -> NotificationPanel._init_$lambda$1(this));
            }
            this.setCloseAction(this::hideNotification);
        }

        private final void showAnnotations() {
            this.forceAnnotate.run();
        }

        private final void hideNotification() {
            this.editor.putUserData(AnnotateDataKeys.WARNING_DATA, null);
            EditorNotifications.getInstance((Project)this.project).updateNotifications((EditorNotificationProvider)AnnotateWarningsProvider.this);
        }

        private static final void lambda$0$0(AnnotationWarning.Action $action, NotificationPanel this$0) {
            $action.doAction(this$0::hideNotification);
        }

        private static final void _init_$lambda$1(NotificationPanel this$0) {
            this$0.showAnnotations();
        }
    }
}

