/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.settings;

import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import com.intellij.sh.ShBundle;
import java.io.File;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ShSettings {
    public static final Supplier<String> I_DO_MIND_SUPPLIER = ShBundle.messagePointer("i.do.mind.path.placeholder", new Object[0]);
    private static final String SHELLCHECK_PATH = "SHELLCHECK.PATH";
    private static final String SHELLCHECK_SKIPPED_VERSION = "SHELLCHECK.SKIPPED.VERSION";
    private static final String SHELLCHECK_UNIX_EXECUTABLE = "shellcheck";
    private static final String SHELLCHECK_WIN_EXECUTABLE = "shellcheck.exe";
    private static final String SHFMT_PATH = "SHFMT.PATH";
    private static final String SHFMT_SKIPPED_VERSION = "SHFMT.SKIPPED.VERSION";
    private static final String SHFMT_UNIX_EXECUTABLE = "shfmt";
    private static final String SHFMT_WIN_EXECUTABLE = "shfmt.exe";

    @NotNull
    public static String getShellcheckPath(@NotNull Project project) {
        String oldProperty;
        EelDescriptor eelDescriptor;
        if (project == null) {
            ShSettings.$$$reportNull$$$0(0);
        }
        if ((eelDescriptor = EelProviderUtil.getEelDescriptor((Project)project)) == LocalEelDescriptor.INSTANCE && !(oldProperty = PropertiesComponent.getInstance().getValue(SHELLCHECK_PATH, "")).isBlank()) {
            PropertiesComponent.getInstance().setValue(SHELLCHECK_PATH, "");
            ShSettings.setShellcheckPath(project, oldProperty);
            String string = oldProperty;
            if (string == null) {
                ShSettings.$$$reportNull$$$0(1);
            }
            return string;
        }
        File defaultExecutable = PathEnvironmentVariableUtil.findInPath((String)(SystemInfo.isWindows ? SHELLCHECK_WIN_EXECUTABLE : SHELLCHECK_UNIX_EXECUTABLE));
        String defaultExecutablePath = defaultExecutable != null ? defaultExecutable.getAbsolutePath() : "";
        String string = PropertiesComponent.getInstance((Project)project).getValue(SHELLCHECK_PATH, defaultExecutablePath);
        if (string == null) {
            ShSettings.$$$reportNull$$$0(2);
        }
        return string;
    }

    public static void setShellcheckPath(@NotNull Project project, @Nullable String path) {
        if (project == null) {
            ShSettings.$$$reportNull$$$0(3);
        }
        if (StringUtil.isNotEmpty((String)path)) {
            PropertiesComponent.getInstance((Project)project).setValue(SHELLCHECK_PATH, path);
        }
    }

    @NotNull
    public static String getShfmtPath(@NotNull Project project) {
        String oldProperty;
        EelDescriptor eelDescriptor;
        if (project == null) {
            ShSettings.$$$reportNull$$$0(4);
        }
        if ((eelDescriptor = EelProviderUtil.getEelDescriptor((Project)project)) == LocalEelDescriptor.INSTANCE && !(oldProperty = PropertiesComponent.getInstance().getValue(SHFMT_PATH, "")).isBlank()) {
            PropertiesComponent.getInstance().setValue(SHFMT_PATH, "");
            ShSettings.setShfmtPath(project, oldProperty);
            String string = oldProperty;
            if (string == null) {
                ShSettings.$$$reportNull$$$0(5);
            }
            return string;
        }
        File defaultExecutable = PathEnvironmentVariableUtil.findInPath((String)(SystemInfo.isWindows ? SHFMT_WIN_EXECUTABLE : SHFMT_UNIX_EXECUTABLE));
        String defaultExecutablePath = defaultExecutable != null ? defaultExecutable.getAbsolutePath() : "";
        String string = PropertiesComponent.getInstance((Project)project).getValue(SHFMT_PATH, defaultExecutablePath);
        if (string == null) {
            ShSettings.$$$reportNull$$$0(6);
        }
        return string;
    }

    public static void setShfmtPath(@NotNull Project project, @Nullable String path) {
        if (project == null) {
            ShSettings.$$$reportNull$$$0(7);
        }
        if (StringUtil.isNotEmpty((String)path)) {
            PropertiesComponent.getInstance((Project)project).setValue(SHFMT_PATH, path);
        }
    }

    @NotNull
    public static String getSkippedShellcheckVersion() {
        String string = PropertiesComponent.getInstance().getValue(SHELLCHECK_SKIPPED_VERSION, "");
        if (string == null) {
            ShSettings.$$$reportNull$$$0(8);
        }
        return string;
    }

    public static void setSkippedShellcheckVersion(@NotNull String version) {
        if (version == null) {
            ShSettings.$$$reportNull$$$0(9);
        }
        if (StringUtil.isNotEmpty((String)version)) {
            PropertiesComponent.getInstance().setValue(SHELLCHECK_SKIPPED_VERSION, version);
        }
    }

    @NotNull
    public static String getSkippedShfmtVersion() {
        String string = PropertiesComponent.getInstance().getValue(SHFMT_SKIPPED_VERSION, "");
        if (string == null) {
            ShSettings.$$$reportNull$$$0(10);
        }
        return string;
    }

    public static void setSkippedShfmtVersion(@NotNull String version) {
        if (version == null) {
            ShSettings.$$$reportNull$$$0(11);
        }
        if (StringUtil.isNotEmpty((String)version)) {
            PropertiesComponent.getInstance().setValue(SHFMT_SKIPPED_VERSION, version);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 5, 6, 8, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sh/settings/ShSettings";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sh/settings/ShSettings";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShellcheckPath";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getShfmtPath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSkippedShellcheckVersion";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSkippedShfmtVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getShellcheckPath";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setShellcheckPath";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getShfmtPath";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setShfmtPath";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setSkippedShellcheckVersion";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setSkippedShfmtVersion";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 5, 6, 8, 10 -> new IllegalStateException(string);
        };
    }
}

