/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.ext.gfm.tables.internal;

import java.util.ArrayList;
import java.util.List;
import org.commonmark.ext.gfm.tables.TableBlock;
import org.commonmark.ext.gfm.tables.TableBody;
import org.commonmark.ext.gfm.tables.TableCell;
import org.commonmark.ext.gfm.tables.TableHead;
import org.commonmark.ext.gfm.tables.TableRow;
import org.commonmark.ext.gfm.tables.internal.TableNodeRenderer;
import org.commonmark.node.Node;
import org.commonmark.renderer.NodeRenderer;
import org.commonmark.renderer.markdown.MarkdownNodeRendererContext;
import org.commonmark.renderer.markdown.MarkdownWriter;
import org.commonmark.text.AsciiMatcher;
import org.commonmark.text.CharMatcher;

public class TableMarkdownNodeRenderer
extends TableNodeRenderer
implements NodeRenderer {
    private final MarkdownWriter writer;
    private final MarkdownNodeRendererContext context;
    private final AsciiMatcher pipe = AsciiMatcher.builder().c('|').build();
    private final List<TableCell.Alignment> columns = new ArrayList<TableCell.Alignment>();

    public TableMarkdownNodeRenderer(MarkdownNodeRendererContext context) {
        this.writer = context.getWriter();
        this.context = context;
    }

    @Override
    protected void renderBlock(TableBlock node) {
        this.columns.clear();
        this.writer.pushTight(true);
        this.renderChildren((Node)node);
        this.writer.popTight();
        this.writer.block();
    }

    @Override
    protected void renderHead(TableHead node) {
        this.renderChildren((Node)node);
        for (TableCell.Alignment columnAlignment : this.columns) {
            this.writer.raw('|');
            if (columnAlignment == TableCell.Alignment.LEFT) {
                this.writer.raw(":---");
                continue;
            }
            if (columnAlignment == TableCell.Alignment.RIGHT) {
                this.writer.raw("---:");
                continue;
            }
            if (columnAlignment == TableCell.Alignment.CENTER) {
                this.writer.raw(":---:");
                continue;
            }
            this.writer.raw("---");
        }
        this.writer.raw("|");
        this.writer.block();
    }

    @Override
    protected void renderBody(TableBody node) {
        this.renderChildren((Node)node);
    }

    @Override
    protected void renderRow(TableRow node) {
        this.renderChildren((Node)node);
        this.writer.raw("|");
        this.writer.block();
    }

    @Override
    protected void renderCell(TableCell node) {
        if (node.getParent() != null && node.getParent().getParent() instanceof TableHead) {
            this.columns.add(node.getAlignment());
        }
        this.writer.raw("|");
        this.writer.pushRawEscape((CharMatcher)this.pipe);
        this.renderChildren((Node)node);
        this.writer.popRawEscape();
    }

    private void renderChildren(Node parent) {
        Node node = parent.getFirstChild();
        while (node != null) {
            Node next = node.getNext();
            this.context.render(node);
            node = next;
        }
    }
}

