/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.hashing;

import com.dynatrace.hash4j.hashing.AbstractKomihash;
import com.dynatrace.hash4j.hashing.ByteAccess;
import com.dynatrace.hash4j.hashing.HashStream64;
import com.dynatrace.hash4j.hashing.Hasher64;
import com.dynatrace.hash4j.internal.ByteArrayUtil;
import com.dynatrace.hash4j.internal.Preconditions;
import com.dynatrace.hash4j.internal.UnsignedMultiplyUtil;

final class Komihash5_0
extends AbstractKomihash {
    private static final Hasher64 DEFAULT_HASHER_INSTANCE = Komihash5_0.create(0L);

    static Hasher64 create() {
        return DEFAULT_HASHER_INSTANCE;
    }

    static Hasher64 create(long useSeed) {
        return new Komihash5_0(useSeed);
    }

    private Komihash5_0(long seed) {
        super(seed);
    }

    @Override
    public HashStream64 hashStream() {
        return new HashStreamImpl();
    }

    private long hashBytesToLong0To15(byte[] input, int off, int len) {
        long r1h = this.seed1;
        long r2h = this.seed5;
        if (len > 7) {
            r1h ^= ByteArrayUtil.getLong(input, off);
            int ml8 = len << 3;
            if (len < 12) {
                int m = input[off + len - 3] & 0xFF | (input[off + len - 1] & 0xFF) << 16 | 0x1000000 | (input[off + len - 2] & 0xFF) << 8;
                r2h ^= (long)(m >>> (ml8 ^= 0x18));
            } else {
                long mh = ((long)ByteArrayUtil.getInt(input, off + len - 4) & 0xFFFFFFFFL | 0x100000000L) >>> -ml8;
                long ml = (long)ByteArrayUtil.getInt(input, off + 8) & 0xFFFFFFFFL;
                r2h ^= mh << 32 | ml;
            }
        } else if (len > 0) {
            int ml8 = len << 3;
            if (len < 4) {
                r1h ^= 1L << ml8;
                r1h ^= (long)input[off] & 0xFFL;
                if (len != 1) {
                    r1h ^= ((long)input[off + 1] & 0xFFL) << 8;
                    if (len != 2) {
                        r1h ^= ((long)input[off + 2] & 0xFFL) << 16;
                    }
                }
            } else {
                long mh = ((long)ByteArrayUtil.getInt(input, off + len - 4) & 0xFFFFFFFFL | 0x100000000L) >>> -ml8;
                long ml = (long)ByteArrayUtil.getInt(input, off) & 0xFFFFFFFFL;
                r1h ^= mh << 32 | ml;
            }
        }
        return Komihash5_0.finish(r1h, r2h, this.seed5);
    }

    private <T> long hashBytesToLong0To15(T input, long off, long len, ByteAccess<T> access) {
        long r1h = this.seed1;
        long r2h = this.seed5;
        if (len > 7L) {
            r1h ^= access.getLong(input, off);
            int ml8 = (int)(len << 3);
            if (len < 12L) {
                int m = access.getByteAsUnsignedInt(input, off + len - 3L) | access.getByteAsUnsignedInt(input, off + len - 1L) << 16 | 0x1000000 | access.getByteAsUnsignedInt(input, off + len - 2L) << 8;
                r2h ^= (long)(m >>> (ml8 ^= 0x18));
            } else {
                long mh = (access.getIntAsUnsignedLong(input, off + len - 4L) | 0x100000000L) >>> -ml8;
                long ml = access.getIntAsUnsignedLong(input, off + 8L);
                r2h ^= mh << 32 | ml;
            }
        } else if (len > 0L) {
            int ml8 = (int)(len << 3);
            if (len < 4L) {
                r1h ^= 1L << ml8;
                r1h ^= access.getByteAsUnsignedLong(input, off);
                if (len != 1L) {
                    r1h ^= access.getByteAsUnsignedLong(input, off + 1L) << 8;
                    if (len != 2L) {
                        r1h ^= access.getByteAsUnsignedLong(input, off + 2L) << 16;
                    }
                }
            } else {
                long mh = (access.getIntAsUnsignedLong(input, off + len - 4L) | 0x100000000L) >>> -ml8;
                long ml = access.getIntAsUnsignedLong(input, off);
                r1h ^= mh << 32 | ml;
            }
        }
        return Komihash5_0.finish(r1h, r2h, this.seed5);
    }

    private long hashBytesToLong16To31(byte[] input, int off, int len) {
        long r2h;
        long r1h;
        long see1 = this.seed1;
        long see5 = this.seed5;
        long tmp1 = see1 ^ ByteArrayUtil.getLong(input, off);
        long tmp2 = see5 ^ ByteArrayUtil.getLong(input, off + 8);
        see1 = tmp1 * tmp2;
        see1 ^= (see5 += UnsignedMultiplyUtil.unsignedMultiplyHigh(tmp1, tmp2));
        int ml8 = len << 3;
        ml8 ^= 0x38;
        if (len < 24) {
            r1h = ByteArrayUtil.getLong(input, off + len - 8) >>> 8 | 0x100000000000000L;
            r2h = see5;
            r1h = r1h >>> ml8 ^ see1;
        } else {
            r2h = ByteArrayUtil.getLong(input, off + len - 8) >>> 8 | 0x100000000000000L;
            r1h = ByteArrayUtil.getLong(input, off + 16) ^ see1;
            r2h = r2h >>> ml8 ^ see5;
        }
        return Komihash5_0.finish(r1h, r2h, see5);
    }

    private <T> long hashBytesToLong16To31(T input, long off, long len, ByteAccess<T> access) {
        long r2h;
        long r1h;
        long see1 = this.seed1;
        long see5 = this.seed5;
        long tmp1 = see1 ^ access.getLong(input, off);
        long tmp2 = see5 ^ access.getLong(input, off + 8L);
        see1 = tmp1 * tmp2;
        see1 ^= (see5 += UnsignedMultiplyUtil.unsignedMultiplyHigh(tmp1, tmp2));
        int ml8 = (int)(len << 3);
        ml8 ^= 0x38;
        if (len < 24L) {
            r1h = access.getLong(input, off + len - 8L) >>> 8 | 0x100000000000000L;
            r2h = see5;
            r1h = r1h >>> ml8 ^ see1;
        } else {
            r2h = access.getLong(input, off + len - 8L) >>> 8 | 0x100000000000000L;
            r1h = access.getLong(input, off + 16L) ^ see1;
            r2h = r2h >>> ml8 ^ see5;
        }
        return Komihash5_0.finish(r1h, r2h, see5);
    }

    @Override
    public long hashBytesToLong(byte[] input, int off, int len) {
        long r2h;
        long r1h;
        long tmp4;
        long tmp3;
        long tmp2;
        long tmp1;
        if (len < 16) {
            return this.hashBytesToLong0To15(input, off, len);
        }
        if (len < 32) {
            return this.hashBytesToLong16To31(input, off, len);
        }
        long see1 = this.seed1;
        long see2 = this.seed2;
        long see3 = this.seed3;
        long see4 = this.seed4;
        long see5 = this.seed5;
        long see6 = this.seed6;
        long see7 = this.seed7;
        long see8 = this.seed8;
        if (len > 63) {
            do {
                tmp1 = see1 ^ ByteArrayUtil.getLong(input, off);
                tmp2 = see2 ^ ByteArrayUtil.getLong(input, off + 8);
                tmp3 = see3 ^ ByteArrayUtil.getLong(input, off + 16);
                tmp4 = see4 ^ ByteArrayUtil.getLong(input, off + 24);
                long tmp5 = see5 ^ ByteArrayUtil.getLong(input, off + 32);
                long tmp6 = see6 ^ ByteArrayUtil.getLong(input, off + 40);
                long tmp7 = see7 ^ ByteArrayUtil.getLong(input, off + 48);
                long tmp8 = see8 ^ ByteArrayUtil.getLong(input, off + 56);
                see1 = (see8 += UnsignedMultiplyUtil.unsignedMultiplyHigh(tmp4, tmp8)) ^ tmp1 * tmp5;
                see2 = (see5 += UnsignedMultiplyUtil.unsignedMultiplyHigh(tmp1, tmp5)) ^ tmp2 * tmp6;
                see3 = (see6 += UnsignedMultiplyUtil.unsignedMultiplyHigh(tmp2, tmp6)) ^ tmp3 * tmp7;
                see4 = (see7 += UnsignedMultiplyUtil.unsignedMultiplyHigh(tmp3, tmp7)) ^ tmp4 * tmp8;
                off += 64;
            } while ((len -= 64) > 63);
            see5 ^= see6 ^ see7 ^ see8;
            see1 ^= see2 ^ see3 ^ see4;
        }
        if (len > 31) {
            tmp1 = see1 ^ ByteArrayUtil.getLong(input, off);
            tmp2 = see5 ^ ByteArrayUtil.getLong(input, off + 8);
            see1 = tmp1 * tmp2;
            tmp3 = (see1 ^= (see5 += UnsignedMultiplyUtil.unsignedMultiplyHigh(tmp1, tmp2))) ^ ByteArrayUtil.getLong(input, off + 16);
            tmp4 = see5 ^ ByteArrayUtil.getLong(input, off + 24);
            see1 = tmp3 * tmp4;
            see1 ^= (see5 += UnsignedMultiplyUtil.unsignedMultiplyHigh(tmp3, tmp4));
            off += 32;
            len -= 32;
        }
        if (len > 15) {
            tmp1 = see1 ^ ByteArrayUtil.getLong(input, off);
            tmp2 = see5 ^ ByteArrayUtil.getLong(input, off + 8);
            see1 = tmp1 * tmp2;
            see1 ^= (see5 += UnsignedMultiplyUtil.unsignedMultiplyHigh(tmp1, tmp2));
            off += 16;
            len -= 16;
        }
        int ml8 = len << 3;
        ml8 ^= 0x38;
        if (len < 8) {
            r1h = ByteArrayUtil.getLong(input, off + len - 8) >>> 8 | 0x100000000000000L;
            r2h = see5;
            r1h = r1h >>> ml8 ^ see1;
        } else {
            r2h = ByteArrayUtil.getLong(input, off + len - 8) >>> 8 | 0x100000000000000L;
            r1h = ByteArrayUtil.getLong(input, off) ^ see1;
            r2h = r2h >>> ml8 ^ see5;
        }
        return Komihash5_0.finish(r1h, r2h, see5);
    }

    @Override
    public <T> long hashBytesToLong(T input, long off, long len, ByteAccess<T> access) {
        long r2h;
        long r1h;
        long tmp4;
        long tmp3;
        long tmp2;
        long tmp1;
        if (len < 16L) {
            return this.hashBytesToLong0To15(input, off, len, access);
        }
        if (len < 32L) {
            return this.hashBytesToLong16To31(input, off, len, access);
        }
        long see1 = this.seed1;
        long see2 = this.seed2;
        long see3 = this.seed3;
        long see4 = this.seed4;
        long see5 = this.seed5;
        long see6 = this.seed6;
        long see7 = this.seed7;
        long see8 = this.seed8;
        if (len > 63L) {
            do {
                tmp1 = see1 ^ access.getLong(input, off);
                tmp2 = see2 ^ access.getLong(input, off + 8L);
                tmp3 = see3 ^ access.getLong(input, off + 16L);
                tmp4 = see4 ^ access.getLong(input, off + 24L);
                long tmp5 = see5 ^ access.getLong(input, off + 32L);
                long tmp6 = see6 ^ access.getLong(input, off + 40L);
                long tmp7 = see7 ^ access.getLong(input, off + 48L);
                long tmp8 = see8 ^ access.getLong(input, off + 56L);
                see1 = (see8 += UnsignedMultiplyUtil.unsignedMultiplyHigh(tmp4, tmp8)) ^ tmp1 * tmp5;
                see2 = (see5 += UnsignedMultiplyUtil.unsignedMultiplyHigh(tmp1, tmp5)) ^ tmp2 * tmp6;
                see3 = (see6 += UnsignedMultiplyUtil.unsignedMultiplyHigh(tmp2, tmp6)) ^ tmp3 * tmp7;
                see4 = (see7 += UnsignedMultiplyUtil.unsignedMultiplyHigh(tmp3, tmp7)) ^ tmp4 * tmp8;
                off += 64L;
            } while ((len -= 64L) > 63L);
            see5 ^= see6 ^ see7 ^ see8;
            see1 ^= see2 ^ see3 ^ see4;
        }
        if (len > 31L) {
            tmp1 = see1 ^ access.getLong(input, off);
            tmp2 = see5 ^ access.getLong(input, off + 8L);
            see1 = tmp1 * tmp2;
            tmp3 = (see1 ^= (see5 += UnsignedMultiplyUtil.unsignedMultiplyHigh(tmp1, tmp2))) ^ access.getLong(input, off + 16L);
            tmp4 = see5 ^ access.getLong(input, off + 24L);
            see1 = tmp3 * tmp4;
            see1 ^= (see5 += UnsignedMultiplyUtil.unsignedMultiplyHigh(tmp3, tmp4));
            off += 32L;
            len -= 32L;
        }
        if (len > 15L) {
            tmp1 = see1 ^ access.getLong(input, off);
            tmp2 = see5 ^ access.getLong(input, off + 8L);
            see1 = tmp1 * tmp2;
            see1 ^= (see5 += UnsignedMultiplyUtil.unsignedMultiplyHigh(tmp1, tmp2));
            off += 16L;
            len -= 16L;
        }
        int ml8 = (int)(len << 3);
        ml8 ^= 0x38;
        if (len < 8L) {
            r1h = access.getLong(input, off + len - 8L) >>> 8 | 0x100000000000000L;
            r2h = see5;
            r1h = r1h >>> ml8 ^ see1;
        } else {
            r2h = access.getLong(input, off + len - 8L) >>> 8 | 0x100000000000000L;
            r1h = access.getLong(input, off) ^ see1;
            r2h = r2h >>> ml8 ^ see5;
        }
        return Komihash5_0.finish(r1h, r2h, see5);
    }

    @Override
    public long hashCharsToLong(CharSequence input) {
        long r1h;
        long r1l;
        long tmp2;
        long tmp1;
        int off = 0;
        int len = input.length();
        long see1 = this.seed1;
        long see2 = this.seed2;
        long see3 = this.seed3;
        long see4 = this.seed4;
        long see5 = this.seed5;
        long see6 = this.seed6;
        long see7 = this.seed7;
        long see8 = this.seed8;
        if (len > 31) {
            do {
                tmp1 = see1 ^ ByteArrayUtil.getLong(input, off);
                tmp2 = see2 ^ ByteArrayUtil.getLong(input, off + 4);
                long tmp3 = see3 ^ ByteArrayUtil.getLong(input, off + 8);
                long tmp4 = see4 ^ ByteArrayUtil.getLong(input, off + 12);
                long tmp5 = see5 ^ ByteArrayUtil.getLong(input, off + 16);
                long tmp6 = see6 ^ ByteArrayUtil.getLong(input, off + 20);
                long tmp7 = see7 ^ ByteArrayUtil.getLong(input, off + 24);
                long tmp8 = see8 ^ ByteArrayUtil.getLong(input, off + 28);
                see1 = (see8 += UnsignedMultiplyUtil.unsignedMultiplyHigh(tmp4, tmp8)) ^ tmp1 * tmp5;
                see2 = (see5 += UnsignedMultiplyUtil.unsignedMultiplyHigh(tmp1, tmp5)) ^ tmp2 * tmp6;
                see3 = (see6 += UnsignedMultiplyUtil.unsignedMultiplyHigh(tmp2, tmp6)) ^ tmp3 * tmp7;
                see4 = (see7 += UnsignedMultiplyUtil.unsignedMultiplyHigh(tmp3, tmp7)) ^ tmp4 * tmp8;
                off += 32;
            } while ((len -= 32) > 31);
            see5 ^= see6 ^ see7 ^ see8;
            see1 ^= see2 ^ see3 ^ see4;
        }
        if (len > 15) {
            tmp1 = see1 ^ ByteArrayUtil.getLong(input, off);
            tmp2 = see5 ^ ByteArrayUtil.getLong(input, off + 4);
            r1l = tmp1 * tmp2;
            r1h = UnsignedMultiplyUtil.unsignedMultiplyHigh(tmp1, tmp2);
            see1 = (see5 += r1h) ^ r1l;
            long tmp3 = see1 ^ ByteArrayUtil.getLong(input, off + 8);
            long tmp4 = see5 ^ ByteArrayUtil.getLong(input, off + 12);
            r1l = tmp3 * tmp4;
            r1h = UnsignedMultiplyUtil.unsignedMultiplyHigh(tmp3, tmp4);
            see1 = (see5 += r1h) ^ r1l;
            off += 16;
            len -= 16;
        }
        if (len > 7) {
            tmp1 = see1 ^ ByteArrayUtil.getLong(input, off);
            tmp2 = see5 ^ ByteArrayUtil.getLong(input, off + 4);
            r1l = tmp1 * tmp2;
            r1h = UnsignedMultiplyUtil.unsignedMultiplyHigh(tmp1, tmp2);
            see1 = (see5 += r1h) ^ r1l;
            off += 8;
            len -= 8;
        }
        long r2h = see5;
        long r1h2 = see1;
        int ml8 = len << 4;
        if (len > 3) {
            r2h ^= 1L << ml8;
            r1h2 ^= ByteArrayUtil.getLong(input, off);
            if (len != 4) {
                r2h ^= (long)input.charAt(off + 4);
                if (len != 5) {
                    r2h ^= (long)input.charAt(off + 5) << 16;
                    if (len != 6) {
                        r2h ^= (long)input.charAt(off + 6) << 32;
                    }
                }
            }
        } else if (len > 0) {
            r1h2 ^= 1L << ml8;
            r1h2 ^= (long)input.charAt(off);
            if (len != 1) {
                r1h2 ^= (long)input.charAt(off + 1) << 16;
                if (len != 2) {
                    r1h2 ^= (long)input.charAt(off + 2) << 32;
                }
            }
        } else if (input.length() != 0) {
            r1h2 ^= 1L;
        }
        return Komihash5_0.finish(r1h2, r2h, see5);
    }

    @Override
    public long hashIntToLong(int v) {
        return Komihash5_0.finish(this.seed1 ^ 0x100000000L ^ (long)v & 0xFFFFFFFFL, this.seed5, this.seed5);
    }

    @Override
    public long hashIntIntIntToLong(int v1, int v2, int v3) {
        return this.finish12Bytes((long)v1 & 0xFFFFFFFFL ^ (long)v2 << 32, 0x100000000L ^ (long)v3 & 0xFFFFFFFFL);
    }

    @Override
    public long hashIntLongToLong(int v1, long v2) {
        return this.finish12Bytes((long)v1 & 0xFFFFFFFFL ^ v2 << 32, 0x100000000L ^ v2 >>> 32);
    }

    @Override
    public long hashLongToLong(long v) {
        return Komihash5_0.finish(this.seed1 ^ v, this.seed5 ^ 1L, this.seed5);
    }

    @Override
    public long hashLongLongToLong(long v1, long v2) {
        long tmp1 = this.seed1 ^ v1;
        long tmp2 = this.seed5 ^ v2;
        long see5 = UnsignedMultiplyUtil.unsignedMultiplyHigh(tmp1, tmp2) + this.seed5;
        return Komihash5_0.finish(tmp1 * tmp2 ^ (see5 ^ 1L), see5, see5);
    }

    @Override
    public long hashLongLongLongToLong(long v1, long v2, long v3) {
        long tmp1 = this.seed1 ^ v1;
        long tmp2 = this.seed5 ^ v2;
        long see5 = UnsignedMultiplyUtil.unsignedMultiplyHigh(tmp1, tmp2) + this.seed5;
        return Komihash5_0.finish(tmp1 * tmp2 ^ (see5 ^ v3), see5 ^ 1L, see5);
    }

    @Override
    public long hashLongIntToLong(long v1, int v2) {
        return this.finish12Bytes(v1, 0x100000000L ^ (long)v2 & 0xFFFFFFFFL);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Komihash5_0)) {
            return false;
        }
        Komihash5_0 that = (Komihash5_0)obj;
        return this.initSeed == that.initSeed;
    }

    public int hashCode() {
        return Long.hashCode(this.initSeed);
    }

    private class HashStreamImpl
    extends AbstractKomihash.HashStreamImpl {
        private static final byte SERIAL_VERSION_V0 = 0;

        private HashStreamImpl() {
        }

        @Override
        protected boolean isLastByteNeeded() {
            return false;
        }

        @Override
        protected void processBuffer(long b0, long b1, long b2, long b3, long b4, long b5, long b6, long b7) {
            this.see5 += UnsignedMultiplyUtil.unsignedMultiplyHigh(b0 ^= this.see1, b4 ^= this.see5);
            this.see6 += UnsignedMultiplyUtil.unsignedMultiplyHigh(b1 ^= this.see2, b5 ^= this.see6);
            this.see7 += UnsignedMultiplyUtil.unsignedMultiplyHigh(b2 ^= this.see3, b6 ^= this.see7);
            this.see8 += UnsignedMultiplyUtil.unsignedMultiplyHigh(b3 ^= this.see4, b7 ^= this.see8);
            this.see2 = this.see5 ^ b1 * b5;
            this.see3 = this.see6 ^ b2 * b6;
            this.see4 = this.see7 ^ b3 * b7;
            this.see1 = this.see8 ^ b0 * b4;
        }

        @Override
        protected long finalizeGetAsLong(long se1, long se5, int off, int len) {
            long r1h = se5;
            long r2h = se1;
            long y = 1L << (len << 3);
            if (len > 7) {
                r1h ^= y;
                r2h ^= ByteArrayUtil.getLong(this.buffer, off);
                r1h ^= ByteArrayUtil.getLong(this.buffer, off + 8) & y - 1L;
            } else if (this.bufferCount > 0 || this.init) {
                r2h ^= y;
                r2h ^= ByteArrayUtil.getLong(this.buffer, off) & y - 1L;
            }
            return AbstractKomihash.finish(r1h, r2h, se5);
        }

        @Override
        public byte[] getState() {
            byte[] state = new byte[2 + (this.init ? 64 : 0) + this.bufferCount];
            state[0] = 0;
            int off = 1;
            state[off++] = (byte)(this.bufferCount | (this.init ? 128 : 0));
            if (this.init) {
                ByteArrayUtil.setLong(state, off, this.see1);
                ByteArrayUtil.setLong(state, off += 8, this.see2);
                ByteArrayUtil.setLong(state, off += 8, this.see3);
                ByteArrayUtil.setLong(state, off += 8, this.see4);
                ByteArrayUtil.setLong(state, off += 8, this.see5);
                ByteArrayUtil.setLong(state, off += 8, this.see6);
                ByteArrayUtil.setLong(state, off += 8, this.see7);
                ByteArrayUtil.setLong(state, off += 8, this.see8);
                off += 8;
            }
            System.arraycopy(this.buffer, 0, state, off, this.bufferCount);
            return state;
        }

        @Override
        public HashStream64 setState(byte[] state) {
            Preconditions.checkArgument(state != null);
            Preconditions.checkArgument(state.length >= 2);
            Preconditions.checkArgument(state[0] == 0);
            int off = 1;
            byte b = state[off++];
            this.bufferCount = b & 0x7F;
            this.init = b < 0;
            Preconditions.checkArgument(this.bufferCount <= 63);
            Preconditions.checkArgument(state.length == 2 + (this.init ? 64 : 0) + this.bufferCount);
            if (this.init) {
                this.see1 = ByteArrayUtil.getLong(state, off);
                this.see2 = ByteArrayUtil.getLong(state, off += 8);
                this.see3 = ByteArrayUtil.getLong(state, off += 8);
                this.see4 = ByteArrayUtil.getLong(state, off += 8);
                this.see5 = ByteArrayUtil.getLong(state, off += 8);
                this.see6 = ByteArrayUtil.getLong(state, off += 8);
                this.see7 = ByteArrayUtil.getLong(state, off += 8);
                this.see8 = ByteArrayUtil.getLong(state, off += 8);
                off += 8;
            } else {
                this.see1 = Komihash5_0.this.seed1;
                this.see2 = Komihash5_0.this.seed2;
                this.see3 = Komihash5_0.this.seed3;
                this.see4 = Komihash5_0.this.seed4;
                this.see5 = Komihash5_0.this.seed5;
                this.see6 = Komihash5_0.this.seed6;
                this.see7 = Komihash5_0.this.seed7;
                this.see8 = Komihash5_0.this.seed8;
            }
            System.arraycopy(state, off, this.buffer, 0, this.bufferCount);
            return this;
        }
    }
}

