/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import java.util.Enumeration;
import java.util.Objects;
import java.util.ResourceBundle;

public class ResourceBundleWithFallback
extends ResourceBundle {
    private final ResourceBundle bundle;
    private final ResourceBundle fallbackBundle;

    public ResourceBundleWithFallback(ResourceBundle bundle, ResourceBundle fallbackBundle) {
        this.bundle = bundle;
        this.fallbackBundle = fallbackBundle;
    }

    @Override
    public Object handleGetObject(String key) {
        String s = this.bundle.getString(key);
        if (s.trim().isEmpty()) {
            return this.fallbackBundle.getString(key);
        }
        return s;
    }

    @Override
    public Enumeration<String> getKeys() {
        return this.bundle.getKeys();
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourceBundleWithFallback)) {
            return false;
        }
        ResourceBundleWithFallback that = (ResourceBundleWithFallback)o;
        return Objects.equals(this.bundle, that.bundle) && Objects.equals(this.fallbackBundle, that.fallbackBundle);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.bundle);
        result = 31 * result + Objects.hashCode(this.fallbackBundle);
        return result;
    }
}

