/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.idea.AppMode;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.PlatformUtils;
import com.intellij.util.xml.dom.XmlDomReader;
import com.intellij.util.xml.dom.XmlElement;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ApplicationNamesInfo {
    private final String myProductName;
    private final String myFullProductName;
    private final String myEditionName;
    private final String myScriptName;
    private final String myMotto;
    private static volatile ApplicationNamesInfo instance;

    @NotNull
    private static XmlElement loadData() {
        XmlElement xmlElement;
        String prefix;
        block21: {
            prefix = System.getProperty("idea.platform.prefix", "");
            String appInfoData = ApplicationNamesInfo.getAppInfoData();
            if (AppMode.isRunningFromDevBuild() && appInfoData.isEmpty()) {
                String module = null;
                if (prefix.isEmpty() || prefix.equals("idea")) {
                    module = "intellij.idea.ultimate.customization";
                } else if (prefix.equals("WebStorm")) {
                    module = "intellij.webstorm";
                }
                if (module != null) {
                    XmlElement xmlElement2;
                    String resource = (prefix.equals("idea") ? "" : prefix) + "ApplicationInfo.xml";
                    Path file = PathManager.getHomeDir().resolve("out/classes/production/" + module + "/idea/" + resource);
                    try {
                        xmlElement2 = XmlDomReader.readXmlAsModel(Files.newInputStream(file, new OpenOption[0]));
                    }
                    catch (NoSuchFileException noSuchFileException) {
                        break block21;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Cannot load " + file, e);
                    }
                    if (xmlElement2 == null) {
                        ApplicationNamesInfo.$$$reportNull$$$0(0);
                    }
                    return xmlElement2;
                }
            } else {
                String customAppInfo;
                if (prefix.equals("Gateway") && (customAppInfo = System.getProperty("idea.application.info.value")) != null) {
                    XmlElement xmlElement3;
                    try {
                        Path file = Paths.get(customAppInfo, new String[0]);
                        xmlElement3 = XmlDomReader.readXmlAsModel(Files.newInputStream(file, new OpenOption[0]));
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Cannot load custom application info file " + customAppInfo, e);
                    }
                    if (xmlElement3 == null) {
                        ApplicationNamesInfo.$$$reportNull$$$0(1);
                    }
                    return xmlElement3;
                }
                boolean forceLoadingFromResources = "true".equals(System.getProperty("intellij.platform.load.app.info.from.resources"));
                if (!forceLoadingFromResources && !appInfoData.isEmpty()) {
                    XmlElement xmlElement4 = XmlDomReader.readXmlAsModel(appInfoData.getBytes(StandardCharsets.UTF_8));
                    if (xmlElement4 == null) {
                        ApplicationNamesInfo.$$$reportNull$$$0(2);
                    }
                    return xmlElement4;
                }
            }
        }
        String resource = "idea/" + (prefix.equals("idea") ? "" : prefix) + "ApplicationInfo.xml";
        InputStream stream = ApplicationNamesInfo.class.getClassLoader().getResourceAsStream(resource);
        if (stream == null) {
            throw new RuntimeException("Resource not found: " + resource);
        }
        try {
            XmlElement data = XmlDomReader.readXmlAsModel(stream);
            if (PlatformUtils.isQodana()) {
                ApplicationNamesInfo.setQodanaProductAttributes(data);
            }
            xmlElement = data;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot load resource: " + resource, e);
        }
        if (xmlElement == null) {
            ApplicationNamesInfo.$$$reportNull$$$0(3);
        }
        return xmlElement;
    }

    private static void setQodanaProductAttributes(XmlElement data) {
        XmlElement namesNode = data.getChild("names");
        assert (namesNode != null);
        String qodanaProductName = System.getProperty("qodana.product.name", "Qodana");
        namesNode.attributes.put("product", qodanaProductName);
        namesNode.attributes.put("fullname", qodanaProductName);
        XmlElement buildNode = data.getChild("build");
        assert (buildNode != null);
        buildNode.attributes.put("number", System.getProperty("qodana.build.number", "QD-SNAPSHOT"));
        String qodanaEap = System.getProperty("qodana.eap", "false");
        XmlElement versionNode = data.getChild("version");
        assert (versionNode != null);
        versionNode.attributes.put("eap", qodanaEap);
    }

    @ApiStatus.Internal
    public static String getAppInfoData() {
        return "<!-- Copyright 2000-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file. -->\n<component xmlns=\"http://jetbrains.org/intellij/schema/application-info\">\n  <version major=\"2025\" minor=\"3\" eap=\"false\"/>\n  <company name=\"JetBrains s.r.o.\" url=\"https://www.jetbrains.com\" copyrightStart=\"2010\"/>\n  <build number=\"PC-253.28294.336\" date=\"202512091015\" majorReleaseDate=\"20251208\"/>\n  <logo url=\"/pycharm_core_logo.png\"/>\n  <icon svg=\"/pycharm-ce.svg\" svg-small=\"/pycharm-ce_16.svg\"/>\n  <icon-eap svg=\"/pycharm-ce-eap.svg\" svg-small=\"/pycharm-ce-eap_16.svg\"/>\n  <names product=\"PyCharm\" edition=\"Community Edition\" script=\"pycharm\" motto=\"Python IDE for Professional Developers\"/>\n\n  <essential-plugin>PythonCore</essential-plugin>\n  <essential-plugin>com.jetbrains.pycharm.community.customization</essential-plugin>\n  <essential-plugin>intellij.pycharm.community.customization.shared</essential-plugin>\n\n  <!-- Required for PythonCore plugin -->\n  <essential-plugin>org.toml.lang</essential-plugin>\n  <essential-plugin>com.intellij.modules.json</essential-plugin>\n</component>\n";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @NotNull
    public static XmlElement initAndGetRawData() {
        Class<ApplicationNamesInfo> clazz = ApplicationNamesInfo.class;
        synchronized (ApplicationNamesInfo.class) {
            XmlElement data = ApplicationNamesInfo.loadData();
            if (instance == null) {
                instance = new ApplicationNamesInfo(data);
            }
            XmlElement xmlElement = data;
            // ** MonitorExit[var0] (shouldn't be in output)
            if (xmlElement == null) {
                ApplicationNamesInfo.$$$reportNull$$$0(4);
            }
            return xmlElement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public static ApplicationNamesInfo getInstance() {
        ApplicationNamesInfo result = instance;
        if (result == null) {
            Class<ApplicationNamesInfo> clazz = ApplicationNamesInfo.class;
            // MONITORENTER : com.intellij.openapi.application.ApplicationNamesInfo.class
            result = instance;
            if (result == null) {
                instance = result = new ApplicationNamesInfo(ApplicationNamesInfo.loadData());
            }
            // MONITOREXIT : clazz
        }
        ApplicationNamesInfo applicationNamesInfo = result;
        if (applicationNamesInfo != null) return applicationNamesInfo;
        ApplicationNamesInfo.$$$reportNull$$$0(5);
        return applicationNamesInfo;
    }

    private ApplicationNamesInfo(XmlElement rootElement) {
        XmlElement names = rootElement.getChild("names");
        assert (names != null);
        this.myProductName = names.getAttributeValue("product");
        this.myFullProductName = names.getAttributeValue("fullname", this.myProductName);
        this.myEditionName = names.getAttributeValue("edition");
        this.myScriptName = names.getAttributeValue("script");
        this.myMotto = names.getAttributeValue("motto", "The Drive to Develop");
    }

    @NlsSafe
    public String getProductName() {
        return this.myProductName;
    }

    @NlsSafe
    public String getFullProductName() {
        return this.myFullProductName;
    }

    @NlsSafe
    public String getFullProductNameWithEdition() {
        return this.myEditionName == null ? this.myFullProductName : this.myFullProductName + ' ' + this.myEditionName;
    }

    @NlsSafe
    @Nullable
    public String getEditionName() {
        return this.myEditionName;
    }

    public String getLowercaseProductName() {
        String s = this.myProductName.toLowerCase(Locale.ENGLISH);
        return Character.isUpperCase(s.charAt(0)) ? s : Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    public String getScriptName() {
        return this.myScriptName;
    }

    @NotNull
    public String getMotto() {
        String string = this.myMotto;
        if (string == null) {
            ApplicationNamesInfo.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/openapi/application/ApplicationNamesInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "loadData";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "initAndGetRawData";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMotto";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

