/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command.note.sequence;

import net.sourceforge.plantuml.Lazy;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.Trim;
import net.sourceforge.plantuml.command.note.SingleMultiFactoryCommand;
import net.sourceforge.plantuml.klimt.color.ColorParser;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.color.HColorSet;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.Pattern2;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.sequencediagram.EventWithNote;
import net.sourceforge.plantuml.sequencediagram.Note;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.NoteStyle;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import net.sourceforge.plantuml.skin.ColorParam;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.stereo.StereotypePattern;
import net.sourceforge.plantuml.url.Url;
import net.sourceforge.plantuml.url.UrlBuilder;
import net.sourceforge.plantuml.url.UrlMode;
import net.sourceforge.plantuml.utils.BlocLines;
import net.sourceforge.plantuml.utils.LineLocation;

public final class FactorySequenceNoteOnArrowCommand
implements SingleMultiFactoryCommand<SequenceDiagram> {
    private static final Lazy<Pattern2> END = new Lazy<Pattern2>(() -> Pattern2.cmpile("^[%s]*end[%s]?note$"));

    private IRegex getRegexConcatMultiLine() {
        return RegexConcat.build(FactorySequenceNoteOnArrowCommand.class.getName() + "multi", RegexLeaf.start(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(1, "STYLE", "(note|hnote|rnote)"), StereotypePattern.optional("STEREO1"), new RegexLeaf(1, "POSITION", "(right|left|bottom|top)"), StereotypePattern.optional("STEREO2"), ColorParser.exp1(), RegexLeaf.spaceZeroOrMore(), UrlBuilder.OPTIONAL, RegexLeaf.end());
    }

    private IRegex getRegexConcatSingleLine() {
        return RegexConcat.build(FactorySequenceNoteOnArrowCommand.class.getName() + "single", RegexLeaf.start(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(1, "STYLE", "(note|hnote|rnote)"), StereotypePattern.optional("STEREO1"), new RegexLeaf(1, "POSITION", "(right|left|bottom|top)"), StereotypePattern.optional("STEREO2"), ColorParser.exp1(), RegexLeaf.spaceZeroOrMore(), UrlBuilder.OPTIONAL, RegexLeaf.spaceZeroOrMore(), new RegexLeaf(":"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(1, "NOTE", "(.*)"), RegexLeaf.end());
    }

    @Override
    public Command<SequenceDiagram> createSingleLine() {
        return new SingleLineCommand2<SequenceDiagram>(this.getRegexConcatSingleLine()){

            @Override
            protected CommandExecutionResult executeArg(SequenceDiagram diagram, LineLocation location, RegexResult arg, ParserPass currentPass) throws NoSuchColorException {
                Display display = Display.getWithNewlines(diagram.getPragma(), arg.get("NOTE", 0));
                return FactorySequenceNoteOnArrowCommand.this.executeInternal(diagram, arg, diagram.manageVariable(display));
            }
        };
    }

    @Override
    public Command<SequenceDiagram> createMultiLine(boolean withBracket) {
        return new CommandMultilines2<SequenceDiagram>(this.getRegexConcatMultiLine(), MultilinesStrategy.KEEP_STARTING_QUOTE, Trim.BOTH, END){

            @Override
            protected CommandExecutionResult executeNow(SequenceDiagram diagram, BlocLines lines, ParserPass currentPass) throws NoSuchColorException {
                RegexResult line0 = this.getStartingPattern().matcher(lines.getFirst().getTrimmed().getString());
                lines = lines.subExtract(1, 1).expandsNewline(false);
                lines = lines.removeEmptyColumns();
                Display display = lines.toDisplay();
                return FactorySequenceNoteOnArrowCommand.this.executeInternal(diagram, line0, diagram.manageVariable(display));
            }
        };
    }

    private CommandExecutionResult executeInternal(SequenceDiagram diagram, RegexResult line0, Display display) throws NoSuchColorException {
        EventWithNote event = diagram.getLastEventWithNote();
        if (event == null) {
            return CommandExecutionResult.ok();
        }
        NotePosition position = NotePosition.valueOf(StringUtils.goUpperCase(line0.get("POSITION", 0)));
        Url url = null;
        if (line0.get("URL", 0) != null) {
            UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlMode.STRICT);
            url = urlBuilder.getUrl(line0.get("URL", 0));
        }
        NoteStyle style = NoteStyle.getNoteStyle(line0.get("STYLE", 0));
        String backcolor0 = line0.get("COLOR", 0);
        Colors colors = Colors.empty().add(ColorType.BACK, backcolor0 == null ? null : HColorSet.instance().getColor(backcolor0));
        Note note = new Note(display, position, style, diagram.getSkinParam().getCurrentStyleBuilder());
        String stereotypeString = line0.getLazzy("STEREO", 0);
        if (stereotypeString != null) {
            Stereotype stereotype = Stereotype.build(stereotypeString);
            colors = colors.applyStereotypeForNote(stereotype, diagram.getSkinParam(), ColorParam.noteBackground, ColorParam.noteBorder);
            note.setStereotype(stereotype);
        }
        note.setUrl(url);
        note.setColors(colors);
        event.addNote(note);
        return CommandExecutionResult.ok();
    }
}

