/*
 * Decompiled with CFR 0.152.
 */
package org.passay;

import org.passay.AbstractDictionaryRule;
import org.passay.dictionary.Dictionary;

public class DictionarySubstringRule
extends AbstractDictionaryRule {
    public static final String ERROR_CODE = "ILLEGAL_WORD";
    public static final String ERROR_CODE_REVERSED = "ILLEGAL_WORD_REVERSED";

    public DictionarySubstringRule() {
    }

    public DictionarySubstringRule(Dictionary dict) {
        this.setDictionary(dict);
    }

    @Override
    protected String doWordSearch(String text) {
        for (int i = 1; i <= text.length(); ++i) {
            int j = 0;
            while (j + i <= text.length()) {
                String s = text.substring(j, j + i);
                if (this.getDictionary().search(s)) {
                    return s;
                }
                ++j;
            }
        }
        return null;
    }

    @Override
    protected String getErrorCode(boolean backwards) {
        return backwards ? ERROR_CODE_REVERSED : ERROR_CODE;
    }
}

