/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.encryptor;

import com.amazonaws.encryptionsdk.AwsCrypto;
import com.amazonaws.encryptionsdk.CommitmentPolicy;
import com.amazonaws.encryptionsdk.CryptoResult;
import com.amazonaws.encryptionsdk.MasterKeyProvider;
import com.amazonaws.encryptionsdk.jce.JceMasterKey;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.ResourceNotFoundException;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.engine.VersionConflictEngineException;
import org.opensearch.ml.common.exception.MLException;
import org.opensearch.ml.common.settings.MLCommonsSettings;
import org.opensearch.ml.common.utils.StringUtils;
import org.opensearch.ml.engine.encryptor.Encryptor;
import org.opensearch.ml.engine.indices.MLIndicesHandler;
import org.opensearch.remote.metadata.client.GetDataObjectRequest;
import org.opensearch.remote.metadata.client.GetDataObjectResponse;
import org.opensearch.remote.metadata.client.PutDataObjectRequest;
import org.opensearch.remote.metadata.client.PutDataObjectResponse;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.remote.metadata.common.SdkClientUtils;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.opensearch.transport.client.Client;

public class EncryptorImpl
implements Encryptor {
    @Generated
    private static final Logger log = LogManager.getLogger(EncryptorImpl.class);
    public static final String MASTER_KEY_NOT_READY_ERROR = "The ML encryption master key has not been initialized yet. Please retry after waiting for 10 seconds.";
    private ClusterService clusterService;
    private Client client;
    private SdkClient sdkClient;
    private final Cache<String, String> tenantMasterKeys;
    private MLIndicesHandler mlIndicesHandler;
    private final Object lock = new Object();
    private volatile long masterKeyCacheTtlMinutes;
    public static final String DEFAULT_TENANT_ID = "03000200-0400-0500-0006-000700080009";

    public EncryptorImpl(ClusterService clusterService, Client client, SdkClient sdkClient, MLIndicesHandler mlIndicesHandler) {
        this.masterKeyCacheTtlMinutes = ((Integer)MLCommonsSettings.ML_COMMONS_MASTER_KEY_CACHE_TTL_MINUTES.get(clusterService.getSettings())).intValue();
        this.tenantMasterKeys = CacheBuilder.newBuilder().expireAfterWrite(this.masterKeyCacheTtlMinutes, TimeUnit.MINUTES).removalListener((RemovalListener)new RemovalListener<String, String>(this){

            public void onRemoval(RemovalNotification<String, String> notification) {
                log.info("Master key cache entry removed - Tenant: {}, Cause: {}", notification.getKey(), (Object)notification.getCause());
            }
        }).build();
        this.clusterService = clusterService;
        this.client = client;
        this.sdkClient = sdkClient;
        this.mlIndicesHandler = mlIndicesHandler;
    }

    @VisibleForTesting
    EncryptorImpl(ClusterService clusterService, Client client, SdkClient sdkClient, MLIndicesHandler mlIndicesHandler, long cacheTtl, TimeUnit timeUnit) {
        this.tenantMasterKeys = CacheBuilder.newBuilder().expireAfterWrite(cacheTtl, timeUnit).removalListener((RemovalListener)new RemovalListener<String, String>(this){

            public void onRemoval(RemovalNotification<String, String> notification) {
                log.info("Master key cache entry removed - Tenant: {}, Cause: {}", notification.getKey(), (Object)notification.getCause());
            }
        }).build();
        this.clusterService = clusterService;
        this.client = client;
        this.sdkClient = sdkClient;
        this.mlIndicesHandler = mlIndicesHandler;
    }

    public EncryptorImpl(String tenantId, String masterKey) {
        this(tenantId, masterKey, 5L, TimeUnit.MINUTES);
    }

    EncryptorImpl(String tenantId, String masterKey, long cacheTtl, TimeUnit timeUnit) {
        this.tenantMasterKeys = CacheBuilder.newBuilder().expireAfterWrite(cacheTtl, timeUnit).removalListener((RemovalListener)new RemovalListener<String, String>(this){

            public void onRemoval(RemovalNotification<String, String> notification) {
                log.info("Master key cache entry removed - Tenant: {}, Cause: {}", notification.getKey(), (Object)notification.getCause());
            }
        }).build();
        this.tenantMasterKeys.put((Object)Objects.requireNonNullElse(tenantId, DEFAULT_TENANT_ID), (Object)masterKey);
    }

    @Override
    public void setMasterKey(String tenantId, String masterKey) {
        this.tenantMasterKeys.put((Object)Objects.requireNonNullElse(tenantId, DEFAULT_TENANT_ID), (Object)masterKey);
    }

    @Override
    public String getMasterKey(String tenantId) {
        return (String)this.tenantMasterKeys.getIfPresent((Object)Objects.requireNonNullElse(tenantId, DEFAULT_TENANT_ID));
    }

    @Override
    public String encrypt(String plainText, String tenantId) {
        String masterKey = this.getOrInitMasterKey(tenantId);
        AwsCrypto crypto = AwsCrypto.builder().withCommitmentPolicy(CommitmentPolicy.RequireEncryptRequireDecrypt).build();
        JceMasterKey jceMasterKey = this.createJceMasterKey(masterKey);
        CryptoResult encryptResult = crypto.encryptData((MasterKeyProvider)jceMasterKey, plainText.getBytes(StandardCharsets.UTF_8));
        return Base64.getEncoder().encodeToString((byte[])encryptResult.getResult());
    }

    @Override
    public String decrypt(String encryptedText, String tenantId) {
        String masterKey = this.getOrInitMasterKey(tenantId);
        AwsCrypto crypto = AwsCrypto.builder().withCommitmentPolicy(CommitmentPolicy.RequireEncryptRequireDecrypt).build();
        JceMasterKey jceMasterKey = this.createJceMasterKey(masterKey);
        CryptoResult decryptedResult = crypto.decryptData((MasterKeyProvider)jceMasterKey, Base64.getDecoder().decode(encryptedText));
        return new String((byte[])decryptedResult.getResult());
    }

    @Override
    public String generateMasterKey() {
        byte[] keyBytes = new byte[32];
        new SecureRandom().nextBytes(keyBytes);
        return Base64.getEncoder().encodeToString(keyBytes);
    }

    private JceMasterKey createJceMasterKey(String masterKey) {
        byte[] bytes = Base64.getDecoder().decode(masterKey);
        return JceMasterKey.getInstance((SecretKey)new SecretKeySpec(bytes, "AES"), (String)"Custom", (String)"", (String)"AES/GCM/NOPADDING");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getOrInitMasterKey(String tenantId) {
        String effectiveTenantId = Objects.requireNonNullElse(tenantId, DEFAULT_TENANT_ID);
        String masterKey = (String)this.tenantMasterKeys.getIfPresent((Object)effectiveTenantId);
        if (masterKey != null) {
            return masterKey;
        }
        Object object = this.lock;
        synchronized (object) {
            masterKey = (String)this.tenantMasterKeys.getIfPresent((Object)effectiveTenantId);
            if (masterKey == null) {
                this.initMasterKey(tenantId);
                masterKey = (String)this.tenantMasterKeys.getIfPresent((Object)effectiveTenantId);
                if (masterKey == null) {
                    throw new ResourceNotFoundException(MASTER_KEY_NOT_READY_ERROR, new Object[0]);
                }
            }
        }
        return masterKey;
    }

    private void initMasterKey(String tenantId) {
        if (this.tenantMasterKeys.getIfPresent((Object)Objects.requireNonNullElse(tenantId, DEFAULT_TENANT_ID)) != null) {
            return;
        }
        Object masterKeyId = "master_key";
        if (tenantId != null) {
            masterKeyId = "master_key_" + StringUtils.hashString((String)tenantId);
        }
        AtomicReference<Exception> exceptionRef = new AtomicReference<Exception>();
        CountDownLatch latch = new CountDownLatch(1);
        this.mlIndicesHandler.initMLConfigIndex(this.createInitMLConfigIndexListener(exceptionRef, latch, tenantId, (String)masterKeyId));
        this.waitForLatch(latch);
        this.checkMasterKeyInitialization(tenantId, exceptionRef);
    }

    private void waitForLatch(CountDownLatch latch) {
        try {
            boolean completed = latch.await(3L, TimeUnit.SECONDS);
            if (!completed) {
                throw new MLException("Fetching master key timed out.");
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    private void checkMasterKeyInitialization(String tenantId, AtomicReference<Exception> exceptionRef) {
        if (exceptionRef.get() != null) {
            log.debug("Failed to init master key for tenant {}", (Object)tenantId, (Object)exceptionRef.get());
            if (exceptionRef.get() instanceof RuntimeException) {
                throw (RuntimeException)exceptionRef.get();
            }
            throw new MLException((Throwable)exceptionRef.get());
        }
        if (this.tenantMasterKeys.getIfPresent((Object)Objects.requireNonNullElse(tenantId, DEFAULT_TENANT_ID)) == null) {
            throw new ResourceNotFoundException(MASTER_KEY_NOT_READY_ERROR, new Object[0]);
        }
    }

    private ActionListener<Boolean> createInitMLConfigIndexListener(AtomicReference<Exception> exceptionRef, CountDownLatch latch, String tenantId, String masterKeyId) {
        return ActionListener.wrap(r -> this.handleInitMLConfigIndexSuccess(exceptionRef, latch, tenantId, masterKeyId), e -> this.handleInitMLConfigIndexFailure(exceptionRef, latch, masterKeyId, (Exception)e));
    }

    private void handleInitMLConfigIndexSuccess(AtomicReference<Exception> exceptionRef, CountDownLatch latch, String tenantId, String masterKeyId) {
        FetchSourceContext fetchSourceContext = new FetchSourceContext(true, Strings.EMPTY_ARRAY, Strings.EMPTY_ARRAY);
        GetDataObjectRequest getDataObjectRequest = this.createGetDataObjectRequest(tenantId, fetchSourceContext);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.sdkClient.getDataObjectAsync(getDataObjectRequest).whenComplete((response, throwable) -> this.handleGetDataObjectResponse(tenantId, masterKeyId, context, (GetDataObjectResponse)response, (Throwable)throwable, exceptionRef, latch));
        }
    }

    private void handleInitMLConfigIndexFailure(AtomicReference<Exception> exceptionRef, CountDownLatch latch, String masterKeyId, Exception e) {
        log.debug("Failed to init ML config index", (Throwable)e);
        exceptionRef.set(new RuntimeException("No response to create ML Config index"));
        latch.countDown();
    }

    private void handleGetDataObjectResponse(String tenantId, String masterKeyId, ThreadContext.StoredContext context, GetDataObjectResponse response, Throwable throwable, AtomicReference<Exception> exceptionRef, CountDownLatch latch) {
        log.debug("Completed Get MASTER_KEY Request, for tenant id:{}", (Object)tenantId);
        if (throwable != null) {
            this.handleGetDataObjectFailure(throwable, exceptionRef, latch);
        } else {
            this.handleGetDataObjectSuccess(response, tenantId, masterKeyId, exceptionRef, latch, context);
        }
        context.restore();
    }

    private void handleGetDataObjectFailure(Throwable throwable, AtomicReference<Exception> exceptionRef, CountDownLatch latch) {
        Exception cause = SdkClientUtils.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[]{OpenSearchStatusException.class});
        log.debug("Failed to get ML encryption master key from config index", (Throwable)cause);
        exceptionRef.set(cause);
        latch.countDown();
    }

    private void handleGetDataObjectSuccess(GetDataObjectResponse response, String tenantId, String masterKeyId, AtomicReference<Exception> exceptionRef, CountDownLatch latch, ThreadContext.StoredContext context) {
        try {
            GetResponse getMasterKeyResponse;
            GetResponse getResponse = getMasterKeyResponse = response.parser() == null ? null : GetResponse.fromXContent((XContentParser)response.parser());
            if (getMasterKeyResponse != null && getMasterKeyResponse.isExists()) {
                Map source = getMasterKeyResponse.getSourceAsMap();
                if (source != null) {
                    Object keyValue = source.get("master_key");
                    if (keyValue instanceof String) {
                        this.tenantMasterKeys.put((Object)Objects.requireNonNullElse(tenantId, DEFAULT_TENANT_ID), (Object)((String)keyValue));
                        log.info("ML encryption master key already initialized, no action needed");
                    } else {
                        log.error("Master key not found or not a string for tenantId: {}, masterKeyId: {}", (Object)tenantId, (Object)masterKeyId);
                        exceptionRef.set((Exception)new ResourceNotFoundException(MASTER_KEY_NOT_READY_ERROR, new Object[0]));
                    }
                } else {
                    log.error("Master key not found or not a string for tenantId: {}, masterKeyId: {}", (Object)tenantId, (Object)masterKeyId);
                    exceptionRef.set((Exception)new ResourceNotFoundException(MASTER_KEY_NOT_READY_ERROR, new Object[0]));
                }
                latch.countDown();
            } else {
                this.initializeNewMasterKey(tenantId, masterKeyId, exceptionRef, latch, context);
            }
        }
        catch (Exception e) {
            log.debug("Failed to get ML encryption master key from config index", (Throwable)e);
            exceptionRef.set(e);
            latch.countDown();
        }
    }

    private void initializeNewMasterKey(String tenantId, String masterKeyId, AtomicReference<Exception> exceptionRef, CountDownLatch latch, ThreadContext.StoredContext context) {
        String generatedMasterKey = this.generateMasterKey();
        this.sdkClient.putDataObjectAsync(this.createPutDataObjectRequest(tenantId, masterKeyId, generatedMasterKey)).whenComplete((putDataObjectResponse, throwable1) -> {
            try {
                this.handlePutDataObjectResponse(tenantId, masterKeyId, context, (PutDataObjectResponse)putDataObjectResponse, (Throwable)throwable1, exceptionRef, latch, generatedMasterKey);
            }
            catch (IOException e) {
                log.debug("Failed to index ML encryption master key to config index", (Throwable)e);
                exceptionRef.set(e);
                latch.countDown();
            }
        });
    }

    private PutDataObjectRequest createPutDataObjectRequest(String tenantId, String masterKeyId, String generatedMasterKey) {
        return ((PutDataObjectRequest.Builder)((PutDataObjectRequest.Builder)((PutDataObjectRequest.Builder)PutDataObjectRequest.builder().tenantId(tenantId)).index(".plugins-ml-config")).id(masterKeyId)).overwriteIfExists(false).dataObject(Map.of("master_key", generatedMasterKey, "create_time", Instant.now().toEpochMilli(), "tenant_id", Objects.requireNonNullElse(tenantId, DEFAULT_TENANT_ID))).build();
    }

    private void handlePutDataObjectResponse(String tenantId, String masterKeyId, ThreadContext.StoredContext context, PutDataObjectResponse putDataObjectResponse, Throwable throwable, AtomicReference<Exception> exceptionRef, CountDownLatch latch, String generatedMasterKey) throws IOException {
        context.restore();
        if (throwable != null) {
            this.handlePutDataObjectFailure(tenantId, masterKeyId, context, throwable, exceptionRef, latch);
        } else {
            IndexResponse indexResponse = IndexResponse.fromXContent((XContentParser)putDataObjectResponse.parser());
            log.info("Master key creation result: {}, Master key id: {}", (Object)indexResponse.getResult(), (Object)indexResponse.getId());
            this.tenantMasterKeys.put((Object)Objects.requireNonNullElse(tenantId, DEFAULT_TENANT_ID), (Object)generatedMasterKey);
            log.info("ML encryption master key initialized successfully");
            latch.countDown();
        }
    }

    private void handlePutDataObjectFailure(String tenantId, String masterKeyId, ThreadContext.StoredContext context, Throwable throwable, AtomicReference<Exception> exceptionRef, CountDownLatch latch) {
        Exception cause = SdkClientUtils.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[]{OpenSearchStatusException.class});
        if (cause instanceof VersionConflictEngineException || cause instanceof OpenSearchException && ((OpenSearchException)cause).status() == RestStatus.CONFLICT) {
            this.handleVersionConflict(tenantId, masterKeyId, context, exceptionRef, latch);
        } else {
            log.debug("Failed to index ML encryption master key to config index", (Throwable)cause);
            exceptionRef.set(cause);
            latch.countDown();
        }
    }

    private void handleVersionConflict(String tenantId, String masterKeyId, ThreadContext.StoredContext context, AtomicReference<Exception> exceptionRef, CountDownLatch latch) {
        this.sdkClient.getDataObjectAsync(this.createGetDataObjectRequest(tenantId, new FetchSourceContext(true, Strings.EMPTY_ARRAY, Strings.EMPTY_ARRAY))).whenComplete((response, throwable) -> {
            try {
                this.handleVersionConflictResponse(tenantId, masterKeyId, context, (GetDataObjectResponse)response, (Throwable)throwable, exceptionRef, latch);
            }
            catch (IOException e) {
                log.debug("Failed to get ML encryption master key from config index", (Throwable)e);
                exceptionRef.set(e);
                latch.countDown();
            }
        });
    }

    private GetDataObjectRequest createGetDataObjectRequest(String tenantId, FetchSourceContext fetchSourceContext) {
        Object masterKeyId = "master_key";
        if (tenantId != null) {
            masterKeyId = "master_key_" + StringUtils.hashString((String)tenantId);
        }
        return ((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)GetDataObjectRequest.builder().index(".plugins-ml-config")).id((String)masterKeyId)).tenantId(tenantId)).fetchSourceContext(fetchSourceContext).build();
    }

    private void handleVersionConflictResponse(String tenantId, String masterKeyId, ThreadContext.StoredContext context, GetDataObjectResponse response1, Throwable throwable2, AtomicReference<Exception> exceptionRef, CountDownLatch latch) throws IOException {
        context.restore();
        log.debug("Completed Get config item");
        if (throwable2 != null) {
            Exception cause1 = SdkClientUtils.unwrapAndConvertToException((Throwable)throwable2, (Class[])new Class[]{OpenSearchStatusException.class});
            log.debug("Failed to get ML encryption master key from config index", (Throwable)cause1);
            exceptionRef.set((Exception)new ResourceNotFoundException(MASTER_KEY_NOT_READY_ERROR, new Object[0]));
            latch.countDown();
        } else {
            GetResponse getMasterKeyResponse;
            GetResponse getResponse = getMasterKeyResponse = response1.parser() == null ? null : GetResponse.fromXContent((XContentParser)response1.parser());
            if (getMasterKeyResponse != null && getMasterKeyResponse.isExists()) {
                Map source = getMasterKeyResponse.getSourceAsMap();
                if (source != null) {
                    Object keyValue = source.get("master_key");
                    if (keyValue instanceof String) {
                        this.tenantMasterKeys.put((Object)Objects.requireNonNullElse(tenantId, DEFAULT_TENANT_ID), (Object)((String)keyValue));
                        log.info("ML encryption master key already initialized, no action needed");
                    } else {
                        log.error("Master key not found or not a string for tenantId: {}, masterKeyId: {}", (Object)tenantId, (Object)masterKeyId);
                        exceptionRef.set((Exception)new ResourceNotFoundException(MASTER_KEY_NOT_READY_ERROR, new Object[0]));
                    }
                } else {
                    log.error("Master key not found or not a string for tenantId: {}, masterKeyId: {}", (Object)tenantId, (Object)masterKeyId);
                    exceptionRef.set((Exception)new ResourceNotFoundException(MASTER_KEY_NOT_READY_ERROR, new Object[0]));
                }
                latch.countDown();
            } else {
                exceptionRef.set((Exception)new ResourceNotFoundException(MASTER_KEY_NOT_READY_ERROR, new Object[0]));
                latch.countDown();
            }
        }
    }
}

