/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.TokenFilterBase;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinition;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinitionVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class MultiplexerTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant,
ToCopyableBuilder<Builder, MultiplexerTokenFilter> {
    @Nonnull
    private final List<String> filters;
    @Nullable
    private final Boolean preserveOriginal;
    public static final JsonpDeserializer<MultiplexerTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MultiplexerTokenFilter::setupMultiplexerTokenFilterDeserializer);

    private MultiplexerTokenFilter(Builder builder) {
        super(builder);
        this.filters = ApiTypeHelper.unmodifiableRequired(builder.filters, (Object)this, "filters");
        this.preserveOriginal = builder.preserveOriginal;
    }

    public static MultiplexerTokenFilter of(Function<Builder, ObjectBuilder<MultiplexerTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.Multiplexer;
    }

    @Nonnull
    public final List<String> filters() {
        return this.filters;
    }

    @Nullable
    public final Boolean preserveOriginal() {
        return this.preserveOriginal;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "multiplexer");
        super.serializeInternal(generator, mapper);
        generator.writeKey("filters");
        generator.writeStartArray();
        for (String item0 : this.filters) {
            generator.write(item0);
        }
        generator.writeEnd();
        if (this.preserveOriginal != null) {
            generator.writeKey("preserve_original");
            generator.write(this.preserveOriginal.booleanValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupMultiplexerTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        MultiplexerTokenFilter.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::filters, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "filters");
        op.add(Builder::preserveOriginal, JsonpDeserializer.booleanDeserializer(), "preserve_original");
        op.ignore("type");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.filters.hashCode();
        result = 31 * result + Objects.hashCode(this.preserveOriginal);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiplexerTokenFilter other = (MultiplexerTokenFilter)o;
        return this.filters.equals(other.filters) && Objects.equals(this.preserveOriginal, other.preserveOriginal);
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, MultiplexerTokenFilter> {
        private List<String> filters;
        @Nullable
        private Boolean preserveOriginal;

        public Builder() {
        }

        private Builder(MultiplexerTokenFilter o) {
            super(o);
            this.filters = Builder._listCopy(o.filters);
            this.preserveOriginal = o.preserveOriginal;
        }

        private Builder(Builder o) {
            super(o);
            this.filters = Builder._listCopy(o.filters);
            this.preserveOriginal = o.preserveOriginal;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder filters(List<String> list) {
            this.filters = Builder._listAddAll(this.filters, list);
            return this;
        }

        @Nonnull
        public final Builder filters(String value, String ... values) {
            this.filters = Builder._listAdd(this.filters, value, values);
            return this;
        }

        @Nonnull
        public final Builder preserveOriginal(@Nullable Boolean value) {
            this.preserveOriginal = value;
            return this;
        }

        @Override
        @Nonnull
        public MultiplexerTokenFilter build() {
            this._checkSingleUse();
            return new MultiplexerTokenFilter(this);
        }
    }
}

