/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling.encryption.providers.store;

import com.amazonaws.services.dynamodbv2.datamodeling.encryption.providers.EncryptionMaterialsProvider;
import java.util.Map;

public abstract class ProviderStore {
    public EncryptionMaterialsProvider getProvider(String materialName) {
        long currVersion = this.getMaxVersion(materialName);
        if (currVersion >= 0L) {
            return this.getProvider(materialName, currVersion);
        }
        return this.getOrCreate(materialName, 0L);
    }

    public abstract EncryptionMaterialsProvider getProvider(String var1, long var2);

    public EncryptionMaterialsProvider newProvider(String materialName) {
        long nextId = this.getMaxVersion(materialName) + 1L;
        return this.getOrCreate(materialName, nextId);
    }

    public EncryptionMaterialsProvider getOrCreate(String materialName, long nextId) {
        try {
            return this.getProvider(materialName, nextId);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new UnsupportedOperationException("This ProviderStore does not support creation.", ex);
        }
    }

    public abstract long getMaxVersion(String var1);

    public abstract long getVersionFromMaterialDescription(Map<String, String> var1);
}

