/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.processor;

import com.google.common.reflect.TypeToken;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ml.common.utils.StringUtils;
import org.opensearch.ml.engine.MLEngineClassLoader;
import org.opensearch.ml.engine.processor.MLProcessor;
import org.opensearch.ml.engine.processor.MLProcessorType;

public class ProcessorChain {
    @Generated
    private static final Logger log = LogManager.getLogger(ProcessorChain.class);
    public static final String INPUT_PROCESSORS = "input_processors";
    public static final String OUTPUT_PROCESSORS = "output_processors";
    private final List<MLProcessor> processors;

    public static List<MLProcessor> createProcessingChain(List<Map<String, Object>> processorConfigs) {
        if (processorConfigs == null || processorConfigs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<MLProcessor> processors = new ArrayList<MLProcessor>();
        for (Map<String, Object> config : processorConfigs) {
            MLProcessorType type = MLProcessorType.fromString((String)config.get("type"));
            MLProcessor mlProcessor = (MLProcessor)MLEngineClassLoader.initInstance(type, config, Map.class);
            processors.add(mlProcessor);
        }
        return processors;
    }

    public static List<MLProcessor> parseProcessorConfigs(Object config) {
        List processorConfigs;
        if (config == null) {
            return Collections.emptyList();
        }
        if (config instanceof Map) {
            processorConfigs = Collections.singletonList((Map)config);
        } else if (config instanceof List) {
            processorConfigs = (List)config;
        } else {
            log.warn("Invalid processor configuration type: {}. Expected Map or List.", (Object)config.getClass().getSimpleName());
            return Collections.emptyList();
        }
        return ProcessorChain.createProcessingChain(processorConfigs);
    }

    public static Object applyProcessors(Object input, List<MLProcessor> processors) {
        Object result = input;
        for (MLProcessor processor : processors) {
            result = processor.process(result);
        }
        return result;
    }

    public ProcessorChain(List<Map<String, Object>> processorConfigs) {
        this.processors = ProcessorChain.createProcessingChain(processorConfigs);
    }

    public ProcessorChain(MLProcessor ... processors) {
        this.processors = Arrays.asList(processors);
    }

    public Object process(Object input) {
        Object result = input;
        for (MLProcessor processor : this.processors) {
            result = processor.process(result);
        }
        return result;
    }

    public boolean hasProcessors() {
        return !this.processors.isEmpty();
    }

    public static List<Map<String, Object>> extractProcessorConfigs(Map<String, ?> params) {
        return ProcessorChain.extractProcessorConfigs(params, OUTPUT_PROCESSORS);
    }

    public static List<Map<String, Object>> extractProcessorConfigs(Map<String, ?> params, String paramName) {
        if (params == null || !params.containsKey(paramName)) {
            return Collections.emptyList();
        }
        Object configObj = params.get(paramName);
        if (configObj instanceof List) {
            return (List)configObj;
        }
        if (configObj instanceof String) {
            String configStr = (String)configObj;
            try {
                List processorConfigs = (List)StringUtils.gson.fromJson(configStr, new TypeToken<List<Map<String, Object>>>(){}.getType());
                if (processorConfigs != null) {
                    return processorConfigs;
                }
                log.warn("Failed to parse output processor config: null result from JSON parsing");
            }
            catch (JsonSyntaxException e) {
                log.error("Invalid JSON format in output processor configuration: {}", (Object)configStr, (Object)e);
            }
            catch (Exception e) {
                log.error("Error parsing output processor configuration: {}", (Object)configStr, (Object)e);
            }
        }
        return Collections.emptyList();
    }
}

