/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.anomalydetection;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.Visitor;
import com.amazon.randomcutforest.returntypes.DiVector;
import com.amazon.randomcutforest.tree.IBoundingBoxView;
import com.amazon.randomcutforest.tree.INodeView;
import java.util.Arrays;

public abstract class AbstractAttributionVisitor
implements Visitor<DiVector> {
    public static final int DEFAULT_IGNORE_LEAF_MASS_THRESHOLD = 0;
    protected final double[] differenceInRangeVector;
    protected final float[] pointToScore;
    protected final int treeMass;
    protected final DiVector directionalAttribution;
    protected boolean hitDuplicates;
    protected double savedScore;
    protected double sumOfNewRange;
    protected double sumOfDifferenceInRange;
    protected boolean ignoreLeaf;
    protected int ignoreLeafMassThreshold;
    protected boolean pointInsideBox;
    protected boolean[] coordInsideBox;
    protected IBoundingBoxView shadowBox;

    public AbstractAttributionVisitor(float[] pointToScore, int treeMass, int ignoreLeafMassThreshold) {
        this.pointToScore = Arrays.copyOf(pointToScore, pointToScore.length);
        this.treeMass = treeMass;
        this.ignoreLeaf = ignoreLeafMassThreshold > 0;
        this.ignoreLeafMassThreshold = ignoreLeafMassThreshold;
        this.hitDuplicates = false;
        this.pointInsideBox = false;
        this.savedScore = 0.0;
        this.directionalAttribution = new DiVector(pointToScore.length);
        this.shadowBox = null;
        this.coordInsideBox = new boolean[pointToScore.length];
        this.differenceInRangeVector = new double[2 * pointToScore.length];
    }

    public AbstractAttributionVisitor(float[] pointToScore, int treeMass) {
        this(pointToScore, treeMass, 0);
    }

    @Override
    public DiVector getResult() {
        DiVector result = new DiVector(this.directionalAttribution);
        result.componentwiseTransform(x -> CommonUtils.defaultScalarNormalizerFunction(x, this.treeMass));
        return result;
    }

    @Override
    public void accept(INodeView node, int depthOfNode) {
        if (this.pointInsideBox) {
            return;
        }
        IBoundingBoxView smallBox = this.hitDuplicates || this.ignoreLeaf ? (this.shadowBox = this.shadowBox == null ? node.getSiblingBoundingBox(this.pointToScore) : this.shadowBox.getMergedBox(node.getSiblingBoundingBox(this.pointToScore))) : node.getBoundingBox();
        IBoundingBoxView largeBox = smallBox.getMergedBox(this.pointToScore);
        this.updateRangesForScoring(smallBox, largeBox);
        double probOfCut = this.sumOfDifferenceInRange / this.sumOfNewRange;
        if (this.ignoreLeaf) {
            this.savedScore = probOfCut * this.scoreUnseen(depthOfNode, node.getMass()) + (1.0 - probOfCut) * this.savedScore;
        }
        if (probOfCut <= 0.0) {
            this.pointInsideBox = true;
        } else {
            double newScore = this.scoreUnseen(depthOfNode, node.getMass());
            for (int i = 0; i < this.pointToScore.length; ++i) {
                double probOfCutInSpikeDirection = this.differenceInRangeVector[2 * i] / this.sumOfNewRange;
                this.directionalAttribution.high[i] = probOfCutInSpikeDirection * newScore + (1.0 - probOfCut) * this.directionalAttribution.high[i];
                double probOfCutInDipDirection = this.differenceInRangeVector[2 * i + 1] / this.sumOfNewRange;
                this.directionalAttribution.low[i] = probOfCutInDipDirection * newScore + (1.0 - probOfCut) * this.directionalAttribution.low[i];
            }
        }
        if ((this.hitDuplicates || this.ignoreLeaf) && (this.pointInsideBox || depthOfNode == 0)) {
            this.directionalAttribution.renormalize(this.savedScore);
        }
    }

    @Override
    public void acceptLeaf(INodeView leafNode, int depthOfNode) {
        this.updateRangesForScoring(leafNode.getBoundingBox(), leafNode.getBoundingBox().getMergedBox(this.pointToScore));
        if (Arrays.equals(leafNode.getLeafPoint(), this.pointToScore)) {
            this.hitDuplicates = true;
        }
        this.savedScore = this.hitDuplicates && (!this.ignoreLeaf || leafNode.getMass() > this.ignoreLeafMassThreshold) ? this.damp(leafNode.getMass(), this.treeMass) * this.scoreSeen(depthOfNode, leafNode.getMass()) : this.scoreUnseen(depthOfNode, leafNode.getMass());
        if (this.hitDuplicates || this.ignoreLeaf && leafNode.getMass() <= this.ignoreLeafMassThreshold || this.sumOfNewRange <= 0.0) {
            Arrays.fill(this.directionalAttribution.high, this.savedScore / (double)(2 * this.pointToScore.length));
            Arrays.fill(this.directionalAttribution.low, this.savedScore / (double)(2 * this.pointToScore.length));
            Arrays.fill(this.coordInsideBox, false);
        } else {
            for (int i = 0; i < this.pointToScore.length; ++i) {
                this.directionalAttribution.high[i] = this.savedScore * this.differenceInRangeVector[2 * i] / this.sumOfNewRange;
                this.directionalAttribution.low[i] = this.savedScore * this.differenceInRangeVector[2 * i + 1] / this.sumOfNewRange;
            }
        }
    }

    protected abstract double scoreSeen(int var1, int var2);

    protected abstract double scoreUnseen(int var1, int var2);

    protected abstract double damp(int var1, int var2);

    protected void updateRangesForScoring(IBoundingBoxView smallBox, IBoundingBoxView largeBox) {
        this.sumOfDifferenceInRange = 0.0;
        this.sumOfNewRange = 0.0;
        Arrays.fill(this.differenceInRangeVector, 0.0);
        for (int i = 0; i < this.pointToScore.length; ++i) {
            double minGap;
            this.sumOfNewRange += largeBox.getRange(i);
            if (this.coordInsideBox[i] && !this.ignoreLeaf) continue;
            double maxGap = Math.max(largeBox.getMaxValue(i) - smallBox.getMaxValue(i), 0.0);
            if (maxGap + (minGap = Math.max(smallBox.getMinValue(i) - largeBox.getMinValue(i), 0.0)) > 0.0) {
                this.sumOfDifferenceInRange += minGap + maxGap;
                this.differenceInRangeVector[2 * i] = maxGap;
                this.differenceInRangeVector[2 * i + 1] = minGap;
                continue;
            }
            this.coordInsideBox[i] = true;
        }
    }

    @Override
    public boolean isConverged() {
        return this.pointInsideBox;
    }
}

