import { ImmutableOutput } from "@nteract/commutable";
import * as React from "react";
interface Props {
    /**
     * React elements that accept Output
     */
    children: React.ReactNode;
    /**
     * The raw output
     */
    output: ImmutableOutput;
    renderError(param: {
        error: Error | null;
        info: ReactErrorInfo;
        output: ImmutableOutput;
        children: React.ReactNode;
    }): React.ReactElement<any>;
}
interface Caught {
    error: Error | null;
    info: ReactErrorInfo;
}
interface State {
    caughtError: Caught | null;
}
interface ReactErrorInfo {
    componentStack: string;
}
export declare class Output extends React.PureComponent<Props, State> {
    static defaultProps: {
        output: null;
        renderError: (caught: Caught) => JSX.Element;
    };
    readonly state: State;
    componentDidCatch(error: Error | null, info: ReactErrorInfo): void;
    render(): React.ReactElement<any, string | ((props: any) => React.ReactElement<any, string | any | (new (props: any) => React.Component<any, any, any>)> | null) | (new (props: any) => React.Component<any, any, any>)> | React.FunctionComponentElement<{
        output: ImmutableOutput;
    }> | null;
}
export default Output;
