/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.highlight;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;

final class LimitTokenOffsetFilter
extends TokenFilter {
    private final OffsetAttribute offsetAttrib = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private int maxStartOffset;

    LimitTokenOffsetFilter(TokenStream input, int maxStartOffset) {
        super(input);
        if (maxStartOffset < 0) {
            throw new IllegalArgumentException("maxStartOffset must be >= zero");
        }
        this.maxStartOffset = maxStartOffset;
    }

    public boolean incrementToken() throws IOException {
        if (!this.input.incrementToken()) {
            return false;
        }
        return this.offsetAttrib.startOffset() <= this.maxStartOffset;
    }
}

