/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin.internals;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.admin.internals.AdminApiFuture;
import org.apache.kafka.clients.admin.internals.AdminApiHandler;
import org.apache.kafka.clients.admin.internals.AdminApiLookupStrategy;
import org.apache.kafka.clients.admin.internals.CoordinatorKey;
import org.apache.kafka.clients.admin.internals.CoordinatorStrategy;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.message.AlterShareGroupOffsetsRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterShareGroupOffsetsRequest;
import org.apache.kafka.common.requests.AlterShareGroupOffsetsResponse;
import org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.kafka.common.utils.LogContext;
import org.slf4j.Logger;

public class AlterShareGroupOffsetsHandler
extends AdminApiHandler.Batched<CoordinatorKey, Map<TopicPartition, ApiException>> {
    private final CoordinatorKey groupId;
    private final Logger log;
    private final Map<TopicPartition, Long> offsets;
    private final CoordinatorStrategy lookupStrategy;

    public AlterShareGroupOffsetsHandler(String groupId, Map<TopicPartition, Long> offsets, LogContext logContext) {
        this.groupId = CoordinatorKey.byGroupId(groupId);
        this.offsets = offsets;
        this.log = logContext.logger(AlterShareGroupOffsetsHandler.class);
        this.lookupStrategy = new CoordinatorStrategy(FindCoordinatorRequest.CoordinatorType.GROUP, logContext);
    }

    public static AdminApiFuture.SimpleAdminApiFuture<CoordinatorKey, Map<TopicPartition, ApiException>> newFuture(String groupId) {
        return AdminApiFuture.forKeys(Set.of(CoordinatorKey.byGroupId(groupId)));
    }

    private void validateKeys(Set<CoordinatorKey> groupIds) {
        if (!groupIds.equals(Set.of(this.groupId))) {
            throw new IllegalArgumentException("Received unexpected group ids " + String.valueOf(groupIds) + " (expected only " + String.valueOf(Set.of(this.groupId)) + ")");
        }
    }

    AlterShareGroupOffsetsRequest.Builder buildBatchedRequest(int brokerId, Set<CoordinatorKey> groupIds) {
        AlterShareGroupOffsetsRequestData data = new AlterShareGroupOffsetsRequestData().setGroupId(this.groupId.idValue);
        this.offsets.forEach((tp, offset) -> {
            AlterShareGroupOffsetsRequestData.AlterShareGroupOffsetsRequestTopic topic = data.topics().find(tp.topic());
            if (topic == null) {
                topic = new AlterShareGroupOffsetsRequestData.AlterShareGroupOffsetsRequestTopic().setTopicName(tp.topic());
                data.topics().add(topic);
            }
            topic.partitions().add(new AlterShareGroupOffsetsRequestData.AlterShareGroupOffsetsRequestPartition().setPartitionIndex(tp.partition()).setStartOffset((long)offset));
        });
        return new AlterShareGroupOffsetsRequest.Builder(data);
    }

    @Override
    public String apiName() {
        return "alterShareGroupOffsets";
    }

    @Override
    public AdminApiHandler.ApiResult<CoordinatorKey, Map<TopicPartition, ApiException>> handleResponse(Node broker, Set<CoordinatorKey> keys, AbstractResponse abstractResponse) {
        this.validateKeys(keys);
        AlterShareGroupOffsetsResponse response = (AlterShareGroupOffsetsResponse)abstractResponse;
        HashSet groupsToUnmap = new HashSet();
        HashSet groupsToRetry = new HashSet();
        HashMap partitionResults = new HashMap();
        if (response.data().errorCode() != Errors.NONE.code()) {
            Errors topLevelError = Errors.forCode(response.data().errorCode());
            String topLevelErrorMessage = response.data().errorMessage();
            this.offsets.forEach((topicPartition, offset) -> this.handleError(this.groupId, (TopicPartition)topicPartition, topLevelError, topLevelErrorMessage, partitionResults, groupsToUnmap, groupsToRetry));
        } else {
            response.data().responses().forEach(topic -> topic.partitions().forEach(partition -> {
                Errors partitionError = Errors.forCode(partition.errorCode());
                if (partitionError != Errors.NONE) {
                    String errorMessageToLog = partition.errorMessage() == null ? "" : partition.errorMessage();
                    this.log.debug("AlterShareGroupOffsets request for group id {} and topic-partition {}-{} failed and returned error {}. {}", new Object[]{this.groupId.idValue, topic.topicName(), partition.partitionIndex(), partitionError.name(), errorMessageToLog});
                }
                partitionResults.put(new TopicPartition(topic.topicName(), partition.partitionIndex()), partitionError.exception(partition.errorMessage()));
            }));
        }
        if (groupsToUnmap.isEmpty() && groupsToRetry.isEmpty()) {
            return AdminApiHandler.ApiResult.completed(this.groupId, partitionResults);
        }
        return AdminApiHandler.ApiResult.unmapped(new ArrayList(groupsToUnmap));
    }

    private void handleError(CoordinatorKey groupId, TopicPartition topicPartition, Errors error, String errorMessage, Map<TopicPartition, ApiException> partitionResults, Set<CoordinatorKey> groupsToUnmap, Set<CoordinatorKey> groupsToRetry) {
        String errorMessageToLog = errorMessage == null ? "" : errorMessage;
        switch (error) {
            case COORDINATOR_LOAD_IN_PROGRESS: 
            case REBALANCE_IN_PROGRESS: {
                this.log.debug("AlterShareGroupOffsets request for group id {} returned error {}. Will retry. {}", new Object[]{groupId.idValue, error, errorMessageToLog});
                groupsToRetry.add(groupId);
                break;
            }
            case COORDINATOR_NOT_AVAILABLE: 
            case NOT_COORDINATOR: {
                this.log.debug("AlterShareGroupOffsets request for group id {} returned error {}. Will rediscover the coordinator and retry. {}", new Object[]{groupId.idValue, error, errorMessageToLog});
                groupsToUnmap.add(groupId);
                break;
            }
            case GROUP_ID_NOT_FOUND: 
            case NON_EMPTY_GROUP: 
            case INVALID_REQUEST: 
            case UNKNOWN_SERVER_ERROR: 
            case KAFKA_STORAGE_ERROR: 
            case GROUP_AUTHORIZATION_FAILED: {
                this.log.debug("AlterShareGroupOffsets request for group id {} failed due to error {}. {}", new Object[]{groupId.idValue, error, errorMessageToLog});
                partitionResults.put(topicPartition, error.exception(errorMessage));
                break;
            }
            default: {
                this.log.error("AlterShareGroupOffsets request for group id {} failed due to unexpected error {}. {}", new Object[]{groupId.idValue, error, errorMessageToLog});
                partitionResults.put(topicPartition, error.exception(errorMessage));
            }
        }
    }

    @Override
    public AdminApiLookupStrategy<CoordinatorKey> lookupStrategy() {
        return this.lookupStrategy;
    }
}

