/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.uk;

import ai.grazie.nlp.langs.Language;
import ai.grazie.nlp.patterns.Pattern;
import ai.grazie.nlp.patterns.ext.AbbreviationPatterns;
import ai.grazie.rules.Example;
import ai.grazie.rules.Rule;
import ai.grazie.rules.common.CommaLicense;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.DateChecker;
import ai.grazie.rules.common.FormattingIssues;
import ai.grazie.rules.common.PairedPunctuation;
import ai.grazie.rules.common.ZeroWidthSpaceRule;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.TreeSupport;
import ai.grazie.rules.uk.IntroductoryConstructions;
import ai.grazie.rules.uk.UkrainianTreePatterns;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

class PunctuationRules {
    static final NodePattern sentenceBoundary = NodePattern.N.spaceAfter().directlyBefore(CommonPatterns.capitalized).andOr(CommonPatterns.closingParen.directlyAfter(NodePattern.N.form("[.!?]").noSpaceAfter()), CommonPatterns.arrow, NodePattern.N.form(".*\\."));
    static final NodePattern commaOrOpening = NodePattern.or(UkrainianTreePatterns.commaOrStronger, UkrainianTreePatterns.openingQuotations, NodePattern.N.form("[(<\\[]"), UkrainianTreePatterns.dashes, sentenceBoundary);
    static final NodePattern commaOrClosing = NodePattern.or(UkrainianTreePatterns.commaOrStronger, UkrainianTreePatterns.closingQuotations, NodePattern.N.form("[)>\\]]"), sentenceBoundary);
    private static final String HYPHEN_TO_DASH_MSG = "\u0412\u0438\u043a\u043e\u0440\u0438\u0441\u0442\u043e\u0432\u0443\u0439\u0442\u0435 \u0442\u0438\u0440\u0435 \u043c\u0456\u0436 \u0447\u043b\u0435\u043d\u0430\u043c\u0438 \u0440\u0435\u0447\u0435\u043d\u043d\u044f";
    private static final String HYPHEN_IN_COMPOUND_MESSAGE = "\u0414\u0435\u0444\u0456\u0441 \u0443 \u0441\u043a\u043b\u0430\u0434\u043d\u0438\u0445 \u0441\u043b\u043e\u0432\u0430\u0445 \u043c\u0430\u0454 \u0431\u0443\u0442\u0438 \u0431\u0435\u0437 \u043f\u0440\u043e\u043f\u0443\u0441\u043a\u0456\u0432";
    private static final String DASH_SPACES = "\u041d\u0430\u0432\u043a\u043e\u043b\u043e \u0442\u0438\u0440\u0435 \u043f\u043e\u0432\u0438\u043d\u043d\u0456 \u0431\u0443\u0442\u0438 \u043f\u0440\u043e\u043f\u0443\u0441\u043a\u0438";
    private static final String COMMA_BEFORE_DASH = "\u0421\u0442\u0430\u0432\u0442\u0435 \u043a\u043e\u043c\u0443 \u043f\u0435\u0440\u0435\u0434 \u0442\u0438\u0440\u0435";
    private static final String DOUBLE_PUNCTUATION = "\u0417\u0430\u0439\u0432\u0438\u0439 \u0440\u043e\u0437\u0434\u0456\u043b\u043e\u0432\u0438\u0439 \u0437\u043d\u0430\u043a?";
    private static final String FIX_SPACES = "\u0412\u0438\u043f\u0440\u0430\u0432\u0438\u0442\u0438 \u043f\u0440\u043e\u043f\u0443\u0441\u043a\u0438?";
    private static final String EXTRA_HYPHEN = "\u0417\u0430\u0439\u0432\u0438\u0439 \u0434\u0435\u0444\u0456\u0441?";
    private static final String WRONG_APOSTROPHE = "\u041d\u0435\u0432\u0456\u0440\u043d\u0438\u0439 \u0441\u0438\u043c\u0432\u043e\u043b \u0430\u043f\u043e\u0441\u0442\u0440\u043e\u0444\u0430?";
    private static final String VOCATIVE_COMMA = "\u041f\u0456\u0441\u043b\u044f \u0437\u0432\u0435\u0440\u0442\u0430\u043d\u043d\u044f \u043f\u043e\u0442\u0440\u0456\u0431\u043d\u0430 \u043a\u043e\u043c\u0430";
    private static final String BEFORE_INTRODUCTORY_COMMA = "\u041f\u043e\u0442\u0440\u0456\u0431\u043d\u0430 \u043a\u043e\u043c\u0430 \u043f\u0435\u0440\u0435\u0434 \u0432\u0441\u0442\u0430\u0432\u043d\u043e\u044e \u043a\u043e\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0456\u0454\u044e";
    private static final String AFTER_INTRODUCTORY_COMMA = "\u041f\u043e\u0442\u0440\u0456\u0431\u043d\u0430 \u043a\u043e\u043c\u0430 \u043f\u0456\u0441\u043b\u044f \u0432\u0441\u0442\u0430\u0432\u043d\u043e\u0457 \u043a\u043e\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0456\u0457";
    private static final String AROUND_INTRODUCTORY_COMMA = "\u041f\u043e\u0442\u0440\u0456\u0431\u043d\u0456 \u043a\u043e\u043c\u0438 \u043d\u0430\u0432\u043a\u043e\u043b\u043e \u0432\u0441\u0442\u0430\u0432\u043d\u043e\u0457 \u043a\u043e\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0456\u0457";
    private static final NodePattern compHyphen = NodePattern.N.markAs("Dash").andOr(NodePattern.N.inFormSequence(1, "\u0456?\u0437", ".*", "\u0437\u0430|\u043f\u0456\u0434"), NodePattern.N.inFormSequence(1, "\u0441\u044c\u043e\u0433\u043e\u0434\u043d\u0456", ".*", "\u0437\u0430\u0432\u0442\u0440\u0430"), NodePattern.N.inFormSequence(1, "\u0434\u0435\u043d\u044c", ".*", "\u0434\u0440\u0443\u0433\u0438\u0439"), NodePattern.N.directlyAfter(NodePattern.N.andNot(CommonPatterns.latin).withHead("compound", NodePattern.N.directlyAfter("Dash"))).directlyBefore(NodePattern.N.withHeadRelation("amod|xcomp.*")), NodePattern.N.directlyAfter(CommonPatterns.withNumberLikeForm).directlyBefore(NodePattern.N.form("([\u0432\u0440\u0442\u043c]?(\u0456([\u0439\u043c\u0445]|\u043c\u0438)|[\u0430\u0435\u0454\u044e]|\u043e?(\u0433\u043e|\u043c\u0443|\u0457)|\u0438?([\u0439\u043c\u0445]|\u043c\u0438)|\u044c\u043e(\u0433\u043e|\u043c\u0443|\u0457))|\u0442[\u0438\u0456\u0443\u0430])")), NodePattern.N.directlyAfter(NodePattern.N.form("\u043a\u0430\u0437\u043d\u0430|\u0445\u0442\u043e\u0437\u043d\u0430|(\u043d\u0435)?\u0431\u0443\u0434\u044c|\u043d\u0435\u0432\u0456\u0434\u044c")).directlyBefore(NodePattern.or(NodePattern.N.lemma("\u044f\u043a\u0438\u0439|\u0447\u0438\u0439|\u0445\u0442\u043e|\u0449\u043e|\u043a\u0430\u043a\u043e\u0439|\u0447\u0442\u043e|\u0433\u0434\u0435|\u043a\u043e\u0433\u0434\u0430|\u0447\u0435\u0439|\u0441\u043a\u043e\u043b\u044c\u043a\u043e"), NodePattern.N.form("\u043d\u0435\u0431\u0443\u0434\u044c"))));
    private static final String RANGE_MSG = "\u041c\u0456\u0436 \u0446\u0438\u0444\u0440\u0430\u043c\u0438 \u0434\u043b\u044f \u043f\u043e\u0437\u043d\u0430\u0447\u0435\u043d\u043d\u044f \u0434\u0456\u0430\u043f\u0430\u0437\u043e\u043d\u0456\u0432 \u0441\u0442\u0430\u0432\u0438\u043c\u043e \u0442\u0438\u0440\u0435 \u0431\u0435\u0437 \u0432\u0456\u0434\u0441\u0442\u0443\u043f\u0456\u0432 \u043c\u0456\u0436 \u0437\u043d\u0430\u043a\u0430\u043c\u0438";
    private static final NodePattern numberOrCount = NodePattern.N.form("~?\\d+.*").andNot(NodePattern.N.form("(.*[=x\u00d7].*|1\u0421)"));
    private static final NodePattern notRangeHead = NodePattern.or(NodePattern.N.lemma("ISO|\u043b\u0456\u0442\u0430\u043a|Boeing|Airbus|Bombardier|\u0441\u0435\u0441\u0456\u044f|\u0434\u0437\u0432\u0456\u043d\u043e\u043a|\u0437\u0430\u043a\u043e\u043d|\u0437\u0430\u043a\u043e\u043d\u043e\u043f\u0440\u043e\u0454\u043a\u0442|\u0441\u0442\u0430\u0442\u0442\u044f"), NodePattern.N.label("GEO_POLITICAL_ENTITY|LOCATION|ORGANIZATION|NICKNAME|EVENT"), NodePattern.N.withHeadRelation("flat.*"));
    private static final NodePattern postalHyphen = CommonPatterns.HYPHEN_NODE.andOr(NodePattern.N.directlyAfter(NodePattern.or(NodePattern.N.withHeadRelation("root").withDependent("appos"), NodePattern.N.withHead("appos", NodePattern.N.withHeadRelation("root")), NodePattern.N.withHead("appos|compound", NodePattern.or(CommonPatterns.capitalized, NodePattern.N.noSpaceAfter().directlyBefore(CommonPatterns.dot)).withHeadRelation("appos")), NodePattern.N.withHeadRelation("appos").directlyAfter(NodePattern.N.withHeadRelation("appos")), NodePattern.N.withHead("flat:title", NodePattern.N.withHeadRelation("appos")))), NodePattern.N.directlyBefore(NodePattern.or(NodePattern.N.withHeadRelation("appos"), NodePattern.N.directlyBefore(CommonPatterns.latin.and(CommonPatterns.capitalizedMiddle)))));
    private static final NodePattern pageOrArticle = NodePattern.N.withHead(NodePattern.N.form("\u0441\u0442?\\.?"));
    private static final NodePattern separatesRange = NodePattern.not(postalHyphen).andOr(NodePattern.N.directlyBefore(numberOrCount.andNot(NodePattern.N.directlyBefore(CommonPatterns.HYPHEN_NODE)).noHeadRelation("flat:title").andNot(NodePattern.N.inFormSequence(0, "\\d\\d?", ",", "\\d+", "(KO|\u041a\u041e)"))).directlyAfter(numberOrCount.noHeadRelation("nsubj").andNot(CommonPatterns.skipUp("conj", NodePattern.N.withHead("nummod|compound|flat:title|list", notRangeHead))).andNot(NodePattern.N.directlyAfter(NodePattern.or(CommonPatterns.HYPHEN_NODE, notRangeHead))).andNot(pageOrArticle.andNot(CommonPatterns.ascendingRange))), NodePattern.N.directlyBefore(CommonPatterns.romanNumeral).directlyAfter(CommonPatterns.romanNumeral));
    private static final NodePattern toDashInRange = CommonPatterns.reportWithNext.directlyAfter(NodePattern.N.includeIntoReport()).and((node, match) -> match.withCorrector(CommonPatterns.replaceWithWhitespace(node, "\u2013"))).message("\u041c\u0456\u0436 \u0446\u0438\u0444\u0440\u0430\u043c\u0438 \u0434\u043b\u044f \u043f\u043e\u0437\u043d\u0430\u0447\u0435\u043d\u043d\u044f \u0434\u0456\u0430\u043f\u0430\u0437\u043e\u043d\u0456\u0432 \u0441\u0442\u0430\u0432\u0438\u043c\u043e \u0442\u0438\u0440\u0435 \u0431\u0435\u0437 \u0432\u0456\u0434\u0441\u0442\u0443\u043f\u0456\u0432 \u043c\u0456\u0436 \u0437\u043d\u0430\u043a\u0430\u043c\u0438");

    PunctuationRules() {
    }

    static List<Rule> priorityRules() {
        return List.of(new ZeroWidthSpaceRule("\u041f\u0440\u043e\u043f\u0443\u0441\u043a\u0438 \u043d\u0443\u043b\u044c\u043e\u0432\u043e\u0457 \u0448\u0438\u0440\u0438\u043d\u0438", "\u041f\u043e\u0448\u0443\u043a \u0442\u0430 \u0437\u0430\u043c\u0456\u043d\u0430 \u043f\u0440\u043e\u043f\u0443\u0441\u043a\u0456\u0432 \u043d\u0443\u043b\u044c\u043e\u0432\u043e\u0457 \u0448\u0438\u0440\u0438\u043d\u0438 Unicode \u0443 \u0441\u043b\u043e\u0432\u0430\u0445.", null, "\u0426\u0435 \u0441\u043b\u043e\u0432\u043e \u043c\u0456\u0441\u0442\u0438\u0442\u044c \u043d\u0435\u0432\u0438\u0434\u0438\u043c\u0456 \u043f\u0440\u043e\u043f\u0443\u0441\u043a\u0438 \u043d\u0443\u043b\u044c\u043e\u0432\u043e\u0457 \u0448\u0438\u0440\u0438\u043d\u0438, \u0432\u0438\u0434\u0430\u043b\u0438\u0442\u0438?", "\u0414\u0443\u0436\u0435 <b>\u043f\u0440\u043e\u200b\u0441\u0442\u043e</b>."));
    }

    static List<Rule> rules() {
        return List.of(new Rule.PatternRule("Punctuation.INTRODUCTORY_COMMAS", "\u041a\u043e\u043c\u0430 \u043f\u0456\u0441\u043b\u044f \u0432\u0441\u0442\u0430\u0432\u043d\u043e\u0457 \u043a\u043e\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0456\u0457", "\u042f\u043a\u0449\u043e \u0432\u0441\u0442\u0430\u0432\u043d\u0456 \u0441\u043b\u043e\u0432\u0430 \u0439 \u043a\u043e\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0456\u0457 \u0437\u043d\u0430\u0445\u043e\u0434\u044f\u0442\u044c\u0441\u044f \u043d\u0430 \u043f\u043e\u0447\u0430\u0442\u043a\u0443 \u0440\u0435\u0447\u0435\u043d\u043d\u044f, \u043f\u0456\u0441\u043b\u044f \u043d\u0438\u0445 \u0441\u0442\u0430\u0432\u0438\u0442\u044c\u0441\u044f \u043a\u043e\u043c\u0430.", null, () -> PunctuationRules.introductoryComma(), new Example("\u0411\u0443\u0432\u0430\u0454, \u0449\u043e \u043d\u0430\u0443\u043a\u043e\u0432\u0456 \u0434\u043e\u0441\u043b\u0456\u0434\u0436\u0435\u043d\u043d\u044f <b>\u0432\u0438\u043f\u0435\u0440\u0435\u0434\u0436\u0430\u044e\u0442\u044c</b><i> \u0442\u0430\u043a \u0431\u0438 </i><b>\u043c\u043e\u0432\u0438\u0442\u0438</b> \u043d\u0430\u0432\u0447\u0430\u043b\u044c\u043d\u0438\u0439 \u043f\u043b\u0430\u043d \u0456 \u043d\u0430\u0432\u0447\u0430\u043b\u044c\u043d\u0456 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u0438.", "\u0411\u0443\u0432\u0430\u0454, \u0449\u043e \u043d\u0430\u0443\u043a\u043e\u0432\u0456 \u0434\u043e\u0441\u043b\u0456\u0434\u0436\u0435\u043d\u043d\u044f <b>\u0432\u0438\u043f\u0435\u0440\u0435\u0434\u0436\u0430\u044e\u0442\u044c,</b><i> \u0442\u0430\u043a \u0431\u0438 </i><b>\u043c\u043e\u0432\u0438\u0442\u0438,</b> \u043d\u0430\u0432\u0447\u0430\u043b\u044c\u043d\u0438\u0439 \u043f\u043b\u0430\u043d \u0456 \u043d\u0430\u0432\u0447\u0430\u043b\u044c\u043d\u0456 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u0438.")), new Rule.PatternRule("Punctuation.VOCATIVE_COMMA", "\u041a\u043e\u043c\u0430 \u043f\u0456\u0441\u043b\u044f \u0437\u0432\u0435\u0440\u0442\u0430\u043d\u043d\u044f", "\u042f\u043a\u0449\u043e \u0437\u0432\u0435\u0440\u0442\u0430\u043d\u043d\u044f \u0437\u043d\u0430\u0445\u043e\u0434\u0438\u0442\u044c\u0441\u044f \u043d\u0430 \u043f\u043e\u0447\u0430\u0442\u043a\u0443 \u0440\u0435\u0447\u0435\u043d\u043d\u044f, \u043f\u0456\u0441\u043b\u044f \u043d\u044c\u043e\u0433\u043e \u0441\u0442\u0430\u0432\u0438\u0442\u044c\u0441\u044f \u043a\u043e\u043c\u0430.", null, () -> PunctuationRules.vocativeComma(), new Example("\u041f\u0430\u043d\u0456 <b>\u041a\u0430\u0442\u0435\u0440\u0438\u043d\u043e</b> \u0440\u043e\u0437\u043a\u0430\u0436\u0456\u0442\u044c \u043d\u0430\u0448\u0438\u043c \u0447\u0438\u0442\u0430\u0447\u0430\u043c \u043f\u0440\u043e \u043a\u0440\u0430\u0444\u0442\u043e\u0432\u0438\u0439 \u0440\u0438\u043d\u043e\u043a.", "\u041f\u0430\u043d\u0456 <b>\u041a\u0430\u0442\u0435\u0440\u0438\u043d\u043e,</b> \u0440\u043e\u0437\u043a\u0430\u0436\u0456\u0442\u044c \u043d\u0430\u0448\u0438\u043c \u0447\u0438\u0442\u0430\u0447\u0430\u043c \u043f\u0440\u043e \u043a\u0440\u0430\u0444\u0442\u043e\u0432\u0438\u0439 \u0440\u0438\u043d\u043e\u043a.")), new Rule.PatternRule("Punctuation.EXCESSIVE_COMMA", "\u0417\u0430\u0439\u0432\u0456 \u043a\u043e\u043c\u0438", "\u041f\u043e\u0448\u0443\u043a \u0437\u0430\u0439\u0432\u0438\u0445 \u043a\u043e\u043c, \u043d\u0435 \u043e\u0431\u0443\u043c\u043e\u0432\u043b\u0435\u043d\u0438\u0445 \u0436\u043e\u0434\u043d\u0438\u043c\u0438 \u043f\u0440\u0430\u0432\u0438\u043b\u0430\u043c\u0438.", "https://answiki.org.ua/1320-chy-potribna-koma-pered-toscho.html", () -> PunctuationRules.excessiveComma(), new Example("\u0421\u0435\u0440\u0432\u0456\u0441, <b>\u043d\u043e\u0432\u0438\u043d\u0438, \u0442\u043e\u0449\u043e</b>.", "\u0421\u0435\u0440\u0432\u0456\u0441, <b>\u043d\u043e\u0432\u0438\u043d\u0438 \u0442\u043e\u0449\u043e</b>.")), new Rule.PatternRule("Punctuation.HYPHEN_VS_DASH", "\u041e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u043d\u044f \u0442\u0438\u0440\u0435 \u0442\u0430 \u0434\u0435\u0444\u0456\u0441\u0456\u0432", "\u0423 \u0441\u043a\u043b\u0430\u0434\u043d\u0438\u0445 \u0441\u043b\u043e\u0432\u0430\u0445 \u0443\u0436\u0438\u0432\u0430\u0454\u0442\u044c\u0441\u044f \u0434\u0435\u0444\u0456\u0441, \u0430 \u043d\u0435 \u0442\u0438\u0440\u0435. \u041d\u0430\u0432\u043a\u043e\u043b\u043e \u0442\u0438\u0440\u0435 \u043c\u0456\u0436 \u0447\u043b\u0435\u043d\u0430\u043c\u0438 \u043f\u0440\u043e\u043f\u043e\u0437\u0438\u0446\u0456\u0457 \u043c\u0430\u044e\u0442\u044c \u0431\u0443\u0442\u0438 \u043f\u0440\u043e\u043f\u0443\u0441\u043a\u0438. \u041a\u043e\u043c\u0438 \u0441\u0442\u0430\u0432\u043b\u044f\u0442\u044c\u0441\u044f \u043f\u0435\u0440\u0435\u0434 \u0442\u0438\u0440\u0435, \u0430 \u043d\u0435 \u043f\u0456\u0441\u043b\u044f.", null, () -> PunctuationRules.hyphenVsDash(), new Example("\u0412\u0430\u0440\u0442\u043e \u0441\u043e\u043d\u0446\u044e \u0437\u0430\u0439\u0442\u0438, \u043e\u0442 \u0456 \u044f \u0441\u0442\u0430\u043d\u0443 \u0432\u043c\u0438\u0442\u044c <b>\u0444\u0456\u043e\u043b\u0435\u0442\u043e\u0432\u043e - \u0447\u043e\u0440\u043d\u0438\u043c</b>.", "\u0412\u0430\u0440\u0442\u043e \u0441\u043e\u043d\u0446\u044e \u0437\u0430\u0439\u0442\u0438, \u043e\u0442 \u0456 \u044f \u0441\u0442\u0430\u043d\u0443 \u0432\u043c\u0438\u0442\u044c <b>\u0444\u0456\u043e\u043b\u0435\u0442\u043e\u0432\u043e-\u0447\u043e\u0440\u043d\u0438\u043c</b>."), new Example("<b>\u041d\u0456\u0447\u2014\u0446\u0435</b> \u0441\u0432\u0456\u0442 \u043f\u0440\u0435\u043a\u0440\u0430\u0441\u043d\u0438\u0445 \u043c\u0440\u0456\u0439.", "<b>\u041d\u0456\u0447 \u2014 \u0446\u0435</b> \u0441\u0432\u0456\u0442 \u043f\u0440\u0435\u043a\u0440\u0430\u0441\u043d\u0438\u0445 \u043c\u0440\u0456\u0439."), new Example("\u00ab\u041d\u0443 \u0446\u0435 \u0432\u0436\u0435 \u0437\u043e\u0432\u0441\u0456\u043c \u0446\u0456\u043a\u0430\u0432\u0438\u0439 <b>\u0444\u043e\u043d\u00bb -, \u043f\u0440\u043e\u043a\u043e\u043c\u0435\u043d\u0442\u0443\u0432\u0430\u0432</b> \u0432\u0456\u043d \u0456 \u0441\u0442\u0430\u0432 \u043f\u0435\u0440\u0435\u0434 \u0430\u0444\u0456\u0448\u0435\u044e \u0441\u043f\u0456\u0432\u0430\u0447\u043a\u0438.", "\u00ab\u041d\u0443 \u0446\u0435 \u0432\u0436\u0435 \u0437\u043e\u0432\u0441\u0456\u043c \u0446\u0456\u043a\u0430\u0432\u0438\u0439 <b>\u0444\u043e\u043d\u00bb, \u2014 \u043f\u0440\u043e\u043a\u043e\u043c\u0435\u043d\u0442\u0443\u0432\u0430\u0432</b> \u0432\u0456\u043d \u0456 \u0441\u0442\u0430\u0432 \u043f\u0435\u0440\u0435\u0434 \u0430\u0444\u0456\u0448\u0435\u044e \u0441\u043f\u0456\u0432\u0430\u0447\u043a\u0438.")), new Rule.PatternRule("Punctuation.FORMATTING_ISSUES", "\u041f\u0440\u043e\u043f\u0443\u0441\u043a\u0438 \u0442\u0430 \u0440\u043e\u0437\u0434\u0456\u043b\u043e\u0432\u0456 \u0437\u043d\u0430\u043a\u0438", "\u041f\u0440\u043e\u0431\u043b\u0435\u043c\u0438 \u0437 \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e\u044e \u0440\u043e\u0437\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u043e\u044e \u043f\u0440\u043e\u043f\u0443\u0441\u043a\u0456\u0432 \u0456 \u043d\u0435\u043c\u043e\u0436\u043b\u0438\u0432\u0456 \u043f\u043e\u0454\u0434\u043d\u0430\u043d\u043d\u044f \u0440\u043e\u0437\u0434\u0456\u043b\u043e\u0432\u0438\u0445 \u0437\u043d\u0430\u043a\u0456\u0432.", null, () -> NodePattern.or(PunctuationRules.formattingIssues(), PunctuationRules.quoteToApostrophe()), new Example("<b>\u041d\u0430\u043f\u0440\u0438\u043a\u043b\u0430\u0434,,</b> \u0441\u043e\u0431\u0430\u043a\u0430.", "\u041d\u0430\u043f\u0440\u0438\u043a\u043b\u0430\u0434<b>,</b> \u0441\u043e\u0431\u0430\u043a\u0430."), new Example("<b>\u041d\u0430\u043f\u0440\u0438\u043a\u043b\u0430\u0434 ,</b> \u0441\u043e\u0431\u0430\u043a\u0430.", "\u041d\u0430\u043f\u0440\u0438\u043a\u043b\u0430\u0434<b>,</b> \u0441\u043e\u0431\u0430\u043a\u0430."), new Example("\u0422\u0430\u043d\u0446\u0456 \u0437 <b>\u0437\u0456- \u0440\u043a\u0430\u043c\u0438</b>.", "\u0422\u0430\u043d\u0446\u0456 \u0437 <b>\u0437\u0456\u0440\u043a\u0430\u043c\u0438</b>."), new Example("\u041e\u0441\u044c \u0456 \u043d\u0430\u0441\u0442\u0430\u0432 \u0447\u0430\u0441 <b>\u0437\"\u044f\u0432\u0438\u0442\u0438\u0441\u044f</b> \u043d\u0430 \u0432\u0443\u043b\u0438\u0446\u0456 \u0443 \u0441\u0430\u0440\u0430\u0444\u0430\u043d\u0447\u0438\u043a\u0443.", "\u041e\u0441\u044c \u0456 \u043d\u0430\u0441\u0442\u0430\u0432 \u0447\u0430\u0441 <b>\u0437'\u044f\u0432\u0438\u0442\u0438\u0441\u044f</b> \u043d\u0430 \u0432\u0443\u043b\u0438\u0446\u0456 \u0443 \u0441\u0430\u0440\u0430\u0444\u0430\u043d\u0447\u0438\u043a\u0443.")), PunctuationRules.quotePunctuation());
    }

    static Rule.PatternRule hyphenToDashRule() {
        return new Rule.PatternRule("Typography.HYPHEN_TO_DASH", "\u0414\u0435\u0444\u0456\u0441 \u0437\u0430\u043c\u0456\u0441\u0442\u044c \u0442\u0438\u0440\u0435", "\u0414\u043b\u044f \u043f\u043e\u0434\u0456\u043b\u0443 \u0447\u043b\u0435\u043d\u0456\u0432 \u0440\u0435\u0447\u0435\u043d\u043d\u044f \u0432\u0438\u043a\u043e\u0440\u0438\u0441\u0442\u043e\u0432\u0443\u0454\u0442\u044c\u0441\u044f \u0442\u0438\u0440\u0435.", "http://newpravopys.mova.info/pravopys.aspx?SectionID=4339", () -> PunctuationRules.hyphenToDash(), new Example("<b>\u041c\u0438 - \u0437\u0430</b> \u043c\u0438\u0440", "<b>\u041c\u0438 \u2014 \u0437\u0430</b> \u043c\u0438\u0440"), new Example("\u0417\u0430\u043f\u0456\u043a\u0430\u0442\u0438 \u043f\u0440\u043e\u0442\u044f\u0433\u043e\u043c <b>25-30</b> \u0445\u0432.", "\u0417\u0430\u043f\u0456\u043a\u0430\u0442\u0438 \u043f\u0440\u043e\u0442\u044f\u0433\u043e\u043c <b>25\u201330</b> \u0445\u0432.")).coveringLTRules("short_vs_long_dash");
    }

    private static NodePattern introductoryComma() {
        return NodePattern.custom((node, match) -> {
            for (CommaLicense commas : IntroductoryConstructions.analyze(node)) {
                if (!commas.obligatory) continue;
                boolean isWord = commas.start == commas.end;
                return PunctuationRules.surroundWithCommas(match, commas.start, commas.end, true, isWord ? "\u041f\u043e\u0442\u0440\u0456\u0431\u043d\u0430 \u043a\u043e\u043c\u0430 \u043f\u0435\u0440\u0435\u0434 \u0432\u0441\u0442\u0430\u0432\u043d\u0438\u043c \u0441\u043b\u043e\u0432\u043e\u043c" : BEFORE_INTRODUCTORY_COMMA, isWord ? "\u041f\u043e\u0442\u0440\u0456\u0431\u043d\u0430 \u043a\u043e\u043c\u0430 \u043f\u0456\u0441\u043b\u044f \u0432\u0441\u0442\u0430\u0432\u043d\u043e\u0433\u043e \u0441\u043b\u043e\u0432\u0430" : AFTER_INTRODUCTORY_COMMA, isWord ? "\u041f\u043e\u0442\u0440\u0456\u0431\u043d\u0456 \u043a\u043e\u043c\u0438 \u043d\u0430\u0432\u043a\u043e\u043b\u043e \u0432\u0441\u0442\u0430\u0432\u043d\u043e\u0433\u043e \u0441\u043b\u043e\u0432\u0430" : AROUND_INTRODUCTORY_COMMA);
            }
            return null;
        });
    }

    private static NodePattern vocativeComma() {
        NodePattern imperative = NodePattern.N.pos("verb.*impr.*");
        NodePattern neProstiGospodi = NodePattern.not(NodePattern.N.inFormSequence(1, "\u0431\u043e\u0440\u043e\u043d\u044c|\u0431\u0435\u0440\u0435\u0436\u0438|\u0434\u0430\u0439|\u043e\u0439|\u043f\u0440\u043e\u0441\u0442\u0438|\u043f\u043e\u043c\u0438\u043b\u0443\u0439", "\u0431\u043e\u0436\u0435|\u0433\u043e\u0441\u043f\u043e\u0434\u0438")).andNot(NodePattern.N.inFormSequence(0, "\u0431\u043e\u0436\u0435|\u0433\u043e\u0441\u043f\u043e\u0434\u0438", "\u043f\u043e\u043c\u043e\u0436\u0438|\u043f\u0440\u043e\u0441\u0442\u0438|\u043f\u043e\u043c\u0438\u043b\u0443\u0439"));
        return NodePattern.or(neProstiGospodi.onlyPos("noun.*v_kly.*").directlyBefore(NodePattern.or(imperative, NodePattern.N.form("\u043d\u0435").directlyBefore(imperative))).correct(NodeCorrector.insertAfter(",")).message(VOCATIVE_COMMA), NodePattern.N.pos(".+").noPos(".*:v_kly").andNot(NodePattern.N.withHeadRelation("parataxis")).withDependent("vocative", neProstiGospodi.andOr(NodePattern.N.pos("noun.*:(v_kly|prop:.name)"), NodePattern.N.potentialPos("noun:anim.*:(v_kly|prop:.name)")).andNot(NodePattern.N.withDependent("parataxis")).andNot(NodePattern.N.directlyBefore(NodePattern.N.withHeadRelation("parataxis"))).andNot(NodePattern.N.withPhraseEnd(NodePattern.N.withNextSibling(NodePattern.N.pos(".*v_kly:.*")))).noDependents("punct", NodePattern.N.afterHead()).and((node, match) -> PunctuationRules.surroundWithCommas(match, node.phraseStart(), node.phraseEnd(), false, "\u041f\u0435\u0440\u0435\u0434 \u0437\u0432\u0435\u0440\u0442\u0430\u043d\u043d\u044f\u043c \u043f\u043e\u0442\u0440\u0456\u0431\u043d\u0430 \u043a\u043e\u043c\u0430", VOCATIVE_COMMA, "\u041d\u0430\u0432\u043a\u043e\u043b\u043e \u0437\u0432\u0435\u0440\u0442\u0430\u043d\u043d\u044f \u043f\u043e\u0442\u0440\u0456\u0431\u043d\u0456 \u043a\u043e\u043c\u0438"))));
    }

    private static NodePattern excessiveComma() {
        return CommonPatterns.comma.directlyBefore(NodePattern.N.form("\u0442\u043e\u0449\u043e")).reportEverythingTouched().and(CommonPatterns.reportWithPrevWord).message("\u0417\u0430\u0439\u0432\u0430 \u043a\u043e\u043c\u0430 \u043f\u0435\u0440\u0435\u0434 \u00ab\u0442\u043e\u0449\u043e\u00bb?").correct(NodeCorrector.replace(""));
    }

    private static NodePattern hyphenToDash() {
        return CommonPatterns.dashLikeHyphens.andOr(NodePattern.N.spaceAround().andNot(separatesRange).and(CommonPatterns.reportWithPrevWord).and(CommonPatterns.reportWithNext).message(HYPHEN_TO_DASH_MSG).and((node, match) -> {
            NodeCorrector corrector = FormattingIssues.properlySpacedColon.matches(node.prevNode()) ? CommonPatterns.replaceWithWhitespace(node, "\n\u2014 ") : NodeCorrector.replace(node, "\u2014");
            return match.withCorrector(corrector.batchCapable("hyphenToDash")).enableAutoFix();
        }), separatesRange.andOr(NodePattern.N.noSpaceBefore(), NodePattern.N.noSpaceAfter()).and(toDashInRange));
    }

    private static NodePattern hyphenVsDash() {
        return NodePattern.or(CommonPatterns.DASH_NODE.noSpaceAround().directlyAfter(UkrainianTreePatterns.openingQuotations).directlyBefore(NodePattern.not(NodePattern.PUNCT)).correct(NodeCorrector.replace("-")).message("\u041f\u0435\u0440\u0435\u0434 \u0447\u0430\u0441\u0442\u0438\u043d\u0430\u043c\u0438 \u0441\u043b\u0456\u0432 \u0441\u0442\u0430\u0432\u0438\u0442\u044c\u0441\u044f \u0434\u0435\u0444\u0456\u0441"), NodePattern.or(CommonPatterns.DASH_NODE, CommonPatterns.HYPHEN_NODE).andNot(NodePattern.N.noSpaceAround()).andOr(NodePattern.N.directlyBefore(CommonPatterns.romanNumeral).directlyAfter(CommonPatterns.romanNumeral), NodePattern.N.directlyBefore(DateChecker.year).directlyAfter(DateChecker.year), separatesRange.and(CommonPatterns.DASH_NODE).andOr(NodePattern.N.spaceBefore(), NodePattern.N.spaceAfter()).and(NodePattern.N.directlyAfter(CommonPatterns.ascendingRange))).and(toDashInRange), CommonPatterns.DASH_NODE.andNot(NodePattern.N.spaceAround()).andNot(compHyphen).andNot(NodePattern.N.noSpaceAround().directlyBefore(NodePattern.N.withHeadRelation("flat:range")).andNot(NodePattern.N.directlyAfter(numberOrCount)).andNot(NodePattern.N.directlyBefore(numberOrCount))).and(PunctuationRules.toSpacedDash("AddDashSpaces")).message(DASH_SPACES), NodePattern.or(CommonPatterns.DASH_NODE, CommonPatterns.HYPHEN_NODE.andOr(NodePattern.N.spaceAfter(), NodePattern.N.spaceBefore())).andOr(NodePattern.N.directlyBefore(CommonPatterns.comma.directlyBefore(NodePattern.N.markAs("Next"))).directlyAfter(NodePattern.N.markAs("Prev")).and(CommonPatterns.reportWithPrevWord).and((dash, match) -> {
            Node next = match.getMarkedNode("Next");
            int prevEnd = match.getMarkedNode("Prev").endOffset();
            int nextStart = next.startOffset();
            return match.withReportedNodes(dash.nextNode(), next).withCorrector(NodeCorrector.rawReplace(prevEnd, nextStart, ", \u2014 ").batchCapable("CommaBeforeDash"));
        }).message(COMMA_BEFORE_DASH), compHyphen.and((node, match) -> match.withCorrector(CommonPatterns.replaceWithWhitespace(node, "-"))).includeIntoReport().directlyAfter(NodePattern.N.includeIntoReport()).directlyBefore(NodePattern.N.includeIntoReport()).andOr(CommonPatterns.DASH_NODE.message("\u0412\u0438\u043a\u043e\u0440\u0438\u0441\u0442\u043e\u0432\u0443\u0439\u0442\u0435 \u0434\u0435\u0444\u0456\u0441 \u0443 \u0441\u043a\u043b\u0430\u0434\u043d\u0438\u0445 \u0441\u043b\u043e\u0432\u0430\u0445"), CommonPatterns.HYPHEN_NODE.message(HYPHEN_IN_COMPOUND_MESSAGE)))).andOr(NodePattern.N.spaceAround().and((node, match) -> match.withReportedRange(CommonPatterns.includeSurroundingWhitespace(node), node.tree())), NodePattern.N.includeIntoReport().directlyBefore(NodePattern.N.includeIntoReport()).directlyAfter(NodePattern.N.includeIntoReport()));
    }

    private static NodePattern toSpacedDash(String batchId) {
        NodePattern textNumber = NodePattern.N.pos("num.*");
        return NodePattern.N.markAs("Hyphen").andOr(CommonPatterns.separatesHeadDependent(NodePattern.not(NodePattern.N.directlyAfter("Hyphen").withHead("appos", NodePattern.N.withHeadRelation("nmod")))), NodePattern.N.directlyAfter(NodePattern.not(NodePattern.N.withHeadRelation("compound")))).andNot(NodePattern.N.directlyBefore(NodePattern.or(numberOrCount, textNumber)).directlyAfter(NodePattern.or(numberOrCount, textNumber))).andNot(NodePattern.N.directlyBefore(NodePattern.or(NodePattern.N.form(">"), NodePattern.N.withHeadRelation("flat:title").pos("number")))).and(CommonPatterns.reportWithPrevWord).and((node, match) -> match.withCorrector(CommonPatterns.replaceWithWhitespace(node, " \u2014 ").batchCapable(batchId)).enableAutoFix());
    }

    private static NodePattern formattingIssues() {
        NodePattern hyphenPattern = NodePattern.N.directlyAfter(NodePattern.N.pos(".*prop.*")).directlyBefore(NodePattern.N.pos(".*prop.*"));
        return NodePattern.or(FormattingIssues.unpairedParentheses.message("\u0412\u0438 \u043c\u0430\u043b\u0438 \u043d\u0430 \u0443\u0432\u0430\u0437\u0456 \u0437\u0430\u043a\u0440\u0438\u0442\u0443 \u0434\u0443\u0436\u043a\u0443?"), FormattingIssues.doublePunctuation.message(DOUBLE_PUNCTUATION), FormattingIssues.punctWhitespace(m -> FIX_SPACES).andNot(CommonPatterns.colon.directlyAfter(CommonPatterns.latinOrNumber)).andNot(CommonPatterns.colon.directlyBefore(CommonPatterns.latinOrNumber)).andNot(CommonPatterns.comma.directlyAfter(CommonPatterns.latinOrNumber).directlyBefore(CommonPatterns.latinOrNumber)), FormattingIssues.endWhitespace(m -> {
            String form = m.anchor().form();
            return "\u0417\u0430\u0439\u0432\u0438\u0439 \u043f\u0440\u043e\u043f\u0443\u0441\u043a \u043f\u0435\u0440\u0435\u0434 " + (String)(form.equals(".") ? "\u043a\u0440\u0430\u043f\u043a\u043e\u044e" : "'" + form + "'");
        }), FormattingIssues.quoteWhitespace("\u041d\u0435\u043c\u0430\u0454 \u043f\u0440\u043e\u043f\u0443\u0441\u043a\u0443?", "\u0417\u0430\u0439\u0432\u0438\u0439 \u043f\u0440\u043e\u043f\u0443\u0441\u043a?").andOr(NodePattern.N.directlyAfter(NodePattern.N.pos(".*")), NodePattern.N.directlyBefore(NodePattern.N.pos(".*"))), UkrainianTreePatterns.quotes.asymmetricalRule(Set.of("\"", "'")).message("\u041d\u0435\u0432\u0456\u0440\u043d\u0430 \u043b\u0430\u043f\u043a\u0430?"), FormattingIssues.joinAdjacentFixes(NodePattern.or(CommonPatterns.openingParen, UkrainianTreePatterns.definitelyOpeningQuotations.directlyBefore(NodePattern.not(UkrainianTreePatterns.anyQuotation))).and(PairedPunctuation.Opening.checkSpace("\u041d\u0435\u043c\u0430\u0454 \u043f\u0440\u043e\u043f\u0443\u0441\u043a\u0443", "\u0417\u0430\u0439\u0432\u0438\u0439 \u043f\u0440\u043e\u043f\u0443\u0441\u043a")), NodePattern.or(CommonPatterns.closingParen, UkrainianTreePatterns.definitelyClosingQuotations.directlyAfter(NodePattern.not(UkrainianTreePatterns.anyQuotation))).andNot(NodePattern.N.directlyBefore(NodePattern.N.form("\\*"))).and(PairedPunctuation.Closing.checkSpace("\u041d\u0435\u043c\u0430\u0454 \u043f\u0440\u043e\u043f\u0443\u0441\u043a\u0443", "\u0417\u0430\u0439\u0432\u0438\u0439 \u043f\u0440\u043e\u043f\u0443\u0441\u043a"))), FormattingIssues.multiWhiteSpace("\u041f\u043e\u0432\u0442\u043e\u0440 \u043f\u0440\u043e\u043f\u0443\u0441\u043a\u0443"), FormattingIssues.trailingComma(UkrainianTreePatterns.clause.andNot(CommonPatterns.withNumberLikeForm).noLemma("\u0432\u0456\u0442\u0430\u0442\u0438|\u0431\u0430\u0436\u0430\u0442\u0438|\u0434\u044f\u043a\u0443\u0432\u0430\u0442\u0438|\u0431\u0443\u0442\u0438|\u0447\u0435\u043a\u0430\u0442\u0438"), "\u041d\u0435\u0437\u0430\u043a\u0456\u043d\u0447\u0435\u043d\u0435 \u0440\u0435\u0447\u0435\u043d\u043d\u044f?"), FormattingIssues.wordSplittingHyphen(EXTRA_HYPHEN).andNot(NodePattern.N.directlyAfter(NodePattern.N.directlyAfter(UkrainianTreePatterns.openingQuotations)).directlyBefore(NodePattern.N.directlyBefore(UkrainianTreePatterns.closingQuotations))), FormattingIssues.leadingHyphen(EXTRA_HYPHEN), FormattingIssues.singleHyphenWhitespace("\u0417\u0430\u0439\u0432\u0438\u0439 \u043f\u0440\u043e\u043f\u0443\u0441\u043a?", "\u041d\u0435\u043c\u0430\u0454 \u043f\u0440\u043e\u043f\u0443\u0441\u043a\u0443?", NodePattern.or(new NodePattern[0]), NodePattern.or(new NodePattern[0]), hyphenPattern).directlyBefore(NodePattern.not(NodePattern.N.pos("conj.*"))).andNot(NodePattern.N.withNeighbor(-2, NodePattern.N.lemma("\u043f\u0440\u0435\u0444\u0456\u043a\u0441"))), FormattingIssues.sentenceStartingPunctuation("\u0417\u0430\u0439\u0432\u0438\u0439 \u0440\u043e\u0437\u0434\u0456\u043b\u043e\u0432\u0438\u0439 \u0437\u043d\u0430\u043a \u043d\u0430 \u043f\u043e\u0447\u0430\u0442\u043a\u0443 \u0440\u0435\u0447\u0435\u043d\u043d\u044f?"), FormattingIssues.wordInternalPunctuation("\u041d\u0435\u043c\u0430\u0454 \u043f\u0440\u043e\u043f\u0443\u0441\u043a\u0443?", "").andNot(FormattingIssues.capitalizedDotCapitalized), FormattingIssues.joinedNumberWord("\u041d\u0435\u043c\u0430\u0454 \u043f\u0440\u043e\u043f\u0443\u0441\u043a\u0443?", "noun:.*prop.*", word -> word.form().length() >= 4 || word.form().length() >= 2 && word.hasPos("conj.*|prep")), FormattingIssues.noSpaceWithBrackets("\u041d\u0435\u043c\u0430\u0454 \u043f\u0440\u043e\u043f\u0443\u0441\u043a\u0443?"), FormattingIssues.excessiveEllipsis("\u0417\u0430\u043d\u0430\u0434\u0442\u043e \u0431\u0430\u0433\u0430\u0442\u043e \u043a\u0440\u0430\u043f\u043e\u043a"));
    }

    private static Rule.PatternRule quotePunctuation() {
        String plainMsg = "\u0420\u043e\u0437\u0434\u0456\u043b\u043e\u0432\u0456 \u0437\u043d\u0430\u043a\u0438 \u0441\u043b\u0456\u0434 \u0441\u0442\u0430\u0432\u0438\u0442\u0438 \u043f\u043e\u0437\u0430 \u043b\u0430\u043f\u043a\u0430\u043c\u0438";
        String abbrDotMsg = "\u041f\u0456\u0441\u043b\u044f \u043b\u0430\u043f\u043e\u043a, \u0449\u043e \u0437\u0430\u043a\u0440\u0438\u0432\u0430\u044e\u0442\u044c\u0441\u044f, \u0441\u0442\u0430\u0432\u0438\u0442\u044c\u0441\u044f \u043a\u0440\u0430\u043f\u043a\u0430, \u044f\u043a\u0449\u043e \u043f\u0435\u0440\u0435\u0434 \u043d\u0438\u043c\u0438 \u0432\u043e\u043d\u0430 \u0432\u0436\u0438\u0442\u0430 \u044f\u043a \u0447\u0430\u0441\u0442\u0438\u043d\u0430 \u0441\u043a\u043e\u0440\u043e\u0447\u0435\u043d\u043d\u044f";
        return new Rule.PatternRule("Punctuation.QUOTE_PUNCTUATION", "\u041b\u0430\u043f\u043a\u0438 \u0442\u0430 \u0456\u043d\u0448\u0456 \u0440\u043e\u0437\u0434\u0456\u043b\u043e\u0432\u0456 \u0437\u043d\u0430\u043a\u0438", " \u041a\u0440\u0430\u043f\u043a\u0430, \u043a\u043e\u043c\u0430, \u043a\u0440\u0430\u043f\u043a\u0430 \u0437 \u043a\u043e\u043c\u043e\u044e, \u0434\u0432\u043e\u043a\u0440\u0430\u043f\u043a\u0430 \u0439 \u0442\u0438\u0440\u0435, \u043d\u0456\u043a\u043e\u043b\u0438 \u043d\u0435 \u0441\u0442\u0430\u0432\u0438\u043c\u043e \u043f\u0435\u0440\u0435\u0434 \u0437\u0430\u043a\u0440\u0438\u0442\u0438\u043c\u0438 \u043b\u0430\u043f\u043a\u0430\u043c\u0438, \u0430 \u0442\u0456\u043b\u044c\u043a\u0438 \u043f\u0456\u0441\u043b\u044f \u043d\u0438\u0445.\n <p>\n \u0417\u043d\u0430\u043a \u043f\u0438\u0442\u0430\u043d\u043d\u044f, \u0437\u043d\u0430\u043a \u043e\u043a\u043b\u0438\u043a\u0443 \u0439 \u0442\u0440\u0438 \u043a\u0440\u0430\u043f\u043a\u0438 \u0441\u0442\u0430\u0432\u0438\u043c\u043e \u0430\u0431\u043e \u043f\u0435\u0440\u0435\u0434 \u0437\u0430\u043a\u0440\u0438\u0442\u0438\u043c\u0438 \u043b\u0430\u043f\u043a\u0430\u043c\u0438, \u044f\u043a\u0449\u043e \u0432\u043e\u043d\u0438 \u0441\u0442\u043e\u0441\u0443\u044e\u0442\u044c\u0441\u044f \u043b\u0438\u0448\u0435 \u0441\u043b\u0456\u0432, \u043f\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0445 \u0443 \u043b\u0430\u043f\u043a\u0438, \u0430\u0431\u043e \u043f\u0456\u0441\u043b\u044f \u043b\u0430\u043f\u043e\u043a, \u044f\u043a\u0449\u043e \u0446\u0456 \u0440\u043e\u0437\u0434\u0456\u043b\u043e\u0432\u0456 \u0437\u043d\u0430\u043a\u0438 \u0441\u0442\u043e\u0441\u0443\u044e\u0442\u044c\u0441\u044f \u0432\u0441\u044c\u043e\u0433\u043e \u0440\u0435\u0447\u0435\u043d\u043d\u044f.\n \u042f\u043a\u0449\u043e \u0437\u043d\u0430\u043a \u043f\u0438\u0442\u0430\u043d\u043d\u044f, \u0437\u043d\u0430\u043a \u043e\u043a\u043b\u0438\u043a\u0443 \u0439 \u0442\u0440\u0438 \u043a\u0440\u0430\u043f\u043a\u0438 \u0441\u0442\u043e\u044f\u0442\u044c \u043f\u0435\u0440\u0435\u0434 \u0437\u0430\u043a\u0440\u0438\u0442\u0438\u043c\u0438 \u043b\u0430\u043f\u043a\u0430\u043c\u0438, \u0442\u043e \u043f\u0456\u0441\u043b\u044f \u043b\u0430\u043f\u043e\u043a \u0443 \u043a\u0456\u043d\u0446\u0456 \u0440\u0435\u0447\u0435\u043d\u043d\u044f \u0442\u0456 \u0441\u0430\u043c\u0456 \u0437\u043d\u0430\u043a\u0438 \u043d\u0435 \u043f\u043e\u0432\u0442\u043e\u0440\u044e\u044e\u0442\u044c\u0441\u044f.\n \u041d\u0435\u043e\u0434\u043d\u0430\u043a\u043e\u0432\u0456 \u0436 \u0437\u043d\u0430\u043a\u0438 \u043c\u043e\u0436\u0435\u043c\u043e, \u0437\u0430\u043b\u0435\u0436\u043d\u043e \u0432\u0456\u0434 \u0437\u043c\u0456\u0441\u0442\u0443, \u0441\u0442\u0430\u0432\u0438\u0442\u0438 \u0432\u043e\u0434\u043d\u043e\u0447\u0430\u0441 \u0456 \u043f\u0435\u0440\u0435\u0434 \u0437\u0430\u043a\u0440\u0438\u0442\u0438\u043c\u0438 \u043b\u0430\u043f\u043a\u0430\u043c\u0438, \u0456 \u043f\u0456\u0441\u043b\u044f \u043d\u0438\u0445.\n <p>\n \u042f\u043a\u0449\u043e \u0437\u0430 \u0445\u0430\u0440\u0430\u043a\u0442\u0435\u0440\u043e\u043c \u0440\u0435\u0447\u0435\u043d\u043d\u044f \u0432 \u0439\u043e\u0433\u043e \u043a\u0456\u043d\u0446\u0456 \u043c\u0430\u0454 \u0441\u0442\u043e\u044f\u0442\u0438 \u043a\u0440\u0430\u043f\u043a\u0430, \u0432\u043e\u043d\u0430 \u0437\u0431\u0435\u0440\u0456\u0433\u0430\u0454\u0442\u044c\u0441\u044f \u0456 \u0432 \u0442\u043e\u043c\u0443 \u0440\u0430\u0437\u0456, \u043a\u043e\u043b\u0438 \u0440\u0435\u0447\u0435\u043d\u043d\u044f \u0437\u0430\u043a\u0456\u043d\u0447\u0443\u0454\u0442\u044c\u0441\u044f \u0444\u0440\u0430\u0433\u043c\u0435\u043d\u0442\u043e\u043c \u0443 \u043b\u0430\u043f\u043a\u0430\u0445 \u0437 \u043d\u0430\u044f\u0432\u043d\u0456\u0441\u0442\u044e \u043f\u0435\u0440\u0435\u0434 \u0437\u0430\u043a\u0440\u0438\u0442\u0438\u043c\u0438 \u043b\u0430\u043f\u043a\u0430\u043c\u0438 \u0446\u0438\u0445 \u0440\u043e\u0437\u0434\u0456\u043b\u043e\u0432\u0438\u0445 \u0437\u043d\u0430\u043a\u0456\u0432.\n", "https://dyskurs.net/lapky-ridshe/", () -> {
            NodePattern moveOutside = NodePattern.or(NodePattern.N.form("[.,;:]"), UkrainianTreePatterns.dashes);
            Pattern abbrPattern = AbbreviationPatterns.withPunctCaseSensitive((Language)Language.UKRAINIAN);
            return NodePattern.or(FormattingIssues.punctQuoteSentenceEnd.andOr(moveOutside.withNeighbor(2, NodePattern.N.form("[?!]").message("\u0417\u0430\u0439\u0432\u0438\u0439 \u0440\u043e\u0437\u0434\u0456\u043b\u043e\u0432\u0438\u0439 \u0437\u043d\u0430\u043a \u043f\u0435\u0440\u0435\u0434 \u00ab$_\u00bb \u0443\u0441\u0435\u0440\u0435\u0434\u0438\u043d\u0456 \u043b\u0430\u043f\u043e\u043a")).correct(NodeCorrector.replace("")), NodePattern.N.form("[?!]").withNeighbor(2, NodePattern.N.sameWordAs(-2).correct(NodeCorrector.replace(""))).message("\u0417\u043d\u0430\u043a \u00ab$_\u00bb \u043d\u0435 \u043c\u0430\u0454 \u043f\u043e\u0432\u0442\u043e\u0440\u044e\u0432\u0430\u0442\u0438\u0441\u044f")), FormattingIssues.punctBeforeQuote(abbrPattern).and(CommonPatterns.dot).withNeighbor(2, NodePattern.PUNCT).correct(NodeCorrector.replace("")).message("\u0417\u0430\u0439\u0432\u0430 \u043a\u0440\u0430\u043f\u043a\u0430 \u0432 \u043b\u0430\u043f\u043a\u0430\u0445?"), FormattingIssues.missingSentenceDotAfterQuotedAbbreviation(abbrPattern).message(abbrDotMsg), FormattingIssues.movePunctAfterQuote(abbrPattern).and(moveOutside).andNot(NodePattern.N.directlyAfter(CommonPatterns.latin)).andNot(CommonPatterns.HYPHEN_NODE.noSpaceBefore()).message(plainMsg));
        }, new Example("\u042f \u0441\u043a\u0430\u0437\u0430\u0432 \u00ab<b>\u043f\u0440\u0435\u043a\u0440\u0430\u0441\u043d\u043e.\u00bb</b>", "\u042f \u0441\u043a\u0430\u0437\u0430\u0432 \u00ab<b>\u043f\u0440\u0435\u043a\u0440\u0430\u0441\u043d\u043e\u00bb.</b>"), new Example("\u0426\u0435 \u0441\u0442\u0430\u043b\u043e\u0441\u044f \u00ab80 \u0440. \u043d. <b>\u0435.\u00bb</b>", "\u0426\u0435 \u0441\u0442\u0430\u043b\u043e\u0441\u044f \u00ab80 \u0440. \u043d. <b>\u0435.\u00bb.</b>"));
    }

    public static NodePattern quoteToApostrophe() {
        return NodePattern.or(NodePattern.or(NodePattern.N.form("`"), UkrainianTreePatterns.anyQuotation).markAs("Apostrophe").directlyAfter(NodePattern.N.markAs("Prev").andNot(NodePattern.N.directlyAfter(UkrainianTreePatterns.anyQuotation))).directlyBefore(NodePattern.N.formCaseSensitive("\\p{Ll}.*").markAs("Next").andNot(NodePattern.N.directlyBefore(UkrainianTreePatterns.anyQuotation))).and((node, match) -> {
            Node prev = match.getMarkedNode("Prev");
            Node apostrophe = match.getMarkedNode("Apostrophe");
            Node next = match.getMarkedNode("Next");
            TreeSupport support = node.tree().treeSupport();
            String concat = prev.form() + "'" + next.form();
            if (!support.tagToken(prev.form() + String.valueOf(apostrophe) + next.form()).hasPos(".*") && support.tagToken(concat).hasPos(".*")) {
                return match.withCorrector(NodeCorrector.replaceNodes(prev, next, concat));
            }
            return null;
        }).andOr(NodePattern.N.noSpaceAround().message(WRONG_APOSTROPHE), NodePattern.N.message("\u0412\u0438\u0434\u0430\u043b\u0438\u0442\u0438 \u043f\u0440\u043e\u043f\u0443\u0441\u043a?")), NodePattern.N.form(".+[`\u00b4\u2018\u044a].+").correct(NodeCorrector.regexReplace("(.*)[\u044a`\u2018\u00b4](.*)", "$1'$2")).message(WRONG_APOSTROPHE));
    }

    @Nullable
    private static NodeMatch surroundWithCommas(NodeMatch match, Node start, Node end, boolean allowDashAfter, String missingBeforeMsg, String missingAfterMsg, String missingBothMsg) {
        return CommaLicense.surroundWithCommas(match, start, end, missingBeforeMsg, missingAfterMsg, missingBothMsg, commaOrOpening, allowDashAfter ? NodePattern.or(commaOrClosing, UkrainianTreePatterns.dashes) : commaOrClosing);
    }
}

