/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.model;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.execution.configurations.ConfigurationUtil;
import com.intellij.ide.util.ClassFilter;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.theoryinpractice.testng.util.TestNGUtil;
import java.util.Arrays;
import java.util.List;

public class TestClassFilter
implements ClassFilter.ClassFilterWithScope {
    private static final String GUICE = "org.testng.annotations.Guice";
    private static final List<String> INJECTION_ANNOTATIONS = Arrays.asList("com.google.inject.Inject", "org.testng.annotations.Factory");
    private final GlobalSearchScope scope;
    private final Project project;
    private final boolean includeConfig;
    private final boolean checkClassCanBeInstantiated;

    public TestClassFilter(GlobalSearchScope scope, Project project, boolean includeConfig) {
        this(scope, project, includeConfig, false);
    }

    public TestClassFilter(GlobalSearchScope scope, Project project, boolean includeConfig, boolean checkClassCanBeInstantiated) {
        this.scope = scope;
        this.project = project;
        this.includeConfig = includeConfig;
        this.checkClassCanBeInstantiated = checkClassCanBeInstantiated;
    }

    public TestClassFilter intersectionWith(GlobalSearchScope scope) {
        return new TestClassFilter(this.scope.intersectWith(scope), this.project, this.includeConfig, this.checkClassCanBeInstantiated);
    }

    public boolean isAccepted(PsiClass psiClass) {
        return (Boolean)ReadAction.compute(() -> {
            if (!ConfigurationUtil.PUBLIC_INSTANTIATABLE_CLASS.value((Object)psiClass)) {
                return false;
            }
            boolean hasTest = TestNGUtil.hasTest((PsiModifierListOwner)psiClass);
            if (hasTest) {
                PsiMethod[] constructors;
                if (this.checkClassCanBeInstantiated && (constructors = psiClass.getConstructors()).length > 0) {
                    boolean canBeInstantiated = false;
                    for (PsiMethod constructor : constructors) {
                        PsiParameter[] parameters = constructor.getParameterList().getParameters();
                        if (parameters.length != 0 && !AnnotationUtil.isAnnotated((PsiModifierListOwner)constructor, INJECTION_ANNOTATIONS, (int)1) && (parameters.length != 1 || !parameters[0].getType().equalsToText("java.lang.String"))) continue;
                        canBeInstantiated = true;
                        break;
                    }
                    if (!canBeInstantiated && !AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)GUICE, (int)0)) {
                        return false;
                    }
                }
                return true;
            }
            return this.includeConfig && TestNGUtil.hasConfig((PsiModifierListOwner)psiClass, TestNGUtil.CONFIG_ANNOTATIONS_FQN_NO_TEST_LEVEL);
        });
    }

    public Project getProject() {
        return this.project;
    }

    public GlobalSearchScope getScope() {
        return this.scope;
    }
}

