/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations.coverage;

import com.intellij.ide.util.PackageChooserDialog;
import com.intellij.java.coverage.JavaCoverageBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiPackage;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.ui.classFilter.ClassFilterEditor;
import java.awt.Component;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

class CoverageClassFilterEditor
extends ClassFilterEditor {
    CoverageClassFilterEditor(Project project) {
        super(project, aClass -> aClass.getContainingClass() == null, null);
        this.myTableModel.setEditEnabled(false);
        this.myTable.setVisibleRowCount(4);
    }

    protected void addPatternFilter() {
        List packages;
        PackageChooserDialog chooser = new PackageChooserDialog(JavaCoverageBundle.message("coverage.pattern.filter.editor.choose.package.title", new Object[0]), this.myProject){

            @Nullable
            protected PsiPackage getPsiPackage(String newQualifiedName) {
                return JavaPsiFacade.getInstance((Project)CoverageClassFilterEditor.this.myProject).findPackage(newQualifiedName);
            }

            protected boolean canExpandInSpeedSearch() {
                return true;
            }
        };
        if (chooser.showAndGet() && !(packages = chooser.getSelectedPackages()).isEmpty()) {
            for (PsiPackage aPackage : packages) {
                String fqName = aPackage.getQualifiedName();
                Object pattern = fqName.isEmpty() ? "*" : fqName + ".*";
                this.myTableModel.addRow(this.createFilter((String)pattern));
            }
            int row = this.myTableModel.getRowCount() - 1;
            this.myTable.getSelectionModel().setSelectionInterval(row, row);
            this.myTable.scrollRectToVisible(this.myTable.getCellRect(row, 0, true));
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myTable, true));
        }
    }

    protected String getAddPatternButtonText() {
        return JavaCoverageBundle.message("coverage.button.add.package", new Object[0]);
    }

    protected Icon getAddPatternButtonIcon() {
        return IconManager.getInstance().getPlatformIcon(PlatformIcons.Package);
    }
}

