/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parameterInfo;

import com.intellij.lang.ASTNode;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoHandlerWithTabActionSupport;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.ParameterInfoUtils;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;

public final class GroovyTypeParameterInfoHandler
implements ParameterInfoHandlerWithTabActionSupport<GrTypeArgumentList, PsiTypeParameter, GrTypeElement> {
    private static final Set<Class<?>> ALLOWED_PARENT_CLASSES = ContainerUtil.newHashSet((Object[])new Class[]{GrCodeReferenceElement.class});
    private static final Set<Class<?>> STOP_SEARCHING_CLASSES = ContainerUtil.newHashSet((Object[])new Class[]{GroovyFile.class});

    public GrTypeElement @NotNull [] getActualParameters(@NotNull GrTypeArgumentList o) {
        if (o == null) {
            GroovyTypeParameterInfoHandler.$$$reportNull$$$0(0);
        }
        GrTypeElement[] grTypeElementArray = o.getTypeArgumentElements();
        if (grTypeElementArray == null) {
            GroovyTypeParameterInfoHandler.$$$reportNull$$$0(1);
        }
        return grTypeElementArray;
    }

    @NotNull
    public IElementType getActualParameterDelimiterType() {
        IElementType iElementType = GroovyTokenTypes.mCOMMA;
        if (iElementType == null) {
            GroovyTypeParameterInfoHandler.$$$reportNull$$$0(2);
        }
        return iElementType;
    }

    @NotNull
    public IElementType getActualParametersRBraceType() {
        IElementType iElementType = GroovyTokenTypes.mGT;
        if (iElementType == null) {
            GroovyTypeParameterInfoHandler.$$$reportNull$$$0(3);
        }
        return iElementType;
    }

    @NotNull
    public Set<Class<?>> getArgumentListAllowedParentClasses() {
        Set<Class<?>> set = ALLOWED_PARENT_CLASSES;
        if (set == null) {
            GroovyTypeParameterInfoHandler.$$$reportNull$$$0(4);
        }
        return set;
    }

    @NotNull
    public Set<? extends Class<?>> getArgListStopSearchClasses() {
        Set<Class<?>> set = STOP_SEARCHING_CLASSES;
        if (set == null) {
            GroovyTypeParameterInfoHandler.$$$reportNull$$$0(5);
        }
        return set;
    }

    @NotNull
    public Class<GrTypeArgumentList> getArgumentListClass() {
        return GrTypeArgumentList.class;
    }

    @Nullable
    public GrTypeArgumentList findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        GrTypeArgumentList parameterList;
        if (context == null) {
            GroovyTypeParameterInfoHandler.$$$reportNull$$$0(6);
        }
        if ((parameterList = (GrTypeArgumentList)ParameterInfoUtils.findParentOfType((PsiFile)context.getFile(), (int)context.getOffset(), GrTypeArgumentList.class)) != null) {
            PsiElement psiElement = parameterList.getParent();
            if (!(psiElement instanceof GrCodeReferenceElement)) {
                return null;
            }
            GrCodeReferenceElement ref2 = (GrCodeReferenceElement)psiElement;
            PsiElement resolved = ref2.resolve();
            if (!(resolved instanceof PsiTypeParameterListOwner)) {
                return null;
            }
            Object[] typeParams = ((PsiTypeParameterListOwner)resolved).getTypeParameters();
            if (typeParams.length == 0) {
                return null;
            }
            context.setItemsToShow(typeParams);
            return parameterList;
        }
        return null;
    }

    public void showParameterInfo(@NotNull GrTypeArgumentList element, @NotNull CreateParameterInfoContext context) {
        if (element == null) {
            GroovyTypeParameterInfoHandler.$$$reportNull$$$0(7);
        }
        if (context == null) {
            GroovyTypeParameterInfoHandler.$$$reportNull$$$0(8);
        }
        context.showHint((PsiElement)element, element.getTextRange().getStartOffset() + 1, (ParameterInfoHandler)this);
    }

    @Nullable
    public GrTypeArgumentList findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        if (context == null) {
            GroovyTypeParameterInfoHandler.$$$reportNull$$$0(9);
        }
        return (GrTypeArgumentList)ParameterInfoUtils.findParentOfType((PsiFile)context.getFile(), (int)context.getOffset(), GrTypeArgumentList.class);
    }

    public void updateParameterInfo(@NotNull GrTypeArgumentList parameterOwner, @NotNull UpdateParameterInfoContext context) {
        if (parameterOwner == null) {
            GroovyTypeParameterInfoHandler.$$$reportNull$$$0(10);
        }
        if (context == null) {
            GroovyTypeParameterInfoHandler.$$$reportNull$$$0(11);
        }
        int index = ParameterInfoUtils.getCurrentParameterIndex((ASTNode)parameterOwner.getNode(), (int)context.getOffset(), (IElementType)this.getActualParameterDelimiterType());
        context.setCurrentParameter(index);
        Object[] objectsToView = context.getObjectsToView();
        context.setHighlightedParameter(index < objectsToView.length && index >= 0 ? objectsToView[index] : null);
    }

    public void updateUI(PsiTypeParameter p, @NotNull ParameterInfoUIContext context) {
        if (context == null) {
            GroovyTypeParameterInfoHandler.$$$reportNull$$$0(12);
        }
        @NonNls StringBuilder buffer = new StringBuilder();
        buffer.append(p.getName());
        int highlightEndOffset = buffer.length();
        buffer.append(" extends ");
        buffer.append(StringUtil.join((Object[])p.getSuperTypes(), t -> t.getPresentableText(), (String)", "));
        context.setupUIComponentPresentation(buffer.toString(), 0, highlightEndOffset, false, false, false, context.getDefaultParameterColor());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/parameterInfo/GroovyTypeParameterInfoHandler";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterOwner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/parameterInfo/GroovyTypeParameterInfoHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParameters";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParameterDelimiterType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParametersRBraceType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentListAllowedParentClasses";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgListStopSearchClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getActualParameters";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findElementForParameterInfo";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "showParameterInfo";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findElementForUpdatingParameterInfo";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateParameterInfo";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "updateUI";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

