/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.findUsages;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.search.MethodTextOccurrenceProcessor;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.util.Processor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.findUsages.GroovyScopeUtil;

public final class GrLiteralMethodSearcher
extends QueryExecutorBase<PsiReference, MethodReferencesSearch.SearchParameters> {
    public void processQuery(@NotNull MethodReferencesSearch.SearchParameters p, @NotNull Processor<? super PsiReference> consumer) {
        PsiMethod[] psiMethodArray;
        PsiMethod method;
        PsiClass aClass;
        if (p == null) {
            GrLiteralMethodSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            GrLiteralMethodSearcher.$$$reportNull$$$0(1);
        }
        if ((aClass = (method = p.getMethod()).getContainingClass()) == null) {
            return;
        }
        String name = method.getName();
        if (StringUtil.isEmpty((String)name)) {
            return;
        }
        boolean strictSignatureSearch = p.isStrictSignatureSearch();
        if (strictSignatureSearch) {
            PsiMethod[] psiMethodArray2 = new PsiMethod[1];
            psiMethodArray = psiMethodArray2;
            psiMethodArray2[0] = method;
        } else {
            psiMethodArray = aClass.findMethodsByName(name, false);
        }
        PsiMethod[] methods = psiMethodArray;
        SearchScope accessScope = GroovyScopeUtil.getEffectiveScope(methods);
        SearchScope restrictedByAccess = GroovyScopeUtil.restrictScopeToGroovyFiles(p.getEffectiveSearchScope(), accessScope);
        String textToSearch = GrLiteralMethodSearcher.findLongestWord(name);
        p.getOptimizer().searchWord(textToSearch, restrictedByAccess, (short)4, true, (PsiElement)method, (RequestResultProcessor)new MethodTextOccurrenceProcessor(aClass, strictSignatureSearch, methods));
    }

    @NotNull
    private static String findLongestWord(@NotNull String sequence) {
        List words;
        if (sequence == null) {
            GrLiteralMethodSearcher.$$$reportNull$$$0(2);
        }
        if ((words = StringUtil.getWordsIn((String)sequence)).isEmpty()) {
            String string = sequence;
            if (string == null) {
                GrLiteralMethodSearcher.$$$reportNull$$$0(3);
            }
            return string;
        }
        String longest = (String)words.get(0);
        for (String word : words) {
            if (word.length() <= longest.length()) continue;
            longest = word;
        }
        String string = longest;
        if (string == null) {
            GrLiteralMethodSearcher.$$$reportNull$$$0(4);
        }
        return string;
    }

    public GrLiteralMethodSearcher() {
        super(true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/findUsages/GrLiteralMethodSearcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/findUsages/GrLiteralMethodSearcher";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findLongestWord";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processQuery";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findLongestWord";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

