/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.internal.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;

public class LineReader
implements Closeable {
    static final int CHAR_BUFFER_SIZE = 8192;
    static final int EXPECTED_LINE_LENGTH = 80;
    private Reader reader;
    private char[] cbuf;
    private int position = 0;
    private int limit = 0;
    private String lineTerminator = null;

    public LineReader(Reader reader) {
        this.reader = reader;
        this.cbuf = new char[8192];
    }

    public String readLine() throws IOException {
        StringBuilder sb = null;
        boolean cr = false;
        while (true) {
            int i;
            if (this.position >= this.limit) {
                this.fill();
            }
            if (cr) {
                if (this.position < this.limit && this.cbuf[this.position] == '\n') {
                    ++this.position;
                    return this.line(sb.toString(), "\r\n");
                }
                return this.line(sb.toString(), "\r");
            }
            if (this.position >= this.limit) {
                return this.line(sb != null ? sb.toString() : null, null);
            }
            int start = this.position;
            for (i = this.position; i < this.limit; ++i) {
                char c = this.cbuf[i];
                if (c == '\n') {
                    this.position = i + 1;
                    return this.line(this.finish(sb, start, i), "\n");
                }
                if (c != '\r') continue;
                if (i + 1 < this.limit) {
                    if (this.cbuf[i + 1] == '\n') {
                        this.position = i + 2;
                        return this.line(this.finish(sb, start, i), "\r\n");
                    }
                    this.position = i + 1;
                    return this.line(this.finish(sb, start, i), "\r");
                }
                cr = true;
                this.position = i + 1;
                break;
            }
            if (this.position < i) {
                this.position = i;
            }
            if (sb == null) {
                sb = new StringBuilder(80);
            }
            sb.append(this.cbuf, start, i - start);
        }
    }

    public String getLineTerminator() {
        return this.lineTerminator;
    }

    @Override
    public void close() throws IOException {
        if (this.reader == null) {
            return;
        }
        try {
            this.reader.close();
        }
        finally {
            this.reader = null;
            this.cbuf = null;
        }
    }

    private void fill() throws IOException {
        int read;
        while ((read = this.reader.read(this.cbuf, 0, this.cbuf.length)) == 0) {
        }
        if (read > 0) {
            this.limit = read;
            this.position = 0;
        }
    }

    private String line(String line, String lineTerminator) {
        this.lineTerminator = lineTerminator;
        return line;
    }

    private String finish(StringBuilder sb, int start, int end) {
        int len = end - start;
        if (sb == null) {
            return new String(this.cbuf, start, len);
        }
        return sb.append(this.cbuf, start, len).toString();
    }
}

