/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.packagesearch.packageversionutils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.packagesearch.packageversionutils.VersionTokenMatcher;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f0\u000bJ\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0014\u0010\u000f\u001a\u00020\u0007*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/packagesearch/packageversionutils/PackageVersionUtils;", "", "<init>", "()V", "singleLetterUnstableMarkerRegex", "Lkotlin/text/Regex;", "evaluateStability", "", "versionName", "", "loggingCallback", "Lkotlin/Function1;", "", "tokenizeVersionName", "", "isTokenBoundary", "", "previousChar", "version-utils"})
@SourceDebugExtension(value={"SMAP\nPackageVersionUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackageVersionUtils.kt\norg/jetbrains/packagesearch/packageversionutils/PackageVersionUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,72:1\n2632#2,2:73\n1755#2,3:75\n2634#2:78\n774#2:81\n865#2:82\n866#2:85\n1179#3,2:79\n1088#3,2:83\n*S KotlinDebug\n*F\n+ 1 PackageVersionUtils.kt\norg/jetbrains/packagesearch/packageversionutils/PackageVersionUtils\n*L\n27#1:73,2\n28#1:75,3\n27#1:78\n61#1:81\n61#1:82\n61#1:85\n49#1:79,2\n61#1:83,2\n*E\n"})
public final class PackageVersionUtils {
    @NotNull
    public static final PackageVersionUtils INSTANCE = new PackageVersionUtils();
    @NotNull
    private static final Regex singleLetterUnstableMarkerRegex = new Regex("\\b[abmt][.\\-]?\\d{1,3}\\w?\\b", RegexOption.IGNORE_CASE);

    private PackageVersionUtils() {
    }

    public final boolean evaluateStability(@NotNull String versionName, @NotNull Function1<? super String, Unit> loggingCallback) {
        boolean bl;
        block14: {
            Intrinsics.checkNotNullParameter((Object)versionName, (String)"versionName");
            Intrinsics.checkNotNullParameter(loggingCallback, (String)"loggingCallback");
            if (StringsKt.isBlank((CharSequence)versionName)) {
                return false;
            }
            if (singleLetterUnstableMarkerRegex.containsMatchIn((CharSequence)versionName)) {
                loggingCallback.invoke((Object)("Version '" + versionName + "' contains a single-letter milestone/alpha/beta -> Unstable"));
                return false;
            }
            List<String> tokens = this.tokenizeVersionName(versionName);
            Iterable $this$none$iv = tokens;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    boolean bl2;
                    block13: {
                        String token = (String)element$iv;
                        boolean bl3 = false;
                        Iterable $this$any$iv = VersionTokenMatcher.Companion.getUnstableTokens();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv) {
                                VersionTokenMatcher matcher = (VersionTokenMatcher)element$iv2;
                                boolean bl4 = false;
                                boolean matches = matcher.matches(token);
                                if (matches) {
                                    String string;
                                    VersionTokenMatcher versionTokenMatcher = matcher;
                                    if (versionTokenMatcher instanceof VersionTokenMatcher.SubstringMatcher) {
                                        string = "contains '" + ((VersionTokenMatcher.SubstringMatcher)matcher).getToMatch() + "'";
                                    } else if (versionTokenMatcher instanceof VersionTokenMatcher.RegexMatcher) {
                                        string = "matches '" + ((VersionTokenMatcher.RegexMatcher)matcher).getRegex().getPattern() + "'";
                                    } else {
                                        throw new NoWhenBranchMatchedException();
                                    }
                                    String detailMessage = string;
                                    loggingCallback.invoke((Object)("Version '" + versionName + "' " + detailMessage + " -> Unstable"));
                                }
                                if (!matches) continue;
                                bl2 = true;
                                break block13;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bl = false;
                    break block14;
                }
                bl = true;
            }
        }
        return bl;
    }

    public static /* synthetic */ boolean evaluateStability$default(PackageVersionUtils packageVersionUtils, String string, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = PackageVersionUtils::evaluateStability$lambda$0;
        }
        return packageVersionUtils.evaluateStability(string, (Function1<? super String, Unit>)function1);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> tokenizeVersionName(String versionName) {
        void $this$filterTo$iv$iv;
        List tokens = new ArrayList();
        Character previousChar = null;
        StringBuilder tokenBuilder = new StringBuilder(versionName.length());
        CharSequence $this$forEach$iv = versionName;
        boolean $i$f$forEach = false;
        for (int i = 0; i < $this$forEach$iv.length(); ++i) {
            char element$iv;
            char c = element$iv = $this$forEach$iv.charAt(i);
            boolean bl = false;
            if (previousChar != null && INSTANCE.isTokenBoundary(c, previousChar.charValue())) {
                ((Collection)tokens).add(tokenBuilder.toString());
                StringsKt.clear((StringBuilder)tokenBuilder);
            }
            tokenBuilder.append(c);
            previousChar = Character.valueOf(c);
        }
        ((Collection)tokens).add(tokenBuilder.toString());
        Iterable $this$filter$iv = tokens;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block4: {
                String token = (String)element$iv$iv;
                boolean bl2 = false;
                CharSequence $this$any$iv = token;
                boolean $i$f$any = false;
                for (int i = 0; i < $this$any$iv.length(); ++i) {
                    char element$iv;
                    char it = element$iv = $this$any$iv.charAt(i);
                    boolean bl3 = false;
                    if (!Character.isLetterOrDigit(it)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean isTokenBoundary(char $this$isTokenBoundary, char previousChar) {
        return !Character.isLetterOrDigit($this$isTokenBoundary) ? true : (Character.isLetter($this$isTokenBoundary) && !Character.isLetter(previousChar) ? true : Character.isDigit($this$isTokenBoundary) && !Character.isDigit(previousChar));
    }

    private static final Unit evaluateStability$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }
}

